/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Bank;
import org.egov.commons.Relation;
import org.egov.commons.repository.RelationRepository;
import org.egov.commons.service.AccountDetailKeyService;
import org.egov.commons.service.AccountdetailtypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RelationJpaService {
    private final RelationRepository relationRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    AccountDetailKeyService accountDetailKeyService;
    @Autowired
    AccountdetailtypeService accountdetailtypeService;

    @Autowired
    public RelationJpaService(RelationRepository relationRepository) {
        this.relationRepository = relationRepository;
    }

    @Transactional
    public Relation create(Relation relation) {
        relation = (Relation)this.relationRepository.save(relation);
        Accountdetailkey ac = new Accountdetailkey();
        ac.setDetailkey(relation.getId());
        ac.setDetailname(relation.getName());
        ac.setGroupid(Integer.valueOf(1));
        ac.setAccountdetailtype(this.accountdetailtypeService.findByName("Supplier"));
        this.accountDetailKeyService.create(ac);
        return relation;
    }

    @Transactional
    public Relation update(Relation relation) {
        if (relation.getBank() != null && relation.getBank().getId() != null) {
            Integer id = relation.getBank().getId();
            this.entityManager.detach((Object)relation.getBank());
            Bank bank = (Bank)this.entityManager.find(Bank.class, (Object)id);
            relation.setBank(bank);
        } else {
            relation.setBank(null);
        }
        return (Relation)this.relationRepository.save(relation);
    }

    public List<Relation> findAll() {
        return this.relationRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Relation findByName(String name) {
        return this.relationRepository.findByName(name);
    }

    public Relation findByCode(String code) {
        return this.relationRepository.findByCode(code);
    }

    public Relation findOne(Integer id) {
        return (Relation)this.relationRepository.findOne(id);
    }

    public List<Relation> search(Relation relation) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Relation.class);
        Root relations = createQuery.from(Relation.class);
        createQuery.select((Selection)relations);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType Relation_ = m.entity(Relation.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (relation.getName() != null) {
            String name = "%" + relation.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)relations.get("name")));
            predicates.add(cb.like(cb.lower((Expression)relations.get(Relation_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (relation.getCode() != null) {
            String code = "%" + relation.getCode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)relations.get("code")));
            predicates.add(cb.like(cb.lower((Expression)relations.get(Relation_.getDeclaredSingularAttribute("code", String.class))), code));
        }
        if (relation.getMobile() != null) {
            String mobile = relation.getMobile();
            predicates.add(cb.isNotNull((Expression)relations.get("mobile")));
            predicates.add(cb.like(cb.lower((Expression)relations.get(Relation_.getDeclaredSingularAttribute("mobile", String.class))), mobile));
        }
        if (relation.getPanno() != null) {
            String panno = relation.getPanno();
            predicates.add(cb.isNotNull((Expression)relations.get("panno")));
            predicates.add(cb.like(cb.lower((Expression)relations.get(Relation_.getDeclaredSingularAttribute("panno", String.class))), panno));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }
}

