/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ChartOfAccountsService
extends PersistenceService<CChartOfAccounts, Long> {
    @Autowired
    protected AppConfigValueService appConfigValuesService;

    public ChartOfAccountsService(Class<CChartOfAccounts> type) {
        super(type);
    }

    public List<CChartOfAccounts> getActiveCodeList() {
        return this.findAllBy("select acc from CChartOfAccounts acc where acc.isActiveForPosting=true order by acc.glcode", new Object[0]);
    }

    @Transactional
    public void updateActiveForPostingByMaterializedPath(String materializedPath) {
        this.getSession().createSQLQuery("update chartofaccounts set isactiveforposting = true where isactiveforposting = false and id in (select distinct bg.mincode from egf_budgetgroup bg,egf_budgetdetail bd where bd.budgetgroup = bg.id  and bd.materializedpath like'" + materializedPath + "%') ").executeUpdate();
    }

    public List<CChartOfAccounts> getAccountCodeByPurposeName(String purposeName) {
        ArrayList<CChartOfAccounts> accountCodeList = new ArrayList<CChartOfAccounts>();
        try {
            if (purposeName == null || purposeName.equalsIgnoreCase("")) {
                throw new ApplicationException("Purpose Name is null or empty");
            }
            Query query = this.getSession().createQuery(" from EgfAccountcodePurpose purpose where purpose.name='" + purposeName + "'");
            if (query.list().size() == 0) {
                throw new ApplicationException("Purpose ID provided is not defined in the system");
            }
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName))) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName)) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery("SELECT coa FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName AND coa.classification=4 AND coa.isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while getting Account Code by purpose", (Throwable)e);
        }
        return accountCodeList;
    }

    public List<CChartOfAccounts> findOtherDeductionAccountCodesByGlcodeOrNameLike(String searchString, String[] purposeNames) {
        if (null == purposeNames || purposeNames.length == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("purposeId", "The supplied purposeId  can not be null or empty")));
        }
        ArrayList<CChartOfAccounts> listChartOfAcc = new ArrayList<CChartOfAccounts>();
        Query query = this.getSession().createQuery("SELECT coa  FROM CChartOfAccounts coa WHERE not exists (select coa1.id from EgfAccountcodePurpose purpose,CChartOfAccounts coa1 where coa.id = coa1.id and coa1.purposeId = purpose.id and purpose.name in(:purposeNames))  AND coa.classification=4 AND coa.isActiveForPosting=true and coa.type in ('I','L') and (coa.glcode like :glCode or upper(coa.name) like :name) order by coa.glcode");
        query.setParameterList("purposeNames", (Object[])purposeNames);
        query.setString("glCode", searchString + "%");
        query.setString("name", "%" + searchString.toUpperCase() + "%");
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        return listChartOfAcc;
    }

    public List<CChartOfAccounts> getSubledgerAccountCodesForAccountDetailTypeAndNonSubledgers(Integer accountDetailTypeId, String glcode) {
        if (accountDetailTypeId == 0 || accountDetailTypeId == -1) {
            return this.findAllBy("from CChartOfAccounts a where a.isActiveForPosting=true and a.classification=4 and size(a.chartOfAccountDetails) = 0 and glcode like ? order by a.id", new Object[]{glcode + "%"});
        }
        return this.findAllBy("from CChartOfAccounts  a LEFT OUTER JOIN  fetch a.chartOfAccountDetails  b where (size(a.chartOfAccountDetails) = 0 or b.detailTypeId.id=?)and a.isActiveForPosting=true and a.classification=4 and a.glcode like ? order by a.id", new Object[]{accountDetailTypeId, glcode + "%"});
    }

    public List<CChartOfAccounts> getAccountCodeByPurpose(Integer purposeId) {
        ArrayList<CChartOfAccounts> accountCodeList = new ArrayList<CChartOfAccounts>();
        try {
            if (purposeId == null || purposeId == 0) {
                throw new ApplicationException("Purpose Id is null or zero");
            }
            Query query = this.getSession().createQuery(" from EgfAccountcodePurpose purpose where purpose.id=" + purposeId + "");
            if (query.list().size() == 0) {
                throw new ApplicationException("Purpose ID provided is not defined in the system");
            }
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId))) AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId)) AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId) AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE purposeid=:purposeId AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while getting Account Code by purpose", (Throwable)e);
        }
        return accountCodeList;
    }

    public List<CChartOfAccounts> getNetPayableCodesByAccountDetailType(Integer accountDetailType) {
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "contingencyBillPurposeIds");
        HashSet<CChartOfAccounts> netPayList = new HashSet<CChartOfAccounts>();
        List<Object> accountCodeByPurpose = new ArrayList();
        for (int i = 0; i < configValuesByModuleAndKey.size(); ++i) {
            try {
                accountCodeByPurpose = this.getAccountCodeByPurpose(Integer.valueOf(((AppConfigValues)configValuesByModuleAndKey.get(i)).getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (accountDetailType == null || accountDetailType == 0) {
                for (CChartOfAccounts coa : accountCodeByPurpose) {
                    if (!coa.getChartOfAccountDetails().isEmpty()) continue;
                    netPayList.add(coa);
                }
                continue;
            }
            for (CChartOfAccounts coa : accountCodeByPurpose) {
                if (!coa.getChartOfAccountDetails().isEmpty()) {
                    for (CChartOfAccountDetail coaDtl : coa.getChartOfAccountDetails()) {
                        if (coaDtl.getDetailTypeId() == null || !coaDtl.getDetailTypeId().getId().equals(accountDetailType)) continue;
                        netPayList.add(coa);
                    }
                }
                netPayList.add(coa);
            }
        }
        return new ArrayList<CChartOfAccounts>(netPayList);
    }
}

