/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.List;
import org.egov.commons.entity.ChairPerson;
import org.egov.commons.repository.ChairPersonRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ChairPersonService {
    private final ChairPersonRepository chairPersonRepository;

    @Autowired
    public ChairPersonService(ChairPersonRepository chairPersonRepository) {
        this.chairPersonRepository = chairPersonRepository;
    }

    public ChairPerson findById(Long id) {
        return (ChairPerson)((Object)this.chairPersonRepository.findOne(id));
    }

    public List<ChairPerson> findAll() {
        return this.chairPersonRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public ChairPerson load(Long id) {
        return (ChairPerson)((Object)this.chairPersonRepository.getOne(id));
    }

    public ChairPerson getActiveChairPersonAsOnCurrentDate() {
        return this.chairPersonRepository.findActiveChairPersonAsOnDate();
    }

    public ChairPerson getActiveChairPerson() {
        return this.chairPersonRepository.findActiveChairPerson();
    }

    public ChairPerson getActiveChairPersonByCurrentDate() {
        return this.chairPersonRepository.findActiveChairPersonByCurrentDate();
    }

    public Page<ChairPerson> getListOfChairPersons(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.DESC, new String[]{"id"});
        return this.chairPersonRepository.findAll((Pageable)pageable);
    }

    @Transactional
    public ChairPerson createChairPerson(ChairPerson chairPerson) {
        return (ChairPerson)((Object)this.chairPersonRepository.save((Object)chairPerson));
    }

    @Transactional
    public void updateChairPerson(ChairPerson chairPerson) {
        this.chairPersonRepository.save((Object)chairPerson);
    }
}

