/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.repository.AccountdetailtypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AccountdetailtypeService {
    private final AccountdetailtypeRepository accountdetailtypeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public AccountdetailtypeService(AccountdetailtypeRepository accountdetailtypeRepository) {
        this.accountdetailtypeRepository = accountdetailtypeRepository;
    }

    @Transactional
    public Accountdetailtype create(Accountdetailtype accountdetailtype) {
        return (Accountdetailtype)this.accountdetailtypeRepository.save(accountdetailtype);
    }

    @Transactional
    public Accountdetailtype update(Accountdetailtype accountdetailtype) {
        return (Accountdetailtype)this.accountdetailtypeRepository.save(accountdetailtype);
    }

    public List<Accountdetailtype> findAll() {
        return this.accountdetailtypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Accountdetailtype findByName(String name) {
        return this.accountdetailtypeRepository.findByName(name);
    }

    public Accountdetailtype findOne(Integer id) {
        return (Accountdetailtype)this.accountdetailtypeRepository.findOne(id);
    }

    public List<Accountdetailtype> findByFullQualifiedName(String fullQualifiedName) {
        return this.accountdetailtypeRepository.findByFullQualifiedName(fullQualifiedName);
    }

    public List<Accountdetailtype> search(Accountdetailtype accountdetailtype, String mode) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Accountdetailtype.class);
        Root accountdetailtypes = createQuery.from(Accountdetailtype.class);
        createQuery.select((Selection)accountdetailtypes);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType Accountdetailtype_ = m.entity(Accountdetailtype.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (accountdetailtype.getName() != null) {
            String name = "%" + accountdetailtype.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)accountdetailtypes.get("name")));
            predicates.add(cb.like(cb.lower((Expression)accountdetailtypes.get(Accountdetailtype_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (accountdetailtype.getDescription() != null) {
            String code = "%" + accountdetailtype.getDescription().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)accountdetailtypes.get("description")));
            predicates.add(cb.like(cb.lower((Expression)accountdetailtypes.get(Accountdetailtype_.getDeclaredSingularAttribute("description", String.class))), code));
        }
        if (mode.equalsIgnoreCase("edit")) {
            predicates.add(cb.equal((Expression)accountdetailtypes.get("fullQualifiedName"), (Object)"org.egov.masters.model.AccountEntity"));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }
}

