/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.exception.ApplicationRuntimeException;

public class Installment
implements Serializable,
Comparable<Installment> {
    private static final long serialVersionUID = 4862908812359340638L;
    private Integer id;
    private Date fromDate;
    private Date toDate;
    private Module module;
    private Integer installmentNumber;
    private String description;
    private Date installmentYear;
    private Date lastUpdatedTimeStamp;
    private String installmentType;
    private String finYearRange;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getInstallmentNumber() {
        return this.installmentNumber;
    }

    public void setInstallmentNumber(Integer installmentNumber) {
        this.installmentNumber = installmentNumber;
    }

    public Date getInstallmentYear() {
        return this.installmentYear;
    }

    public void setInstallmentYear(Date installmentYear) {
        this.installmentYear = installmentYear;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Date getLastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public void setLastUpdatedTimeStamp(Date lastUpdatedTimeStamp) {
        this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean validate() {
        if (this.fromDate == null || this.toDate == null) {
            throw new ApplicationRuntimeException("From Date or To Date is null in installemnt.");
        }
        if (this.fromDate.compareTo(this.toDate) >= 0) {
            throw new ApplicationRuntimeException("From Date greater than or equal to 'ToDate' in installemnt.");
        }
        if (this.module == null) {
            throw new ApplicationRuntimeException("Module not specified in installemnt.");
        }
        if (this.installmentYear == null) {
            throw new ApplicationRuntimeException("Installment year not specified in installemnt.");
        }
        if (this.installmentNumber == 0) {
            throw new ApplicationRuntimeException("Installment Number cannot be zero in a installemnt.");
        }
        return true;
    }

    public String toString() {
        return this.description;
    }

    public String getInstallmentType() {
        return this.installmentType;
    }

    public void setInstallmentType(String installmentType) {
        this.installmentType = installmentType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fromDate == null ? 0 : this.fromDate.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.installmentNumber == null ? 0 : this.installmentNumber.hashCode());
        result = 31 * result + (this.installmentYear == null ? 0 : this.installmentYear.hashCode());
        result = 31 * result + (this.installmentType == null ? 0 : this.installmentType.hashCode());
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.toDate == null ? 0 : this.toDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Installment)) {
            return false;
        }
        Installment inst = (Installment)obj;
        if (this == inst) {
            return true;
        }
        if (this.getId() != null && inst.getId() != null) {
            return this.getId().equals(inst.getId());
        }
        if (this.fromDate == null || this.toDate == null || this.installmentNumber == null || this.installmentYear == null || this.module == null) {
            return false;
        }
        if (inst.fromDate == null || inst.toDate == null || inst.installmentNumber == null || inst.installmentYear == null || inst.module == null) {
            return false;
        }
        return this.fromDate.equals(inst.fromDate) && this.toDate.equals(inst.toDate) && this.installmentNumber.equals(inst.installmentNumber) && this.installmentYear.equals(inst.installmentYear) && this.module.equals((Object)inst.module) && this.installmentType != null && inst.installmentType != null && this.installmentType.equals(inst.installmentType);
    }

    @Override
    public int compareTo(Installment inst) {
        return new CompareToBuilder().append((Object)this.fromDate, (Object)inst.getFromDate()).append((Object)this.id, (Object)inst.getId()).append((Object)this.installmentYear, (Object)inst.getInstallmentYear()).append((Object)this.installmentNumber, (Object)inst.getInstallmentNumber()).append((Object)this.installmentType, (Object)inst.getInstallmentType()).append((Object)this.module.getName(), (Object)inst.getModule().getName()).append((Object)this.toDate, (Object)inst.getToDate()).build();
    }

    public String getFinYearRange() {
        return this.finYearRange;
    }

    public void setFinYearRange(String finYearRange) {
        this.finYearRange = finYearRange;
    }
}

