/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Fundsource;
import org.egov.commons.repository.FundsourceRepository;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FundsourceService {
    private final FundsourceRepository fundsourceRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public FundsourceService(FundsourceRepository fundsourceRepository) {
        this.fundsourceRepository = fundsourceRepository;
    }

    @Transactional
    public Fundsource create(Fundsource fundsource) {
        return (Fundsource)((Object)this.fundsourceRepository.save((Object)fundsource));
    }

    @Transactional
    public Fundsource update(Fundsource fundsource) {
        return (Fundsource)((Object)this.fundsourceRepository.save((Object)fundsource));
    }

    public List<Fundsource> findAll() {
        return this.fundsourceRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Fundsource findByName(String name) {
        return this.fundsourceRepository.findByName(name);
    }

    public Fundsource findByCode(String code) {
        return this.fundsourceRepository.findByCode(code);
    }

    public Fundsource findOne(Long id) {
        return (Fundsource)((Object)this.fundsourceRepository.findOne(id));
    }

    public List<Fundsource> getBySubSchemeId(Integer subSchemeId) {
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(" from Fundsource where isactive = true and subSchemeId.id=:subSchemeId");
        query.setInteger("subSchemeId", subSchemeId.intValue());
        return query.list();
    }

    public List<Fundsource> search(Fundsource fundsource) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Fundsource.class);
        Root fundsources = createQuery.from(Fundsource.class);
        createQuery.select((Selection)fundsources);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType Fundsource_ = m.entity(Fundsource.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (fundsource.getName() != null) {
            String name = "%" + fundsource.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)fundsources.get("name")));
            predicates.add(cb.like(cb.lower((Expression)fundsources.get(Fundsource_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (fundsource.getCode() != null) {
            String code = "%" + fundsource.getCode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)fundsources.get("code")));
            predicates.add(cb.like(cb.lower((Expression)fundsources.get(Fundsource_.getDeclaredSingularAttribute("code", String.class))), code));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }
}

