/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FiscalPeriodHibernateDAO;
import org.egov.commons.dao.GeneralLedgerDAO;
import org.egov.infra.exception.ApplicationException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class GeneralLedgerHibernateDAO
implements GeneralLedgerDAO {
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private FiscalPeriodHibernateDAO fiscalPeriodHibernateDAO;
    @PersistenceContext
    private EntityManager entityManager;
    private static final Logger LOG = LoggerFactory.getLogger(GeneralLedgerHibernateDAO.class);

    @Transactional
    public CGeneralLedger update(CGeneralLedger entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public CGeneralLedger create(CGeneralLedger entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(CGeneralLedger entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public CGeneralLedger findById(Number id, boolean lock) {
        return (CGeneralLedger)this.getCurrentSession().load(CGeneralLedger.class, (Serializable)id);
    }

    public List<CGeneralLedger> findAll() {
        return this.getCurrentSession().createCriteria(CGeneralLedger.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public String getActualsPrev(String accCode, String functionId, String budgetingType) throws Exception {
        FinancialYearHibernateDAO fiscal = this.financialYearHibernateDAO;
        String financialperiodId = fiscal.getPrevYearFiscalId();
        FiscalPeriodHibernateDAO fiscalperiod = this.fiscalPeriodHibernateDAO;
        String fiscalperiodId = fiscalperiod.getFiscalPeriodIds(financialperiodId);
        String result = "";
        String hqlQuery = "";
        ArrayList list = new ArrayList();
        if (!functionId.equalsIgnoreCase("0")) {
            if (budgetingType.equalsIgnoreCase("1")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount)-sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.fiscalPeriodId in (" + fiscalperiodId + ") and cgeneralledger.functionId='" + functionId + "'  and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("2")) {
                hqlQuery = "select sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.id.voucherHeaderId=cvoucherheader.id and cvoucherheader.fiscalPeriodId in (" + fiscalperiodId + ") and cgeneralledger.functionId='" + functionId + "'  and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("3")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.id.voucherHeaderId=cvoucherheader.id and cvoucherheader.fiscalPeriodId in (" + fiscalperiodId + ") and cgeneralledger.functionId='" + functionId + "'  and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            }
        } else if (functionId.equalsIgnoreCase("0")) {
            if (budgetingType.equalsIgnoreCase("1")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount)-sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.fiscalPeriodId in (" + fiscalperiodId + ") and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("2")) {
                hqlQuery = "select sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.fiscalPeriodId in (" + fiscalperiodId + ") and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("3")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.fiscalPeriodId in (" + fiscalperiodId + ")  and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            }
        }
        try {
            Query query = this.getCurrentSession().createQuery(hqlQuery);
            list = (ArrayList)query.list();
        }
        catch (Exception e) {
            LOG.error("Error occurred while getting Actuals Prev", (Throwable)e);
            throw new ApplicationException("Error occurred while getting Actuals Prev", (Throwable)e);
        }
        if (list.size() > 0) {
            if (list.get(0) == null) {
                return "0.0";
            }
        } else {
            return "0.0";
        }
        result = list.get(0).toString();
        if (result.startsWith("-")) {
            result = result.substring(1, result.length());
        }
        return result;
    }

    @Override
    public String getActualsDecCurr(String accCode, String functionId, String budgetingType) throws Exception {
        FinancialYearHibernateDAO fiscal = this.financialYearHibernateDAO;
        String startdate = fiscal.getCurrYearStartDate();
        String[] temp = startdate.split("-");
        String[] temp1 = temp[2].split(" ");
        Date dt = new Date();
        Date dt1 = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dt1);
        calendar.set(1, Integer.parseInt(temp[0]));
        calendar.set(2, Integer.parseInt(temp[1]) - 1);
        calendar.set(5, Integer.parseInt(temp1[0]));
        startdate = formatter.format(calendar.getTime());
        calendar.setTime(dt);
        calendar.set(1, Integer.parseInt(temp[0]));
        calendar.set(2, 11);
        calendar.set(5, 31);
        String endDate = formatter.format(calendar.getTime());
        String result = "";
        String hqlQuery = "";
        ArrayList list = new ArrayList();
        if (!functionId.equalsIgnoreCase("0")) {
            if (budgetingType.equalsIgnoreCase("1")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount)-sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.voucherDate >='" + startdate + "' and cvoucherheader.voucherDate <='" + endDate + "' and cgeneralledger.functionId='" + functionId + "'  and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("2")) {
                hqlQuery = "select sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.voucherDate >='" + startdate + "' and cvoucherheader.voucherDate <='" + endDate + "' and cgeneralledger.functionId='" + functionId + "'  and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("3")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.voucherDate >='" + startdate + "' and cvoucherheader.voucherDate <='" + endDate + "' and cgeneralledger.functionId='" + functionId + "'  and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            }
        } else if (functionId.equalsIgnoreCase("0")) {
            if (budgetingType.equalsIgnoreCase("1")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount)-sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.voucherDate >='" + startdate + "' and cvoucherheader.voucherDate <='" + endDate + "' and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("2")) {
                hqlQuery = "select sum(cgeneralledger.creditAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.voucherDate >='" + startdate + "' and cvoucherheader.voucherDate <='" + endDate + "' and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            } else if (budgetingType.equalsIgnoreCase("3")) {
                hqlQuery = "select sum(cgeneralledger.debitAmount) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.voucherDate >='" + startdate + "' and cvoucherheader.voucherDate <='" + endDate + "' and cgeneralledger.glcode like '" + accCode + "'|| '%'";
            }
        }
        try {
            Query query = this.getCurrentSession().createQuery(hqlQuery);
            list = (ArrayList)query.list();
        }
        catch (Exception e) {
            LOG.error("Error occurred while getting Actuals upto december", (Throwable)e);
            throw new ApplicationException("Error occurred while getting Actuals upto december", (Throwable)e);
        }
        if (list.size() > 0) {
            if (list.get(0) == null) {
                return "0.0";
            }
        } else {
            return "0.0";
        }
        result = list.get(0).toString();
        if (result.startsWith("-")) {
            result = result.substring(1, result.length());
        }
        return result;
    }

    @Override
    public List<CGeneralLedger> findCGeneralLedgerByVoucherHeaderId(Long voucherHeaderId) {
        Query qry = this.getCurrentSession().createQuery("from CGeneralLedger gen where gen.voucherHeaderId.id = :voucherHeaderId");
        qry.setString("voucherHeaderId", voucherHeaderId.toString());
        return qry.list();
    }

    @Override
    public String getCBillDeductionAmtByVhId(Long voucherHeaderId) {
        String result = "0";
        Query qry = this.getCurrentSession().createQuery("select sum(gl.creditAmount) from CGeneralLedger gl where gl.voucherHeaderId.id = :voucherHeaderId and gl.glcodeId not in(select id from CChartOfAccounts where purposeId=28) ");
        qry.setString("voucherHeaderId", voucherHeaderId.toString());
        if (qry.uniqueResult() != null) {
            return qry.uniqueResult().toString();
        }
        return "0";
    }

    @Override
    public BigDecimal getGlAmountForBudgetingType(Long budType, List glcodeList, String finYearID, String functionId, String schemeId, String subSchemeId, String asOnDate) throws Exception {
        try {
            Query qry = null;
            StringBuffer qryStr = new StringBuffer();
            BigDecimal result = new BigDecimal("0.00");
            if (budType == 1L) {
                qryStr.append("select abs(sum(cgeneralledger.debitAmount)-sum(cgeneralledger.creditAmount)) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader ");
            } else if (budType == 2L) {
                qryStr.append("select abs(sum(cgeneralledger.creditAmount)) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader ");
            } else if (budType == 3L) {
                qryStr.append("select abs(sum(cgeneralledger.debitAmount)) from CGeneralLedger cgeneralledger,CVoucherHeader cvoucherheader ");
            }
            String frmTab = "";
            String whrCond = "";
            String dateCond = "";
            String funcStr = "";
            String schStr = "";
            String subSchStr = "";
            String cond = "";
            cond = " where cgeneralledger.voucherHeaderId.id=cvoucherheader.id and cvoucherheader.fiscalPeriodId in ( select cfiscalperiod.id from CFiscalPeriod cfiscalperiod where cfiscalperiod.financialYearId =:finYearID ) and cgeneralledger.glcode in ( :glcodeList) ";
            if (functionId != null && !"".equals(functionId)) {
                funcStr = " and cgeneralledger.functionId =:functionId";
            }
            if (schemeId != null && (subSchemeId == null || subSchemeId.isEmpty())) {
                schStr = "  and vouchermis.schemeid =:schemeId";
                frmTab = " ,Vouchermis vouchermis ";
                whrCond = " and cvoucherheader.id=vouchermis.voucherheaderid ";
            }
            if (schemeId != null && !schemeId.isEmpty() && subSchemeId != null && !subSchemeId.isEmpty()) {
                schStr = "  and vouchermis.schemeid =:schemeId";
                subSchStr = " and vouchermis.subschemeid =:subSchemeId";
                frmTab = " ,Vouchermis vouchermis ";
                whrCond = " and cvoucherheader.id=vouchermis.voucherheaderid ";
            }
            if (asOnDate != null && !"".equals(asOnDate)) {
                dateCond = " and cvoucherheader.voucherDate <=:asOnDate";
            }
            qryStr.append(frmTab);
            qryStr.append(cond);
            qryStr.append(whrCond);
            qryStr.append(funcStr);
            qryStr.append(schStr);
            qryStr.append(subSchStr);
            qryStr.append(dateCond);
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            if (!functionId.equals("") && functionId != null) {
                qry.setString("functionId", functionId);
            }
            if (!schemeId.equals("") && schemeId != null && (subSchemeId.equals("") || subSchemeId == null)) {
                qry.setString("schemeId", schemeId);
            }
            if (!schemeId.equals("") && schemeId != null && !subSchemeId.equals("") && subSchemeId != null) {
                qry.setString("schemeId", schemeId);
                qry.setString("subSchemeId", subSchemeId);
            }
            if (!asOnDate.equals("") && asOnDate != null) {
                qry.setString("asOnDate", asOnDate);
            }
            qry.setString("finYearID", finYearID);
            qry.setParameterList("glcodeList", (Collection)glcodeList);
            if (qry.uniqueResult() != null) {
                return new BigDecimal(qry.uniqueResult().toString());
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("Error occurred while getting Amount for Budgetting Type", (Throwable)e);
            throw new ApplicationException("Error occurred while getting Amount for Budgetting Type", (Throwable)e);
        }
    }

    @Override
    public BigDecimal getGlAmountbyGlcodeList(List glCodeList, BigDecimal glAmount) throws Exception {
        BigDecimal amount = glAmount;
        Query qry = null;
        try {
            for (String glCode : glCodeList) {
                Iterator iterator;
                qry = this.getCurrentSession().createQuery("from CGeneralLedger gl where gl.glcode =:glCode order by gl.id desc");
                qry.setString("glCode", glCode);
                if (qry.list() == null || !(iterator = qry.iterate()).hasNext()) continue;
                CGeneralLedger ob = (CGeneralLedger)iterator.next();
                Double debitamount = ob.getDebitAmount();
                Double creditamount = ob.getCreditAmount();
                if (!debitamount.equals(0.0)) {
                    amount = amount.subtract(new BigDecimal(debitamount.toString()));
                    continue;
                }
                amount = amount.subtract(new BigDecimal(creditamount.toString()));
            }
        }
        catch (Exception e) {
            LOG.error("Error occurred while getting GL Amount By GLCode", (Throwable)e);
            throw new ApplicationException("Error occurred while getting GL Amount By GLCode", (Throwable)e);
        }
        return amount;
    }
}

