/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository
public class EgwStatusHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgwStatus> getEgwStatusFilterByStatus(ArrayList<Integer> statusId) {
        Query qry = this.getCurrentSession().createQuery("from EgwStatus egs where egs.id in (:statusId)  order by orderId");
        qry.setParameterList("statusId", statusId);
        return qry.list();
    }

    public EgwStatus getStatusByModuleAndCode(String moduleType, String code) {
        Query qry = this.getCurrentSession().createQuery("from EgwStatus S where S.moduletype =:moduleType and S.code =:code");
        qry.setString("moduleType", moduleType);
        qry.setString("code", code);
        return (EgwStatus)qry.uniqueResult();
    }

    public List<EgwStatus> getStatusByModule(String moduleType) {
        Query qry = this.getCurrentSession().createQuery("from EgwStatus S where S.moduletype =:moduleType  order by orderId");
        qry.setString("moduleType", moduleType);
        return qry.list();
    }

    public List<EgwStatus> getStatusListByModuleAndCodeList(String moduleType, List codeList) {
        Query qry = this.getCurrentSession().createQuery("from EgwStatus S where S.moduletype =:moduleType and S.code in(:codeList)  order by orderId");
        qry.setString("moduleType", moduleType);
        qry.setParameterList("codeList", (Collection)codeList);
        return qry.list();
    }

    public EgwStatus getEgwStatusByCode(String code) {
        Query qry = this.getCurrentSession().createQuery("from EgwStatus S where S.code =:code ");
        qry.setString("code", code);
        return (EgwStatus)qry.uniqueResult();
    }

    public EgwStatus findById(Integer integer, boolean b) {
        return (EgwStatus)this.getCurrentSession().get(EgwStatus.class, (Serializable)integer);
    }
}

