/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Bank;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BankHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public Bank update(Bank entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public Bank create(Bank entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(Bank entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public Bank findById(Number id, boolean lock) {
        return (Bank)this.getCurrentSession().load(Bank.class, (Serializable)id);
    }

    public List<Bank> findAll() {
        return this.getCurrentSession().createCriteria(Bank.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Bank getBankByCode(String bankCode) {
        Query qry = this.getCurrentSession().createQuery("from Bank where code=:bankCode");
        qry.setString("bankCode", bankCode);
        return (Bank)qry.uniqueResult();
    }

    public Bank getBankByName(String bankCode) {
        Query qry = this.getCurrentSession().createQuery("from Bank where name=:bankName");
        qry.setString("bankName", bankCode);
        return (Bank)qry.uniqueResult();
    }

    public List<Bank> getAllBanks() {
        Query qry = this.getCurrentSession().createQuery("from Bank order by code");
        return qry.list();
    }

    public List<Bank> getAllBankHavingBranchAndAccounts() {
        LinkedHashSet ss = new LinkedHashSet();
        ArrayList<Bank> bankList = new ArrayList<Bank>();
        Query createQuery = this.getCurrentSession().createQuery("select   b from Bank b , Bankbranch bb , Bankaccount ba WHERE bb.bank=b and ba.bankbranch=bb and b.isactive=true order by upper(b.name)");
        List list = createQuery.list();
        if (list != null && !list.isEmpty()) {
            ss.addAll(list);
            bankList.addAll(ss);
        }
        return bankList;
    }

    public List<Bank> getAllBanksByFund(Integer fundId) {
        List list;
        LinkedHashSet ss = new LinkedHashSet();
        ArrayList<Bank> bankList = new ArrayList<Bank>();
        Query createQuery = this.getCurrentSession().createQuery("select distinct b from Bank b,Bankbranch bb , Bankaccount ba  where bb.bank=b and ba.bankbranch =bb and ba.type in ('RECEIPTS_PAYMENTS','PAYMENTS') and ba.fund.id=:fundId").setInteger("fundId", fundId.intValue());
        if (fundId != null && (list = createQuery.list()) != null && !list.isEmpty()) {
            ss.addAll(list);
            bankList.addAll(ss);
        }
        return bankList;
    }
}

