/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Bankbranch;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BankBranchHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public Bankbranch update(Bankbranch entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public Bankbranch create(Bankbranch entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(Bankbranch entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public Bankbranch findById(Number id, boolean lock) {
        return (Bankbranch)this.getCurrentSession().load(Bankbranch.class, (Serializable)id);
    }

    public List<Bankbranch> findAll() {
        return this.getCurrentSession().createCriteria(Bankbranch.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<Bankbranch> getAllBankBranchs() {
        return this.getCurrentSession().createQuery("from Bankbranch BB order by BB.bank.name").list();
    }

    public List<Bankbranch> getAllBankBranchsByBank(Integer bankId) {
        List list;
        LinkedHashSet ss = new LinkedHashSet();
        ArrayList<Bankbranch> bankBranchList = new ArrayList<Bankbranch>();
        Query createQuery = this.getCurrentSession().createQuery("select distinct bb from Bankbranch bb , Bankaccount ba  where ba.bankbranch =bb and ba.type in ('RECEIPTS_PAYMENTS','PAYMENTS') and bb.bank.id=:bankId and bb.isactive=true").setInteger("bankId", bankId.intValue());
        if (bankId != null && (list = createQuery.list()) != null && !list.isEmpty()) {
            ss.addAll(list);
            bankBranchList.addAll(ss);
        }
        return bankBranchList;
    }

    public List<Bankbranch> getAllBankBranchsByBankForReceiptPayments(Integer bankId) {
        List list;
        LinkedHashSet ss = new LinkedHashSet();
        ArrayList<Bankbranch> bankBranchList = new ArrayList<Bankbranch>();
        Query createQuery = this.getCurrentSession().createQuery("select distinct bb from Bankbranch bb , Bankaccount ba  where ba.bankbranch =bb and ba.type in ('RECEIPTS_PAYMENTS','RECEIPTS') and bb.bank.id=:bankId and bb.isactive=true").setInteger("bankId", bankId.intValue());
        if (bankId != null && (list = createQuery.list()) != null && !list.isEmpty()) {
            ss.addAll(list);
            bankBranchList.addAll(ss);
        }
        return bankBranchList;
    }
}

