/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="Function")
@SequenceGenerator(name="SEQ_FUNCTION", sequenceName="SEQ_FUNCTION", allocationSize=1)
@Unique(id="id", tableName="Function", fields={"code", "name"}, columnName={"code", "name"}, enableDfltMsg=true)
public class CFunction
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ = "SEQ_FUNCTION";
    @Id
    @GeneratedValue(generator="SEQ_FUNCTION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(max=100, min=2)
    @Required
    private String name;
    @Length(max=50, min=2)
    @Required
    private String code;
    @Length(max=50)
    private String type;
    private int llevel;
    private Boolean isActive;
    private Boolean isNotLeaf;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parentId")
    private CFunction parentId;

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public int getLlevel() {
        return this.llevel;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Boolean getIsNotLeaf() {
        return this.isNotLeaf;
    }

    public CFunction getParentId() {
        return this.parentId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLlevel(int llevel) {
        this.llevel = llevel;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public void setIsNotLeaf(Boolean isNotLeaf) {
        this.isNotLeaf = isNotLeaf;
    }

    public void setParentId(CFunction parentId) {
        this.parentId = parentId;
    }
}

