/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.entity;

import java.util.Calendar;
import java.util.Date;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.entity.Module;

public class InstallmentBuilder {
    private final Installment installment = new Installment();

    public Installment build() {
        return this.installment;
    }

    public InstallmentBuilder withModule(Module module) {
        this.installment.setModule(module);
        return this;
    }

    public InstallmentBuilder withDescription(String description) {
        this.installment.setDescription(description);
        return this;
    }

    public InstallmentBuilder withFromDate(Date fromDate) {
        this.installment.setFromDate(fromDate);
        return this;
    }

    public InstallmentBuilder withToDate(Date toDate) {
        this.installment.setToDate(toDate);
        return this;
    }

    public InstallmentBuilder withCurrentHalfPeriod(Module module) {
        Calendar today = Calendar.getInstance();
        Calendar fromDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        int month = today.get(2) + 1;
        int year = today.get(1);
        fromDate.set(11, 0);
        fromDate.set(12, 0);
        fromDate.set(13, 0);
        toDate.set(11, 23);
        toDate.set(12, 59);
        toDate.set(13, 59);
        if (month >= 4 && month <= 9) {
            fromDate.set(5, 1);
            fromDate.set(2, 3);
            fromDate.set(1, year);
            toDate.set(5, 30);
            toDate.set(2, 8);
            toDate.set(1, year);
        } else {
            fromDate.set(5, 1);
            fromDate.set(2, 9);
            fromDate.set(1, year - 1);
            toDate.set(5, 31);
            toDate.set(2, 2);
            toDate.set(1, year);
        }
        this.withFromDate(fromDate.getTime());
        this.withToDate(toDate.getTime());
        this.withModule(module);
        return this;
    }
}

