/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.CFunction;
import org.egov.commons.repository.FunctionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FunctionService {
    private final FunctionRepository functionRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public FunctionService(FunctionRepository functionRepository) {
        this.functionRepository = functionRepository;
    }

    @Transactional
    public CFunction create(CFunction function) {
        return (CFunction)((Object)this.functionRepository.save((Object)function));
    }

    @Transactional
    public CFunction update(CFunction function) {
        return (CFunction)((Object)this.functionRepository.save((Object)function));
    }

    public List<CFunction> findAll() {
        return this.functionRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CFunction findByName(String name) {
        return this.functionRepository.findByName(name);
    }

    public CFunction findByCode(String code) {
        return this.functionRepository.findByCode(code);
    }

    public CFunction findOne(Long id) {
        return (CFunction)((Object)this.functionRepository.findOne(id));
    }

    public List<CFunction> findAllIsNotLeafTrue() {
        return this.functionRepository.findByIsNotLeaf(true);
    }

    public List<CFunction> findByNameLikeOrCodeLike(String name) {
        return this.functionRepository.findByNameContainingIgnoreCaseOrCodeContainingIgnoreCase(name, name);
    }

    public List<CFunction> search(CFunction function) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(CFunction.class);
        Root functions = createQuery.from(CFunction.class);
        createQuery.select((Selection)functions);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType CFunction_ = m.entity(CFunction.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (function.getName() != null) {
            String name = "%" + function.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)functions.get("name")));
            predicates.add(cb.like(cb.lower((Expression)functions.get(CFunction_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (function.getCode() != null) {
            String code = "%" + function.getCode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)functions.get("code")));
            predicates.add(cb.like(cb.lower((Expression)functions.get(CFunction_.getDeclaredSingularAttribute("code", String.class))), code));
        }
        if (function.getIsActive().booleanValue()) {
            predicates.add(cb.equal((Expression)functions.get(CFunction_.getDeclaredSingularAttribute("isActive", Boolean.class)), (Object)true));
        }
        if (function.getParentId() != null) {
            predicates.add(cb.equal((Expression)functions.get("parentId"), (Object)function.getParentId()));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }
}

