/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.repository.AccountEntityRepository;
import org.egov.commons.service.AccountDetailKeyService;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.masters.model.AccountEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AccountEntityService
implements EntityTypeService {
    private final AccountEntityRepository accountEntityRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;
    @Autowired
    private AccountDetailKeyService accountDetailKeyService;

    @Autowired
    public AccountEntityService(AccountEntityRepository accountEntityRepository) {
        this.accountEntityRepository = accountEntityRepository;
    }

    @Transactional
    public AccountEntity create(AccountEntity accountEntity) {
        AccountEntity accountEntitytmp = new AccountEntity();
        accountEntitytmp = (AccountEntity)this.accountEntityRepository.save(accountEntity);
        Accountdetailkey ac = new Accountdetailkey();
        ac.setDetailkey(accountEntitytmp.getId());
        ac.setDetailname(accountEntitytmp.getName());
        ac.setGroupid(Integer.valueOf(1));
        ac.setAccountdetailtype(accountEntitytmp.getAccountdetailtype());
        this.accountDetailKeyService.create(ac);
        return accountEntitytmp;
    }

    @Transactional
    public AccountEntity update(AccountEntity accountEntity) {
        return (AccountEntity)this.accountEntityRepository.save(accountEntity);
    }

    public List<AccountEntity> findAll() {
        return this.accountEntityRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public AccountEntity findByName(String name) {
        return this.accountEntityRepository.findByName(name);
    }

    public AccountEntity findByCode(String code) {
        return this.accountEntityRepository.findByCode(code);
    }

    public AccountEntity findOne(Integer id) {
        return (AccountEntity)this.accountEntityRepository.findOne(id);
    }

    public List<AccountEntity> search(AccountEntity accountEntity) {
        if (accountEntity.getAccountdetailtype() != null && accountEntity.getAccountdetailtype().getId() == null) {
            accountEntity.setAccountdetailtype(null);
        } else {
            accountEntity.setAccountdetailtype(this.accountdetailtypeService.findOne(accountEntity.getAccountdetailtype().getId()));
        }
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(AccountEntity.class);
        Root accountEntitys = createQuery.from(AccountEntity.class);
        createQuery.select((Selection)accountEntitys);
        Metamodel m = this.entityManager.getMetamodel();
        javax.persistence.metamodel.EntityType AccountEntity_ = m.entity(AccountEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (accountEntity.getName() != null) {
            String name = "%" + accountEntity.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)accountEntitys.get("name")));
            predicates.add(cb.like(cb.lower((Expression)accountEntitys.get(AccountEntity_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (accountEntity.getCode() != null) {
            String code = "%" + accountEntity.getCode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)accountEntitys.get("code")));
            predicates.add(cb.like(cb.lower((Expression)accountEntitys.get(AccountEntity_.getDeclaredSingularAttribute("code", String.class))), code));
        }
        if (accountEntity.getAccountdetailtype() != null) {
            predicates.add(cb.equal((Expression)accountEntitys.get("accountdetailtype"), (Object)accountEntity.getAccountdetailtype()));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }

    @Override
    public List<? extends EntityType> getAllActiveEntities(Integer accountDetailTypeId) {
        Accountdetailtype accountdetailtype = this.accountdetailtypeService.findOne(accountDetailTypeId);
        List<AccountEntity> activeEntityList = this.accountEntityRepository.findByAccountdetailtypeAndIsactive(accountdetailtype, true);
        return activeEntityList;
    }

    @Override
    public List<? extends EntityType> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        ArrayList<AccountEntity> entities = new ArrayList<AccountEntity>();
        filterKey = "%" + filterKey + "%";
        List<AccountEntity> pagedEntities = this.accountEntityRepository.findBy20(accountDetailTypeId, filterKey);
        entities.addAll(pagedEntities);
        return entities;
    }

    @Override
    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    @Override
    public List<? extends EntityType> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    @Override
    public List<? extends EntityType> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }
}

