/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.Fund;
import org.egov.commons.Vouchermis;
import org.egov.infra.workflow.entity.StateAware;
import org.hibernate.search.annotations.DocumentId;

@Entity
@Table(name="VOUCHERHEADER")
@SequenceGenerator(name="SEQ_VOUCHERHEADER", sequenceName="SEQ_VOUCHERHEADER", allocationSize=1)
public class CVoucherHeader
extends StateAware {
    private static final long serialVersionUID = -1950866465902911747L;
    public static final String SEQ_VOUCHERHEADER = "SEQ_VOUCHERHEADER";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_VOUCHERHEADER", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String name;
    private String type;
    private String description;
    private Date effectiveDate;
    private String voucherNumber;
    private Date voucherDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fundId")
    private Fund fundId;
    private Integer fiscalPeriodId;
    private Integer status;
    private Long originalvcId;
    private Integer isConfirmed;
    private Long refvhId;
    private String cgvn;
    private Integer moduleId;
    @Transient
    private String voucherSubType;
    @Transient
    private Boolean isRestrictedtoOneFunctionCenter;
    @Transient
    private String voucherNumberPrefix;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="voucherHeaderId", targetEntity=CGeneralLedger.class)
    private Set<CGeneralLedger> generalLedger;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="voucherheaderid", targetEntity=Vouchermis.class)
    private Vouchermis vouchermis;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getVoucherDate() {
        return this.voucherDate;
    }

    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public Fund getFundId() {
        return this.fundId;
    }

    public void setFundId(Fund fundId) {
        this.fundId = fundId;
    }

    public Integer getFiscalPeriodId() {
        return this.fiscalPeriodId;
    }

    public void setFiscalPeriodId(Integer fiscalPeriodId) {
        this.fiscalPeriodId = fiscalPeriodId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getOriginalvcId() {
        return this.originalvcId;
    }

    public void setOriginalvcId(Long originalvcId) {
        this.originalvcId = originalvcId;
    }

    public Integer getIsConfirmed() {
        return this.isConfirmed;
    }

    public void setIsConfirmed(Integer isConfirmed) {
        this.isConfirmed = isConfirmed;
    }

    public Long getRefvhId() {
        return this.refvhId;
    }

    public void setRefvhId(Long refvhId) {
        this.refvhId = refvhId;
    }

    public String getCgvn() {
        return this.cgvn;
    }

    public void setCgvn(String cgvn) {
        this.cgvn = cgvn;
    }

    public Integer getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Integer moduleId) {
        this.moduleId = moduleId;
    }

    public String getStateDetails() {
        return this.voucherNumber + "-" + this.getState().getComments();
    }

    public Set<CGeneralLedger> getGeneralledger() {
        return this.generalLedger;
    }

    public Vouchermis getVouchermis() {
        return this.vouchermis;
    }

    public void setVouchermis(Vouchermis vouchermis) {
        this.vouchermis = vouchermis;
    }

    public void reset() {
        this.name = null;
        this.type = null;
        this.description = null;
        this.effectiveDate = null;
        this.voucherNumber = null;
        this.voucherDate = null;
        this.fundId = null;
        this.fiscalPeriodId = null;
        this.status = null;
        this.originalvcId = null;
        this.isConfirmed = null;
        this.refvhId = null;
        this.cgvn = null;
        this.moduleId = null;
        this.vouchermis = null;
    }

    public BigDecimal getTotalAmount() {
        BigDecimal amount = BigDecimal.ZERO;
        for (CGeneralLedger detail : this.generalLedger) {
            amount = amount.add(new BigDecimal(detail.getDebitAmount()));
        }
        return amount;
    }

    public Boolean getIsRestrictedtoOneFunctionCenter() {
        return this.isRestrictedtoOneFunctionCenter;
    }

    public void setIsRestrictedtoOneFunctionCenter(Boolean isRestrictedtoOneFunctionCenter) {
        this.isRestrictedtoOneFunctionCenter = isRestrictedtoOneFunctionCenter;
    }

    public String getVoucherSubType() {
        return this.voucherSubType;
    }

    public void setVoucherSubType(String voucherSubType) {
        this.voucherSubType = voucherSubType;
    }

    public Set<CGeneralLedger> getGeneralLedger() {
        return this.generalLedger;
    }

    public void setGeneralLedger(Set<CGeneralLedger> generalLedger) {
        this.generalLedger = generalLedger;
    }

    public String getVoucherNumberPrefix() {
        return this.voucherNumberPrefix;
    }

    public void setVoucherNumberPrefix(String voucherNumberPrefix) {
        this.voucherNumberPrefix = voucherNumberPrefix;
    }
}

