/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Fund;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FundHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public Fund update(Fund entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public Fund create(Fund entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(Fund entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public List<Fund> findAll() {
        return this.getCurrentSession().createCriteria(Fund.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List findAllActiveFunds() {
        return this.getCurrentSession().createQuery("from Fund where isactive = true order by name").list();
    }

    public List findAllActiveIsLeafFunds() {
        return this.getCurrentSession().createQuery("from Fund where isactive = true and isnotleaf=false order by name").list();
    }

    public Fund fundByCode(String fundCode) {
        Query qry = this.getCurrentSession().createQuery("FROM Fund f WHERE f.code =:fundCode");
        qry.setString("fundCode", fundCode);
        return (Fund)((Object)qry.uniqueResult());
    }

    public Fund fundById(Integer id, boolean b) {
        return (Fund)((Object)this.getCurrentSession().get(Fund.class, (Serializable)id));
    }
}

