/*
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 *         1) All versions of this program, verbatim or modified must carry this
 *            Legal Notice.
 *
 *         2) Any misrepresentation of the origin of the material is prohibited. It
 *            is required that all modified versions of this material be marked in
 *            reasonable ways as different from the original version.
 *
 *         3) This license does not grant any rights to any user of the program
 *            with regards to rights under trademark law for use of the trade names
 *            or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.commons;

import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="Function")
@SequenceGenerator(name = CFunction.SEQ, sequenceName = CFunction.SEQ, allocationSize = 1)
@Unique(id = "id", tableName = "Function", fields = { "code","name" }, columnName = { "code","name" }, enableDfltMsg = true)
public class CFunction extends AbstractAuditable{
	
	private static final long serialVersionUID = 1L;
	public static final String SEQ = "SEQ_FUNCTION";

	@Id
	@GeneratedValue(generator = SEQ, strategy = GenerationType.SEQUENCE)
	private Long id ;
	
	
    @Length(max = 100, min = 2)
    @Required
	private String name;
	
	@Length(max = 50, min = 2)
    @Required
	private String code;
	
	@Length(max=50)
	private String type;
	
	private int llevel;
	
	private Boolean isActive;
	
	private Boolean isNotLeaf;
	 
	@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name = "parentId")	
	private CFunction parentId;

	public Long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getCode() {
		return code;
	}

	public String getType() {
		return type;
	}

	public int getLlevel() {
		return llevel;
	}

	public Boolean getIsActive() {
		return isActive;
	}

	public Boolean getIsNotLeaf() {
		return isNotLeaf;
	}

	public CFunction getParentId() {
		return parentId;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public void setType(String type) {
		this.type = type;
	}

	public void setLlevel(int llevel) {
		this.llevel = llevel;
	}

	public void setIsActive(Boolean isActive) {
		this.isActive = isActive;
	}

	public void setIsNotLeaf(Boolean isNotLeaf) {
		this.isNotLeaf = isNotLeaf;
	}

	public void setParentId(CFunction parentId) {
		this.parentId = parentId;
	}
	 
	
	
	
	
}
