/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.BranchUserMap;
import org.egov.commons.Bankbranch;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"bankBranchList"}, location="branchUserMap-bankBranchList.jsp"), @Result(name={"success"}, location="branchUserMap-success.jsp"), @Result(name={"beforesearch"}, location="branchUserMap-search.jsp"), @Result(name={"search"}, location="branchUserMap-search.jsp"), @Result(name={"new"}, location="branchUserMap-new.jsp")})
public class BranchUserMapAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(BranchUserMapAction.class);
    private static final long serialVersionUID = 1L;
    protected static final String BEFORECREATE = "beforeCreate";
    protected static final String SEARCH = "search";
    protected static final String BEFORESEARCH = "beforesearch";
    protected static final String MESSAGE = "message";
    private BranchUserMap branchUserMap = new BranchUserMap();
    private static final String BANK_BRANCH_LIST = "bankBranchList";
    private static final String BANK_NAME_LIST = "bankNameList";
    private static final String BANK_COLLECTION_OPERATOR_USER_LIST = "bankCollectionOperatorUserList";
    protected static final String BANKBRANCHLIST = "bankBranchList";
    private List<Bankbranch> bankBranchArrayList = new ArrayList(0);
    private PersistenceService<BranchUserMap, Long> branchUserMapService;
    private List<BranchUserMap> branchUserList = null;
    private Integer bankId;
    private Integer branchId;
    private Long userId;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    private UserService userService;
    @Autowired
    private BankBranchHibernateDAO bankBranchHibernateDAO;
    @PersistenceContext
    private EntityManager entityManager;
    private Boolean isActive = Boolean.FALSE;

    public BranchUserMapAction() {
        this.addRelatedEntity("bankbranch", Bankbranch.class);
        this.addRelatedEntity("bankuser", User.class);
    }

    public BranchUserMap getModel() {
        return this.branchUserMap;
    }

    @Action(value="/service/branchUserMap-newform")
    public String newform() {
        this.addDropdownData(BANK_NAME_LIST, this.bankHibernateDAO.getAllBankHavingBranchAndAccounts());
        System.out.println(this.branchUserMap.getIsActive());
        this.addDropdownData("bankBranchList", Collections.emptyList());
        this.addDropdownData(BANK_COLLECTION_OPERATOR_USER_LIST, this.getBankCollectionOperator());
        return "new";
    }

    private List<User> getBankCollectionOperator() {
        ArrayList<User> bankCollOpUserList = new ArrayList<User>(this.userService.getUsersByRoleName("Bank Collection Operator"));
        TypedQuery query = this.entityManager.createNamedQuery("QUERY_ACTIVE_BRANCHUSER", User.class);
        List userMapToBranchList = query.getResultList();
        if (!userMapToBranchList.isEmpty()) {
            bankCollOpUserList.removeAll(userMapToBranchList);
        }
        if (bankCollOpUserList.isEmpty()) {
            return Collections.emptyList();
        }
        return bankCollOpUserList;
    }

    @Action(value="/service/branchUserMap-bankBranchsByBankForReceiptPayments")
    public String bankBranchsByBankForReceiptPayments() {
        this.bankBranchArrayList = this.bankBranchHibernateDAO.getAllBankBranchsByBankForReceiptPayments(this.bankId);
        return "bankBranchList";
    }

    @Action(value="/service/branchUserMap-create")
    public String create() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside create");
        }
        if (this.branchId != null && this.userId != null) {
            this.branchUserMap.setBankbranch(this.bankBranchHibernateDAO.findById((Number)this.branchId, Boolean.FALSE.booleanValue()));
            this.branchUserMap.setIsActive(this.getIsActive());
            this.branchUserMap.setBankuser(this.userService.getUserById(this.userId));
            this.branchUserMapService.persist((Object)this.branchUserMap);
            this.addActionMessage(this.getText("branchuser.master.success", new String[]{this.branchUserMap.getBankuser().getUsername(), this.branchUserMap.getBankbranch().getBranchname()}));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"end create");
        }
        return "success";
    }

    public Integer getBankId() {
        return this.bankId;
    }

    public void setBankId(Integer bankId) {
        this.bankId = bankId;
    }

    public List getBankBranchArrayList() {
        return this.bankBranchArrayList;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getBranchId() {
        return this.branchId;
    }

    public void setBranchId(Integer branchId) {
        this.branchId = branchId;
    }

    public PersistenceService<BranchUserMap, Long> getBranchUserMapService() {
        return this.branchUserMapService;
    }

    public void setBranchUserMapService(PersistenceService<BranchUserMap, Long> branchUserMapService) {
        this.branchUserMapService = branchUserMapService;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public List<BranchUserMap> getBranchUserList() {
        return this.branchUserList;
    }
}

