/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.CollectionBankRemittanceReport;
import org.egov.collection.entity.CollectionRemittanceReportResult;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.Remittance;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.web.actions.receipts.AjaxBankRemittanceAction;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"index"}, location="remittanceVoucherReport-index.jsp"), @Result(name={"report"}, location="remittanceVoucherReport-report.jsp")})
@ParentPackage(value="egov")
public class RemittanceVoucherReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_VOUCHER_NUMBER = "EGOV_VOUCHER_NUMBER";
    private static final String EGOV_RECEIPT_NUMBER = "EGOV_RECEIPT_NUMBER";
    private static final String EGOV_REMITTANCE_NUMBER = "EGOV_REMITTANCE_NUMBER";
    private static final String EGOV_REMITTANCE_DATE = "EGOV_REMITTANCE_DATE";
    private static final String EGOV_BANKACCOUNT_ID = "EGOV_BANKACCOUNT_ID";
    private static final String EGOV_BRANCH_ID = "EGOV_BRANCH_ID";
    @Autowired
    private ReportService reportService;
    private Integer branchId;
    private String voucherNumber;
    private Long bankAcctId;
    private static final String ACCOUNT_NUMBER_LIST = "accountNumberList";
    private static final String RECEIPTDETAILSLIST = "receiptdetailslist";
    private static final String RECIEPT_DETAILS_TEMPLATE = "collection_receiptdetails_main_report";
    private String reportId;
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    private final Map<String, Object> critParams = new HashMap(0);
    private List<CollectionBankRemittanceReport> bankRemittanceList;
    private Long srvId;
    private Integer bankBranchId;
    @Autowired
    private BankaccountHibernateDAO bankAccountHibernateDAO;
    @Autowired
    private BankBranchHibernateDAO bankbranchDAO;
    private PersistenceService<ServiceDetails, Long> serviceDetailsService;
    @Autowired
    private CollectionsUtil collectionsUtil;
    @Autowired
    private CityService cityService;

    public void prepare() {
        this.setReportFormat(ReportFormat.PDF);
        this.setDataSourceType(ReportDataSourceType.SQL);
    }

    public void populateBankAccountList() {
        AjaxBankRemittanceAction ajaxBankRemittanceAction = new AjaxBankRemittanceAction();
        ajaxBankRemittanceAction.setPersistenceService(this.getPersistenceService());
        ajaxBankRemittanceAction.setCollectionsUtil(this.collectionsUtil);
        ajaxBankRemittanceAction.bankBranchListOfService();
        this.addDropdownData("bankBranchList", ajaxBankRemittanceAction.getBankBranchArrayList());
        if (this.branchId != null) {
            ajaxBankRemittanceAction.setBranchId(this.branchId);
            ajaxBankRemittanceAction.accountListOfService();
            this.addDropdownData(ACCOUNT_NUMBER_LIST, ajaxBankRemittanceAction.getBankAccountArrayList());
        } else {
            this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.EMPTY_LIST);
        }
    }

    @Action(value="/reports/remittanceVoucherReport-criteria")
    public String criteria() {
        this.populateBankAccountList();
        this.setReportParam(EGOV_REMITTANCE_DATE, (Object)new Date());
        this.critParams.put(EGOV_REMITTANCE_DATE, new Date());
        return "index";
    }

    @Action(value="/reports/remittanceVoucherReport-reportReceiptDetails")
    public String reportReceiptDetails() {
        Remittance remittanceObj = (Remittance)this.persistenceService.findByNamedQuery("getRemitanceByVoucherNumber", new Object[]{this.voucherNumber});
        this.critParams.put(EGOV_REMITTANCE_DATE, new Date());
        ArrayList<CollectionBankRemittanceReport> reportList = new ArrayList<CollectionBankRemittanceReport>(0);
        if (remittanceObj != null) {
            for (ReceiptHeader receiptHead : remittanceObj.getCollectionRemittance()) {
                Iterator itr = receiptHead.getReceiptInstrument().iterator();
                while (itr.hasNext()) {
                    CollectionBankRemittanceReport collBankRemitReport = new CollectionBankRemittanceReport();
                    InstrumentHeader instHead = (InstrumentHeader)itr.next();
                    collBankRemitReport.setPaymentMode(instHead.getInstrumentType().getType());
                    collBankRemitReport.setAmount(Double.valueOf(instHead.getInstrumentAmount().doubleValue()));
                    collBankRemitReport.setReceiptNumber(receiptHead.getReceiptnumber());
                    collBankRemitReport.setReceiptDate(receiptHead.getReceiptDate());
                    collBankRemitReport.setServiceType(receiptHead.getService().getName());
                    reportList.add(collBankRemitReport);
                }
            }
        }
        ServiceDetails service = (ServiceDetails)this.serviceDetailsService.findById((Serializable)this.srvId, false);
        this.critParams.put("CITY_LOGO_PATH", this.cityService.getCityLogoURL());
        CollectionRemittanceReportResult collReportResult = new CollectionRemittanceReportResult();
        collReportResult.setCollectionBankRemittanceReportList(reportList);
        ReportRequest reportInput = new ReportRequest(RECIEPT_DETAILS_TEMPLATE, (Object)collReportResult, this.critParams);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return "report";
    }

    @Action(value="/reports/remittanceVoucherReport-report")
    public String report() {
        this.critParams.put("CITY_LOGO_PATH", this.cityService.getCityLogoURL());
        ReportRequest reportInput = new ReportRequest(this.getReportTemplateName(), this.critParams, ReportDataSourceType.SQL);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return "report";
    }

    public void setFromDate(Date fromDate) {
        this.critParams.put(EGOV_REMITTANCE_DATE, fromDate);
    }

    public static String getReceiptdetailslist() {
        return RECEIPTDETAILSLIST;
    }

    protected String getReportTemplateName() {
        return "collection_remittancevoucher_report";
    }

    public Integer getBankAccountId() {
        return (Integer)this.getReportParam(EGOV_BANKACCOUNT_ID);
    }

    public void setBankAccountId(Integer bankAccountId) {
        this.critParams.put(EGOV_BANKACCOUNT_ID, bankAccountId);
    }

    public Integer getBranchId() {
        return (Integer)this.getReportParam(EGOV_BRANCH_ID);
    }

    public void setBranchId(Integer branchId) {
        this.critParams.put(EGOV_BRANCH_ID, branchId);
    }

    public Date getRemittanceDate() {
        return (Date)this.getReportParam(EGOV_REMITTANCE_DATE);
    }

    public void setRemittanceDate(Date remittanceDate) {
        this.critParams.put(EGOV_REMITTANCE_DATE, remittanceDate);
    }

    public String getReceiptNumber() {
        return (String)this.getReportParam(EGOV_RECEIPT_NUMBER);
    }

    public void setReceiptNumber(String receiptNumber) {
        this.critParams.put(EGOV_RECEIPT_NUMBER, receiptNumber);
    }

    public String getRemittanceNumber() {
        return (String)this.getReportParam(EGOV_REMITTANCE_NUMBER);
    }

    public void setRemittanceNumber(String remittanceNumber) {
        this.critParams.put(EGOV_REMITTANCE_NUMBER, remittanceNumber);
    }

    public String getVoucherNumber() {
        return (String)this.getReportParam(EGOV_VOUCHER_NUMBER);
    }

    public void setVoucherNumber(String voucherNumber) {
        this.critParams.put(EGOV_VOUCHER_NUMBER, voucherNumber);
    }

    public String getReportId() {
        return this.reportId;
    }

    public List<CollectionBankRemittanceReport> getBankRemittanceList() {
        return this.bankRemittanceList;
    }

    public void setBankRemittanceList(List<CollectionBankRemittanceReport> bankRemittanceList) {
        this.bankRemittanceList = bankRemittanceList;
    }

    public Long getBankAcctId() {
        return this.bankAcctId;
    }

    public void setBankAcctId(Long bankAcctId) {
        this.bankAcctId = bankAcctId;
    }

    public Integer getBankBranchId() {
        return this.bankBranchId;
    }

    public void setBankBranchId(Integer bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public void setServiceDetailsService(PersistenceService<ServiceDetails, Long> serviceDetailsService) {
        this.serviceDetailsService = serviceDetailsService;
    }
}

