/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.util.Date;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.web.struts.actions.ReportFormAction;

public class PendingChallansReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_DEPT_ID = "EGOV_DEPT_ID";
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_CHALLAN_SERVICE_ID = "EGOV_CHALLAN_SERVICE_ID";
    private CollectionsUtil collectionsUtil;

    public void prepare() {
        super.prepare();
        this.setReportFormat(ReportFormat.PDF);
        this.setDataSourceType(ReportDataSourceType.HQL);
    }

    @Action(value="/reports/pendingChallansReport-criteria", results={@Result(name={"index"}, type="redirect")})
    public String criteria() {
        this.addRelatedEntity("department", Department.class, "deptName");
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("serviceList", this.collectionsUtil.getChallanServiceList());
        Department dept = this.collectionsUtil.getDepartmentOfLoggedInUser();
        if (dept != null) {
            this.setReportParam(EGOV_DEPT_ID, (Object)dept.getId());
        }
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        return "index";
    }

    protected String getReportTemplateName() {
        return "pending_challans";
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Integer getDeptId() {
        return (Integer)this.getReportParam(EGOV_DEPT_ID);
    }

    public void setDeptId(Integer deptId) {
        this.setReportParam(EGOV_DEPT_ID, (Object)deptId);
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    public void setFromDate(Date fromDate) {
        this.setReportParam(EGOV_FROM_DATE, (Object)fromDate);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public void setToDate(Date toDate) {
        this.setReportParam(EGOV_TO_DATE, (Object)toDate);
    }

    public Long getChallanServiceId() {
        return (Long)this.getReportParam(EGOV_CHALLAN_SERVICE_ID);
    }

    public void setChallanServiceId(Long challanServiceId) {
        this.setReportParam(EGOV_CHALLAN_SERVICE_ID, (Object)challanServiceId);
    }
}

