/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.service.CollectionReportHeadWiseService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"index"}, location="collectionSummaryHeadWise-index.jsp"), @Result(name={"report"}, location="collectionSummaryHeadWise-report.jsp")})
public class CollectionSummaryHeadWiseAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_PAYMENT_MODE = "EGOV_PAYMENT_MODE";
    private static final String COLLECTION_SUMMARY_TEMPLATE = "collection_summary_headwise";
    private static final String EGOV_SOURCE = "EGOV_SOURCE";
    private static final String EGOV_STATUS = "EGOV_STATUS";
    private static final String EGOV_GLCODE_NAME = "EGOV_GLCODE_NAME";
    private static final String EGOV_GLCODE_ID = "EGOV_GLCODE_ID";
    private static final String EGOV_BRANCH_NAME = "EGOV_BRANCH_NAME";
    private Integer statusId;
    private Long revenueId;
    private String glCode;
    private final Map<String, String> paymentModes = this.createPaymentModeList();
    private final Map<String, String> sources = this.createSourceList();
    private CollectionsUtil collectionsUtil;
    @Autowired
    private CollectionReportHeadWiseService reportService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private Integer branchId = -1;
    @Autowired
    private CityService cityService;

    private Map<String, String> createPaymentModeList() {
        HashMap<String, String> paymentModesMap = new HashMap<String, String>(0);
        paymentModesMap.put("cash", "cash");
        paymentModesMap.put("cheque/dd", "cheque/dd");
        paymentModesMap.put("online", "online");
        paymentModesMap.put("card", "card");
        return paymentModesMap;
    }

    private Map<String, String> createSourceList() {
        HashMap<String, String> sourcesMap = new HashMap<String, String>(0);
        sourcesMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        sourcesMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        sourcesMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        sourcesMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return sourcesMap;
    }

    public void prepare() {
        this.setReportFormat(ReportFormat.PDF);
        this.setDataSourceType(ReportDataSourceType.JAVABEAN);
        this.addDropdownData("bankBranchList", this.collectionsUtil.getBankCollectionBankBranchList());
    }

    @Action(value="/reports/collectionSummaryHeadWise-criteria")
    public String criteria() {
        this.addRelatedEntity("department", Department.class, "name");
        this.addDropdownData("servicetypeList", this.collectionsUtil.getBillingServiceList());
        this.setupDropdownDataExcluding(new String[0]);
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        this.addDropdownData("receiptStatuses", this.getPersistenceService().findAllByNamedQuery("STATUS_OF_RECEIPTS", new Object[0]));
        this.addDropdownData("revenueHeads", this.chartOfAccountsHibernateDAO.getActiveAccountsForTypes(CollectionConstants.REVENUEHEADS));
        return "index";
    }

    @Action(value="/reports/collectionSummaryHeadWise-report")
    public String report() {
        EgwStatus statusObj;
        if (this.getStatusId() != -1) {
            statusObj = (EgwStatus)this.entityManager.find(EgwStatus.class, (Object)this.getStatusId());
            this.setStatusName(statusObj.getDescription());
        }
        if (this.getRevenueId() != -1L) {
            statusObj = (CChartOfAccounts)this.entityManager.find(CChartOfAccounts.class, (Object)this.getRevenueId());
            this.setGlCodeName(statusObj.getName());
            this.setGlCode(statusObj.getGlcode());
        }
        if (this.getBranchId() != null && this.getBranchId() != -1) {
            Bankbranch bankbranch = (Bankbranch)this.entityManager.find(Bankbranch.class, (Object)this.getBranchId());
            String brankname = bankbranch.getBank().getName() + "-" + bankbranch.getBranchname();
            this.setBranchName(brankname);
        } else {
            this.setBranchName("All Bank Branch");
        }
        this.setReportParam("CITY_LOGO_PATH", (Object)this.cityService.getCityLogoURL());
        this.setReportData((Object)this.reportService.getCollectionSummaryReport(this.getFromDate(), this.getToDate(), this.getPaymentMode(), this.getSource(), this.getGlCode(), this.getStatusId(), this.getBranchId()));
        return super.report();
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    public void setFromDate(Date fromDate) {
        this.setReportParam(EGOV_FROM_DATE, (Object)fromDate);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public void setToDate(Date toDate) {
        this.setReportParam(EGOV_TO_DATE, (Object)toDate);
    }

    public String getPaymentMode() {
        return (String)this.getReportParam(EGOV_PAYMENT_MODE);
    }

    public void setPaymentMode(String paymentMode) {
        this.setReportParam(EGOV_PAYMENT_MODE, (Object)paymentMode);
    }

    public Map<String, String> getPaymentModes() {
        return this.paymentModes;
    }

    public String getSource() {
        return (String)this.getReportParam(EGOV_SOURCE);
    }

    public void setSource(String source) {
        this.setReportParam(EGOV_SOURCE, (Object)source);
    }

    public Map<String, String> getSources() {
        return this.sources;
    }

    protected String getReportTemplateName() {
        return COLLECTION_SUMMARY_TEMPLATE;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public String getStatusName() {
        return (String)this.getReportParam(EGOV_STATUS);
    }

    public void setStatusName(String statusName) {
        this.setReportParam(EGOV_STATUS, (Object)statusName);
    }

    public Long getGlCodeId() {
        return (Long)this.getReportParam(EGOV_GLCODE_ID);
    }

    public void setGlCodeId(String glCodeId) {
        this.setReportParam(EGOV_GLCODE_ID, (Object)glCodeId);
    }

    public String getGlCodeName() {
        return (String)this.getReportParam(EGOV_GLCODE_ID);
    }

    public void setGlCodeName(String glCodeName) {
        this.setReportParam(EGOV_GLCODE_NAME, (Object)glCodeName);
    }

    public String getGlCode() {
        return this.glCode;
    }

    public void setGlCode(String glCode) {
        this.glCode = glCode;
    }

    public Long getRevenueId() {
        return this.revenueId;
    }

    public void setRevenueId(Long revenueId) {
        this.revenueId = revenueId;
    }

    public Integer getBranchId() {
        return this.branchId;
    }

    public void setBranchId(Integer branchId) {
        this.branchId = branchId;
    }

    public void setBranchName(String branchName) {
        this.setReportParam(EGOV_BRANCH_NAME, (Object)branchName);
    }
}

