/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.service.CollectionReportService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.EgwStatus;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.egov.infstr.models.ServiceDetails;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"index"}, location="collectionSummary-index.jsp"), @Result(name={"report"}, location="collectionSummary-report.jsp")})
public class CollectionSummaryAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_PAYMENT_MODE = "EGOV_PAYMENT_MODE";
    private static final String COLLECTION_SUMMARY_TEMPLATE = "collection_summary";
    private static final String EGOV_SOURCE = "EGOV_SOURCE";
    private static final String EGOV_SERVICE_ID = "EGOV_SERVICE_ID";
    private static final String EGOV_SERVICE_NAME = "EGOV_SERVICE_NAME";
    private static final String EGOV_STATUS = "EGOV_STATUS";
    private static final String EGOV_CLASSIFICATION = "EGOV_CLASSIFICATION";
    private Integer statusId;
    private final Map<String, String> paymentModes = this.createPaymentModeList();
    private final Map<String, String> sources = this.createSourceList();
    private TreeMap<String, String> serviceTypeMap = new TreeMap();
    private CollectionsUtil collectionsUtil;
    @Autowired
    private CollectionReportService reportService;
    @PersistenceContext
    EntityManager entityManager;
    private String serviceType;
    @Autowired
    private CityService cityService;

    private Map<String, String> createPaymentModeList() {
        HashMap<String, String> paymentModesMap = new HashMap<String, String>(0);
        paymentModesMap.put("cash", "cash");
        paymentModesMap.put("cheque/dd", "cheque/dd");
        paymentModesMap.put("online", "online");
        paymentModesMap.put("bankchallan", "bankchallan");
        paymentModesMap.put("card", "card");
        return paymentModesMap;
    }

    private Map<String, String> createSourceList() {
        HashMap<String, String> sourcesMap = new HashMap<String, String>(0);
        sourcesMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        sourcesMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        sourcesMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        sourcesMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return sourcesMap;
    }

    public void prepare() {
        this.setReportFormat(ReportFormat.PDF);
        this.setDataSourceType(ReportDataSourceType.JAVABEAN);
    }

    @Action(value="/reports/collectionSummary-criteria")
    public String criteria() {
        this.addRelatedEntity("department", Department.class, "name");
        this.addDropdownData("servicetypeList", this.collectionsUtil.getBillingServiceList());
        this.setupDropdownDataExcluding(new String[0]);
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        this.addDropdownData("receiptStatuses", this.getPersistenceService().findAllByNamedQuery("STATUS_OF_RECEIPTS", new Object[0]));
        this.serviceTypeMap.putAll(CollectionConstants.SERVICE_TYPE_CLASSIFICATION);
        this.serviceTypeMap.remove("P");
        return "index";
    }

    @Action(value="/reports/collectionSummary-report")
    public String report() {
        if (this.getServiceId() != null && this.getServiceId() != -1L) {
            ServiceDetails serviceDets = (ServiceDetails)this.entityManager.find(ServiceDetails.class, (Object)this.getServiceId());
            this.setServiceName(serviceDets.getName());
        }
        if (this.getStatusId() != -1) {
            EgwStatus statusObj = (EgwStatus)this.entityManager.find(EgwStatus.class, (Object)this.getStatusId());
            this.setStatusName(statusObj.getDescription());
        }
        this.setClassification(this.getServiceType());
        this.setReportData((Object)this.reportService.getCollectionSummaryReport(this.getFromDate(), this.getToDate(), this.getPaymentMode(), this.getSource(), this.getServiceId(), this.getStatusId(), this.getServiceType()));
        this.setReportParam("CITY_LOGO_PATH", (Object)this.cityService.getCityLogoURL());
        return super.report();
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    public void setFromDate(Date fromDate) {
        this.setReportParam(EGOV_FROM_DATE, (Object)fromDate);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public void setToDate(Date toDate) {
        this.setReportParam(EGOV_TO_DATE, (Object)toDate);
    }

    public String getPaymentMode() {
        return (String)this.getReportParam(EGOV_PAYMENT_MODE);
    }

    public void setPaymentMode(String paymentMode) {
        this.setReportParam(EGOV_PAYMENT_MODE, (Object)paymentMode);
    }

    public Map<String, String> getPaymentModes() {
        return this.paymentModes;
    }

    public String getSource() {
        return (String)this.getReportParam(EGOV_SOURCE);
    }

    public void setSource(String source) {
        this.setReportParam(EGOV_SOURCE, (Object)source);
    }

    public Map<String, String> getSources() {
        return this.sources;
    }

    public Long getServiceId() {
        return (Long)this.getReportParam(EGOV_SERVICE_ID);
    }

    public void setServiceId(Long serviceId) {
        this.setReportParam(EGOV_SERVICE_ID, (Object)serviceId);
    }

    public Long getServiceName() {
        return (Long)this.getReportParam(EGOV_SERVICE_ID);
    }

    public void setServiceName(String serviceName) {
        this.setReportParam(EGOV_SERVICE_NAME, (Object)serviceName);
    }

    protected String getReportTemplateName() {
        return COLLECTION_SUMMARY_TEMPLATE;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public String getStatusName() {
        return (String)this.getReportParam(EGOV_STATUS);
    }

    public void setStatusName(String statusName) {
        this.setReportParam(EGOV_STATUS, (Object)statusName);
    }

    public TreeMap<String, String> getServiceTypeMap() {
        return this.serviceTypeMap;
    }

    public void setServiceTypeMap(TreeMap<String, String> serviceTypeMap) {
        this.serviceTypeMap = serviceTypeMap;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getClassification() {
        return (String)this.getReportParam(EGOV_CLASSIFICATION);
    }

    public void setClassification(String classification) {
        this.setReportParam(EGOV_CLASSIFICATION, (Object)classification);
    }
}

