/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.web.actions.reports.CashCollectionReportAction;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"index"}, location="chequeCollectionReport-index.jsp"), @Result(name={"report"}, location="chequeCollectionReport-report.jsp")})
public class ChequeCollectionReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CashCollectionReportAction.class);
    public Map<String, Object> critParams = new HashMap(0);
    private ReportService reportService;
    private CollectionsUtil collectionsUtil;
    private String reportId;
    public static final String REPORT = "report";
    private static final String EGOV_COUNTER_OPERATOR_ID = "EGOV_COUNTER_OPERATOR_ID";
    private static final String EGOV_COUNTER_ID = "EGOV_COUNTER_ID";
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_BOUNDARY_ID = "EGOV_BOUNDARY_ID";
    private static final String EGOV_RECEIPT_IDS = "EGOV_RECEIPT_IDS";
    private static final String CHEQUE_COLLETION_TEMPLATE = "chequeCollectionReport";
    private String receiptDate;
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    @Autowired
    private CityService cityService;

    public Object getModel() {
        return null;
    }

    public void setFromDate(Date fromDate) {
        this.critParams.put(EGOV_FROM_DATE, fromDate);
    }

    public void setToDate(Date toDate) {
        this.critParams.put(EGOV_TO_DATE, toDate);
    }

    public void setCounterId(Long counterId) {
        this.critParams.put(EGOV_COUNTER_ID, counterId);
    }

    public void setUserId(Long userId) {
        this.critParams.put(EGOV_COUNTER_OPERATOR_ID, userId);
    }

    public void setBoundaryId(Long boundaryId) {
        this.critParams.put(EGOV_BOUNDARY_ID, boundaryId);
    }

    public Date getFromDate() {
        return (Date)this.critParams.get(EGOV_FROM_DATE);
    }

    public Date getToDate() {
        return (Date)this.critParams.get(EGOV_TO_DATE);
    }

    public Long getCounterId() {
        return (Long)this.critParams.get(EGOV_COUNTER_ID);
    }

    public Long getUserId() {
        return (Long)this.critParams.get(EGOV_COUNTER_OPERATOR_ID);
    }

    public Long getBoundaryId() {
        return (Long)this.critParams.get(EGOV_BOUNDARY_ID);
    }

    public String getReportId() {
        return this.reportId;
    }

    private void initializeCriteriaMap() {
        this.critParams.clear();
        this.critParams.put(EGOV_COUNTER_OPERATOR_ID, -1L);
        this.critParams.put(EGOV_COUNTER_ID, -1L);
        this.critParams.put(EGOV_FROM_DATE, new Date());
        this.critParams.put(EGOV_TO_DATE, new Date());
        this.critParams.put(EGOV_BOUNDARY_ID, -1L);
    }

    public void prepare() {
        super.prepare();
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("counterList", this.collectionsUtil.getAllCounters());
        this.addDropdownData("receiptCreatorList", this.collectionsUtil.getReceiptCreators());
        this.addDropdownData("activeZoneList", this.collectionsUtil.getReceiptZoneList());
        this.initializeCriteriaMap();
    }

    @Action(value="/reports/chequeCollectionReport-submissionReport")
    public String submissionReport() {
        Map session = this.getSession();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date rcptDate = null;
        try {
            rcptDate = sdf.parse(this.receiptDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Exception occured while parsing receipt created date", (Throwable)e);
        }
        this.critParams.put(EGOV_FROM_DATE, rcptDate);
        this.critParams.put(EGOV_TO_DATE, rcptDate);
        this.critParams.put(EGOV_COUNTER_OPERATOR_ID, -1L);
        this.critParams.put(EGOV_COUNTER_ID, Long.valueOf(this.collectionsUtil.getLocationOfUser(this.getSession()).getId()));
        this.critParams.put(EGOV_RECEIPT_IDS, Arrays.asList((Long[])session.get(EGOV_RECEIPT_IDS)));
        return this.report();
    }

    @Action(value="/reports/chequeCollectionReport-report")
    public String report() {
        this.critParams.put("CITY_LOGO_PATH", this.cityService.getCityLogoURL());
        ReportRequest reportInput = new ReportRequest(CHEQUE_COLLETION_TEMPLATE, this.critParams, ReportDataSourceType.SQL);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return REPORT;
    }

    @Action(value="/reports/chequeCollectionReport-criteria")
    public String criteria() {
        return "index";
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCritParams(Map<String, Object> critParams) {
        this.critParams = critParams;
    }

    public Map<String, Object> getCritParams() {
        return this.critParams;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public String getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }
}

