/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"index"}, location="cashCollectionReport-index.jsp"), @Result(name={"report"}, location="cashCollectionReport-report.jsp")})
public class CashCollectionReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CashCollectionReportAction.class);
    private final Map<String, Object> critParams = new HashMap(0);
    private ReportService reportService;
    private CollectionsUtil collectionsUtil;
    private String reportId;
    public static final String REPORT = "report";
    private static final String EGOV_COUNTER_OPERATOR_ID = "EGOV_COUNTER_OPERATOR_ID";
    private static final String EGOV_COUNTER_ID = "EGOV_COUNTER_ID";
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_INSTRUMENT_TYPE = "EGOV_INSTRUMENT_TYPE";
    private static final String EGOV_INSTRUMENT_STATUS = "EGOV_INSTRUMENT_STATUS";
    private static final String EGOV_BOUNDARY_ID = "EGOV_BOUNDARY_ID";
    private static final String EGOV_RECEIPT_IDS = "EGOV_RECEIPT_IDS";
    private static final String CASH_COLLECTION_TEMPLATE = "cash_collection";
    private static final String EGOV_SOURCE = "EGOV_SOURCE";
    private String receiptDate;
    private final Map<String, String> sources = this.createSourceList();
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    @Autowired
    private CityService cityService;

    public Object getModel() {
        return null;
    }

    public void setInstrumentStatus(String instrumentStatus) {
        this.critParams.put(EGOV_INSTRUMENT_STATUS, instrumentStatus);
    }

    public void setFromDate(Date fromDate) {
        this.critParams.put(EGOV_FROM_DATE, fromDate);
    }

    public void setToDate(Date toDate) {
        this.critParams.put(EGOV_TO_DATE, toDate);
    }

    public void setCounterId(Long counterId) {
        this.critParams.put(EGOV_COUNTER_ID, counterId);
    }

    public void setUserId(Long userId) {
        this.critParams.put(EGOV_COUNTER_OPERATOR_ID, userId);
    }

    public void setBoundaryId(Long boundaryId) {
        this.critParams.put(EGOV_BOUNDARY_ID, boundaryId);
    }

    public String getInstrumentStatus() {
        return (String)this.critParams.get(EGOV_INSTRUMENT_STATUS);
    }

    public Date getFromDate() {
        return (Date)this.critParams.get(EGOV_FROM_DATE);
    }

    public Date getToDate() {
        return (Date)this.critParams.get(EGOV_TO_DATE);
    }

    public Long getCounterId() {
        return (Long)this.critParams.get(EGOV_COUNTER_ID);
    }

    public Long getUserId() {
        return (Long)this.critParams.get(EGOV_COUNTER_OPERATOR_ID);
    }

    public Long getBoundaryId() {
        return (Long)this.critParams.get(EGOV_BOUNDARY_ID);
    }

    public String getReportId() {
        return this.reportId;
    }

    private void initCriteriaMap() {
        this.critParams.clear();
        this.critParams.put(EGOV_COUNTER_OPERATOR_ID, -1L);
        this.critParams.put(EGOV_COUNTER_ID, -1L);
        this.critParams.put(EGOV_FROM_DATE, new Date());
        this.critParams.put(EGOV_TO_DATE, new Date());
        this.critParams.put(EGOV_INSTRUMENT_TYPE, "cash");
        this.critParams.put(EGOV_INSTRUMENT_STATUS, null);
        this.critParams.put(EGOV_BOUNDARY_ID, -1L);
        this.critParams.put(EGOV_RECEIPT_IDS, null);
        this.critParams.put(EGOV_SOURCE, "ALL");
    }

    private void initDropDowns() {
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("counterList", this.collectionsUtil.getAllCounters());
        this.addDropdownData("receiptCreatorList", this.collectionsUtil.getReceiptCreators());
        this.addDropdownData("activeZoneList", this.collectionsUtil.getReceiptZoneList());
    }

    public void prepare() {
        super.prepare();
        this.initDropDowns();
        this.initCriteriaMap();
    }

    @Action(value="/reports/cashCollectionReport-submissionReport")
    public String submissionReport() {
        Map session = this.getSession();
        this.collectionsUtil.getLoggedInUser();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date rcptDate = null;
        try {
            rcptDate = sdf.parse(this.receiptDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Exception occured while parsing receipt created date", (Throwable)e);
        }
        this.critParams.put(EGOV_FROM_DATE, rcptDate);
        this.critParams.put(EGOV_TO_DATE, rcptDate);
        this.critParams.put(EGOV_COUNTER_OPERATOR_ID, -1L);
        this.critParams.put(EGOV_COUNTER_ID, Long.valueOf(this.collectionsUtil.getLocationOfUser(this.getSession()).getId()));
        this.critParams.put(EGOV_RECEIPT_IDS, Arrays.asList((Long[])session.get(EGOV_RECEIPT_IDS)));
        return this.report();
    }

    @Action(value="/reports/cashCollectionReport-report")
    public String report() {
        this.critParams.put("CITY_LOGO_PATH", this.cityService.getCityLogoURL());
        ReportRequest reportInput = new ReportRequest(CASH_COLLECTION_TEMPLATE, this.critParams, ReportDataSourceType.SQL);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return REPORT;
    }

    @Action(value="/reports/cashCollectionReport-criteria")
    public String criteria() {
        return "index";
    }

    private Map<String, String> createSourceList() {
        HashMap<String, String> sourcesMap = new HashMap<String, String>(0);
        sourcesMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        sourcesMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        sourcesMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        sourcesMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return sourcesMap;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public String getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }

    public Map<String, String> getSources() {
        return this.sources;
    }

    public void setSource(String source) {
        this.critParams.put(EGOV_SOURCE, source);
    }

    public String getSource() {
        return (String)this.critParams.get(EGOV_SOURCE);
    }
}

