/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptDetailInfo;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.handler.BillInfoMarshaller;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.services.DebitAccountHeadDetailsService;
import org.egov.collection.service.CollectionService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.collection.web.actions.receipts.AjaxBankRemittanceAction;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FunctionaryHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.dao.FundSourceHibernateDAO;
import org.egov.commons.dao.SchemeHibernateDAO;
import org.egov.commons.dao.SubSchemeHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.models.ServiceCategory;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="receipt-new.jsp"), @Result(name={"index"}, location="receipt-index.jsp"), @Result(name={"redirect"}, location="receipt-redirect.jsp"), @Result(name={"report"}, location="receipt-report.jsp")})
public class ReceiptAction
extends BaseFormAction {
    protected static final String REDIRECT = "redirect";
    private static final String ACCOUNT_NUMBER_LIST = "accountNumberList";
    private static final String BANK_BRANCH_LIST = "bankBranchList";
    private static final Logger LOGGER = Logger.getLogger(ReceiptAction.class);
    private static final long serialVersionUID = 1L;
    private static final String CANCEL = "cancel";
    protected List<String> headerFields;
    protected List<String> mandatoryFields;
    private String reportId;
    private String collectXML;
    private FinancialsUtil financialsUtil;
    private Long[] selectedReceipts;
    private ReceiptHeader[] receipts;
    private ReceiptHeaderService receiptHeaderService;
    private CollectionService collectionService;
    private CollectionsUtil collectionsUtil;
    private List<ReceiptHeader> receiptHeaderValues = new ArrayList(0);
    private List<InstrumentHeader> instrumentProxyList;
    private int instrumentCount;
    private BigDecimal cashOrCardInstrumenttotal = BigDecimal.ZERO;
    private BigDecimal chequeInstrumenttotal = BigDecimal.ZERO;
    private BigDecimal instrumenttotal = BigDecimal.ZERO;
    private String reasonForCancellation;
    private String target = "view";
    private String paidBy;
    private ReceiptHeader receiptHeader = new ReceiptHeader();
    private Long oldReceiptId;
    private String fundName;
    private Boolean overrideAccountHeads = Boolean.FALSE;
    private Boolean partPaymentAllowed;
    private Boolean callbackForApportioning = Boolean.FALSE;
    private BigDecimal totalAmntToBeCollected;
    private Boolean cashAllowed = Boolean.TRUE;
    private Boolean cardAllowed = Boolean.TRUE;
    private Boolean chequeAllowed = Boolean.TRUE;
    private Boolean ddAllowed = Boolean.TRUE;
    private Boolean bankAllowed = Boolean.TRUE;
    private Boolean onlineAllowed = Boolean.TRUE;
    private Boolean isReceiptCancelEnable = Boolean.TRUE;
    private InstrumentHeader instrHeaderCash;
    private InstrumentHeader instrHeaderCard;
    private InstrumentHeader instrHeaderBank;
    private InstrumentHeader instrHeaderOnline;
    private Date voucherDate;
    private String voucherNum;
    private List<ReceiptDetailInfo> subLedgerlist;
    private List<ReceiptDetailInfo> billCreditDetailslist;
    private List<ReceiptDetailInfo> billRebateDetailslist;
    private String billSource = "bill";
    private ReceiptMisc receiptMisc = new ReceiptMisc();
    private String deptId;
    private BigDecimal totalDebitAmount;
    private String serviceName;
    private List<String> collectionModesNotAllowed = new ArrayList(0);
    private User receiptCreatedByCounterOperator;
    private List<ReceiptDetail> receiptDetailList = new ArrayList(0);
    private String instrumentTypeCashOrCard;
    private CollectionCommon collectionCommon;
    private Long bankAccountId;
    private Integer bankBranchId;
    private String payeename = "";
    private Date manualReceiptDate;
    private String manualReceiptNumber;
    private Boolean manualReceiptNumberAndDateReq = Boolean.FALSE;
    private Boolean receiptBulkUpload = Boolean.FALSE;
    private PersistenceService<ServiceCategory, Long> serviceCategoryService;
    private PersistenceService<ServiceDetails, Long> serviceDetailsService;
    private Long serviceId;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private FunctionHibernateDAO functionDAO;
    @Autowired
    private FunctionaryHibernateDAO functionaryDAO;
    @Autowired
    private SchemeHibernateDAO schemeDAO;
    @Autowired
    private FundSourceHibernateDAO fundSourceDAO;
    @Autowired
    private BankBranchHibernateDAO bankBranchDAO;
    @Autowired
    private BankHibernateDAO bankDAO;
    @Autowired
    private BankaccountHibernateDAO bankAccountDAO;
    @Autowired
    private SubSchemeHibernateDAO subSchemeDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsDAO;
    @Autowired
    private EgwStatusHibernateDAO statusDAO;
    private List<CChartOfAccounts> bankCOAList;
    private Long functionId;
    private String instrumentType;
    private PaymentRequest paymentRequest;
    @Autowired
    private ApplicationContext beanProvider;

    public void prepare() {
        super.prepare();
        this.setReceiptCreatedByCounterOperator(this.collectionsUtil.getLoggedInUser());
        if (this.getCollectXML() != null && !this.getCollectXML().isEmpty()) {
            String decodedCollectXML = this.decodeBillXML();
            try {
                BillInfoImpl collDetails = BillInfoMarshaller.toObject((String)decodedCollectXML);
                Fund fund = this.fundDAO.fundByCode(collDetails.getFundCode());
                if (fund == null) {
                    this.addActionError(this.getText("billreceipt.improperbilldata.missingfund"));
                }
                this.setFundName(fund.getName());
                Department dept = (Department)this.getPersistenceService().findByNamedQuery("getDepartmentByCode", new Object[]{collDetails.getDepartmentCode()});
                if (dept == null) {
                    this.addActionError(this.getText("billreceipt.improperbilldata.missingdepartment"));
                }
                ServiceDetails service = (ServiceDetails)this.getPersistenceService().findByNamedQuery("getServiceByCode", new Object[]{collDetails.getServiceCode()});
                this.setServiceName(service.getName());
                this.setCollectionModesNotAllowed(collDetails.getCollectionModesNotAllowed());
                this.setOverrideAccountHeads(collDetails.getOverrideAccountHeadsAllowed());
                this.setCallbackForApportioning(collDetails.getCallbackForApportioning());
                this.setPartPaymentAllowed(collDetails.getPartPaymentAllowed());
                this.totalAmntToBeCollected = BigDecimal.ZERO;
                this.populateBankBranchList(true);
                this.receiptHeader = this.collectionCommon.initialiseReceiptModelWithBillInfo((BillInfo)collDetails, fund, dept);
                this.totalAmntToBeCollected = this.totalAmntToBeCollected.add(this.receiptHeader.getTotalAmountToBeCollected());
                for (ReceiptDetail rDetails : this.receiptHeader.getReceiptDetails()) {
                    rDetails.getCramountToBePaid().setScale(2, 0);
                }
                this.setReceiptDetailList(new ArrayList(this.receiptHeader.getReceiptDetails()));
                if (this.totalAmntToBeCollected.compareTo(BigDecimal.ZERO) == -1) {
                    this.addActionError(this.getText("billreceipt.totalamountlessthanzero.error"));
                    LOGGER.info((Object)this.getText("billreceipt.totalamountlessthanzero.error"));
                } else {
                    this.setTotalAmntToBeCollected(this.totalAmntToBeCollected.setScale(2, 0));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)this.getText("billreceipt.error.improperbilldata"), (Throwable)e);
                this.addActionError(this.getText("billreceipt.error.improperbilldata"));
            }
        }
        this.addDropdownData("serviceCategoryList", this.serviceCategoryService.findAllByNamedQuery("ACTIVE_SERVICE_CATEGORY", new Object[0]));
        this.addDropdownData("serviceList", Collections.emptyList());
        this.instrumentCount = this.instrumentProxyList == null ? 0 : this.instrumentProxyList.size();
    }

    private String decodeBillXML() {
        String decodedBillXml = "";
        try {
            decodedBillXml = URLDecoder.decode(this.getCollectXML(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)(this.getText("billreceipt.error.improperbilldata") + e));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return decodedBillXml;
    }

    private void populateBankBranchList(boolean populate) {
        AjaxBankRemittanceAction ajaxBankRemittanceAction = new AjaxBankRemittanceAction();
        ajaxBankRemittanceAction.setServiceName(this.getServiceName());
        ajaxBankRemittanceAction.setPersistenceService(this.getPersistenceService());
        if (populate) {
            ajaxBankRemittanceAction.setFundName(this.getFundName());
            ajaxBankRemittanceAction.bankBranchList();
            this.addDropdownData(BANK_BRANCH_LIST, ajaxBankRemittanceAction.getBankBranchArrayList());
            this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.emptyList());
        } else if (this.getServiceName() != null && this.receiptMisc.getFund() != null) {
            Fund fund = this.fundDAO.fundById(this.receiptMisc.getFund().getId(), false);
            ajaxBankRemittanceAction.setFundName(fund.getName());
            ajaxBankRemittanceAction.bankBranchList();
            this.addDropdownData(BANK_BRANCH_LIST, ajaxBankRemittanceAction.getBankBranchArrayList());
            if (this.bankBranchId != null && this.bankBranchId != 0) {
                Bankbranch branch = this.bankBranchDAO.findById((Number)this.bankBranchId, false);
                ajaxBankRemittanceAction.setBranchId(branch.getId());
                ajaxBankRemittanceAction.accountList();
                this.addDropdownData(ACCOUNT_NUMBER_LIST, ajaxBankRemittanceAction.getBankAccountArrayList());
            } else {
                this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.emptyList());
            }
        } else {
            this.addDropdownData(BANK_BRANCH_LIST, Collections.emptyList());
            this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.emptyList());
        }
    }

    private void setCollModesNotAllowedForRemitReceipt(String collModesNotAllowed) {
        List<Object> modesNotAllowed = Arrays.asList(new Object[]{collModesNotAllowed == null ? Collections.emptyList() : collModesNotAllowed.split(",")});
        if (modesNotAllowed != null && modesNotAllowed.contains("cash")) {
            this.setCashAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed != null && modesNotAllowed.contains("card")) {
            this.setCardAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed != null && modesNotAllowed.contains("cheque")) {
            this.setChequeAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed != null && modesNotAllowed.contains("dd")) {
            this.setDdAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed != null && modesNotAllowed.contains("bankchallan")) {
            this.setBankAllowed(Boolean.FALSE);
        }
    }

    private void setCollectionModesNotAllowed() {
        List modesNotAllowed = this.collectionsUtil.getCollectionModesNotAllowed(this.getReceiptCreatedByCounterOperator());
        List collModesNotAllowed = this.getCollectionModesNotAllowed();
        if (modesNotAllowed.contains("cash") || collModesNotAllowed != null && collModesNotAllowed.contains("cash")) {
            this.setCashAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("card") || collModesNotAllowed != null && collModesNotAllowed.contains("card")) {
            this.setCardAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("cheque") || collModesNotAllowed != null && collModesNotAllowed.contains("cheque")) {
            this.setChequeAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("dd") || collModesNotAllowed != null && collModesNotAllowed.contains("dd")) {
            this.setDdAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("bankchallan") || collModesNotAllowed != null && collModesNotAllowed.contains("bankchallan")) {
            this.setBankAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("online") || this.isBillSourcemisc() || collModesNotAllowed != null && collModesNotAllowed.contains("online")) {
            this.setOnlineAllowed(Boolean.FALSE);
        }
    }

    private boolean setMiscReceiptDetails() {
        ReceiptDetail receiptDetail;
        CFunction function;
        CChartOfAccounts account;
        if ("".equals(this.payeename)) {
            this.payeename = this.collectionsUtil.getAppConfigValue("Collection", "PayeeForMiscReceipts");
        }
        ServiceDetails service = (ServiceDetails)this.getPersistenceService().findByNamedQuery("getServiceByCode", new Object[]{"CL"});
        if (null != this.serviceId && this.serviceId != -1L) {
            service = (ServiceDetails)this.serviceDetailsService.findById((Serializable)this.serviceId, false);
        }
        this.receiptHeader.setPartPaymentAllowed(Boolean.valueOf(false));
        this.receiptHeader.setService(service);
        Fund fund = this.fundDAO.fundById(this.receiptMisc.getFund().getId(), false);
        Functionary functionary = null;
        Scheme scheme = null;
        SubScheme subscheme = null;
        try {
            if (this.receiptMisc.getIdFunctionary() != null) {
                functionary = this.functionaryDAO.functionaryById(this.receiptMisc.getIdFunctionary().getId());
            }
            if (this.receiptMisc.getScheme() != null && this.receiptMisc.getScheme().getId() != -1) {
                scheme = this.schemeDAO.getSchemeById(this.receiptMisc.getScheme().getId());
            }
            if (this.receiptMisc.getSubscheme() != null && this.receiptMisc.getSubscheme().getId() != -1) {
                subscheme = this.subSchemeDAO.getSubSchemeById(this.receiptMisc.getSubscheme().getId());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in getting functionary for id [" + this.receiptMisc.getIdFunctionary().getId() + "]"), (Throwable)e);
        }
        Fundsource fundSource = null;
        if (this.receiptMisc.getFundsource() != null && this.receiptMisc.getFundsource().getId() != null) {
            fundSource = this.fundSourceDAO.fundsourceById(Integer.valueOf(this.receiptMisc.getFundsource().getId().intValue()));
        }
        Department dept = (Department)this.getPersistenceService().findByNamedQuery("getDepartmentById", new Object[]{Long.valueOf(this.deptId)});
        this.receiptHeader.setReceiptMisc(new ReceiptMisc(null, fund, functionary, fundSource, dept, this.receiptHeader, scheme, subscheme, null));
        this.totalAmntToBeCollected = BigDecimal.ZERO;
        int m = 0;
        BigDecimal debitamount = BigDecimal.ZERO;
        this.removeEmptyRows(this.billCreditDetailslist);
        this.removeEmptyRows(this.billRebateDetailslist);
        this.removeEmptyRows(this.subLedgerlist);
        if (this.validateData(this.billCreditDetailslist, this.subLedgerlist)) {
            for (ReceiptDetailInfo voucherDetails : this.billCreditDetailslist) {
                account = this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(voucherDetails.getGlcodeDetail());
                function = null;
                if (this.functionId != null) {
                    function = this.functionDAO.getFunctionById(this.functionId);
                }
                receiptDetail = new ReceiptDetail(account, function, voucherDetails.getCreditAmountDetail(), voucherDetails.getDebitAmountDetail(), BigDecimal.ZERO, Long.valueOf(m), null, Boolean.valueOf(true), this.receiptHeader, BillAccountDetails.PURPOSE.OTHERS.toString());
                if (voucherDetails.getCreditAmountDetail() == null) {
                    receiptDetail.setCramount(BigDecimal.ZERO);
                } else {
                    receiptDetail.setCramount(voucherDetails.getCreditAmountDetail());
                }
                if (voucherDetails.getDebitAmountDetail() == null) {
                    receiptDetail.setDramount(BigDecimal.ZERO);
                } else {
                    receiptDetail.setDramount(voucherDetails.getDebitAmountDetail());
                }
                receiptDetail = this.setAccountPayeeDetails(this.subLedgerlist, receiptDetail);
                this.receiptHeader.addReceiptDetail(receiptDetail);
                debitamount = debitamount.add(voucherDetails.getCreditAmountDetail());
                debitamount = debitamount.subtract(voucherDetails.getDebitAmountDetail());
                ++m;
            }
        } else {
            return false;
        }
        if (this.validateRebateData(this.billRebateDetailslist, this.subLedgerlist)) {
            for (ReceiptDetailInfo voucherDetails : this.billRebateDetailslist) {
                if (voucherDetails.getGlcodeDetail() == null || !StringUtils.isNotBlank((String)voucherDetails.getGlcodeDetail())) continue;
                account = this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(voucherDetails.getGlcodeDetail());
                function = null;
                if (voucherDetails.getFunctionIdDetail() != null) {
                    function = this.functionDAO.getFunctionById(voucherDetails.getFunctionIdDetail());
                }
                receiptDetail = new ReceiptDetail(account, function, voucherDetails.getCreditAmountDetail(), voucherDetails.getDebitAmountDetail(), BigDecimal.ZERO, Long.valueOf(m), null, Boolean.valueOf(true), this.receiptHeader, BillAccountDetails.PURPOSE.OTHERS.toString());
                if (voucherDetails.getDebitAmountDetail() == null) {
                    receiptDetail.setDramount(BigDecimal.ZERO);
                } else {
                    receiptDetail.setDramount(voucherDetails.getDebitAmountDetail());
                }
                if (voucherDetails.getCreditAmountDetail() == null) {
                    receiptDetail.setCramount(BigDecimal.ZERO);
                } else {
                    receiptDetail.setCramount(voucherDetails.getCreditAmountDetail());
                }
                receiptDetail = this.setAccountPayeeDetails(this.subLedgerlist, receiptDetail);
                this.receiptHeader.addReceiptDetail(receiptDetail);
                debitamount = debitamount.add(voucherDetails.getCreditAmountDetail());
                debitamount = debitamount.subtract(voucherDetails.getDebitAmountDetail());
                ++m;
            }
        } else {
            return false;
        }
        this.setTotalDebitAmount(debitamount);
        return true;
    }

    public ReceiptDetail setAccountPayeeDetails(List<ReceiptDetailInfo> subLedgerlist, ReceiptDetail receiptDetail) {
        for (ReceiptDetailInfo subvoucherDetails : subLedgerlist) {
            if (subvoucherDetails.getGlcode() == null || subvoucherDetails.getGlcode().getId() == 0L || !subvoucherDetails.getGlcode().getId().equals(receiptDetail.getAccounthead().getId())) continue;
            Accountdetailtype accdetailtype = (Accountdetailtype)this.getPersistenceService().findByNamedQuery("getAccountDetailtypeById", new Object[]{subvoucherDetails.getDetailType().getId()});
            Accountdetailkey accdetailkey = (Accountdetailkey)this.getPersistenceService().findByNamedQuery("getAccountDetailkeyByDetailKey", new Object[]{subvoucherDetails.getDetailKeyId(), subvoucherDetails.getDetailType().getId()});
            AccountPayeeDetail accPayeeDetail = new AccountPayeeDetail(accdetailtype, accdetailkey, subvoucherDetails.getAmount(), receiptDetail);
            receiptDetail.addAccountPayeeDetail(accPayeeDetail);
        }
        return receiptDetail;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/receipts/receipt-newform")
    public String newform() {
        String[] receiptType;
        String manualReceiptInfoRequired = this.collectionsUtil.getAppConfigValue("Collection", "MANUALRECEIPTINFOREQUIRED");
        if ("Y".equalsIgnoreCase(manualReceiptInfoRequired)) {
            this.setManualReceiptNumberAndDateReq(Boolean.TRUE);
        }
        if ((receiptType = (String[])this.parameters.get("Receipt")) != null && "Misc".equalsIgnoreCase(receiptType[0])) {
            this.createMisc();
        }
        this.setCollectionModesNotAllowed();
        return "new";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/receipts/receipt-save")
    public String save() {
        String returnValue;
        if (this.instrumentTypeCashOrCard != null && this.instrumentTypeCashOrCard.equals("online")) {
            ServiceDetails paymentService;
            if (this.callbackForApportioning.booleanValue() && !this.overrideAccountHeads.booleanValue()) {
                this.apportionBillAmount();
            }
            if (null != (paymentService = (ServiceDetails)this.getPersistenceService().findByNamedQuery("getServiceByCode", new Object[]{"SBIMOPS"}))) {
                this.setPaymentRequest(this.collectionService.populateAndPersistReceipts(paymentService, this.receiptHeader, this.receiptDetailList, this.instrHeaderOnline.getInstrumentAmount(), Character.valueOf('C')));
            }
            return REDIRECT;
        }
        List receiptInstrList = new ArrayList(0);
        LOGGER.info((Object)"Receipt creation process is started !!!!!!");
        ReceiptHeader rhForValidation = null;
        long startTimeMillis = System.currentTimeMillis();
        if (this.manualReceiptNumber != null && this.manualReceiptDate != null) {
            CFinancialYear financialYear = this.collectionsUtil.getFinancialYearforDate(this.manualReceiptDate);
            rhForValidation = (ReceiptHeader)this.receiptHeaderService.findByNamedQuery("RECEIPT_BY_SERVICE_MANUALRECEIPTNO_AND_DATE", new Object[]{this.manualReceiptNumber, this.receiptHeader.getService().getCode(), financialYear.getStartingDate(), financialYear.getEndingDate(), "CANCELLED"});
        }
        if (rhForValidation == null) {
            if (this.oldReceiptId != null) {
                ReceiptHeader receiptHeaderToBeCancelled = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.oldReceiptId, false);
                receiptHeaderToBeCancelled.setStatus(this.statusDAO.getStatusByModuleAndCode("ReceiptHeader", "CANCELLED"));
                receiptHeaderToBeCancelled.setReasonForCancellation(this.reasonForCancellation);
                receiptHeaderToBeCancelled.setIsReconciled(Boolean.valueOf(false));
                this.receiptHeader.setLocation(receiptHeaderToBeCancelled.getLocation());
                this.receiptHeaderService.persist(receiptHeaderToBeCancelled);
                if (receiptHeaderToBeCancelled.getReceipttype() == 'B') {
                    this.populateReceiptModelWithExistingReceiptInfo(receiptHeaderToBeCancelled);
                    LOGGER.info((Object)("Receipt Cancelled with Receipt Number(recreateNewReceiptOnCancellation): " + receiptHeaderToBeCancelled.getReceiptnumber() + "; Consumer Code: " + receiptHeaderToBeCancelled.getConsumerCode()));
                }
            }
            if ("misc".equalsIgnoreCase(this.billSource)) {
                this.createMisc();
                if (!this.setMiscReceiptDetails()) {
                    returnValue = "new";
                }
            } else {
                if (this.callbackForApportioning.booleanValue() && !this.overrideAccountHeads.booleanValue()) {
                    this.apportionBillAmount();
                }
                if (this.receiptDetailList == null || this.receiptDetailList.isEmpty()) {
                    throw new ApplicationRuntimeException("Receipt could not be created as the apportioned receipt detail list is empty");
                }
                BigDecimal totalCreditAmount = BigDecimal.ZERO;
                for (ReceiptDetail receiptDetail : this.receiptDetailList) {
                    totalCreditAmount = totalCreditAmount.add(receiptDetail.getCramount());
                }
                if (totalCreditAmount.intValue() == 0) {
                    throw new ApplicationRuntimeException("Apportioning Failed at the Billing System: " + this.receiptHeader.getService().getCode() + ", for bill number: " + this.receiptHeader.getReferencenumber());
                }
                this.receiptHeader.setReceiptDetails(new HashSet(this.receiptDetailList));
            }
            int noOfNewlyCreatedReceipts = 0;
            boolean setInstrument = true;
            if (this.receiptHeader.getStatus() == null) {
                ++noOfNewlyCreatedReceipts;
                if (this.manualReceiptDate == null) {
                    this.receiptHeader.setReceiptdate(new Date());
                } else {
                    this.receiptHeader.setManualreceiptdate(this.manualReceiptDate);
                    this.receiptHeader.setReceiptdate(this.manualReceiptDate);
                    this.receiptHeader.setVoucherDate(this.manualReceiptDate);
                }
                if (this.manualReceiptNumber != null) {
                    this.receiptHeader.setManualreceiptnumber(this.manualReceiptNumber);
                }
                if (this.isBillSourcemisc()) {
                    this.receiptHeader.setReceipttype('A');
                    this.receiptHeader.setVoucherDate(this.voucherDate);
                    this.receiptHeader.setReceiptdate(this.voucherDate);
                    this.receiptHeader.setVoucherNum(this.voucherNum);
                    this.receiptHeader.setIsReconciled(Boolean.TRUE);
                    this.receiptHeader.setManualreceiptdate(this.manualReceiptDate);
                    this.receiptHeader.setPayeeName(StringEscapeUtils.unescapeHtml((String)this.paidBy));
                } else {
                    this.receiptHeader.setReceipttype('B');
                    this.receiptHeader.setIsModifiable(Boolean.TRUE);
                    this.receiptHeader.setIsReconciled(Boolean.FALSE);
                }
                this.receiptHeader.setCollectiontype(Character.valueOf('C'));
                if (!this.collectionsUtil.isBankCollectionOperator(this.receiptCreatedByCounterOperator).booleanValue() && this.receiptHeader.getLocation() == null) {
                    this.receiptHeader.setLocation(this.collectionsUtil.getLocationOfUser(this.getSession()));
                }
                this.receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "TO_BE_SUBMITTED"));
                this.receiptHeader.setPaidBy(StringEscapeUtils.unescapeHtml((String)this.paidBy));
                this.receiptHeader.setSource(Source.SYSTEM.toString());
                if (this.getOldReceiptId() != null) {
                    this.receiptHeader.setReceiptHeader((ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.getOldReceiptId(), false));
                }
                if (setInstrument) {
                    receiptInstrList = this.populateInstrumentDetails();
                    setInstrument = false;
                }
                this.receiptHeader.setReceiptInstrument(new HashSet(receiptInstrList));
                BigDecimal debitAmount = BigDecimal.ZERO;
                for (ReceiptDetail creditChangeReceiptDetail : this.receiptDetailList) {
                    for (ReceiptDetail receiptDetail : this.receiptHeader.getReceiptDetails()) {
                        if (!creditChangeReceiptDetail.getReceiptHeader().getReferencenumber().equals(receiptDetail.getReceiptHeader().getReferencenumber()) || !receiptDetail.getOrdernumber().equals(creditChangeReceiptDetail.getOrdernumber())) continue;
                        receiptDetail.setCramount(creditChangeReceiptDetail.getCramount());
                        receiptDetail.setDramount(creditChangeReceiptDetail.getDramount());
                        debitAmount = debitAmount.add(creditChangeReceiptDetail.getCramount());
                        debitAmount = debitAmount.subtract(creditChangeReceiptDetail.getDramount());
                    }
                }
                if (this.chequeInstrumenttotal != null && this.chequeInstrumenttotal.compareTo(BigDecimal.ZERO) != 0) {
                    this.receiptHeader.setTotalAmount(this.chequeInstrumenttotal);
                }
                if (this.cashOrCardInstrumenttotal != null && this.cashOrCardInstrumenttotal.compareTo(BigDecimal.ZERO) != 0) {
                    this.receiptHeader.setTotalAmount(this.cashOrCardInstrumenttotal);
                }
                DebitAccountHeadDetailsService debitAccountHeadService = (DebitAccountHeadDetailsService)this.beanProvider.getBean(this.collectionsUtil.getBeanNameForDebitAccountHead());
                if (this.isBillSourcemisc()) {
                    this.receiptHeader.addReceiptDetail(debitAccountHeadService.addDebitAccountHeadDetails(this.totalDebitAmount, this.receiptHeader, this.chequeInstrumenttotal, this.cashOrCardInstrumenttotal, this.instrumentTypeCashOrCard));
                } else {
                    this.receiptHeader.addReceiptDetail(debitAccountHeadService.addDebitAccountHeadDetails(debitAmount, this.receiptHeader, this.chequeInstrumenttotal, this.cashOrCardInstrumenttotal, this.instrumentTypeCashOrCard));
                }
            }
            LOGGER.info((Object)"Call back for apportioning is completed");
            this.receiptHeaderService.populateAndPersistReceipts(this.receiptHeader, receiptInstrList);
            this.selectedReceipts = new Long[noOfNewlyCreatedReceipts];
            int i = 0;
            if (!this.receiptHeader.getId().equals(this.oldReceiptId)) {
                this.selectedReceipts[i] = this.receiptHeader.getId();
                ++i;
            }
            long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
            LOGGER.info((Object)("$$$$$$ Receipt Persisted with Receipt Number: " + this.receiptHeader.getReceiptnumber() + (this.receiptHeader.getConsumerCode() != null ? " and consumer code: " + this.receiptHeader.getConsumerCode() : "") + "; Time taken(ms) = " + elapsedTimeMillis));
            returnValue = !this.receiptBulkUpload.booleanValue() ? this.printReceipts() : "success";
        } else {
            if (rhForValidation.getService().getCode().equals("PT")) {
                this.addActionError("Entered Manual receipt number already exists for the index number" + rhForValidation.getConsumerCode() + ".Please enter a valid manual receipt number and create the receipt.");
            } else {
                this.addActionError("Receipt already exists for the service ");
            }
            returnValue = "new";
        }
        return returnValue;
    }

    public void createMisc() {
        this.headerFields = new ArrayList(0);
        this.mandatoryFields = new ArrayList(0);
        this.getHeaderMandateFields();
        this.setupDropdownDataExcluding(new String[0]);
        this.headerFields.remove("fundsource");
        this.headerFields.remove("scheme");
        this.headerFields.remove("subscheme");
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.persistenceService.findAllByNamedQuery("getAllDepartment", new Object[0]));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.persistenceService.findAllByNamedQuery("getAllFunctionary", new Object[0]));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.collectionsUtil.getAllFunds());
        }
        if (this.headerFields.contains("function")) {
            this.addDropdownData("functionList", this.functionDAO.getAllActiveFunctions());
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.persistenceService.findAllByNamedQuery("getAllField", new Object[0]));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.persistenceService.findAllByNamedQuery("getAllFundsource", new Object[0]));
        }
        if (this.headerFields.contains("scheme")) {
            if (this.receiptMisc.getFund() == null || this.receiptMisc.getFund().getId() == null) {
                this.addDropdownData("schemeList", Collections.emptyList());
            } else {
                this.addDropdownData("schemeList", this.persistenceService.findAllByNamedQuery("getAllSchemeByFundId", new Object[]{this.receiptMisc.getFund().getId()}));
            }
        }
        if (this.headerFields.contains("subscheme")) {
            if (this.receiptMisc.getScheme() == null || this.receiptMisc.getScheme().getId() == null) {
                this.addDropdownData("subschemeList", Collections.emptyList());
            } else {
                this.addDropdownData("subschemeList", this.persistenceService.findAllByNamedQuery("getAllSubSchemeBySchemeId", new Object[]{this.receiptMisc.getScheme().getId()}));
            }
        }
        if (this.billCreditDetailslist == null) {
            this.billCreditDetailslist = new ArrayList(0);
            this.billRebateDetailslist = new ArrayList(0);
            this.subLedgerlist = new ArrayList(0);
            this.billRebateDetailslist.add(new ReceiptDetailInfo());
            this.billCreditDetailslist.add(new ReceiptDetailInfo());
            this.subLedgerlist.add(new ReceiptDetailInfo());
        }
        this.billSource = "misc";
        this.receiptHeader.setPartPaymentAllowed(Boolean.valueOf(false));
        this.setHeaderFields(this.headerFields);
        this.setMandatoryFields(this.mandatoryFields);
        Department dept = this.collectionsUtil.getDepartmentOfLoggedInUser();
        if (dept == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("Department does not exists", "viewchallan.validation.error.user.notexists")));
        }
        if (this.getDeptId() == null) {
            this.setDeptId(dept.getId().toString());
        }
        this.populateBankBranchList(false);
    }

    public boolean isBillSourcemisc() {
        boolean flag = false;
        if ("misc".equalsIgnoreCase(this.getBillSource())) {
            flag = true;
        }
        return flag;
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    protected void getHeaderMandateFields() {
        List appConfigValuesList = this.collectionsUtil.getAppConfigValues("EGF", "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigValuesList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!"M".equalsIgnoreCase(mandate)) continue;
            this.mandatoryFields.add(header);
        }
        this.mandatoryFields.add("voucherdate");
    }

    private List<InstrumentHeader> populateInstrumentDetails() {
        List<InstrumentHeader> instrumentHeaderList = new ArrayList<InstrumentHeader>(0);
        if ("cash".equals(this.instrumentTypeCashOrCard)) {
            this.instrHeaderCash.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("cash"));
            this.instrHeaderCash.setIsPayCheque("0");
            this.cashOrCardInstrumenttotal = this.cashOrCardInstrumenttotal.add(this.instrHeaderCash.getInstrumentAmount());
            instrumentHeaderList.add(this.instrHeaderCash);
        }
        if ("card".equals(this.instrumentTypeCashOrCard)) {
            this.instrHeaderCard.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("card"));
            if (this.instrHeaderCard.getTransactionDate() == null) {
                this.instrHeaderCard.setTransactionDate(new Date());
            }
            this.instrHeaderCard.setIsPayCheque("0");
            this.cashOrCardInstrumenttotal = this.cashOrCardInstrumenttotal.add(this.instrHeaderCard.getInstrumentAmount());
            instrumentHeaderList.add(this.instrHeaderCard);
        }
        if ("bankchallan".equals(this.instrumentTypeCashOrCard)) {
            this.instrHeaderBank.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("bankchallan"));
            if (this.instrHeaderBank.getTransactionDate() == null) {
                this.instrHeaderBank.setTransactionDate(new Date());
            }
            this.instrHeaderBank.setIsPayCheque("0");
            Bankaccount account = this.bankAccountDAO.findById((Number)this.bankAccountId, false);
            this.instrHeaderBank.setBankAccountId(account);
            this.instrHeaderBank.setBankBranchName(account.getBankbranch().getBranchname());
            this.cashOrCardInstrumenttotal = this.cashOrCardInstrumenttotal.add(this.instrHeaderBank.getInstrumentAmount());
            instrumentHeaderList.add(this.instrHeaderBank);
        }
        if ("online".equals(this.instrumentTypeCashOrCard)) {
            this.instrHeaderOnline.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("online"));
            this.instrHeaderOnline.setIsPayCheque("0");
            this.cashOrCardInstrumenttotal = this.cashOrCardInstrumenttotal.add(this.instrHeaderOnline.getInstrumentAmount());
            instrumentHeaderList.add(this.instrHeaderOnline);
        }
        if (!(this.instrumentProxyList == null || "cash".equals(this.instrumentTypeCashOrCard) || "card".equals(this.instrumentTypeCashOrCard) || "bankchallan".equals(this.instrumentTypeCashOrCard) || !this.getInstrumentType().equals("cheque") && !this.getInstrumentType().equals("dd"))) {
            instrumentHeaderList = this.populateInstrumentHeaderForChequeDD(instrumentHeaderList, this.instrumentProxyList);
        }
        instrumentHeaderList = this.receiptHeaderService.createInstrument(instrumentHeaderList);
        return instrumentHeaderList;
    }

    private List<InstrumentHeader> populateInstrumentHeaderForChequeDD(List<InstrumentHeader> instrumentHeaderList, List<InstrumentHeader> instrumentProxyList) {
        for (InstrumentHeader instrumentHeader : instrumentProxyList) {
            if (this.getInstrumentType().equals("cheque")) {
                instrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("cheque"));
            } else if (this.getInstrumentType().equals("dd")) {
                instrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("dd"));
            }
            if (instrumentHeader.getBankId() != null && instrumentHeader.getBankId().getId() == null) {
                this.addActionError("Bank is not exist");
                throw new ApplicationRuntimeException("Bank is not exist");
            }
            if (instrumentHeader.getBankId() != null && instrumentHeader.getBankId().getId() != null) {
                instrumentHeader.setBankId(this.bankDAO.findById((Number)instrumentHeader.getBankId().getId(), false));
            }
            this.chequeInstrumenttotal = this.chequeInstrumenttotal.add(instrumentHeader.getInstrumentAmount());
            instrumentHeader.setIsPayCheque("0");
            instrumentHeaderList.add(instrumentHeader);
        }
        return instrumentHeaderList;
    }

    private void populateReceiptModelWithExistingReceiptInfo(ReceiptHeader oldReceiptHeader) {
        this.totalAmntToBeCollected = BigDecimal.ZERO;
        this.receiptHeader = new ReceiptHeader(oldReceiptHeader.getReferencenumber(), oldReceiptHeader.getReferencedate(), oldReceiptHeader.getConsumerCode(), oldReceiptHeader.getReferenceDesc(), oldReceiptHeader.getTotalAmount(), oldReceiptHeader.getMinimumAmount(), oldReceiptHeader.getPartPaymentAllowed(), oldReceiptHeader.getOverrideAccountHeads(), oldReceiptHeader.getCallbackForApportioning(), oldReceiptHeader.getDisplayMsg(), oldReceiptHeader.getService(), oldReceiptHeader.getCollModesNotAllwd(), oldReceiptHeader.getPayeeName(), oldReceiptHeader.getPayeeAddress(), oldReceiptHeader.getPayeeEmail(), oldReceiptHeader.getConsumerType());
        if (oldReceiptHeader.getCollModesNotAllwd() != null) {
            this.setCollectionModesNotAllowed(Arrays.asList(oldReceiptHeader.getCollModesNotAllwd().split(",")));
        }
        this.setOverrideAccountHeads(oldReceiptHeader.getOverrideAccountHeads());
        this.setPartPaymentAllowed(oldReceiptHeader.getPartPaymentAllowed());
        this.setServiceName(oldReceiptHeader.getService().getName());
        this.receiptHeader.setReceiptMisc(new ReceiptMisc(oldReceiptHeader.getReceiptMisc().getBoundary(), oldReceiptHeader.getReceiptMisc().getFund(), oldReceiptHeader.getReceiptMisc().getIdFunctionary(), oldReceiptHeader.getReceiptMisc().getFundsource(), oldReceiptHeader.getReceiptMisc().getDepartment(), this.receiptHeader, oldReceiptHeader.getReceiptMisc().getScheme(), oldReceiptHeader.getReceiptMisc().getSubscheme(), null));
        this.receiptHeader.setLocation(oldReceiptHeader.getLocation());
        this.bankCOAList = this.chartOfAccountsDAO.getBankChartofAccountCodeList();
        for (ReceiptDetail oldDetail : oldReceiptHeader.getReceiptDetails()) {
            if (oldDetail.getOrdernumber() == null || FinancialsUtil.isRevenueAccountHead((CChartOfAccounts)oldDetail.getAccounthead(), (List)this.bankCOAList, (PersistenceService)this.persistenceService)) continue;
            ReceiptDetail receiptDetail = new ReceiptDetail(oldDetail.getAccounthead(), oldDetail.getFunction(), oldDetail.getCramount(), oldDetail.getDramount(), oldDetail.getCramount(), oldDetail.getOrdernumber(), oldDetail.getDescription(), oldDetail.getIsActualDemand(), this.receiptHeader, oldDetail.getPurpose());
            receiptDetail.setCramountToBePaid(oldDetail.getCramountToBePaid());
            receiptDetail.setCramount(oldDetail.getCramount());
            if (oldDetail.getAccountPayeeDetails() != null) {
                for (AccountPayeeDetail oldAccountPayeeDetail : oldDetail.getAccountPayeeDetails()) {
                    AccountPayeeDetail accountPayeeDetail = new AccountPayeeDetail(oldAccountPayeeDetail.getAccountDetailType(), oldAccountPayeeDetail.getAccountDetailKey(), oldAccountPayeeDetail.getAmount(), receiptDetail);
                    receiptDetail.addAccountPayeeDetail(accountPayeeDetail);
                }
            }
            if (oldDetail.getIsActualDemand().booleanValue()) {
                this.totalAmntToBeCollected = this.totalAmntToBeCollected.add(oldDetail.getCramountToBePaid()).subtract(oldDetail.getDramount()).setScale(2, 0);
            }
            this.setTotalAmntToBeCollected(this.totalAmntToBeCollected);
            this.receiptHeader.addReceiptDetail(receiptDetail);
        }
        if (oldReceiptHeader.getReceipttype() == 'A') {
            this.loadReceiptDetails(this.receiptHeader);
            this.createMisc();
            if (oldReceiptHeader.getVoucherNum() != null) {
                this.setVoucherNum(this.voucherNum);
            }
        }
        this.setReceiptDetailList(new ArrayList(this.receiptHeader.getReceiptDetails()));
        this.setCollModesNotAllowedForRemitReceipt(oldReceiptHeader.getCollModesNotAllwd());
    }

    private void loadReceiptDetails(ReceiptHeader receiptHeader) {
        this.setReceiptMisc(receiptHeader.getReceiptMisc());
        this.setBillCreditDetailslist(this.collectionCommon.setReceiptDetailsList(receiptHeader, "credit"));
        this.setBillRebateDetailslist(this.collectionCommon.setReceiptDetailsList(receiptHeader, "debit"));
        this.setSubLedgerlist(this.collectionCommon.setAccountPayeeList(receiptHeader));
    }

    private String viewReceipts(boolean printReceipts) {
        if (this.selectedReceipts == null || this.selectedReceipts.length == 0) {
            throw new ApplicationRuntimeException("No receipts selected to view!");
        }
        this.receipts = new ReceiptHeader[this.selectedReceipts.length];
        for (int i = 0; i < this.selectedReceipts.length; ++i) {
            try {
                this.receipts[i] = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.selectedReceipts[i], false);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error in printReceipts", (Throwable)e);
            }
        }
        try {
            this.reportId = this.collectionCommon.generateReport(this.receipts, printReceipts);
        }
        catch (Exception e) {
            String errMsg = "Error during report generation!";
            LOGGER.error((Object)"Error during report generation!", (Throwable)e);
            throw new ApplicationRuntimeException("Error during report generation!", (Throwable)e);
        }
        return "report";
    }

    @Action(value="/receipts/receipt-viewReceipts")
    public String viewReceipts() {
        return this.viewReceipts(false);
    }

    @Action(value="/receipts/receipt-printReceipts")
    public String printReceipts() {
        return this.viewReceipts(true);
    }

    @ValidationErrorPage(value="error")
    @Action(value="/receipts/receipt-cancel")
    public String cancel() {
        List appConfigValuesList = this.collectionsUtil.getAppConfigValues("Collection", "COLLECTIONCREATORRECEIPTCANCELROLE");
        Boolean isRoleToCheckCreator = Boolean.FALSE;
        User user = this.collectionsUtil.getLoggedInUser();
        for (AppConfigValues appConfigVal : appConfigValuesList) {
            String value = appConfigVal.getValue();
            for (Role role : user.getRoles()) {
                if (role == null || !role.getName().equals(value)) continue;
                isRoleToCheckCreator = true;
            }
        }
        if (this.getSelectedReceipts() != null && this.getSelectedReceipts().length > 0) {
            this.receipts = new ReceiptHeader[this.selectedReceipts.length];
            for (int i = 0; i < this.selectedReceipts.length; ++i) {
                this.receipts[i] = (ReceiptHeader)this.getPersistenceService().findByNamedQuery("getReceiptHeaderById", new Object[]{(long)this.selectedReceipts[i]});
                if (!isRoleToCheckCreator.booleanValue()) continue;
                this.isReceiptCancelEnable = this.receipts[i].getCreatedBy().getId().compareTo(user.getId()) == 0;
            }
        }
        return CANCEL;
    }

    @ValidationErrorPage(value="error")
    @Action(value="/receipts/receipt-saveOnCancel")
    public String saveOnCancel() {
        boolean isInstrumentDeposited = false;
        ReceiptHeader receiptHeaderToBeCancelled = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.oldReceiptId, false);
        if (receiptHeaderToBeCancelled.getReceipttype() == 'B') {
            this.receiptHeaderService.validateReceiptCancellation(receiptHeaderToBeCancelled.getReceiptnumber(), receiptHeaderToBeCancelled.getService().getCode(), receiptHeaderToBeCancelled.getConsumerCode());
        }
        LOGGER.info((Object)("Receipt Header to be Cancelled : " + receiptHeaderToBeCancelled.getReceiptnumber()));
        for (InstrumentHeader instrumentHeader : receiptHeaderToBeCancelled.getReceiptInstrument()) {
            if (instrumentHeader.getInstrumentType().getType().equals("cash")) {
                if (!instrumentHeader.getStatusId().getDescription().equals("Reconciled")) continue;
                isInstrumentDeposited = true;
                break;
            }
            if (!instrumentHeader.getStatusId().getDescription().equals("Deposited")) continue;
            isInstrumentDeposited = true;
            break;
        }
        if (isInstrumentDeposited) {
            this.populateReceiptModelWithExistingReceiptInfo(receiptHeaderToBeCancelled);
            this.setFundName(receiptHeaderToBeCancelled.getReceiptMisc().getFund().getName());
            this.setServiceName(receiptHeaderToBeCancelled.getService().getName());
            this.setServiceId(receiptHeaderToBeCancelled.getService().getId());
            this.addDropdownData("serviceList", receiptHeaderToBeCancelled.getService() != null ? this.getPersistenceService().findAllByNamedQuery("getServiceDetailsByCategory", new Object[]{receiptHeaderToBeCancelled.getService().getServiceCategory().getId(), Boolean.TRUE}) : Collections.emptyList());
            this.populateBankBranchList(true);
            return "new";
        }
        receiptHeaderToBeCancelled.setStatus(this.statusDAO.getStatusByModuleAndCode("ReceiptHeader", "CANCELLED"));
        receiptHeaderToBeCancelled.setIsReconciled(Boolean.valueOf(false));
        receiptHeaderToBeCancelled.setReasonForCancellation(this.reasonForCancellation);
        for (InstrumentHeader instrumentHeader : receiptHeaderToBeCancelled.getReceiptInstrument()) {
            instrumentHeader.setStatusId(this.statusDAO.getStatusByModuleAndCode("Instrument", "Cancelled"));
        }
        for (ReceiptVoucher receiptVoucher : receiptHeaderToBeCancelled.getReceiptVoucher()) {
            this.receiptHeaderService.createReversalVoucher(receiptVoucher);
        }
        this.receiptHeaderService.persist(receiptHeaderToBeCancelled);
        this.receiptHeaderValues.clear();
        this.receiptHeaderValues.add(receiptHeaderToBeCancelled);
        LOGGER.info((Object)("Receipt Cancelled with Receipt Number(saveOnCancel): " + receiptHeaderToBeCancelled.getReceiptnumber() + "; Consumer Code: " + receiptHeaderToBeCancelled.getConsumerCode()));
        this.target = CANCEL;
        return "index";
    }

    public String amountInWords(BigDecimal amount) {
        return NumberUtil.amountInWords((BigDecimal)amount);
    }

    public List<ReceiptHeader> getReceiptHeaderValues() {
        return this.receiptHeaderValues;
    }

    public void setReceiptHeaderValues(List<ReceiptHeader> receiptHeaderValues) {
        this.receiptHeaderValues = receiptHeaderValues;
    }

    public String getReasonForCancellation() {
        return this.reasonForCancellation;
    }

    public void setReasonForCancellation(String reasonForCancellation) {
        this.reasonForCancellation = reasonForCancellation;
    }

    public String getTarget() {
        return this.target;
    }

    public String getPaidBy() {
        return org.egov.infra.utils.StringUtils.escapeJavaScript((String)this.paidBy);
    }

    public void setPaidBy(String paidBy) {
        this.paidBy = paidBy;
    }

    public Long getOldReceiptId() {
        return this.oldReceiptId;
    }

    public void setOldReceiptId(Long oldReceiptId) {
        this.oldReceiptId = oldReceiptId;
    }

    public Long getBankAccountId() {
        return this.bankAccountId;
    }

    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public BigDecimal getTotalAmntToBeCollected() {
        return this.totalAmntToBeCollected;
    }

    public void setTotalAmntToBeCollected(BigDecimal totalAmntToBeCollected) {
        this.totalAmntToBeCollected = totalAmntToBeCollected;
    }

    public InstrumentHeader getInstrHeaderCash() {
        return this.instrHeaderCash;
    }

    public void setInstrHeaderCash(InstrumentHeader instrHeaderCash) {
        this.instrHeaderCash = instrHeaderCash;
    }

    public InstrumentHeader getInstrHeaderCard() {
        return this.instrHeaderCard;
    }

    public void setInstrHeaderCard(InstrumentHeader instrHeaderCard) {
        this.instrHeaderCard = instrHeaderCard;
    }

    public InstrumentHeader getInstrHeaderBank() {
        return this.instrHeaderBank;
    }

    public void setInstrHeaderBank(InstrumentHeader instrHeaderBank) {
        this.instrHeaderBank = instrHeaderBank;
    }

    public InstrumentHeader getInstrHeaderOnline() {
        return this.instrHeaderOnline;
    }

    public void setInstrHeaderOnline(InstrumentHeader instrHeaderOnline) {
        this.instrHeaderOnline = instrHeaderOnline;
    }

    public List<String> getCollectionModesNotAllowed() {
        return this.collectionModesNotAllowed;
    }

    public void setCollectionModesNotAllowed(List<String> collectionModesNotAllowed) {
        this.collectionModesNotAllowed = collectionModesNotAllowed;
    }

    public User getReceiptCreatedByCounterOperator() {
        return this.receiptCreatedByCounterOperator;
    }

    public void setReceiptCreatedByCounterOperator(User receiptCreatedByCounterOperator) {
        this.receiptCreatedByCounterOperator = receiptCreatedByCounterOperator;
    }

    public List<ReceiptDetail> getReceiptDetailList() {
        return this.receiptDetailList;
    }

    public void setReceiptDetailList(List<ReceiptDetail> receiptDetailList) {
        this.receiptDetailList = receiptDetailList;
    }

    public String getInstrumentTypeCashOrCard() {
        return this.instrumentTypeCashOrCard;
    }

    public void setInstrumentTypeCashOrCard(String instrumentTypeCashOrCard) {
        this.instrumentTypeCashOrCard = instrumentTypeCashOrCard;
    }

    public Integer getTotalNoOfAccounts() {
        Integer totalNoOfAccounts = 0;
        totalNoOfAccounts = totalNoOfAccounts + this.receiptHeader.getReceiptDetails().size();
        return totalNoOfAccounts;
    }

    public BigDecimal getMinimumAmount() {
        return null;
    }

    public Boolean getOverrideAccountHeads() {
        return this.overrideAccountHeads;
    }

    public void setOverrideAccountHeads(Boolean overrideAccountHeads) {
        this.overrideAccountHeads = overrideAccountHeads;
    }

    public Boolean getCallbackForApportioning() {
        return this.callbackForApportioning;
    }

    public void setCallbackForApportioning(Boolean callbackForApportioning) {
        this.callbackForApportioning = callbackForApportioning;
    }

    public Boolean getPartPaymentAllowed() {
        return this.partPaymentAllowed;
    }

    public void setPartPaymentAllowed(Boolean partPaymentAllowed) {
        this.partPaymentAllowed = partPaymentAllowed;
    }

    public BigDecimal getCashOrCardInstrumenttotal() {
        return this.cashOrCardInstrumenttotal;
    }

    public void setCashOrCardInstrumenttotal(BigDecimal cashOrCardInstrumenttotal) {
        this.cashOrCardInstrumenttotal = cashOrCardInstrumenttotal;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Boolean getCashAllowed() {
        return this.cashAllowed;
    }

    public void setCashAllowed(Boolean cashAllowed) {
        this.cashAllowed = cashAllowed;
    }

    public Boolean getCardAllowed() {
        return this.cardAllowed;
    }

    public void setCardAllowed(Boolean cardAllowed) {
        this.cardAllowed = cardAllowed;
    }

    public Boolean getChequeAllowed() {
        return this.chequeAllowed;
    }

    public void setChequeAllowed(Boolean chequeAllowed) {
        this.chequeAllowed = chequeAllowed;
    }

    public Boolean getDdAllowed() {
        return this.ddAllowed;
    }

    public void setDdAllowed(Boolean ddAllowed) {
        this.ddAllowed = ddAllowed;
    }

    public Boolean getBankAllowed() {
        return this.bankAllowed;
    }

    public void setBankAllowed(Boolean bankAllowed) {
        this.bankAllowed = bankAllowed;
    }

    public Date getVoucherDate() {
        return this.voucherDate;
    }

    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    public String getVoucherNum() {
        return this.voucherNum;
    }

    public void setVoucherNum(String voucherNum) {
        this.voucherNum = voucherNum;
    }

    public List<ReceiptDetailInfo> getBillCreditDetailslist() {
        return this.billCreditDetailslist;
    }

    public void setBillCreditDetailslist(List<ReceiptDetailInfo> billCreditDetailslist) {
        this.billCreditDetailslist = billCreditDetailslist;
    }

    public List<ReceiptDetailInfo> getBillRebateDetailslist() {
        return this.billRebateDetailslist;
    }

    public void setBillRebateDetailslist(List<ReceiptDetailInfo> billRebateDetailslist) {
        this.billRebateDetailslist = billRebateDetailslist;
    }

    public List<ReceiptDetailInfo> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<ReceiptDetailInfo> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public String getBillSource() {
        return this.billSource;
    }

    public void setBillSource(String billSource) {
        this.billSource = billSource;
    }

    public ReceiptMisc getReceiptMisc() {
        return this.receiptMisc;
    }

    public void setReceiptMisc(ReceiptMisc receiptMisc) {
        this.receiptMisc = receiptMisc;
    }

    public String getReportId() {
        return this.reportId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public BigDecimal getTotalDebitAmount() {
        return this.totalDebitAmount;
    }

    public void setTotalDebitAmount(BigDecimal totalDebitAmount) {
        this.totalDebitAmount = totalDebitAmount;
    }

    protected boolean validateData(List<ReceiptDetailInfo> billDetailslistd, List<ReceiptDetailInfo> subLedgerList) {
        BigDecimal totalDrAmt = BigDecimal.ZERO;
        BigDecimal totalCrAmt = BigDecimal.ZERO;
        Integer index = 0;
        boolean isDataValid = true;
        for (ReceiptDetailInfo rDetails : billDetailslistd) {
            index = index + 1;
            totalDrAmt = totalDrAmt.add(rDetails.getDebitAmountDetail());
            totalCrAmt = totalCrAmt.add(rDetails.getCreditAmountDetail());
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getGlcodeDetail().trim().length() == 0) {
                this.addActionError(this.getText("miscreceipt.accdetail.emptyaccrow", new String[]{index.toString()}));
                isDataValid = false;
                continue;
            }
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getGlcodeDetail().trim().length() != 0) {
                this.addActionError(this.getText("miscreceipt.accdetail.amountZero", new String[]{rDetails.getGlcodeDetail()}));
                isDataValid = false;
                continue;
            }
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) > 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) > 0) {
                this.addActionError(this.getText("miscreceipt.accdetail.amount", new String[]{rDetails.getGlcodeDetail()}));
                isDataValid = false;
                continue;
            }
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) <= 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) <= 0 || rDetails.getGlcodeDetail().trim().length() != 0) continue;
            this.addActionError(this.getText("miscreceipt.accdetail.accmissing", new String[]{index.toString()}));
            isDataValid = false;
        }
        if (isDataValid) {
            isDataValid = this.validateSubledgerDetails(this.billCreditDetailslist, subLedgerList);
        }
        return isDataValid;
    }

    protected boolean validateRebateData(List<ReceiptDetailInfo> billDetailslistd, List<ReceiptDetailInfo> subLedgerList) {
        Integer index = 0;
        boolean isDataValid = true;
        for (ReceiptDetailInfo rDetails : billDetailslistd) {
            index = index + 1;
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getGlcodeDetail().trim().length() != 0) {
                this.addActionError(this.getText("miscreceipt.accdetail.amountZero", new String[]{rDetails.getGlcodeDetail()}));
                isDataValid = false;
                continue;
            }
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) <= 0 || rDetails.getGlcodeDetail().trim().length() != 0) continue;
            this.addActionError(this.getText("miscreceipt.accdetail.accmissing", new String[]{index.toString()}));
            isDataValid = false;
        }
        if (isDataValid) {
            isDataValid = this.validateSubledgerDetails(this.billRebateDetailslist, subLedgerList);
        }
        return isDataValid;
    }

    protected boolean validateSubledgerDetails(List<ReceiptDetailInfo> billRebateDetailslist, List<ReceiptDetailInfo> subLedgerlist) {
        List list;
        HashMap<String, BigDecimal> subledAmtmap = new HashMap<String, BigDecimal>(0);
        ArrayList subLegAccMap = null;
        for (ReceiptDetailInfo rDetails : billRebateDetailslist) {
            CChartOfAccountDetail cChartOfAccountDetail = (CChartOfAccountDetail)this.getPersistenceService().find(" from CChartOfAccountDetail where glCodeId=(select id from CChartOfAccounts where glcode=?)", new Object[]{rDetails.getGlcodeDetail()});
            if (null == cChartOfAccountDetail) continue;
            HashMap<String, Object> accountDetailMap = new HashMap<String, Object>();
            accountDetailMap.put("glcodeId", rDetails.getGlcodeIdDetail());
            accountDetailMap.put("glcode", rDetails.getGlcodeDetail());
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                accountDetailMap.put("amount", rDetails.getCreditAmountDetail());
            } else if (rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                accountDetailMap.put("amount", rDetails.getDebitAmountDetail());
            }
            if (null == subLegAccMap) {
                subLegAccMap = new ArrayList();
                subLegAccMap.add(accountDetailMap);
                continue;
            }
            subLegAccMap.add(accountDetailMap);
        }
        if (null != subLegAccMap) {
            HashMap<String, String> subLedgerMap = new HashMap<String, String>();
            for (ReceiptDetailInfo receiptDetailInfo : subLedgerlist) {
                if (receiptDetailInfo.getGlcode().getId() == 0L) continue;
                if (null == subledAmtmap.get(receiptDetailInfo.getGlcode().getId().toString())) {
                    subledAmtmap.put(receiptDetailInfo.getGlcode().getId().toString(), receiptDetailInfo.getAmount());
                } else {
                    BigDecimal debitTotalAmount = ((BigDecimal)subledAmtmap.get(receiptDetailInfo.getGlcode().getId().toString())).add(receiptDetailInfo.getAmount());
                    subledAmtmap.put(receiptDetailInfo.getGlcode().getId().toString(), debitTotalAmount);
                }
                StringBuilder subledgerDetailRow = new StringBuilder();
                subledgerDetailRow.append(receiptDetailInfo.getGlcode().getId().toString()).append(receiptDetailInfo.getDetailType().getId().toString()).append(receiptDetailInfo.getDetailKeyId().toString());
                if (null == subLedgerMap.get(subledgerDetailRow.toString())) {
                    subLedgerMap.put(subledgerDetailRow.toString(), subledgerDetailRow.toString());
                    continue;
                }
                this.addActionError(this.getText("miscreciept.samesubledger.repeated"));
                return false;
            }
            for (Map map : subLegAccMap) {
                String glcodeId = map.get("glcodeId").toString();
                if (null == subledAmtmap.get(glcodeId)) {
                    this.addActionError(this.getText("miscreciept.subledger.entrymissing", new String[]{map.get("glcode").toString()}));
                    return false;
                }
                if (((BigDecimal)subledAmtmap.get(glcodeId)).compareTo(new BigDecimal(map.get("amount").toString())) == 0) continue;
                this.addActionError(this.getText("miscreciept.subledger.amtnotmatchinng", new String[]{map.get("glcode").toString()}));
                return false;
            }
        }
        if ((list = this.persistenceService.findAllBy("from CFinancialYear where isActiveForPosting=true and startingDate <= ? and endingDate >= ?", new Object[]{this.getVoucherDate(), this.getVoucherDate()})).isEmpty()) {
            this.addActionError(this.getText("miscreciept.fYear.notActive"));
            return false;
        }
        return true;
    }

    public void apportionBillAmount() {
        this.receiptDetailList = this.collectionCommon.apportionBillAmount(this.instrumenttotal, (ArrayList)this.getReceiptDetailList());
    }

    void removeEmptyRows(List<ReceiptDetailInfo> list) {
        Iterator<ReceiptDetailInfo> detail = list.iterator();
        while (detail.hasNext()) {
            if (detail.next() != null) continue;
            detail.remove();
        }
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(List<String> headerFields) {
        this.headerFields = headerFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public void setMandatoryFields(List<String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    public Integer getBankBranchId() {
        return this.bankBranchId;
    }

    public void setBankBranchId(Integer bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public String getFundName() {
        return this.fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public String getCollectXML() {
        return this.collectXML;
    }

    public void setCollectXML(String collectXML) {
        this.collectXML = collectXML;
    }

    public Object getModel() {
        return this.receiptHeader;
    }

    public ReceiptHeader[] getReceipts() {
        return this.receipts;
    }

    public void setReceipts(ReceiptHeader[] receipts) {
        this.receipts = receipts;
    }

    public Long[] getSelectedReceipts() {
        return this.selectedReceipts;
    }

    public void setSelectedReceipts(Long[] selectedReceipts) {
        this.selectedReceipts = selectedReceipts;
    }

    public void setPayeename(String payeename) {
        this.payeename = payeename;
    }

    public Date getManualReceiptDate() {
        return this.manualReceiptDate;
    }

    public void setManualReceiptDate(Date manualReceiptDate) {
        this.manualReceiptDate = manualReceiptDate;
    }

    public Boolean getReceiptBulkUpload() {
        return this.receiptBulkUpload;
    }

    public void setReceiptBulkUpload(Boolean receiptBulkUpload) {
        this.receiptBulkUpload = receiptBulkUpload;
    }

    public BigDecimal getInstrumenttotal() {
        return this.instrumenttotal;
    }

    public void setInstrumenttotal(BigDecimal instrumenttotal) {
        this.instrumenttotal = instrumenttotal;
    }

    public void setServiceDetailsService(PersistenceService<ServiceDetails, Long> serviceDetailsService) {
        this.serviceDetailsService = serviceDetailsService;
    }

    public List<InstrumentHeader> getInstrumentProxyList() {
        return this.instrumentProxyList;
    }

    public void setInstrumentProxyList(List<InstrumentHeader> instrumentProxyList) {
        this.instrumentProxyList = instrumentProxyList;
    }

    public int getInstrumentCount() {
        return this.instrumentCount;
    }

    public void setInstrumentCount(int instrumentCount) {
        this.instrumentCount = instrumentCount;
    }

    public String getManualReceiptNumber() {
        return this.manualReceiptNumber;
    }

    public void setManualReceiptNumber(String manualReceiptNumber) {
        this.manualReceiptNumber = manualReceiptNumber;
    }

    public Boolean getManualReceiptNumberAndDateReq() {
        return this.manualReceiptNumberAndDateReq;
    }

    public void setManualReceiptNumberAndDateReq(Boolean manualReceiptNumberAndDateReq) {
        this.manualReceiptNumberAndDateReq = manualReceiptNumberAndDateReq;
    }

    public ReceiptHeader getReceiptHeader() {
        return this.receiptHeader;
    }

    public void setReceiptHeader(ReceiptHeader receiptHeader) {
        this.receiptHeader = receiptHeader;
    }

    public void setServiceCategoryService(PersistenceService<ServiceCategory, Long> serviceCategoryService) {
        this.serviceCategoryService = serviceCategoryService;
    }

    public Long getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Long functionId) {
        this.functionId = functionId;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public String getInstrumentType() {
        return this.instrumentType;
    }

    public void setInstrumentType(String instrumentType) {
        this.instrumentType = instrumentType;
    }

    public Boolean getOnlineAllowed() {
        return this.onlineAllowed;
    }

    public void setOnlineAllowed(Boolean onlineAllowed) {
        this.onlineAllowed = onlineAllowed;
    }

    public CollectionService getCollectionService() {
        return this.collectionService;
    }

    public void setCollectionService(CollectionService collectionService) {
        this.collectionService = collectionService;
    }

    public PaymentRequest getPaymentRequest() {
        return this.paymentRequest;
    }

    public void setPaymentRequest(PaymentRequest paymentRequest) {
        this.paymentRequest = paymentRequest;
    }

    public Boolean getIsReceiptCancelEnable() {
        return this.isReceiptCancelEnable;
    }

    public void setIsReceiptCancelEnable(Boolean isReceiptCancelEnable) {
        this.isReceiptCancelEnable = isReceiptCancelEnable;
    }
}

