/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.DishonoredChequeBean;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.integration.services.DishonorChequeService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQuerySQL;
import org.egov.model.instrument.InstrumentType;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"search"}, location="dishonoredCheque-search.jsp"), @Result(name={"success"}, location="dishonoredCheque-success.jsp"), @Result(name={"process"}, location="dishonoredCheque-process.jsp"), @Result(name={"accountList"}, location="dishonoredCheque-accountList.jsp")})
@ParentPackage(value="egov")
public class DishonoredChequeAction
extends SearchFormAction {
    private static final long serialVersionUID = 2871716607884152080L;
    private static final Logger LOGGER = Logger.getLogger(DishonoredChequeAction.class);
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    public static final String SEARCH = "search";
    private List bankBranchList;
    @Autowired
    private BankBranchHibernateDAO bankBranchHibernateDAO;
    @Autowired
    private BankaccountHibernateDAO bankaccountHibernateDAO;
    private String bankBranchId;
    private List accountNumberList;
    private Map instrumentModesMap;
    private String chequeNumber;
    private Date chequeDate;
    private String instHeaderIds;
    private String voucherHeaderIds;
    private String receiptHeaderIds;
    private String receiptGLDetails;
    private String remittanceGLDetails;
    private Date transactionDate;
    private String dishonorReason;
    private String remarks;
    private String instrumentMode;
    private String referenceNo;
    private Long accountNumber;
    private EgovPaginatedList paginatedList;
    private List<DishonoredChequeBean> generalLedger = new ArrayList(0);
    private List<DishonoredChequeBean> subLedgerDetails = new ArrayList(0);
    private List<DishonoredChequeBean> remittanceGeneralLedger = new ArrayList(0);
    protected List<DishonoredChequeBean> dishonoredChequeDisplayList = new ArrayList(0);
    @Autowired
    private ReceiptHeaderService receiptHeaderService;
    @Autowired
    private DishonorChequeService dishonorChequeService;
    private BigDecimal reversalAmount;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("bankBranchList", this.bankBranchHibernateDAO.getAllBankBranchs());
        this.addDropdownData("accountNumberList", Collections.EMPTY_LIST);
        this.addDropdownData("dishonorReasonsList", this.persistenceService.getSession().createSQLQuery("select * from egf_instrument_dishonor_reason").list());
        this.instrumentModesMap = CollectionConstants.INSTRUMENT_MODES_MAP;
    }

    @Action(value="/receipts/dishonoredCheque-getAccountNumbers")
    public String getAccountNumbers() {
        try {
            Long branchId = null;
            if (!this.bankBranchId.equals("-1") && this.bankBranchId != null && this.bankBranchId != "") {
                String[] id = this.bankBranchId.split("-");
                branchId = Long.parseLong(id[1]);
            }
            this.accountNumberList = this.bankaccountHibernateDAO.getBankAccountByBankBranch(Integer.valueOf(branchId.intValue()));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception Encountered!!!" + ex.getMessage()), (Throwable)ex);
        }
        return "accountList";
    }

    @SkipValidation
    @Action(value="/receipts/dishonoredCheque-search")
    public String search() {
        return SEARCH;
    }

    @Action(value="/receipts/dishonoredCheque-list")
    public String list() throws Exception {
        this.setPageSize(30);
        super.search();
        this.prepareResults();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"DishonoredChequeAction | list | End");
        }
        return SEARCH;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        Long bankId = null;
        if (StringUtils.isNotBlank((CharSequence)this.bankBranchId) && !this.bankBranchId.equals("-1")) {
            String[] id = this.bankBranchId.split("-");
            bankId = Long.parseLong(id[0]);
        }
        InstrumentType instType = (InstrumentType)this.getPersistenceService().find("from InstrumentType where type=?", new Object[]{this.instrumentMode});
        String searchQuery = this.receiptHeaderService.getReceiptHeaderforDishonor(instType.getId(), this.accountNumber, bankId, this.chequeNumber, this.chequeDate.toString());
        String srchQry = "select rpt.id as receiptheaderid,ih.id as instrumentheaderid,rpt.receiptnumber as receiptnumber,rpt.receiptdate as receiptdate,ih.instrumentnumber as instrumentnumber,ih.instrumentdate as instrumentdate,ih.instrumentamount as instrumentamount,b.name as bankname,ba.accountnumber as accountnumber,ih.payto as payto,status.description as description " + searchQuery + " ORDER BY rpt.receiptnumber, rpt.receiptdate ";
        String countQry = "select count(distinct rpt) " + searchQuery + "";
        return new SearchQuerySQL(srchQry, countQry, null);
    }

    @ValidationErrorPage(value="process")
    @Action(value="/receipts/dishonoredCheque-create")
    public String create() throws Exception {
        try {
            DishonoredChequeBean chequeForm = new DishonoredChequeBean();
            chequeForm.setTransactionDate(this.transactionDate);
            chequeForm.setDishonorReason(this.dishonorReason);
            chequeForm.setReferenceNo(this.referenceNo);
            chequeForm.setRemarks(this.remarks);
            chequeForm.setInstHeaderIds(this.instHeaderIds);
            chequeForm.setVoucherHeaderIds(this.voucherHeaderIds);
            chequeForm.setReceiptHeaderIds(this.receiptHeaderIds);
            chequeForm.setReceiptGLDetails(this.receiptGLDetails);
            chequeForm.setRemittanceGLDetails(this.remittanceGLDetails);
            this.dishonorChequeService.createDishonorCheque(chequeForm);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + (Object)((Object)e)));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + e));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return "success";
    }

    private void prepareResults() {
        LOGGER.debug((Object)"Entering into prepareResults");
        this.paginatedList = (EgovPaginatedList)this.searchResult;
        List list = this.paginatedList.getList();
        this.paginatedList.setList(this.populateDishonorChequeBean(list));
        LOGGER.debug((Object)"Exiting from prepareResults");
    }

    public List<DishonoredChequeBean> populateDishonorChequeBean(List<Object[]> list) {
        ArrayList<DishonoredChequeBean> dishonoredChequeList = new ArrayList<DishonoredChequeBean>();
        for (Object[] object : list) {
            Long receiptId = this.getLongValue(object[0]);
            DishonoredChequeBean chequeBean = new DishonoredChequeBean();
            ReceiptVoucher receiptVoucher = (ReceiptVoucher)this.persistenceService.findByNamedQuery("RECEIPT_VOUCHER_BY_RECEIPTID", new Object[]{receiptId});
            if (receiptVoucher != null) {
                chequeBean.setVoucherHeaderId(receiptVoucher.getVoucherheader().getId());
                chequeBean.setVoucherNumber(receiptVoucher.getVoucherheader().getVoucherNumber());
            }
            chequeBean.setReceiptHeaderid(receiptId);
            chequeBean.setInstrumentHeaderid(this.getLongValue(object[1]));
            chequeBean.setReceiptNumber(this.getStringValue(object[2]));
            chequeBean.setReceiptDate(this.getDateValue(object[3]));
            chequeBean.setInstrumentNumber(this.getStringValue(object[4]));
            chequeBean.setInstrumentDate(this.getDateValue(object[5]));
            chequeBean.setInstrumentAmount(this.getBigDecimalValue(object[6]));
            chequeBean.setBankName(this.getStringValue(object[7]));
            chequeBean.setAccountNumber(this.getStringValue(object[8]));
            chequeBean.setPayTo(this.getStringValue(object[9]));
            chequeBean.setDescription(this.getStringValue(object[10]));
            dishonoredChequeList.add(chequeBean);
        }
        return dishonoredChequeList;
    }

    @Action(value="/receipts/dishonoredCheque-process")
    public String process() throws Exception {
        this.getReversalGlCodes();
        return "process";
    }

    public void getReversalGlCodes() {
        ReceiptVoucher receiptVoucher;
        DishonoredChequeBean detail;
        List glCodes = new ArrayList(0);
        List glCodescredit = new ArrayList(0);
        List remittanceDetailsCredit = new ArrayList(0);
        List instrumentDetails = new ArrayList(0);
        this.reversalAmount = (BigDecimal)this.persistenceService.find("select sum(instrumentAmount) from InstrumentHeader where id in (" + this.instHeaderIds + ")");
        glCodescredit = this.persistenceService.findAllBy("select rh.id ,accounthead.id, accounthead.glcode,accounthead.name, sum(rd.cramount),sum(rd.dramount),function.id from ReceiptDetail rd  inner join rd.accounthead as accounthead inner join rd.receiptHeader as rh inner join rd.function as function where rh.id in(" + this.receiptHeaderIds + ") and rd.dramount<>0 and rd.cramount=0 and accounthead.glcode not in (select glcode from CChartOfAccounts where purposeId in (select id from AccountCodePurpose where name='Cheque In Hand')) group by rh.id ,accounthead.id,accounthead.glcode,accounthead.name,function.id order by accounthead", new Object[0]);
        glCodes = this.persistenceService.findAllBy("select rh.id ,accounthead.id, accounthead.glcode,accounthead.name, sum(rd.cramount),sum(rd.dramount),function.id from ReceiptDetail rd  inner join rd.accounthead as accounthead inner join rd.receiptHeader as rh inner join rd.function as function where rh.id in(" + this.receiptHeaderIds + ") and rd.cramount<>0 and rd.dramount=0  group by rh.id ,accounthead.id,accounthead.glcode,accounthead.name,function.id order by accounthead", new Object[0]);
        glCodes.addAll(glCodescredit);
        String reversalGlCodesStr = "";
        for (Object[] rd : glCodes) {
            detail = new DishonoredChequeBean();
            receiptVoucher = (ReceiptVoucher)this.persistenceService.findByNamedQuery("RECEIPT_VOUCHER_BY_RECEIPTID", new Object[]{this.getLongValue(rd[0])});
            if (receiptVoucher != null) {
                detail.setVoucherHeaderId(receiptVoucher.getVoucherheader().getId());
            }
            detail.setGlcodeId(this.getStringValue(rd[1]));
            detail.setGlcode(this.getStringValue(rd[2]));
            detail.setDescription(this.getStringValue(rd[3]));
            detail.setDebitAmount(this.getStringValue(rd[4]));
            detail.setCreditAmount(this.getStringValue(rd[5]));
            detail.setFunctionId(this.getStringValue(rd[6]));
            this.generalLedger.add(detail);
            if (reversalGlCodesStr.equalsIgnoreCase("")) {
                reversalGlCodesStr = "'" + this.getStringValue(rd[2]) + "'";
                continue;
            }
            reversalGlCodesStr = reversalGlCodesStr + "," + "'" + this.getStringValue(rd[2]) + "'";
        }
        remittanceDetailsCredit = this.persistenceService.findAllBy("select rh.id ,accounthead.id, accounthead.glcode,accounthead.name, sum(rd.cramount),sum(rd.dramount),function.id from ReceiptDetail rd  inner join rd.accounthead as accounthead inner join rd.receiptHeader as rh inner join rd.function as function inner join rh.receiptInstrument ri where ri.id in (" + this.instHeaderIds + ") and rd.dramount<>0 and rd.cramount=0  group by rh.id ,accounthead.id,accounthead.glcode,accounthead.name,function.id order by accounthead", new Object[0]);
        for (Object[] rd : remittanceDetailsCredit) {
            detail = new DishonoredChequeBean();
            receiptVoucher = (ReceiptVoucher)this.persistenceService.findByNamedQuery("RECEIPT_VOUCHER_BY_RECEIPTID", new Object[]{this.getLongValue(rd[0])});
            if (receiptVoucher != null) {
                detail.setVoucherHeaderId(receiptVoucher.getVoucherheader().getId());
            }
            detail.setGlcodeId(this.getStringValue(rd[1]));
            detail.setGlcode(this.getStringValue(rd[2]));
            detail.setDescription(this.getStringValue(rd[3]));
            detail.setDebitAmount(this.getStringValue(rd[4]));
            detail.setCreditAmount(this.getStringValue(rd[5]));
            detail.setFunctionId(this.getStringValue(rd[6]));
            this.remittanceGeneralLedger.add(detail);
        }
        instrumentDetails = this.persistenceService.getSession().createSQLQuery("select rpt.id as receiptheaderid,ih.id as instrumentheaderid,rpt.receiptnumber as receiptnumber,rpt.receiptdate as receiptdate,ih.instrumentnumber as instrumentnumber,ih.instrumentdate as instrumentdate,ih.instrumentamount as instrumentamount,b.name as bankname,ba.accountnumber as accountnumber,ih.payto as payto,status.description as description from egcl_collectionheader rpt,egcl_collectioninstrument ci,egf_instrumentheader ih,egw_status status,bank b,bankbranch bb,bankaccount ba where rpt.id = ci.collectionheader AND ci.instrumentheader = ih.id AND status.id = ih.id_status AND b.id = bb.bankid AND bb.id = ba.branchid AND ba.id = ih.bankaccountid and ih.id in  (" + this.instHeaderIds + ")").list();
        this.dishonoredChequeDisplayList = this.populateDishonorChequeBean(instrumentDetails);
    }

    protected String getStringValue(Object object) {
        return object != null ? object.toString() : "";
    }

    protected String getDateValue(Object object) {
        return object != null ? this.formatter.format((Date)object) : "";
    }

    protected Long getLongValue(Object object) {
        return object != null ? Long.valueOf(object.toString()) : null;
    }

    private BigDecimal getBigDecimalValue(Object object) {
        return object != null ? new BigDecimal(object.toString()).setScale(2) : BigDecimal.ZERO.setScale(2);
    }

    public List getBankBranchList() {
        return this.bankBranchList;
    }

    public void setBankBranchList(List bankBranchList) {
        this.bankBranchList = bankBranchList;
    }

    public Map getInstrumentModesMap() {
        return this.instrumentModesMap;
    }

    public void setInstrumentModesMap(Map instrumentModesList) {
        this.instrumentModesMap = instrumentModesList;
    }

    public String getBankBranchId() {
        return this.bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public List getAccountNumberList() {
        return this.accountNumberList;
    }

    public void setAccountNumberList(List accountNumberList) {
        this.accountNumberList = accountNumberList;
    }

    public String getChequeNumber() {
        return this.chequeNumber;
    }

    public void setChequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
    }

    public Date getChequeDate() {
        return this.chequeDate;
    }

    public void setChequeDate(Date chequeDate) {
        this.chequeDate = chequeDate;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public String getInstrumentMode() {
        return this.instrumentMode;
    }

    public void setInstrumentMode(String instrumentMode) {
        this.instrumentMode = instrumentMode;
    }

    public String getInstHeaderIds() {
        return this.instHeaderIds;
    }

    public void setInstHeaderIds(String instHeaderIds) {
        this.instHeaderIds = instHeaderIds;
    }

    public String getVoucherHeaderIds() {
        return this.voucherHeaderIds;
    }

    public void setVoucherHeaderIds(String voucherHeaderIds) {
        this.voucherHeaderIds = voucherHeaderIds;
    }

    public List<DishonoredChequeBean> getGeneralLedger() {
        return this.generalLedger;
    }

    public void setGeneralLedger(List<DishonoredChequeBean> generalLedger) {
        this.generalLedger = generalLedger;
    }

    public List<DishonoredChequeBean> getSubLedgerDetails() {
        return this.subLedgerDetails;
    }

    public void setSubLedgerDetails(List<DishonoredChequeBean> subLedgerDetails) {
        this.subLedgerDetails = subLedgerDetails;
    }

    public BigDecimal getReversalAmount() {
        return this.reversalAmount;
    }

    public void setReversalAmount(BigDecimal reversalAmount) {
        this.reversalAmount = reversalAmount;
    }

    public List<DishonoredChequeBean> getRemittanceGeneralLedger() {
        return this.remittanceGeneralLedger;
    }

    public void setRemittanceGeneralLedger(List<DishonoredChequeBean> remittanceGeneralLedger) {
        this.remittanceGeneralLedger = remittanceGeneralLedger;
    }

    public String getReceiptGLDetails() {
        return this.receiptGLDetails;
    }

    public void setReceiptGLDetails(String receiptGLDetails) {
        this.receiptGLDetails = receiptGLDetails;
    }

    public String getRemittanceGLDetails() {
        return this.remittanceGLDetails;
    }

    public void setRemittanceGLDetails(String remittanceGLDetails) {
        this.remittanceGLDetails = remittanceGLDetails;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getDishonorReason() {
        return this.dishonorReason;
    }

    public void setDishonorReason(String dishonorReason) {
        this.dishonorReason = dishonorReason;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getReferenceNo() {
        return this.referenceNo;
    }

    public void setReferenceNo(String referenceNo) {
        this.referenceNo = referenceNo;
    }

    public Long getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(Long accountNumber) {
        this.accountNumber = accountNumber;
    }

    public List<DishonoredChequeBean> getDishonoredChequeDisplayList() {
        return this.dishonoredChequeDisplayList;
    }

    public void setDishonoredChequeDisplayList(List<DishonoredChequeBean> dishonoredChequeDisplayList) {
        this.dishonoredChequeDisplayList = dishonoredChequeDisplayList;
    }

    public String getReceiptHeaderIds() {
        return this.receiptHeaderIds;
    }

    public void setReceiptHeaderIds(String receiptHeaderIds) {
        this.receiptHeaderIds = receiptHeaderIds;
    }
}

