/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptDetailInfo;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.services.DebitAccountHeadDetailsService;
import org.egov.collection.service.ChallanService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bank;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.models.ServiceCategory;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.pims.commons.Position;
import org.hibernate.StaleObjectStateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="challan-new.jsp"), @Result(name={"createReceipt"}, location="challan-createReceipt.jsp"), @Result(name={"cancelReceipt"}, location="challan-cancelReceipt.jsp"), @Result(name={"success"}, location="challan-success.jsp"), @Result(name={"view"}, location="challan-view.jsp"), @Result(name={"report"}, location="challan-report.jsp"), @Result(name={"error"}, location="challan-error.jsp")})
public class ChallanAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(ChallanAction.class);
    private static final long serialVersionUID = 1L;
    protected List<String> headerFields;
    protected List<String> mandatoryFields;
    private List<ReceiptDetailInfo> subLedgerlist;
    private List<ReceiptDetailInfo> billDetailslist;
    private ReceiptHeader receiptHeader = new ReceiptHeader();
    private CollectionsUtil collectionsUtil;
    private FinancialsUtil financialsUtil;
    @Autowired
    private BoundaryService boundaryService;
    private String deptId;
    private Long boundaryId;
    private Department dept;
    private Boundary boundary;
    private CFunction function;
    private Long receiptId;
    private final String VIEW = "view";
    private CollectionCommon collectionCommon;
    private ReceiptHeaderService receiptHeaderService;
    private SimpleWorkflowService<Challan> challanWorkflowService;
    private String challanId;
    private String approvalRemarks;
    private Long positionUser;
    private Integer designationId;
    private String challanNumber;
    private Boolean cashAllowed = Boolean.TRUE;
    private Boolean cardAllowed = Boolean.TRUE;
    private Boolean chequeAllowed = Boolean.TRUE;
    private Boolean ddAllowed = Boolean.TRUE;
    private Boolean bankAllowed = Boolean.TRUE;
    private Boolean onlineAllowed = Boolean.TRUE;
    private InstrumentHeader instrHeaderCash;
    private InstrumentHeader instrHeaderCard;
    private List<InstrumentHeader> instrumentProxyList;
    private int instrumentCount;
    private BigDecimal cashOrCardInstrumenttotal = BigDecimal.ZERO;
    private BigDecimal chequeInstrumenttotal = BigDecimal.ZERO;
    private String instrumentTypeCashOrCard;
    private String actionName;
    private String sourcePage;
    private String voucherNumber;
    private final List<ValidationError> errors = new ArrayList(0);
    private String reportId;
    private Position position = null;
    private Long[] selectedReceipts;
    private String currentFinancialYearId;
    private ServiceDetails service;
    private PersistenceService<ServiceCategory, Long> serviceCategoryService;
    private PersistenceService<ServiceDetails, Long> serviceDetailsService;
    @Autowired
    private BankHibernateDAO bankDAO;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsDAO;
    @Autowired
    private FunctionHibernateDAO functionDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    private Long serviceCategoryId;
    private Long serviceId;
    private ChallanService challanService;
    private String approverName;
    private Long functionId;
    private Date cutOffDate;
    private String instrumentType;
    @Autowired
    private ApplicationContext beanProvider;

    public ChallanAction() {
        this.addRelatedEntity("receiptMisc.fund", Fund.class);
        this.addRelatedEntity("challan.service", ServiceDetails.class);
    }

    public Object getModel() {
        if (this.receiptHeader.getReceiptMisc() == null) {
            this.receiptHeader.setReceiptMisc(new ReceiptMisc());
        }
        if (this.receiptHeader.getChallan() == null) {
            this.receiptHeader.setChallan(new Challan());
        }
        return this.receiptHeader;
    }

    @Action(value="/receipts/challan-newform")
    @ValidationErrorPage(value="error")
    @SkipValidation
    public String newform() {
        this.setLoginDept();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            this.cutOffDate = sdf.parse(this.collectionsUtil.getAppConfigValue("Collection", "COLLECTIONDATAENTRYCUTOFFDATE"));
        }
        catch (ParseException e) {
            LOGGER.error((Object)(this.getText("Error parsing Cut Off Date") + e.getMessage()));
        }
        return "new";
    }

    private void setLoginDept() {
        Department loginUserDepartment = this.collectionsUtil.getDepartmentOfLoggedInUser();
        if (loginUserDepartment == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("Department does not exists", "viewchallan.validation.error.user.notexists")));
        }
        this.setDeptId(loginUserDepartment.getId().toString());
        this.setDept(loginUserDepartment);
        this.addDropdownData("approverDepartmentList", this.collectionsUtil.getDepartmentsAllowedForChallanApproval());
    }

    @Action(value="/receipts/challan-save")
    @ValidationErrorPage(value="new")
    public String save() {
        if (!this.actionName.equals("CHALLAN_REJECT")) {
            this.position = this.getPositionUser() == null || this.getPositionUser() == -1L ? this.collectionsUtil.getPositionOfUser(this.collectionsUtil.getLoggedInUser()) : this.collectionsUtil.getPositionById(this.positionUser);
        }
        if (this.actionName.equals("CHALLAN_NEW") || this.actionName.equals("CHALLAN_MODIFY") || this.actionName.equals("CHALLAN_VALIDATE")) {
            return this.saveChallan();
        }
        this.challanService.workflowtransition(this.receiptHeader.getChallan(), this.position, this.actionName, this.approvalRemarks);
        if (this.receiptHeader.getChallan().getState() != null && this.receiptHeader.getChallan().getState().getOwnerPosition() != null) {
            this.approverName = this.collectionsUtil.getApproverName((Position)this.receiptHeader.getChallan().getState().getOwnerPosition());
        }
        return "success";
    }

    @ValidationErrorPage(value="createReceipt")
    @SkipValidation
    @Action(value="/receipts/challan-createReceipt")
    public String createReceipt() {
        if (this.challanNumber != null && !"".equals(this.challanNumber)) {
            this.receiptHeader = (ReceiptHeader)this.persistenceService.findByNamedQuery("VALIDRECEIPT_BY_CHALLANNO", new Object[]{this.challanNumber});
            if (this.receiptHeader == null) {
                this.receiptHeader = new ReceiptHeader();
                this.errors.add(new ValidationError(this.getText("challan.notfound.message"), "No Valid Challan Found. Please check the challan number."));
                throw new ValidationException(this.errors);
            }
            if ("CANCELLED".equals(this.receiptHeader.getChallan().getStatus().getCode())) {
                this.errors.add(new ValidationError(this.getText("challan.cancel.receipt.error"), "Challan is cancelled. Cannot create Receipt for Challan."));
                throw new ValidationException(this.errors);
            }
            if ("PENDING".equals(this.receiptHeader.getStatus().getCode())) {
                this.loadReceiptDetails();
                this.setCollectionModesNotAllowed();
            } else {
                this.errors.add(new ValidationError(this.getText("challanreceipt.created.message", new String[]{this.receiptHeader.getReceiptnumber()}), "Receipt Already Created For this Challan. Receipt Number is " + this.receiptHeader.getReceiptnumber()));
                throw new ValidationException(this.errors);
            }
        }
        return "createReceipt";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/receipts/challan-saveChallan")
    public String saveChallan() {
        this.receiptHeader.getReceiptDetails().clear();
        this.errors.clear();
        this.addDropdownData("approverDepartmentList", this.collectionsUtil.getDepartmentsAllowedForChallanApproval());
        this.populateAndPersistChallanReceipt();
        if (this.receiptHeader.getChallan().getState() != null && this.receiptHeader.getChallan().getState().getOwnerPosition() != null && !"CHALLAN_VALIDATE".equals(this.actionName)) {
            this.addActionMessage(this.getText("challan.savechallan.success", new String[]{this.collectionsUtil.getApproverName((Position)this.receiptHeader.getChallan().getState().getOwnerPosition()), this.receiptHeader.getChallan().getChallanNumber()}));
        }
        if ("CHALLAN_VALIDATE".equals(this.actionName)) {
            this.addActionMessage(this.getText("challan.validatesuccess.message"));
            return this.viewChallan();
        }
        return this.viewChallan();
    }

    @Action(value="/receipts/challan-viewChallan")
    @ValidationErrorPage(value="error")
    @SkipValidation
    public String viewChallan() {
        if (this.challanId == null) {
            this.receiptHeader = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.receiptId, false);
        } else {
            this.receiptHeader = (ReceiptHeader)this.persistenceService.findByNamedQuery("RECEIPT_BY_CHALLANID", new Object[]{Long.valueOf(this.challanId)});
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                this.cutOffDate = sdf.parse(this.collectionsUtil.getAppConfigValue("Collection", "COLLECTIONDATAENTRYCUTOFFDATE"));
            }
            catch (ParseException e) {
                LOGGER.error((Object)(this.getText("Error parsing Cut Off Date") + e.getMessage()));
            }
        }
        this.setLoginDept();
        this.loadReceiptDetails();
        return "view";
    }

    @ValidationErrorPage(value="createReceipt")
    @Action(value="/receipts/challan-saveOrupdate")
    public String saveOrupdate() {
        try {
            this.errors.clear();
            if (this.receiptHeader.getReceiptHeader() != null) {
                this.collectionCommon.cancelChallanReceiptOnCreation(this.receiptHeader);
            }
            boolean setInstrument = true;
            List receiptInstrList = new ArrayList();
            this.receiptHeader.setIsReconciled(Boolean.FALSE);
            this.receiptHeader.setIsModifiable(Boolean.TRUE);
            this.receiptHeader.setCollectiontype(Character.valueOf('C'));
            this.receiptHeader.setLocation(this.collectionsUtil.getLocationOfUser(this.getSession()));
            this.receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "TO_BE_SUBMITTED"));
            this.receiptHeader.setCreatedBy(this.collectionsUtil.getLoggedInUser());
            this.receiptHeader.setCreatedDate(new Date());
            if (setInstrument) {
                receiptInstrList = this.populateInstrumentDetails();
                setInstrument = false;
            }
            this.receiptHeader.setReceiptInstrument(new HashSet(receiptInstrList));
            BigDecimal debitAmount = BigDecimal.ZERO;
            for (ReceiptDetail receiptDetail : this.receiptHeader.getReceiptDetails()) {
                debitAmount = debitAmount.add(receiptDetail.getCramount());
            }
            DebitAccountHeadDetailsService debitAccountHeadService = (DebitAccountHeadDetailsService)this.beanProvider.getBean(this.collectionsUtil.getBeanNameForDebitAccountHead());
            this.receiptHeader.addReceiptDetail(debitAccountHeadService.addDebitAccountHeadDetails(debitAmount, this.receiptHeader, this.chequeInstrumenttotal, this.cashOrCardInstrumenttotal, this.instrumentTypeCashOrCard));
            if (this.chequeInstrumenttotal != null && this.chequeInstrumenttotal.compareTo(BigDecimal.ZERO) != 0) {
                this.receiptHeader.setTotalAmount(this.chequeInstrumenttotal);
            }
            if (this.cashOrCardInstrumenttotal != null && this.cashOrCardInstrumenttotal.compareTo(BigDecimal.ZERO) != 0) {
                this.receiptHeader.setTotalAmount(this.cashOrCardInstrumenttotal);
            }
            this.receiptHeaderService.setReceiptNumber(this.receiptHeader);
            this.receiptHeaderService.populateAndPersistReceipts(this.receiptHeader, receiptInstrList);
            ReceiptHeader[] receipts = new ReceiptHeader[]{this.receiptHeader};
            try {
                this.reportId = this.collectionCommon.generateReport(receipts, true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error during report generation!", (Throwable)e);
                throw new ApplicationRuntimeException("Error during report generation!", (Throwable)e);
            }
            return "report";
        }
        catch (StaleObjectStateException exp) {
            this.errors.add(new ValidationError(this.getText("challanreceipt.created.staleobjectstate"), "Receipt Already Created For this Challan.Go to Search Receipt screen to Re-print the receipt."));
            LOGGER.error((Object)"Receipt Already Created For this Challan", (Throwable)exp);
            throw new ValidationException(this.errors);
        }
        catch (Exception exp) {
            this.errors.add(new ValidationError(this.getText("challanreceipt.create.errorincreate"), "Error occured in Challan Receipt creation, please try again."));
            LOGGER.error((Object)"Error occured in Challan Receipt creation, please try again", (Throwable)exp);
            throw new ValidationException(this.errors);
        }
    }

    @Action(value="/receipts/challan-printChallan")
    public String printChallan() {
        try {
            this.reportId = this.collectionCommon.generateChallan(this.receiptHeader, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error during report generation!", (Throwable)e);
            throw new ApplicationRuntimeException("Error during report generation!", (Throwable)e);
        }
        this.setSourcePage("viewChallan");
        return "report";
    }

    @Action(value="/receipts/challan-cancelReceipt")
    @SkipValidation
    public String cancelReceipt() {
        if (this.getSelectedReceipts() != null && this.getSelectedReceipts().length > 0) {
            this.receiptHeader = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.selectedReceipts[0], false);
            this.loadReceiptDetails();
        }
        return "cancelReceipt";
    }

    @Action(value="/receipts/challan-saveOnCancel")
    @SkipValidation
    public String saveOnCancel() {
        boolean isInstrumentDeposited = false;
        this.setSourcePage("cancelReceipt");
        for (InstrumentHeader instrumentHeader : this.receiptHeader.getReceiptInstrument()) {
            if (instrumentHeader.getInstrumentType().getType().equals("cash")) {
                if (!instrumentHeader.getStatusId().getDescription().equals("Reconciled")) continue;
                isInstrumentDeposited = true;
                break;
            }
            if (!instrumentHeader.getStatusId().getDescription().equals("Deposited")) continue;
            isInstrumentDeposited = true;
            break;
        }
        if (isInstrumentDeposited) {
            if (this.collectionsUtil.checkChallanValidity(this.receiptHeader.getChallan())) {
                this.receiptHeaderService.persist(this.receiptHeader);
                this.receiptHeader = this.collectionCommon.createPendingReceiptFromCancelledChallanReceipt(this.receiptHeader);
                LOGGER.info((Object)" Created a receipt in PENDING status in lieu of the cancelled receipt ");
                this.loadReceiptDetails();
                this.setCollectionModesNotAllowed();
                return "createReceipt";
            }
            this.collectionCommon.cancelChallanReceipt(this.receiptHeader, false);
            this.addActionMessage(this.getText("challan.expired.message", "Please note that a new receipt can not be created as the corresponding challan " + this.receiptHeader.getChallan().getChallanNumber() + " has expired"));
        } else {
            this.collectionCommon.cancelChallanReceipt(this.receiptHeader, true);
            if (!this.receiptHeader.getState().getValue().equals("END")) {
                this.receiptHeaderService.endReceiptWorkFlowOnCancellation(this.receiptHeader);
            }
            if (this.collectionsUtil.checkChallanValidity(this.receiptHeader.getChallan())) {
                ReceiptHeader newReceipt = this.collectionCommon.createPendingReceiptFromCancelledChallanReceipt(this.receiptHeader);
                this.receiptHeaderService.persist(newReceipt);
                LOGGER.info((Object)" Created a receipt in PENDING status in lieu of the cancelled receipt ");
            }
        }
        return "success";
    }

    public List<WorkflowAction> getValidActions() {
        Challan challan = this.receiptHeader.getChallan();
        if (challan == null) {
            challan = new Challan();
        }
        return this.challanWorkflowService.getValidActions((StateAware)challan);
    }

    private List<InstrumentHeader> populateInstrumentDetails() {
        List<InstrumentHeader> instrumentHeaderList = new ArrayList();
        if ("cash".equals(this.instrumentTypeCashOrCard)) {
            this.instrHeaderCash.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("cash"));
            this.instrHeaderCash.setIsPayCheque("0");
            this.cashOrCardInstrumenttotal = this.cashOrCardInstrumenttotal.add(this.instrHeaderCash.getInstrumentAmount());
            instrumentHeaderList.add(this.instrHeaderCash);
        }
        if ("card".equals(this.instrumentTypeCashOrCard)) {
            this.instrHeaderCard.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("card"));
            if (this.instrHeaderCard.getTransactionDate() == null) {
                this.instrHeaderCard.setTransactionDate(new Date());
            }
            this.instrHeaderCard.setIsPayCheque("0");
            this.cashOrCardInstrumenttotal = this.cashOrCardInstrumenttotal.add(this.instrHeaderCard.getInstrumentAmount());
            instrumentHeaderList.add(this.instrHeaderCard);
        }
        if (this.instrumentProxyList != null && (this.getInstrumentType().equals("cheque") || this.getInstrumentType().equals("dd"))) {
            instrumentHeaderList = this.populateInstrumentHeaderForChequeDD(instrumentHeaderList, this.instrumentProxyList);
        }
        instrumentHeaderList = this.receiptHeaderService.createInstrument(instrumentHeaderList);
        return instrumentHeaderList;
    }

    private List<InstrumentHeader> populateInstrumentHeaderForChequeDD(List<InstrumentHeader> instrumentHeaderList, List<InstrumentHeader> instrumentProxyList) {
        for (InstrumentHeader instrumentHeader : instrumentProxyList) {
            if (this.getInstrumentType().equals("cheque")) {
                instrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("cheque"));
            } else if (this.getInstrumentType().equals("dd")) {
                instrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("dd"));
            }
            if (instrumentHeader.getBankId() != null) {
                Bank bank = this.bankDAO.findById((Number)instrumentHeader.getBankId().getId(), false);
                instrumentHeader.setBankId(bank);
            }
            this.chequeInstrumenttotal = this.chequeInstrumenttotal.add(instrumentHeader.getInstrumentAmount());
            instrumentHeader.setIsPayCheque("0");
            instrumentHeaderList.add(instrumentHeader);
        }
        return instrumentHeaderList;
    }

    private void populateAndPersistChallanReceipt() {
        if (this.voucherNumber != null && !"".equals(this.voucherNumber)) {
            CVoucherHeader voucherHeader = (CVoucherHeader)this.persistenceService.findByNamedQuery("getVoucherHeaderByVoucherNumber", new Object[]{this.voucherNumber});
            if (voucherHeader == null) {
                this.errors.add(new ValidationError("challan.invalid.vouchernumber", "Voucher not found. Please check the voucher number."));
            }
            this.receiptHeader.getChallan().setVoucherHeader(voucherHeader);
        }
        this.receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "PENDING"));
        this.receiptHeader.setIsReconciled(Boolean.TRUE);
        this.receiptHeader.setIsModifiable(Boolean.FALSE);
        this.receiptHeader.setReceipttype('C');
        this.receiptHeader.setPaidBy("CHAIRPERSON");
        this.receiptHeader.setSource(Source.SYSTEM.toString());
        this.receiptHeader.setReceiptdate(new Date());
        this.receiptHeader.setService((ServiceDetails)this.serviceDetailsService.findById((Serializable)this.serviceId, false));
        this.receiptHeader.getService().setServiceCategory((ServiceCategory)this.serviceCategoryService.findById((Serializable)this.serviceCategoryId, false));
        this.receiptHeader.getReceiptMisc().setFund(this.fundDAO.fundById(this.receiptHeader.getReceiptMisc().getFund().getId(), false));
        Department depart = (Department)this.getPersistenceService().findByNamedQuery("getDepartmentById", new Object[]{Long.valueOf(this.deptId)});
        this.receiptHeader.getReceiptMisc().setDepartment(depart);
        if (this.boundaryId != null) {
            this.receiptHeader.getReceiptMisc().setBoundary(this.boundaryService.getBoundaryById(this.boundaryId));
        }
        this.receiptHeader.getReceiptMisc().setReceiptHeader(this.receiptHeader);
        BigDecimal debitamount = BigDecimal.ZERO;
        this.removeEmptyRows(this.billDetailslist);
        this.removeEmptyRows(this.subLedgerlist);
        int m = 0;
        this.validateAccountDetails();
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (ReceiptDetailInfo rDetails : this.billDetailslist) {
            CChartOfAccounts account = this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(rDetails.getGlcodeDetail());
            CFunction funcn = null;
            if (this.functionId != null) {
                funcn = this.functionDAO.getFunctionById(this.functionId);
            }
            ReceiptDetail receiptDetail = new ReceiptDetail(account, funcn, rDetails.getCreditAmountDetail(), rDetails.getDebitAmountDetail(), null, Long.valueOf(m), null, null, this.receiptHeader, BillAccountDetails.PURPOSE.OTHERS.toString());
            receiptDetail.setCramount(rDetails.getCreditAmountDetail());
            totalAmt = totalAmt.add(receiptDetail.getCramount()).subtract(receiptDetail.getDramount());
            CFinancialYear financialYear = this.financialYearDAO.findById((Number)rDetails.getFinancialYearId(), false);
            receiptDetail.setFinancialYear(financialYear);
            if (rDetails.getCreditAmountDetail() == null) {
                receiptDetail.setCramount(BigDecimal.ZERO);
            } else {
                receiptDetail.setCramount(rDetails.getCreditAmountDetail());
            }
            if (rDetails.getDebitAmountDetail() == null) {
                receiptDetail.setDramount(BigDecimal.ZERO);
            } else {
                receiptDetail.setDramount(rDetails.getDebitAmountDetail());
            }
            receiptDetail = this.setAccountPayeeDetails(this.subLedgerlist, receiptDetail);
            this.receiptHeader.addReceiptDetail(receiptDetail);
            debitamount = debitamount.add(rDetails.getCreditAmountDetail());
            debitamount = debitamount.subtract(rDetails.getDebitAmountDetail());
            ++m;
        }
        this.receiptHeader.setTotalAmount(totalAmt);
        this.receiptHeader.getChallan().setStatus(this.collectionsUtil.getStatusForModuleAndCode("Challan", "CREATED"));
        if (this.receiptHeader.getChallan().getService() != null && this.receiptHeader.getChallan().getService().getId() != null) {
            this.receiptHeader.getChallan().setService((ServiceDetails)this.getPersistenceService().findByNamedQuery("SERVICE_BY_ID", new Object[]{this.receiptHeader.getChallan().getService().getId()}));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            this.cutOffDate = sdf.parse(this.collectionsUtil.getAppConfigValue("Collection", "COLLECTIONDATAENTRYCUTOFFDATE"));
        }
        catch (ParseException e) {
            LOGGER.error((Object)(this.getText("Error parsing Cut Off Date") + e.getMessage()));
        }
        if (this.receiptHeader.getChallan().getChallanDate().before(this.cutOffDate)) {
            this.actionName = "CHALLAN_VALIDATE";
        }
        this.receiptHeaderService.persistChallan(this.receiptHeader, this.position, this.actionName, this.approvalRemarks);
        this.receiptId = this.receiptHeader.getId();
        LOGGER.info((Object)"Persisted Challan and Created Receipt In Pending State For the Challan");
    }

    public ReceiptDetail setAccountPayeeDetails(List<ReceiptDetailInfo> subLedgerlist, ReceiptDetail receiptDetail) {
        for (ReceiptDetailInfo subvoucherDetails : subLedgerlist) {
            if (subvoucherDetails.getGlcode() == null || subvoucherDetails.getGlcode().getId() == 0L || !subvoucherDetails.getGlcode().getId().equals(receiptDetail.getAccounthead().getId())) continue;
            Accountdetailtype accdetailtype = (Accountdetailtype)this.getPersistenceService().findByNamedQuery("getAccountDetailtypeById", new Object[]{subvoucherDetails.getDetailType().getId()});
            Accountdetailkey accdetailkey = (Accountdetailkey)this.getPersistenceService().findByNamedQuery("getAccountDetailkeyByDetailKey", new Object[]{subvoucherDetails.getDetailKeyId(), subvoucherDetails.getDetailType().getId()});
            AccountPayeeDetail accPayeeDetail = new AccountPayeeDetail(accdetailtype, accdetailkey, subvoucherDetails.getAmount(), receiptDetail);
            receiptDetail.addAccountPayeeDetail(accPayeeDetail);
        }
        return receiptDetail;
    }

    protected void validateAccountDetails() {
        BigDecimal totalDrAmt = BigDecimal.ZERO;
        BigDecimal totalCrAmt = BigDecimal.ZERO;
        Integer index = 0;
        for (ReceiptDetailInfo rDetails : this.billDetailslist) {
            index = index + 1;
            totalDrAmt = totalDrAmt.add(rDetails.getDebitAmountDetail());
            totalCrAmt = totalCrAmt.add(rDetails.getCreditAmountDetail());
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getGlcodeDetail().trim().length() == 0) {
                this.errors.add(new ValidationError("challan.accdetail.emptyaccrow", "No data entered in Account Details grid row : {0}", new String[]{index.toString()}));
                continue;
            }
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0 && rDetails.getGlcodeDetail().trim().length() != 0) {
                this.errors.add(new ValidationError("challan.accdetail.amountZero", "Enter debit/credit amount for the account code : {0}", new String[]{rDetails.getGlcodeDetail()}));
                continue;
            }
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) > 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) > 0) {
                this.errors.add(new ValidationError("challan.accdetail.amount", "Please enter either debit/credit amount for the account code : {0}", new String[]{rDetails.getGlcodeDetail()}));
                continue;
            }
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) <= 0 && rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) <= 0 || rDetails.getGlcodeDetail().trim().length() != 0) continue;
            this.errors.add(new ValidationError("challan.accdetail.accmissing", "Account code is missing for credit/debit supplied field in account grid row :{0}", new String[]{"" + index}));
        }
        this.validateSubledgerDetails();
        if (!this.errors.isEmpty()) {
            throw new ValidationException(this.errors);
        }
    }

    protected void validateSubledgerDetails() {
        HashMap<String, BigDecimal> subledAmtmap = new HashMap<String, BigDecimal>();
        ArrayList subLegAccMap = null;
        for (ReceiptDetailInfo rDetails : this.billDetailslist) {
            CChartOfAccountDetail cChartOfAccountDetail = (CChartOfAccountDetail)this.getPersistenceService().find(" from CChartOfAccountDetail where glCodeId=(select id from CChartOfAccounts where glcode=?)", new Object[]{rDetails.getGlcodeDetail()});
            if (null == cChartOfAccountDetail) continue;
            HashMap<String, Object> accountDetailMap = new HashMap<String, Object>();
            accountDetailMap.put("glcodeId", rDetails.getGlcodeIdDetail());
            accountDetailMap.put("glcode", rDetails.getGlcodeDetail());
            if (rDetails.getDebitAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                accountDetailMap.put("amount", rDetails.getCreditAmountDetail());
            } else if (rDetails.getCreditAmountDetail().compareTo(BigDecimal.ZERO) == 0) {
                accountDetailMap.put("amount", rDetails.getDebitAmountDetail());
            }
            if (null == subLegAccMap) {
                subLegAccMap = new ArrayList();
                subLegAccMap.add(accountDetailMap);
                continue;
            }
            subLegAccMap.add(accountDetailMap);
        }
        if (null != subLegAccMap) {
            HashMap<String, String> subLedgerMap = new HashMap<String, String>();
            for (ReceiptDetailInfo receiptDetailInfo : this.subLedgerlist) {
                if (receiptDetailInfo.getGlcode() == null || receiptDetailInfo.getGlcode().getId() == 0L) continue;
                if (null == subledAmtmap.get(receiptDetailInfo.getGlcode().getId().toString())) {
                    subledAmtmap.put(receiptDetailInfo.getGlcode().getId().toString(), receiptDetailInfo.getAmount());
                } else {
                    BigDecimal debitTotalAmount = ((BigDecimal)subledAmtmap.get(receiptDetailInfo.getGlcode().getId().toString())).add(receiptDetailInfo.getAmount());
                    subledAmtmap.put(receiptDetailInfo.getGlcode().getId().toString(), debitTotalAmount);
                }
                StringBuilder subledgerDetailRow = new StringBuilder();
                subledgerDetailRow.append(receiptDetailInfo.getGlcode().getId().toString()).append(receiptDetailInfo.getDetailType().getId().toString()).append(receiptDetailInfo.getDetailKeyId().toString());
                if (null == subLedgerMap.get(subledgerDetailRow.toString())) {
                    subLedgerMap.put(subledgerDetailRow.toString(), subledgerDetailRow.toString());
                    continue;
                }
                this.errors.add(new ValidationError("miscreciept.samesubledger.repeated", "Same subledger should not allow for same account code"));
            }
            for (Map map : subLegAccMap) {
                String glcodeId = map.get("glcodeId").toString();
                if (null == subledAmtmap.get(glcodeId)) {
                    this.errors.add(new ValidationError("miscreciept.samesubledger.entrymissing", "Subledger detail entry is missing for account code: {0}", new String[]{map.get("glcode").toString()}));
                    continue;
                }
                if (((BigDecimal)subledAmtmap.get(glcodeId)).equals(new BigDecimal(map.get("amount").toString()))) continue;
                this.errors.add(new ValidationError("miscreciept.samesubledger.entrymissing", "Total subledger amount is not matching for account code : {0}", new String[]{map.get("glcode").toString()}));
            }
        }
    }

    void removeEmptyRows(List list) {
        Iterator detail = list.iterator();
        while (detail.hasNext()) {
            if (detail.next() != null) continue;
            detail.remove();
        }
    }

    private void loadReceiptDetails() {
        CFunction functn;
        this.setDeptId(this.receiptHeader.getReceiptMisc().getDepartment().getId().toString());
        this.setDept(this.receiptHeader.getReceiptMisc().getDepartment());
        if (!this.receiptHeader.getReceiptDetails().isEmpty() && (functn = ((ReceiptDetail)this.receiptHeader.getReceiptDetails().iterator().next()).getFunction()) != null) {
            this.setFunctionId(functn.getId());
            this.setFunction(functn);
        }
        this.setBoundary(this.receiptHeader.getReceiptMisc().getBoundary());
        this.setServiceCategoryId(this.receiptHeader.getService().getServiceCategory().getId());
        this.setServiceId(this.receiptHeader.getService().getId());
        if (null != this.receiptHeader.getService() && null != this.receiptHeader.getService().getServiceCategory() && this.receiptHeader.getService().getServiceCategory().getId() != -1L) {
            this.addDropdownData("serviceList", this.serviceDetailsService.findAllByNamedQuery("SERVICE_BY_CATEGORY_FOR_TYPE", new Object[]{this.receiptHeader.getService().getServiceCategory().getId(), "C", Boolean.TRUE}));
        } else {
            this.addDropdownData("serviceList", Collections.emptyList());
        }
        this.setBillDetailslist(this.collectionCommon.setReceiptDetailsList(this.receiptHeader, "both"));
        this.setSubLedgerlist(this.collectionCommon.setAccountPayeeList(this.receiptHeader));
        for (ReceiptDetail rDetails : this.receiptHeader.getReceiptDetails()) {
            if (rDetails.getFunction() == null) continue;
            this.setFunction(rDetails.getFunction());
        }
        if (this.receiptHeader.getReceiptMisc().getBoundary() != null) {
            this.setBoundaryId(this.receiptHeader.getReceiptMisc().getBoundary().getId());
        }
        if (this.receiptHeader.getChallan() != null && this.receiptHeader.getChallan().getVoucherHeader() != null) {
            this.setVoucherNumber(this.receiptHeader.getChallan().getVoucherHeader().getVoucherNumber());
        }
        if (this.receiptHeader.getTotalAmount() != null) {
            this.receiptHeader.setTotalAmount(this.receiptHeader.getTotalAmount());
        }
    }

    private void setCollectionModesNotAllowed() {
        List modesNotAllowed = this.collectionsUtil.getCollectionModesNotAllowed(this.collectionsUtil.getLoggedInUser());
        if (modesNotAllowed.contains("cash")) {
            this.setCashAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("card")) {
            this.setCardAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("cheque")) {
            this.setChequeAllowed(Boolean.FALSE);
        }
        if (modesNotAllowed.contains("dd")) {
            this.setDdAllowed(Boolean.FALSE);
        }
        this.setBankAllowed(Boolean.FALSE);
        this.setOnlineAllowed(Boolean.FALSE);
    }

    public void prepare() {
        this.setupChallanPage();
        if (this.receiptId != null) {
            this.receiptHeader = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.receiptId, false);
            this.receiptHeader = (ReceiptHeader)this.receiptHeaderService.merge((Object)this.receiptHeader);
            if (this.receiptHeader.getChallan() != null && this.receiptHeader.getChallan().getService() != null && this.receiptHeader.getChallan().getService().getId() == -1L) {
                this.receiptHeader.getChallan().setService(null);
            }
        }
        this.addDropdownData("designationMasterList", Collections.emptyList());
        this.addDropdownData("postionUserList", Collections.emptyList());
        this.setCurrentFinancialYearId(this.collectionCommon.getFinancialYearIdByDate(new Date()));
        if (!"CHALLAN_CANCEL".equals(this.actionName)) {
            super.prepare();
        }
    }

    public void setupChallanPage() {
        this.headerFields = new ArrayList();
        this.mandatoryFields = new ArrayList();
        this.getHeaderMandateFields();
        if (this.headerFields.contains("fund")) {
            this.setupDropdownDataExcluding(new String[]{"receiptMisc.fund"});
            this.addDropdownData("fundList", this.collectionsUtil.getAllFunds());
        }
        this.addDropdownData("serviceCategoryList", this.serviceCategoryService.findAllByNamedQuery("ACTIVE_SERVICE_CATEGORY", new Object[0]));
        if (null != this.service && null != this.service.getServiceCategory() && this.service.getServiceCategory().getId() != -1L) {
            this.addDropdownData("serviceList", this.serviceDetailsService.findAllByNamedQuery("SERVICE_BY_CATEGORY_FOR_TYPE", new Object[]{this.service.getServiceCategory().getId(), "C", Boolean.TRUE}));
        } else if (this.serviceCategoryId != null) {
            this.addDropdownData("serviceList", this.serviceDetailsService.findAllByNamedQuery("SERVICE_BY_CATEGORY_FOR_TYPE", new Object[]{this.serviceCategoryId, "C", Boolean.TRUE}));
        } else {
            this.addDropdownData("serviceList", Collections.emptyList());
        }
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.persistenceService.findAllByNamedQuery("getAllDepartment", new Object[0]));
        }
        if (this.headerFields.contains("function")) {
            this.addDropdownData("functionList", this.functionDAO.getAllActiveFunctions());
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.persistenceService.findAllByNamedQuery("getAllField", new Object[0]));
        }
        this.setupDropdownDataExcluding(new String[]{"challan.service"});
        this.addDropdownData("financialYearList", this.persistenceService.findAllByNamedQuery("getActiveFinancialYear", new Object[0]));
        if (this.getBillDetailslist() == null) {
            this.setBillDetailslist(new ArrayList());
            this.getBillDetailslist().add(new ReceiptDetailInfo());
        }
        if (this.getSubLedgerlist() == null) {
            this.setSubLedgerlist(new ArrayList());
            this.getSubLedgerlist().add(new ReceiptDetailInfo());
        }
        this.setHeaderFields(this.headerFields);
        this.setMandatoryFields(this.mandatoryFields);
        this.instrumentCount = this.instrumentProxyList == null ? 0 : this.instrumentProxyList.size();
        this.addDropdownData("bankBranchList", Collections.emptyList());
        this.addDropdownData("accountNumberList", Collections.emptyList());
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    protected void getHeaderMandateFields() {
        List appConfigList = this.collectionsUtil.getAppConfigValues("EGF", "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!"M".equalsIgnoreCase(mandate)) continue;
            this.mandatoryFields.add(header);
        }
    }

    public List getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(List headerFields) {
        this.headerFields = headerFields;
    }

    public List getMandatoryFields() {
        return this.mandatoryFields;
    }

    public void setMandatoryFields(List mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    public String getChallanNumber() {
        return this.challanNumber;
    }

    public void setChallanNumber(String challanNumber) {
        this.challanNumber = challanNumber;
    }

    public List<ReceiptDetailInfo> getBillDetailslist() {
        return this.billDetailslist;
    }

    public void setBillDetailslist(List<ReceiptDetailInfo> billDetailslist) {
        this.billDetailslist = billDetailslist;
    }

    public List<ReceiptDetailInfo> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<ReceiptDetailInfo> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public Department getDept() {
        return this.dept;
    }

    public void setDept(Department dept) {
        this.dept = dept;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Boundary boundary) {
        this.boundary = boundary;
    }

    public Long getBoundaryId() {
        return this.boundaryId;
    }

    public void setBoundaryId(Long boundaryId) {
        this.boundaryId = boundaryId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public ReceiptHeader getReceiptHeader() {
        return this.receiptHeader;
    }

    public void setReceiptHeader(ReceiptHeader receiptHeader) {
        this.receiptHeader = receiptHeader;
    }

    public void setReceiptId(Long receiptId) {
        this.receiptId = receiptId;
    }

    public Long getReceiptId() {
        return this.receiptId;
    }

    public String getChallanId() {
        return this.challanId;
    }

    public void setChallanId(String challanId) {
        this.challanId = challanId;
    }

    public String getApprovalRemarks() {
        return this.approvalRemarks;
    }

    public void setApprovalRemarks(String approvalRemarks) {
        this.approvalRemarks = approvalRemarks;
    }

    public Long getPositionUser() {
        return this.positionUser;
    }

    public void setPositionUser(Long positionUser) {
        this.positionUser = positionUser;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public Boolean getCashAllowed() {
        return this.cashAllowed;
    }

    public void setCashAllowed(Boolean cashAllowed) {
        this.cashAllowed = cashAllowed;
    }

    public Boolean getCardAllowed() {
        return this.cardAllowed;
    }

    public void setCardAllowed(Boolean cardAllowed) {
        this.cardAllowed = cardAllowed;
    }

    public InstrumentHeader getInstrHeaderCash() {
        return this.instrHeaderCash;
    }

    public void setInstrHeaderCash(InstrumentHeader instrHeaderCash) {
        this.instrHeaderCash = instrHeaderCash;
    }

    public InstrumentHeader getInstrHeaderCard() {
        return this.instrHeaderCard;
    }

    public void setInstrHeaderCard(InstrumentHeader instrHeaderCard) {
        this.instrHeaderCard = instrHeaderCard;
    }

    public BigDecimal getCashOrCardInstrumenttotal() {
        return this.cashOrCardInstrumenttotal;
    }

    public void setCashOrCardInstrumenttotal(BigDecimal cashOrCardInstrumenttotal) {
        this.cashOrCardInstrumenttotal = cashOrCardInstrumenttotal;
    }

    public BigDecimal getChequeInstrumenttotal() {
        return this.chequeInstrumenttotal;
    }

    public void setChequeInstrumenttotal(BigDecimal chequeInstrumenttotal) {
        this.chequeInstrumenttotal = chequeInstrumenttotal;
    }

    public String getInstrumentTypeCashOrCard() {
        return this.instrumentTypeCashOrCard;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public void setInstrumentTypeCashOrCard(String instrumentTypeCashOrCard) {
        this.instrumentTypeCashOrCard = instrumentTypeCashOrCard;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getReportId() {
        return this.reportId;
    }

    public String getSourcePage() {
        return this.sourcePage;
    }

    public void setSourcePage(String sourcePage) {
        this.sourcePage = sourcePage;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public Long[] getSelectedReceipts() {
        return this.selectedReceipts;
    }

    public void setSelectedReceipts(Long[] selectedReceipts) {
        this.selectedReceipts = selectedReceipts;
    }

    public String getCurrentFinancialYearId() {
        return this.currentFinancialYearId;
    }

    public void setCurrentFinancialYearId(String currentFinancialYearId) {
        this.currentFinancialYearId = currentFinancialYearId;
    }

    public String amountInWords(BigDecimal amount) {
        return NumberUtil.amountInWords((BigDecimal)amount);
    }

    public List<InstrumentHeader> getInstrumentProxyList() {
        return this.instrumentProxyList;
    }

    public void setInstrumentProxyList(List<InstrumentHeader> instrumentProxyList) {
        this.instrumentProxyList = instrumentProxyList;
    }

    public int getInstrumentCount() {
        return this.instrumentCount;
    }

    public void setInstrumentCount(int instrumentCount) {
        this.instrumentCount = instrumentCount;
    }

    public ServiceDetails getService() {
        return this.service;
    }

    public void setService(ServiceDetails service) {
        this.service = service;
    }

    public void setServiceCategoryService(PersistenceService<ServiceCategory, Long> serviceCategoryService) {
        this.serviceCategoryService = serviceCategoryService;
    }

    public void setServiceDetailsService(PersistenceService<ServiceDetails, Long> serviceDetailsService) {
        this.serviceDetailsService = serviceDetailsService;
    }

    public void setChallanWorkflowService(SimpleWorkflowService<Challan> challanWorkflowService) {
        this.challanWorkflowService = challanWorkflowService;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Long getServiceCategoryId() {
        return this.serviceCategoryId;
    }

    public void setServiceCategoryId(Long serviceCategoryId) {
        this.serviceCategoryId = serviceCategoryId;
    }

    public void setChallanService(ChallanService challanService) {
        this.challanService = challanService;
    }

    public String getApproverName() {
        return this.approverName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public Long getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Long functionId) {
        this.functionId = functionId;
    }

    public Date getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(Date cutOffDate) {
        this.cutOffDate = cutOffDate;
    }

    public Boolean getBankAllowed() {
        return this.bankAllowed;
    }

    public void setBankAllowed(Boolean bankAllowed) {
        this.bankAllowed = bankAllowed;
    }

    public Boolean getChequeAllowed() {
        return this.chequeAllowed;
    }

    public void setChequeAllowed(Boolean chequeAllowed) {
        this.chequeAllowed = chequeAllowed;
    }

    public Boolean getDdAllowed() {
        return this.ddAllowed;
    }

    public void setDdAllowed(Boolean ddAllowed) {
        this.ddAllowed = ddAllowed;
    }

    public String getInstrumentType() {
        return this.instrumentType;
    }

    public void setInstrumentType(String instrumentType) {
        this.instrumentType = instrumentType;
    }

    public Boolean getOnlineAllowed() {
        return this.onlineAllowed;
    }

    public void setOnlineAllowed(Boolean onlineAllowed) {
        this.onlineAllowed = onlineAllowed;
    }

    public void validate() {
        super.validate();
        Department loginUserDepartment = this.collectionsUtil.getDepartmentOfLoggedInUser();
        if (loginUserDepartment != null) {
            this.setLoginDept();
        }
        if (this.receiptHeader.getReceiptdate() != null && this.receiptHeader.getReceiptdate().before(this.financialYearDAO.getFinancialYearByDate(new Date()).getStartingDate())) {
            this.addActionError(this.getText("challan.error.receiptdate.lessthan.financialyear"));
        }
        if (this.receiptHeader.getChallan().getChallanDate() != null && this.receiptHeader.getChallan().getChallanDate().before(this.financialYearDAO.getFinancialYearByDate(new Date()).getStartingDate())) {
            this.addActionError(this.getText("challan.error.challandate.lessthan.financialyear"));
        }
        if (this.receiptHeader.getReceiptdate() != null && this.receiptHeader.getReceiptdate().before(this.receiptHeader.getChallan().getChallanDate())) {
            this.addActionError(this.getText("challan.error.receiptdate.lessthan.challandate"));
        }
    }
}

