/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.Fund;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.eis.entity.EmployeeView;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"bankBranchList"}, location="ajaxBankRemittance-bankBranchList.jsp"), @Result(name={"accountList"}, location="ajaxBankRemittance-accountList.jsp"), @Result(name={"userList"}, location="ajaxBankRemittance-userList.jsp"), @Result(name={"designationList"}, location="ajaxBankRemittance-designationList.jsp"), @Result(name={"serviceNameList"}, location="ajaxBankRemittance-serviceListOfAccount.jsp"), @Result(name={"bankAccountList"}, location="ajaxBankRemittance-bankAccountList.jsp")})
public class AjaxBankRemittanceAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    protected static final String BANKBRANCHLIST = "bankBranchList";
    protected static final String ACCOUNTLIST = "accountList";
    protected static final String BANKACCOUNTLIST = "bankAccountList";
    private String serviceName;
    private String fundName;
    protected static final String USERLIST = "userList";
    protected static final String DESIGNATIONLIST = "designationList";
    private Long designationId;
    private Long approverDeptId;
    private List<EmployeeView> postionUserList = new ArrayList(0);
    private final List<Designation> designationMasterList = new ArrayList(0);
    private CollectionsUtil collectionsUtil;
    protected static final String SERVICENAMELIST = "serviceNameList";
    @Autowired
    private BankBranchHibernateDAO bankBranchHibernateDAO;
    @Autowired
    private BankaccountHibernateDAO bankaccountHibernateDAO;
    private PersistenceService<ServiceDetails, Long> serviceDetailsService;
    private Integer fundId;
    private Integer branchId;
    private Integer bankAccountId;
    private Long serviceId;
    private Integer bankId;
    private List<Bankbranch> bankBranchArrayList = new ArrayList(0);
    private List<Bankaccount> bankAccountArrayList;
    private List<ServiceDetails> serviceNameList;

    @Action(value="/receipts/ajaxBankRemittance-bankBranchList")
    public String bankBranchList() {
        if (this.getFundId() != null) {
            Fund fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.fundId});
            if (fund == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("fund.not.found", "Fund information not available")));
            }
            this.setFundName(fund.getName());
        }
        if (this.serviceName == null && this.serviceId != null && this.serviceId != -1L) {
            ServiceDetails serviceDetails = (ServiceDetails)this.persistenceService.find("from ServiceDetails where id=?", new Object[]{this.serviceId});
            this.setServiceName(serviceDetails.getName());
        }
        String bankBranchQueryString = "select distinct(bb.id) as branchid,b.NAME||'-'||bb.BRANCHNAME as branchname from BANK b,BANKBRANCH bb, BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.bankaccount=ba.ID and asm.servicedetails=sd.ID and ba.BRANCHID=bb.ID and bb.BANKID=b.ID and fd.ID=ba.FUNDID and sd.NAME='" + this.serviceName + "' and fd.NAME='" + this.getFundName() + "'";
        SQLQuery bankBranchQuery = this.persistenceService.getSession().createSQLQuery(bankBranchQueryString);
        List queryResults = bankBranchQuery.list();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            Bankbranch newBankbranch = new Bankbranch();
            newBankbranch.setId(Integer.valueOf(arrayObjectInitialIndex[0].toString()));
            newBankbranch.setBranchname(arrayObjectInitialIndex[1].toString());
            this.bankBranchArrayList.add(newBankbranch);
        }
        return BANKBRANCHLIST;
    }

    @Action(value="/receipts/ajaxBankRemittance-bankBranchListOfService")
    public String bankBranchListOfService() {
        String bankBranchQueryString = this.collectionsUtil.isBankCollectionRemitter(this.collectionsUtil.getLoggedInUser()) != false ? "select distinct(bb.id) as branchid,b.NAME||'-'||bb.BRANCHNAME as branchname from BANK b,BANKBRANCH bb, BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd,EGCL_BRANCHUSER_MAP bu where asm.bankaccount=ba.ID and asm.servicedetails=sd.ID and ba.BRANCHID=bb.ID and bb.BANKID=b.ID and  bu.isActive=true and bb.id=bu.bankbranch and bu.bankuser=" + this.collectionsUtil.getLoggedInUser().getId() : "select distinct(bb.id) as branchid,b.NAME||'-'||bb.BRANCHNAME as branchname from BANK b,BANKBRANCH bb, BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.bankaccount=ba.ID and asm.servicedetails=sd.ID and ba.BRANCHID=bb.ID and bb.BANKID=b.ID";
        SQLQuery bankBranchQuery = this.persistenceService.getSession().createSQLQuery(bankBranchQueryString);
        List queryResults = bankBranchQuery.list();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            Bankbranch newBankbranch = new Bankbranch();
            newBankbranch.setId(Integer.valueOf(arrayObjectInitialIndex[0].toString()));
            newBankbranch.setBranchname(arrayObjectInitialIndex[1].toString());
            this.bankBranchArrayList.add(newBankbranch);
        }
        return BANKBRANCHLIST;
    }

    public Object getModel() {
        return null;
    }

    @Action(value="/receipts/ajaxBankRemittance-accountList")
    public String accountList() {
        if (this.fundId != null && this.fundId != -1) {
            Fund fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.fundId});
            if (fund == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("fund.not.found", "Fund information not available")));
            }
            this.setFundName(fund.getName());
        }
        if (this.serviceName == null && this.serviceId != null && this.serviceId != -1L) {
            ServiceDetails serviceDetails = (ServiceDetails)this.persistenceService.find("from ServiceDetails where id=?", new Object[]{this.serviceId});
            this.setServiceName(serviceDetails.getName());
        }
        String bankAccountQueryString = "select ba.id as accountid,ba.accountnumber as accountnumber from BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.BANKACCOUNT=ba.ID and asm.servicedetails=sd.ID and fd.ID=ba.FUNDID and ba.BRANCHID=" + this.branchId + " and sd.NAME='" + this.serviceName + "' and fd.NAME='" + this.fundName + "'";
        SQLQuery bankAccountQuery = this.persistenceService.getSession().createSQLQuery(bankAccountQueryString);
        List queryResults = bankAccountQuery.list();
        this.bankAccountArrayList = new ArrayList();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            Bankaccount newBankaccount = new Bankaccount();
            newBankaccount.setId(Long.valueOf(arrayObjectInitialIndex[0].toString()));
            newBankaccount.setAccountnumber(arrayObjectInitialIndex[1].toString());
            this.getBankAccountArrayList().add(newBankaccount);
        }
        return ACCOUNTLIST;
    }

    @Action(value="/receipts/ajaxBankRemittance-accountListOfService")
    public String accountListOfService() {
        String bankAccountQueryString = "select distinct ba.id as accountid,ba.accountnumber as accountnumber from BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.BANKACCOUNT=ba.ID and asm.servicedetails=sd.ID and fd.ID=ba.FUNDID and ba.BRANCHID=" + this.branchId;
        SQLQuery bankAccountQuery = this.persistenceService.getSession().createSQLQuery(bankAccountQueryString);
        List queryResults = bankAccountQuery.list();
        this.bankAccountArrayList = new ArrayList();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            Bankaccount newBankaccount = new Bankaccount();
            newBankaccount.setId(Long.valueOf(arrayObjectInitialIndex[0].toString()));
            newBankaccount.setAccountnumber(arrayObjectInitialIndex[1].toString());
            this.getBankAccountArrayList().add(newBankaccount);
        }
        return ACCOUNTLIST;
    }

    @Action(value="/receipts/ajaxBankRemittance-serviceListOfAccount")
    public String serviceListOfAccount() {
        String serviceAccountQueryString = "select sd.id as serviceid,sd.name as servicename from EGCL_SERVICEDETAILS sd,EGCL_BANKACCOUNTSERVICEMAPPING asm where sd.id=asm.servicedetails and asm.bankaccount=" + this.bankAccountId;
        SQLQuery serviceListQuery = this.persistenceService.getSession().createSQLQuery(serviceAccountQueryString);
        List queryResults = serviceListQuery.list();
        this.serviceNameList = new ArrayList();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            ServiceDetails newServiceNameList = new ServiceDetails();
            newServiceNameList.setId(Long.valueOf(arrayObjectInitialIndex[0].toString()));
            newServiceNameList.setName(arrayObjectInitialIndex[1].toString());
            this.getServiceNameList().add(newServiceNameList);
        }
        return SERVICENAMELIST;
    }

    @Action(value="/receipts/ajaxBankRemittance-positionUserList")
    public String positionUserList() {
        if (this.designationId != null && this.approverDeptId != null) {
            try {
                this.postionUserList = this.collectionsUtil.getPositionBySearchParameters(null, Integer.valueOf(this.designationId.intValue()), Integer.valueOf(this.approverDeptId.intValue()), null, null, new Date(), Integer.valueOf(0));
            }
            catch (NoSuchObjectException e) {
                throw new ApplicationRuntimeException("Designation Postion not found", (Throwable)e);
            }
        }
        return USERLIST;
    }

    @Action(value="/receipts/ajaxBankRemittance-serviceListNotMappedToAccount")
    public String serviceListNotMappedToAccount() {
        String serviceAccountQueryString = "select distinct sd from ServiceDetails sd where sd.isEnabled='true' and sd.serviceCategory.id=? ";
        Query serviceListQuery = this.persistenceService.getSession().createQuery("select distinct sd from ServiceDetails sd where sd.isEnabled='true' and sd.serviceCategory.id=? ");
        serviceListQuery.setParameter(0, (Object)this.serviceId);
        this.serviceNameList = serviceListQuery.list();
        return SERVICENAMELIST;
    }

    @Action(value="/receipts/ajaxBankRemittance-bankBranchsByBankForReceiptPayments")
    public String bankBranchsByBankForReceiptPayments() {
        this.bankBranchArrayList = this.bankBranchHibernateDAO.getAllBankBranchsByBankForReceiptPayments(this.bankId);
        return BANKBRANCHLIST;
    }

    @Action(value="/receipts/ajaxBankRemittance-bankAccountByBankBranch")
    public String bankAccountByBankBranch() {
        if (this.serviceId != -1L) {
            ServiceDetails sd = (ServiceDetails)this.serviceDetailsService.findById((Serializable)this.serviceId, false);
            this.fundId = sd.getFund().getId();
        }
        this.bankAccountArrayList = this.bankaccountHibernateDAO.getBankAccountByBankBranchForReceiptsPayments(this.branchId, this.fundId);
        return BANKACCOUNTLIST;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setBranchId(Integer branchId) {
        this.branchId = branchId;
    }

    public List getBankBranchArrayList() {
        return this.bankBranchArrayList;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Bankaccount> getBankAccountArrayList() {
        return this.bankAccountArrayList;
    }

    public List<ServiceDetails> getServiceNameList() {
        return this.serviceNameList;
    }

    public void setServiceNameList(List<ServiceDetails> serviceNameList) {
        this.serviceNameList = serviceNameList;
    }

    public String getFundName() {
        return this.fundName;
    }

    public void setFundName(String fundName) {
        this.fundName = fundName;
    }

    public Integer getFundId() {
        return this.fundId;
    }

    public void setFundId(Integer fundId) {
        this.fundId = fundId;
    }

    public void setDesignationId(Long designationId) {
        this.designationId = designationId;
    }

    public Long getApproverDeptId() {
        return this.approverDeptId;
    }

    public void setApproverDeptId(Long approverDeptId) {
        this.approverDeptId = approverDeptId;
    }

    public List<EmployeeView> getPostionUserList() {
        return this.postionUserList;
    }

    public List<Designation> getDesignationMasterList() {
        return this.designationMasterList;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Integer getBankAccountId() {
        return this.bankAccountId;
    }

    public void setBankAccountId(Integer bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Integer getBankId() {
        return this.bankId;
    }

    public void setBankId(Integer bankId) {
        this.bankId = bankId;
    }

    public void setServiceDetailsService(PersistenceService<ServiceDetails, Long> serviceDetailsService) {
        this.serviceDetailsService = serviceDetailsService;
    }
}

