/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.citizen;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.handler.BillInfoMarshaller;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.collection.integration.services.DebitAccountHeadDetailsService;
import org.egov.collection.service.CollectionService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="onlineReceipt-new.jsp"), @Result(name={"redirect"}, location="onlineReceipt-redirect.jsp"), @Result(name={"result"}, location="onlineReceipt-result.jsp"), @Result(name={"reconresult"}, location="onlineReceipt-reconresult.jsp"), @Result(name={"report"}, location="onlineReceipt-report.jsp")})
public class OnlineReceiptAction
extends BaseFormAction {
    public static final String REDIRECT = "redirect";
    protected static final String RESULT = "result";
    protected static final String RECONRESULT = "reconresult";
    private static final Logger LOGGER = Logger.getLogger(OnlineReceiptAction.class);
    private static final long serialVersionUID = 1L;
    private static final String BROKEN_TRANSACTION_ERROR_MESSAGE = "If the amount has been deducted from " + "your account, then no further action is required from you right now. Such transactions are normally " + "resolved within 24 hours so you can check and download the receipt then." + "\n \nIf the amount has not been deducted from your account, then please check your " + "internet connection and try to pay again after some time. If the transaction fails again, " + "please contact cell in Corporation.";
    private final List<ValidationError> errors = new ArrayList(0);
    private CollectionsUtil collectionsUtil;
    private ReceiptHeaderService receiptHeaderService;
    private CollectionService collectionService;
    private CollectionCommon collectionCommon;
    private BigDecimal onlineInstrumenttotal = BigDecimal.ZERO;
    private List<ReceiptDetail> receiptDetailList = new ArrayList(0);
    private BillInfoImpl collDetails = new BillInfoImpl();
    private String collectXML;
    private String serviceName;
    private List<String> collectionModesNotAllowed = new ArrayList(0);
    private Boolean overrideAccountHeads;
    private Boolean partPaymentAllowed;
    private BigDecimal totalAmountToBeCollected;
    private BigDecimal paymentAmount;
    private ReceiptHeader onlinePaymentReceiptHeader;
    private Long receiptId;
    private ReceiptHeader[] receipts;
    private Integer paymentServiceId = -1;
    private String reportId;
    private String serviceCode;
    private PaymentRequest paymentRequest;
    private PaymentResponse paymentResponse;
    private String responseMsg = "";
    private Boolean callbackForApportioning;
    private String receiptNumber;
    private String consumerCode;
    private String receiptResponse = "";
    private ReceiptHeader receiptHeader;
    private String refNumber;
    private List<ServiceDetails> serviceDetailsList = new ArrayList(0);
    @Autowired
    private FundHibernateDAO fundDAO;
    private List<OnlinePayment> lastThreeOnlinePayments = new ArrayList(0);
    private Boolean onlinePayPending = Boolean.FALSE;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private String[] transactionId;
    private Long[] selectedReceipts;
    private String[] transactionDate;
    private String[] statusCode;
    private String[] remarks;
    @Autowired
    private ApplicationContext beanProvider;

    public Object getModel() {
        return null;
    }

    @Action(value="/citizen/onlineReceipt-newform")
    public String newform() {
        return "new";
    }

    @Action(value="/citizen/onlineReceipt-saveNew")
    public String saveNew() {
        if (this.callbackForApportioning.booleanValue() && !this.overrideAccountHeads.booleanValue()) {
            this.apportionBillAmount();
        }
        ServiceDetails paymentService = null;
        if (null != this.paymentServiceId && this.paymentServiceId > 0) {
            paymentService = (ServiceDetails)this.getPersistenceService().findByNamedQuery("SERVICE_BY_ID", new Object[]{this.paymentServiceId.longValue()});
        }
        this.setPaymentRequest(this.collectionService.populateAndPersistReceipts(paymentService, this.receiptHeader, this.getReceiptDetailList(), this.paymentAmount, Character.valueOf('O')));
        return REDIRECT;
    }

    @ValidationErrorPage(value="result")
    @Action(value="/citizen/onlineReceipt-acceptMessageFromPaymentGateway")
    public String acceptMessageFromPaymentGateway() {
        System.currentTimeMillis();
        LOGGER.info((Object)("responseMsg:\t" + this.responseMsg));
        ServiceDetails paymentService = null != this.paymentServiceId && this.paymentServiceId > 0 ? (ServiceDetails)this.getPersistenceService().findByNamedQuery("SERVICE_BY_ID", new Object[]{this.paymentServiceId.longValue()}) : (ServiceDetails)this.getPersistenceService().findByNamedQuery("getServiceByCode", new Object[]{"BDPGI"});
        try {
            this.setPaymentResponse(this.collectionCommon.createPaymentResponse(paymentService, this.getMsg()));
        }
        catch (ApplicationRuntimeException egovEx) {
            LOGGER.error((Object)("acceptMessageFromPaymentGateway" + (Object)((Object)egovEx)));
            throw new ValidationException(Arrays.asList(new ValidationError(egovEx.getMessage(), egovEx.getMessage())));
        }
        this.onlinePaymentReceiptHeader = (ReceiptHeader)this.receiptHeaderService.findByNamedQuery("QUERY_RECEIPT_BY_ID_AND_CONSUMERCODE", new Object[]{Long.valueOf(this.paymentResponse.getReceiptId()), this.paymentResponse.getAdditionalInfo6()});
        if (this.onlinePaymentReceiptHeader != null) {
            if ("0300".equals(this.paymentResponse.getAuthStatus())) {
                this.processSuccessMsg();
            } else if (paymentService.getCode().equals("BDPGI") && "0002".equals(this.paymentResponse.getAuthStatus()) || paymentService.getCode().equals("ATOM") && CollectionConstants.ATOM_AUTHORISATION_CODES_WAITINGFOR_PAY_GATEWAY_RESPONSE.contains(this.paymentResponse.getAuthStatus())) {
                EgwStatus paymentStatus = this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_PENDING");
                this.onlinePaymentReceiptHeader.getOnlinePayment().setStatus(paymentStatus);
                this.onlinePaymentReceiptHeader.getOnlinePayment().setAuthorisationStatusCode(this.paymentResponse.getAuthStatus());
                this.onlinePaymentReceiptHeader.getOnlinePayment().setRemarks(this.paymentResponse.getErrorDescription());
            } else {
                this.processFailureMsg();
            }
        } else {
            this.errors.add(new ValidationError(BROKEN_TRANSACTION_ERROR_MESSAGE, BROKEN_TRANSACTION_ERROR_MESSAGE));
            LOGGER.info((Object)"onlinePaymentReceiptHeader object is null");
        }
        return RESULT;
    }

    private void processFailureMsg() {
        this.onlinePaymentReceiptHeader.setStatus(this.collectionsUtil.getReceiptStatusForCode("FAILED"));
        EgwStatus paymentStatus = this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_FAILURE");
        this.onlinePaymentReceiptHeader.getOnlinePayment().setStatus(paymentStatus);
        this.onlinePaymentReceiptHeader.getOnlinePayment().setAuthorisationStatusCode(this.paymentResponse.getAuthStatus());
        this.receiptHeaderService.persist(this.onlinePaymentReceiptHeader);
        LOGGER.debug((Object)"Cancelled receipt after receiving failure message from the payment gateway");
        this.addActionError(this.getText(this.onlinePaymentReceiptHeader.getOnlinePayment().getService().getCode().toLowerCase() + ".pgi." + this.onlinePaymentReceiptHeader.getService().getCode().toLowerCase() + "." + this.paymentResponse.getAuthStatus()));
        this.receiptResponse = "FAILURE|NA";
    }

    private void processSuccessMsg() {
        this.errors.clear();
        if (this.onlinePaymentReceiptHeader.getReceiptnumber() != null && this.onlinePaymentReceiptHeader.getReceiptnumber().length() > 0) {
            this.receiptResponse = "SUCCESS|" + this.onlinePaymentReceiptHeader.getReceiptnumber();
        } else {
            this.onlinePaymentReceiptHeader = this.receiptHeaderService.createOnlineSuccessPayment(this.onlinePaymentReceiptHeader, this.paymentResponse.getTxnDate(), this.paymentResponse.getTxnReferenceNo(), this.paymentResponse.getTxnAmount(), this.paymentResponse.getAuthStatus(), null, null);
            this.receiptResponse = "SUCCESS|" + this.onlinePaymentReceiptHeader.getReceiptnumber();
        }
    }

    @ValidationErrorPage(value="reconresult")
    @Action(value="/citizen/onlineReceipt-reconcileOnlinePayment")
    public String reconcileOnlinePayment() {
        ReceiptHeader[] receipts = new ReceiptHeader[this.selectedReceipts.length];
        Date transDate = null;
        this.errors.clear();
        for (int i = 0; i < this.getSelectedReceipts().length; ++i) {
            receipts[i] = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.selectedReceipts[i], false);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
            if (this.getTransactionDate()[i] != null) {
                String vdt = this.getTransactionDate()[i];
                try {
                    transDate = sdf.parse(vdt);
                }
                catch (ParseException e) {
                    LOGGER.debug((Object)("Error occured while parsing date " + e.getMessage()));
                }
            }
            if (this.getStatusCode()[i].equals("ONLINE_STATUS_SUCCESS")) {
                ArrayList<ReceiptDetail> existingReceiptDetails = new ArrayList<ReceiptDetail>(0);
                for (ReceiptDetail receiptDetail : receipts[i].getReceiptDetails()) {
                    if (FinancialsUtil.isRevenueAccountHead((CChartOfAccounts)receiptDetail.getAccounthead(), (List)this.chartOfAccountsHibernateDAO.getBankChartofAccountCodeList(), (PersistenceService)this.persistenceService)) continue;
                    ReceiptDetail newReceiptDetail = new ReceiptDetail();
                    if (receiptDetail.getOrdernumber() != null) {
                        newReceiptDetail.setOrdernumber(receiptDetail.getOrdernumber());
                    }
                    if (receiptDetail.getDescription() != null) {
                        newReceiptDetail.setDescription(receiptDetail.getDescription());
                    }
                    if (receiptDetail.getIsActualDemand() != null) {
                        newReceiptDetail.setIsActualDemand(receiptDetail.getIsActualDemand());
                    }
                    if (receiptDetail.getFunction() != null) {
                        newReceiptDetail.setFunction(receiptDetail.getFunction());
                    }
                    if (receiptDetail.getCramountToBePaid() != null) {
                        newReceiptDetail.setCramountToBePaid(receiptDetail.getCramountToBePaid());
                    }
                    newReceiptDetail.setCramount(receiptDetail.getCramount());
                    newReceiptDetail.setAccounthead(receiptDetail.getAccounthead());
                    newReceiptDetail.setDramount(receiptDetail.getDramount());
                    existingReceiptDetails.add(newReceiptDetail);
                }
                List reconstructedList = this.collectionsUtil.reconstructReceiptDetail(receipts[i], existingReceiptDetails);
                ReceiptDetail debitAccountDetail = null;
                if (reconstructedList != null) {
                    DebitAccountHeadDetailsService debitAccountHeadService = (DebitAccountHeadDetailsService)this.beanProvider.getBean(this.collectionsUtil.getBeanNameForDebitAccountHead());
                    debitAccountDetail = debitAccountHeadService.addDebitAccountHeadDetails(receipts[i].getTotalAmount(), receipts[i], BigDecimal.ZERO, receipts[i].getTotalAmount(), "online");
                }
                this.receiptHeaderService.reconcileOnlineSuccessPayment(receipts[i], transDate, this.getTransactionId()[i], receipts[i].getTotalAmount(), null, reconstructedList, debitAccountDetail);
                LOGGER.debug((Object)"Manually reconciled a success online payment");
            }
            if (!"TO_BE_REFUNDED".equals(this.getStatusCode()[i]) && !"ONLINE_STATUS_REFUNDED".equals(this.getStatusCode()[i])) continue;
            receipts[i].setStatus(this.collectionsUtil.getReceiptStatusForCode("FAILED"));
            receipts[i].getOnlinePayment().setTransactionNumber(this.getTransactionId()[i]);
            receipts[i].getOnlinePayment().setTransactionAmount(receipts[i].getTotalAmount());
            receipts[i].getOnlinePayment().setTransactionDate(transDate);
            receipts[i].getOnlinePayment().setRemarks(this.getRemarks()[i]);
            if (this.getStatusCode()[i].equals("TO_BE_REFUNDED")) {
                receipts[i].getOnlinePayment().setStatus(this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "TO_BE_REFUNDED"));
            } else {
                receipts[i].getOnlinePayment().setStatus(this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_REFUNDED"));
            }
            this.receiptHeaderService.persist(receipts[i]);
            LOGGER.debug((Object)("Manually reconciled an online payment to " + this.getStatusCode()[i] + " state."));
        }
        return RECONRESULT;
    }

    @Action(value="/citizen/onlineReceipt-view")
    public String view() {
        this.setReceipts(new ReceiptHeader[1]);
        this.receipts[0] = (ReceiptHeader)this.receiptHeaderService.findById((Serializable)this.getReceiptId(), false);
        try {
            this.reportId = this.collectionCommon.generateReport(this.receipts, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error during report generation!", (Throwable)e);
            throw new ApplicationRuntimeException("Error during report generation!", (Throwable)e);
        }
        return "report";
    }

    @Action(value="/citizen/onlineReceipt-viewReceipt")
    public String viewReceipt() {
        LOGGER.debug((Object)("::VIEWRECEIPT API::: Receipt Number=" + this.getReceiptNumber() + ", Consumer Code=" + this.getConsumerCode()));
        ReceiptHeader receiptHead = (ReceiptHeader)this.getPersistenceService().findByNamedQuery("RECEIPT_BY_SERVICE_RECEIPTNUMBER_CONSUMERCODE", new Object[]{this.getReceiptNumber(), this.getReceiptNumber(), this.getConsumerCode()});
        if (receiptHead != null) {
            this.setReceiptId(receiptHead.getId());
            return this.view();
        }
        throw new ValidationException(Arrays.asList(new ValidationError("No Receipt Data Found", "No Receipt Data Found")));
    }

    public void prepare() {
        super.prepare();
        if (StringUtils.isNotBlank((CharSequence)this.getCollectXML())) {
            String decodedCollectXml = this.decodeBillXML();
            try {
                Department dept;
                this.collDetails = BillInfoMarshaller.toObject((String)decodedCollectXml);
                Fund fund = this.fundDAO.fundByCode(this.collDetails.getFundCode());
                if (fund == null) {
                    this.addActionError(this.getText("billreceipt.improperbilldata.missingfund"));
                }
                if ((dept = (Department)this.getPersistenceService().findByNamedQuery("getDepartmentByCode", new Object[]{this.collDetails.getDepartmentCode()})) == null) {
                    this.addActionError(this.getText("billreceipt.improperbilldata.missingdepartment"));
                }
                ServiceDetails service = (ServiceDetails)this.getPersistenceService().findByNamedQuery("getServiceByCode", new Object[]{this.collDetails.getServiceCode()});
                this.setServiceName(service.getName());
                this.setCollectionModesNotAllowed(this.collDetails.getCollectionModesNotAllowed());
                this.setOverrideAccountHeads(this.collDetails.getOverrideAccountHeadsAllowed());
                this.setPartPaymentAllowed(this.collDetails.getPartPaymentAllowed());
                this.setCallbackForApportioning(this.collDetails.getCallbackForApportioning());
                this.totalAmountToBeCollected = BigDecimal.valueOf(0L);
                this.receiptHeader = this.collectionCommon.initialiseReceiptModelWithBillInfo((BillInfo)this.collDetails, fund, dept);
                this.setRefNumber(this.receiptHeader.getReferencenumber());
                this.totalAmountToBeCollected = this.totalAmountToBeCollected.add(this.receiptHeader.getTotalAmountToBeCollected());
                for (ReceiptDetail rDetails : this.receiptHeader.getReceiptDetails()) {
                    rDetails.getCramountToBePaid().setScale(2, 0);
                }
                this.setReceiptDetailList(new ArrayList(this.receiptHeader.getReceiptDetails()));
                if (this.totalAmountToBeCollected.compareTo(BigDecimal.ZERO) == -1) {
                    this.addActionError(this.getText("billreceipt.totalamountlessthanzero.error"));
                    LOGGER.info((Object)this.getText("billreceipt.totalamountlessthanzero.error"));
                } else {
                    this.setTotalAmountToBeCollected(this.totalAmountToBeCollected.setScale(2, 0));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)(this.getText("billreceipt.error.improperbilldata") + e));
                this.addActionError(this.getText("billreceipt.error.improperbilldata"));
            }
        }
        this.addDropdownData("paymentServiceList", this.getPersistenceService().findAllByNamedQuery("getServicesByType", new Object[]{"P"}));
        this.constructServiceDetailsList();
        if (null != this.consumerCode && !"".equals(this.consumerCode)) {
            this.lastThreeOnlinePayments = this.collectionsUtil.getOnlineTransactionHistory(this.consumerCode);
        }
        for (OnlinePayment onlinePay : this.lastThreeOnlinePayments) {
            if (!onlinePay.getStatus().getCode().equals("ONLINE_STATUS_PENDING")) continue;
            this.onlinePayPending = Boolean.TRUE;
        }
    }

    private String decodeBillXML() {
        String decodedBillXml = "";
        try {
            decodedBillXml = URLDecoder.decode(this.getCollectXML(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"decodeBillXML", (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return decodedBillXml;
    }

    private void constructServiceDetailsList() {
        List appConfigValuesList = this.collectionsUtil.getAppConfigValues("Collection", "BILLINGSERVICEPAYMENTGATEWAY");
        for (AppConfigValues appConfigVal : appConfigValuesList) {
            String value = appConfigVal.getValue();
            String attr = value.substring(0, value.indexOf(124));
            if (!attr.equalsIgnoreCase(this.collDetails.getServiceCode())) continue;
            String attrVal = value.substring(value.indexOf(124) + 1);
            ArrayList<String> serviceCodes = new ArrayList<String>(0);
            for (String code : attrVal.split(",")) {
                serviceCodes.add(code);
            }
            this.serviceDetailsList = this.getPersistenceService().findAllByNamedQuery("getActiveServiceByCodes", new Object[]{"P", serviceCodes});
        }
        if (this.serviceDetailsList.isEmpty()) {
            this.serviceDetailsList = this.getPersistenceService().findAllByNamedQuery("getActiveServiceByType", new Object[]{"P"});
        }
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public String[] getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String[] remarks) {
        this.remarks = remarks;
    }

    public String[] getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(String[] transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String[] getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String[] transactionId) {
        this.transactionId = transactionId;
    }

    public Long[] getSelectedReceipts() {
        return this.selectedReceipts;
    }

    public void setSelectedReceipts(Long[] selectedReceipts) {
        this.selectedReceipts = selectedReceipts;
    }

    public String[] getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String[] statusCode) {
        this.statusCode = statusCode;
    }

    public String getReportId() {
        return this.reportId;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public Long getReceiptId() {
        return this.receiptId;
    }

    public void setReceiptId(Long receiptId) {
        this.receiptId = receiptId;
    }

    public ReceiptHeader[] getReceipts() {
        return this.receipts;
    }

    public void setReceipts(ReceiptHeader[] receipts) {
        this.receipts = receipts;
    }

    public Integer getTotalNoOfAccounts() {
        return this.receiptHeader.getReceiptDetails().size();
    }

    public BigDecimal getTotalAmountToBeCollected() {
        return this.totalAmountToBeCollected;
    }

    public void setTotalAmountToBeCollected(BigDecimal totalAmountToBeCollected) {
        this.totalAmountToBeCollected = totalAmountToBeCollected;
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public PaymentRequest getPaymentRequest() {
        return this.paymentRequest;
    }

    public void setPaymentRequest(PaymentRequest paymentRequest) {
        this.paymentRequest = paymentRequest;
    }

    public PaymentResponse getPaymentResponse() {
        return this.paymentResponse;
    }

    public void setPaymentResponse(PaymentResponse paymentResponse) {
        this.paymentResponse = paymentResponse;
    }

    public Integer getPaymentServiceId() {
        return this.paymentServiceId;
    }

    public void setPaymentServiceId(Integer paymentServiceId) {
        this.paymentServiceId = paymentServiceId;
    }

    public String getMsg() {
        if (this.responseMsg != null && this.responseMsg == "") {
            HttpServletRequest httpRequest = ServletActionContext.getRequest();
            Enumeration paramNames = httpRequest.getParameterNames();
            HashMap<String, String> responseMap = new HashMap<String, String>(0);
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String paramValue = httpRequest.getParameter(paramName);
                if (null == paramValue || "".equals(paramValue)) continue;
                responseMap.put(paramName, paramValue);
            }
            this.responseMsg = ((Object)responseMap).toString();
        }
        LOGGER.debug((Object)("responseMsg::::::" + this.responseMsg));
        return this.responseMsg;
    }

    public void setMsg(String successMsg) {
        this.responseMsg = successMsg;
    }

    public ReceiptHeader getOnlinePaymentReceiptHeader() {
        return this.onlinePaymentReceiptHeader;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<String> getCollectionModesNotAllowed() {
        return this.collectionModesNotAllowed;
    }

    public void setCollectionModesNotAllowed(List<String> collectionModesNotAllowed) {
        this.collectionModesNotAllowed = collectionModesNotAllowed;
    }

    public Boolean getOverrideAccountHeads() {
        return this.overrideAccountHeads;
    }

    public void setOverrideAccountHeads(Boolean overrideAccountHeads) {
        this.overrideAccountHeads = overrideAccountHeads;
    }

    public Boolean getPartPaymentAllowed() {
        return this.partPaymentAllowed;
    }

    public void setPartPaymentAllowed(Boolean partPaymentAllowed) {
        this.partPaymentAllowed = partPaymentAllowed;
    }

    public String getCollectXML() {
        return this.collectXML;
    }

    public void setCollectXML(String collectXML) {
        this.collectXML = collectXML;
    }

    public List<ReceiptDetail> getReceiptDetailList() {
        return this.receiptDetailList;
    }

    public void setReceiptDetailList(List<ReceiptDetail> receiptDetailList) {
        this.receiptDetailList = receiptDetailList;
    }

    public BigDecimal getOnlineInstrumenttotal() {
        return this.onlineInstrumenttotal;
    }

    public void setOnlineInstrumenttotal(BigDecimal onlineInstrumenttotal) {
        this.onlineInstrumenttotal = onlineInstrumenttotal;
    }

    private void apportionBillAmount() {
        this.receiptDetailList = this.collectionCommon.apportionBillAmount(this.paymentAmount, (ArrayList)this.getReceiptDetailList());
    }

    public Boolean getCallbackForApportioning() {
        return this.callbackForApportioning;
    }

    public void setCallbackForApportioning(Boolean callbackForApportioning) {
        this.callbackForApportioning = callbackForApportioning;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getReceiptResponse() {
        return this.receiptResponse;
    }

    public void setReceiptResponse(String receiptResponse) {
        this.receiptResponse = receiptResponse;
    }

    public List<ServiceDetails> getServiceDetailsList() {
        return this.serviceDetailsList;
    }

    public void setServiceDetailsList(List<ServiceDetails> serviceDetailsList) {
        this.serviceDetailsList = serviceDetailsList;
    }

    public String getRefNumber() {
        return this.refNumber;
    }

    public void setRefNumber(String refNumber) {
        this.refNumber = refNumber;
    }

    public List<OnlinePayment> getLastThreeOnlinePayments() {
        return this.lastThreeOnlinePayments;
    }

    public void setLastThreeOnlinePayments(List<OnlinePayment> lastThreeOnlinePayments) {
        this.lastThreeOnlinePayments = lastThreeOnlinePayments;
    }

    public Boolean getOnlinePayPending() {
        return this.onlinePayPending;
    }

    public void setOnlinePayPending(Boolean onlinePayPending) {
        this.onlinePayPending = onlinePayPending;
    }

    public void setCollectionService(CollectionService collectionService) {
        this.collectionService = collectionService;
    }
}

