/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.controller.dashboard;

import java.io.IOException;
import java.util.List;
import org.egov.collection.bean.dashboard.CollectionDashBoardRequest;
import org.egov.collection.bean.dashboard.TaxPayerDashBoardResponseDetails;
import org.egov.collection.bean.dashboard.TotalCollectionDashBoardStats;
import org.egov.collection.bean.dashboard.TotalCollectionStatistics;
import org.egov.collection.service.dashboard.CollectionDashboardService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/dashboard", "/dashboard"})
public class CollectionDashboardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionDashboardController.class);
    @Autowired
    private CollectionDashboardService collectionDashboardService;
    private static final String MILLISECS = " (millisecs) ";
    private static final String ULBGRADE = " ulbGrade ";
    private static final String DISTRICTNAME = " districtName ";
    private static final String ULBCODE = " ulbCode ";
    private static final String FROMDATE = " fromDate ";
    private static final String TODATE = " toDate ";
    private static final String TYPE = "  type ";

    @RequestMapping(value={"/otherrevenuecollectionstats"}, method={RequestMethod.POST}, produces={"application/json"})
    public TotalCollectionDashBoardStats getConsolidatedCollDetails(@RequestBody CollectionDashBoardRequest collectionDashBoardRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        TotalCollectionDashBoardStats consolidatedCollectionDetails = this.collectionDashboardService.getTotalCollectionStats(collectionDashBoardRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve collectionstats is : " + timeTaken + MILLISECS);
        }
        return consolidatedCollectionDetails;
    }

    @RequestMapping(value={"/otherrevenuecollectiondashboard"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<TotalCollectionStatistics> getCollectionDetails(@RequestBody CollectionDashBoardRequest collectionDashBoardRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDashBoardRequest input for otherrevenuecollectiondashboard : regionName = " + collectionDashBoardRequest.getRegionName() + "," + DISTRICTNAME + " = " + collectionDashBoardRequest.getDistrictName() + "," + ULBGRADE + "= " + collectionDashBoardRequest.getUlbGrade() + "," + ULBCODE + "= " + collectionDashBoardRequest.getUlbCode() + "," + FROMDATE + "= " + collectionDashBoardRequest.getFromDate() + "," + TODATE + "= " + collectionDashBoardRequest.getToDate() + "," + TYPE + "= " + collectionDashBoardRequest.getType());
        }
        List collectionDetails = this.collectionDashboardService.getCollectionIndexDetails(collectionDashBoardRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve collectiondashboard is : " + timeTaken + MILLISECS);
        }
        return collectionDetails;
    }

    @RequestMapping(value={"/otherrevenuetoptencollection"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<TaxPayerDashBoardResponseDetails> getTopTenTaxProducers(@RequestBody CollectionDashBoardRequest collectionDashBoardRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDashBoardRequest input for otherrevenuetoptencollection : regionName = " + collectionDashBoardRequest.getRegionName() + "," + DISTRICTNAME + " = " + collectionDashBoardRequest.getDistrictName() + "," + ULBGRADE + "= " + collectionDashBoardRequest.getUlbGrade() + "," + ULBCODE + "= " + collectionDashBoardRequest.getUlbCode() + "," + FROMDATE + "= " + collectionDashBoardRequest.getFromDate() + "," + TODATE + "= " + collectionDashBoardRequest.getToDate() + "," + TYPE + "= " + collectionDashBoardRequest.getType());
        }
        List taxPayerDetails = this.collectionDashboardService.getTopTenTaxProducers(collectionDashBoardRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve toptentaxers is : " + timeTaken + MILLISECS);
        }
        return taxPayerDetails;
    }

    @RequestMapping(value={"/otherrevenuebottomtencollection"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<TaxPayerDashBoardResponseDetails> getBottomTenTaxProducers(@RequestBody CollectionDashBoardRequest collectionDashBoardRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDashBoardRequest input for otherrevenuebottomtencollection : regionName = " + collectionDashBoardRequest.getRegionName() + "," + DISTRICTNAME + " = " + collectionDashBoardRequest.getDistrictName() + "," + ULBGRADE + "= " + collectionDashBoardRequest.getUlbGrade() + "," + ULBCODE + "= " + collectionDashBoardRequest.getUlbCode() + "," + FROMDATE + "= " + collectionDashBoardRequest.getFromDate() + "," + TODATE + "= " + collectionDashBoardRequest.getToDate() + "," + TYPE + "= " + collectionDashBoardRequest.getType());
        }
        List taxPayerDetails = this.collectionDashboardService.getBottomTenTaxProducers(collectionDashBoardRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve bottomtentaxers is : " + timeTaken + MILLISECS);
        }
        return taxPayerDetails;
    }
}

