/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.citizen.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.collection.entity.OnlinePaymentResult;
import org.egov.collection.service.CollectionReportService;
import org.egov.collection.web.actions.citizen.reports.OnlinePaymentResultAdaptor;
import org.egov.infra.utils.JsonUtils;
import org.hibernate.SQLQuery;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OnlinePaymentReportController {
    @Autowired
    private CollectionReportService reportService;

    @ModelAttribute
    public void getPropertyModel(Model model) {
        OnlinePaymentResult OnlinePaymentResult2 = new OnlinePaymentResult();
        model.addAttribute("onlinePaymentResult", (Object)OnlinePaymentResult2);
    }

    @ModelAttribute(value="districtname")
    public List getDistrictnames() {
        return this.reportService.getDistrictNames();
    }

    @RequestMapping(value={"/citizen/onlinePaymentReport"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("fromdate", (Object)new Date());
        model.addAttribute("todate", (Object)new Date());
        return "onlinePaymentReport-form";
    }

    @RequestMapping(value={"/citizen/onlinePaymentReport/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void springPaginationDataTablesUpdate(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        String districtname = request.getParameter("districtname");
        String ulbname = request.getParameter("ulbname");
        String fromdate = request.getParameter("fromdate");
        String todate = request.getParameter("todate");
        String transid = request.getParameter("transid");
        SQLQuery query = this.reportService.getOnlinePaymentReportData(districtname, ulbname, fromdate, todate, transid);
        List onlinePaymentList = query.list();
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)onlinePaymentList, OnlinePaymentResult.class, OnlinePaymentResultAdaptor.class) + "}";
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    @RequestMapping(value={"/citizen/getUlbNamesByDistrict"}, method={RequestMethod.GET})
    @ResponseBody
    public void getUlbNamesByDistrict(@RequestParam String districtname, HttpServletResponse response) throws IOException {
        List ulbnames = new ArrayList();
        ulbnames = this.reportService.getUlbNames(districtname);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("ulbname", ulbnames);
        jsonObjects.add(jsonObj);
        IOUtils.write((String)((Object)jsonObjects).toString(), (Writer)response.getWriter());
    }
}

