/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.Fund;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.models.ServiceAccountDetails;
import org.egov.infstr.models.ServiceCategory;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.models.ServiceSubledgerInfo;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="serviceDetails-new.jsp"), @Result(name={"list"}, location="serviceDetails-list.jsp"), @Result(name={"beforeCreate"}, location="serviceDetails-beforeCreate.jsp"), @Result(name={"codeUniqueCheck"}, location="serviceDetails-codeUniqueCheck.jsp"), @Result(name={"message"}, location="serviceDetails-message.jsp"), @Result(name={"view"}, location="serviceDetails-view.jsp"), @Result(name={"SUCCESS"}, location="serviceDetails-view.jsp"), @Result(name={"beforeModify"}, location="serviceDetails-beforeModify.jsp")})
public class ServiceDetailsAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(ServiceDetailsAction.class);
    private static final long serialVersionUID = 1L;
    private PersistenceService<ServiceCategory, Long> serviceCategoryService;
    private PersistenceService<ServiceDetails, Long> serviceDetailsService;
    private ServiceDetails serviceDetails = new ServiceDetails();
    protected static final String BEFORECREATE = "beforeCreate";
    protected static final String BEFOREMODIFY = "beforeModify";
    protected static final String MESSAGE = "message";
    private List<ServiceAccountDetails> accountDetails = new ArrayList(0);
    private List<ServiceSubledgerInfo> subledgerDetails = new ArrayList(0);
    private List<Long> departmentList = new ArrayList();
    private List<ServiceDetails> serviceList;
    private Boolean isVoucherApproved = Boolean.FALSE;
    @Autowired
    private DepartmentService departmentService;
    private Long serviceCategoryId;
    protected List<String> headerFields;
    protected List<String> mandatoryFields;
    @Autowired
    private CollectionsUtil collectionsUtil;
    @Autowired
    private FunctionHibernateDAO functionDAO;
    @Autowired
    private ChartOfAccountsDAO chartOfAccountsDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private SortedMap<String, String> serviceTypeMap = new TreeMap();
    private String deptId;
    private EgovCommon egovCommon;

    public ServiceDetailsAction() {
        this.addRelatedEntity("serviceCategory", ServiceCategory.class);
        this.addRelatedEntity("fund", Fund.class);
        this.addRelatedEntity("function", CFunction.class);
    }

    public ServiceDetails getModel() {
        return this.serviceDetails;
    }

    @Action(value="/service/serviceDetails-newform")
    public String newform() {
        this.addDropdownData("serviceCategoryList", this.serviceCategoryService.findAllByNamedQuery("ACTIVE_SERVICE_CATEGORY", new Object[0]));
        return "new";
    }

    @Action(value="/service/serviceDetails")
    public String execute() {
        return "success";
    }

    public void prepare() {
        super.prepare();
        if (null != this.parameters.get("serviceId") && StringUtils.isNotEmpty((String)((String[])this.parameters.get("serviceId"))[0])) {
            this.serviceDetails = (ServiceDetails)this.serviceDetailsService.findById((Serializable)Long.valueOf(((String[])this.parameters.get("serviceId"))[0]), false);
            this.accountDetails.addAll(this.serviceDetails.getServiceAccountDtls());
            for (ServiceAccountDetails account : this.serviceDetails.getServiceAccountDtls()) {
                this.subledgerDetails.addAll(account.getSubledgerDetails());
            }
            for (ServiceSubledgerInfo serviceSubledgerInfo : this.subledgerDetails) {
                if (serviceSubledgerInfo.getDetailType() == null || serviceSubledgerInfo.getDetailKeyId() == null) continue;
                EntityType entityType = null;
                try {
                    entityType = this.egovCommon.getEntityType(serviceSubledgerInfo.getDetailType(), (Serializable)serviceSubledgerInfo.getDetailKeyId());
                }
                catch (ApplicationException e) {
                    LOGGER.error((Object)"Exception while setting subledger details", (Throwable)e);
                    throw new ApplicationRuntimeException("Exception while setting subledger details", (Throwable)e);
                }
                if (entityType == null) continue;
                serviceSubledgerInfo.setDetailCode(entityType.getCode());
                serviceSubledgerInfo.setDetailKey(entityType.getName());
            }
            for (Department department : this.serviceDetails.getServiceDept()) {
                this.departmentList.add(department.getId());
                this.setDeptId(department.getId().toString());
            }
        } else if (null != this.serviceDetails.getServiceCategory() && null != this.serviceDetails.getServiceCategory().getCode()) {
            ServiceCategory category = (ServiceCategory)this.serviceCategoryService.findById((Serializable)this.serviceDetails.getServiceCategory().getId(), false);
            this.setServiceCategoryId(this.serviceDetails.getServiceCategory().getId());
            this.serviceDetails.setServiceCategory(category);
        } else if (null != this.serviceCategoryId) {
            ServiceCategory category = (ServiceCategory)this.serviceCategoryService.findById((Serializable)this.serviceCategoryId, false);
            this.serviceDetails.setServiceCategory(category);
        }
        this.headerFields = new ArrayList(0);
        this.mandatoryFields = new ArrayList(0);
        this.getHeaderMandateFields();
        this.setupDropdownDataExcluding(new String[0]);
        if (this.headerFields.contains("department")) {
            this.addDropdownData("departmentList", this.persistenceService.findAllByNamedQuery("getAllDepartment", new Object[0]));
        }
        if (this.headerFields.contains("functionary")) {
            this.addDropdownData("functionaryList", this.persistenceService.findAllByNamedQuery("getAllFunctionary", new Object[0]));
        }
        if (this.headerFields.contains("fund")) {
            this.addDropdownData("fundList", this.collectionsUtil.getAllFunds());
        }
        if (this.headerFields.contains("function")) {
            this.addDropdownData("functionList", this.functionDAO.getAllActiveFunctions());
        }
        if (this.headerFields.contains("field")) {
            this.addDropdownData("fieldList", this.persistenceService.findAllByNamedQuery("getAllField", new Object[0]));
        }
        if (this.headerFields.contains("fundsource")) {
            this.addDropdownData("fundsourceList", this.persistenceService.findAllByNamedQuery("getAllFundsource", new Object[0]));
        }
        this.serviceTypeMap.putAll(CollectionConstants.SERVICE_TYPE_CLASSIFICATION);
        this.serviceTypeMap.remove("P");
        this.serviceTypeMap.remove("B");
        this.setHeaderFields(this.headerFields);
        this.setMandatoryFields(this.mandatoryFields);
    }

    @Action(value="/service/serviceDetails-beforeCreate")
    public String beforeCreate() {
        this.accountDetails.add(new ServiceAccountDetails());
        this.subledgerDetails.add(new ServiceSubledgerInfo());
        return BEFORECREATE;
    }

    @ValidationErrorPage(value="beforeCreate")
    @Action(value="/service/serviceDetails-create")
    public String create() {
        this.insertOrUpdateService();
        if (this.hasActionErrors()) {
            return BEFORECREATE;
        }
        return MESSAGE;
    }

    @Action(value="/service/serviceDetails-listServices")
    public String listServices() {
        return "list";
    }

    @Action(value="/service/serviceDetails-view")
    public String view() {
        this.serviceTypeMap.putAll(CollectionConstants.SERVICE_TYPE_CLASSIFICATION);
        return "view";
    }

    @ValidationErrorPage(value="beforeModify")
    @Action(value="/service/serviceDetails-beforeModify")
    public String beforeModify() {
        if (null == this.accountDetails || this.accountDetails.isEmpty()) {
            this.accountDetails.add(new ServiceAccountDetails());
        }
        if (null == this.subledgerDetails || this.subledgerDetails.isEmpty()) {
            this.subledgerDetails.add(new ServiceSubledgerInfo());
        }
        this.serviceTypeMap.putAll(CollectionConstants.SERVICE_TYPE_CLASSIFICATION);
        if (this.serviceDetails.getServiceType().equals("C") || this.serviceDetails.getServiceType().equals("M")) {
            this.serviceTypeMap.remove("P");
            this.serviceTypeMap.remove("B");
        }
        return BEFOREMODIFY;
    }

    @ValidationErrorPage(value="beforeModify")
    @Action(value="/service/serviceDetails-modify")
    public String modify() {
        List accountList = this.getPersistenceService().getSession().createCriteria(ServiceAccountDetails.class).add((Criterion)Restrictions.eq((String)"serviceDetails.id", (Object)this.serviceDetails.getId())).list();
        for (ServiceAccountDetails serviceAccountDetails : accountList) {
            Query qry = this.getPersistenceService().getSession().createQuery("delete from ServiceSubledgerInfo where serviceAccountDetail.id=:accountId");
            qry.setLong("accountId", serviceAccountDetails.getId().longValue());
            qry.executeUpdate();
        }
        Query qry = this.getPersistenceService().getSession().createQuery("delete from ServiceAccountDetails where serviceDetails.id=:serviceId");
        qry.setLong("serviceId", this.serviceDetails.getId().longValue());
        qry.executeUpdate();
        this.insertOrUpdateService();
        if (this.hasActionErrors()) {
            return BEFOREMODIFY;
        }
        return MESSAGE;
    }

    private void insertOrUpdateService() {
        this.removeEmptyRowsAccoutDetail(this.accountDetails);
        this.removeEmptyRowsSubledger(this.subledgerDetails);
        if (this.validateAccountDetails()) {
            this.formatServiceDetails();
            if (this.serviceDetails.getVoucherCreation().equals(Boolean.TRUE)) {
                this.isVoucherApproved = this.serviceDetails.getIsVoucherApproved();
                this.serviceDetails.setIsVoucherApproved(this.isVoucherApproved);
            }
            this.serviceDetailsService.getSession().flush();
            this.serviceDetailsService.persist((Object)this.serviceDetails);
            this.addActionMessage(this.getText("service.create.success.msg", new String[]{this.getModel().getCode(), this.getModel().getName()}));
        }
        if (this.subledgerDetails.isEmpty()) {
            this.subledgerDetails.add(new ServiceSubledgerInfo());
        }
        if (this.accountDetails.isEmpty()) {
            this.accountDetails.add(new ServiceAccountDetails());
        }
    }

    private void formatServiceDetails() {
        for (Long departId : this.departmentList) {
            Department dept = this.departmentService.getDepartmentById(departId);
            this.serviceDetails.addServiceDept(dept);
        }
        for (ServiceAccountDetails account : this.accountDetails) {
            ServiceAccountDetails serviceAccount = new ServiceAccountDetails();
            serviceAccount.setAmount(account.getAmount());
            CChartOfAccounts glCodeId = this.chartOfAccountsDAO.findById((Number)account.getGlCodeId().getId(), false);
            serviceAccount.setGlCodeId(glCodeId);
            serviceAccount.setServiceDetails(this.serviceDetails);
            for (ServiceSubledgerInfo subledger : this.subledgerDetails) {
                if (!subledger.getServiceAccountDetail().getGlCodeId().getId().equals(account.getGlCodeId().getId())) continue;
                ServiceSubledgerInfo subledgerInfo = new ServiceSubledgerInfo();
                Accountdetailtype accdetailtype = (Accountdetailtype)this.getPersistenceService().findByNamedQuery("getAccountDetailtypeById", new Object[]{subledger.getDetailType().getId()});
                subledgerInfo.setDetailType(accdetailtype);
                subledgerInfo.setDetailKeyId(subledger.getDetailKeyId());
                subledgerInfo.setAmount(subledger.getAmount());
                subledgerInfo.setServiceAccountDetail(serviceAccount);
                serviceAccount.addSubledgerDetails(subledgerInfo);
            }
            this.serviceDetails.addServiceAccountDtls(serviceAccount);
        }
    }

    private void removeEmptyRowsAccoutDetail(List<ServiceAccountDetails> list) {
        Iterator<ServiceAccountDetails> detail = list.iterator();
        while (detail.hasNext()) {
            ServiceAccountDetails next = detail.next();
            if (null != next && (null == next.getGlCodeId() || null == next.getGlCodeId().getId() || next.getGlCodeId().getId().toString().trim().isEmpty()) && next.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                detail.remove();
                continue;
            }
            if (null != next) continue;
            detail.remove();
        }
    }

    protected void removeEmptyRowsSubledger(List<ServiceSubledgerInfo> list) {
        Iterator<ServiceSubledgerInfo> detail = list.iterator();
        while (detail.hasNext()) {
            ServiceSubledgerInfo next = detail.next();
            if (null != next && (null == next.getServiceAccountDetail() || null == next.getServiceAccountDetail().getGlCodeId() || null == next.getServiceAccountDetail().getGlCodeId().getId() || next.getServiceAccountDetail().getGlCodeId().getId() == 0L || next.getServiceAccountDetail().getGlCodeId().getId() == -1L)) {
                detail.remove();
                continue;
            }
            if (null != next) continue;
            detail.remove();
        }
    }

    private boolean validateAccountDetails() {
        int index = 0;
        for (ServiceAccountDetails account : this.accountDetails) {
            if (account.getAmount().compareTo(BigDecimal.ZERO) <= 0 || null != account.getGlCodeId() && null != account.getGlCodeId().getId()) continue;
            this.addActionError(this.getText("service.accdetail.accmissing", new String[]{"" + ++index}));
            return Boolean.FALSE;
        }
        return this.validateSubledger();
    }

    private boolean validateSubledger() {
        HashMap<String, BigDecimal> accountDetailAmount = new HashMap<String, BigDecimal>(0);
        for (ServiceAccountDetails account : this.accountDetails) {
            Set set = this.chartOfAccountsHibernateDAO.getCChartOfAccountsByGlCode(account.getGlCodeId().getGlcode()).getChartOfAccountDetails();
            if (null == set || set.isEmpty()) continue;
            accountDetailAmount.put(account.getGlCodeId().getGlcode(), account.getAmount());
        }
        HashMap<String, BigDecimal> subledgerAmount = new HashMap<String, BigDecimal>(0);
        for (ServiceSubledgerInfo serviceSubledgerInfo : this.subledgerDetails) {
            if (null == serviceSubledgerInfo.getDetailType() || null == serviceSubledgerInfo.getDetailType().getId() || serviceSubledgerInfo.getDetailType().getId() == 0) {
                this.addActionError(this.getText("service.accdetailType.entrymissing", new String[]{serviceSubledgerInfo.getServiceAccountDetail().getGlCodeId().getGlcode()}));
                return Boolean.FALSE;
            }
            if (null != subledgerAmount.get(serviceSubledgerInfo.getServiceAccountDetail().getGlCodeId().getGlcode())) {
                BigDecimal amount = (BigDecimal)subledgerAmount.get(serviceSubledgerInfo.getServiceAccountDetail().getGlCodeId().getGlcode());
                subledgerAmount.put(serviceSubledgerInfo.getServiceAccountDetail().getGlCodeId().getGlcode(), amount.add(serviceSubledgerInfo.getAmount()));
                continue;
            }
            subledgerAmount.put(serviceSubledgerInfo.getServiceAccountDetail().getGlCodeId().getGlcode(), serviceSubledgerInfo.getAmount());
        }
        for (Map.Entry entry : accountDetailAmount.entrySet()) {
            String key = (String)entry.getKey();
            BigDecimal value = (BigDecimal)entry.getValue();
            if (null == subledgerAmount.get(key)) {
                this.addActionError(this.getText("service.accdetail.entrymissing", new String[]{key}));
                return Boolean.FALSE;
            }
            if (((BigDecimal)subledgerAmount.get(key)).compareTo(value) == 0) continue;
            this.addActionError(this.getText("service.subledger.amtnotmatchinng", new String[]{key}));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public boolean shouldShowHeaderField(String field) {
        return this.headerFields.contains(field);
    }

    protected void getHeaderMandateFields() {
        List appConfigValuesList = this.collectionsUtil.getAppConfigValues("Collection", "DEFAULTTXNMISATTRRIBUTESCOLLECTION");
        for (AppConfigValues appConfigVal : appConfigValuesList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            this.mandatoryFields.add(header);
        }
    }

    @Action(value="/service/serviceDetails-codeUniqueCheck")
    public String codeUniqueCheck() {
        return "codeUniqueCheck";
    }

    public boolean getCodeCheck() {
        boolean codeExistsOrNot = false;
        ServiceDetails service = (ServiceDetails)this.serviceDetailsService.findByNamedQuery("getServiceByCode", new Object[]{this.serviceDetails.getCode()});
        if (null != service) {
            codeExistsOrNot = true;
        }
        return codeExistsOrNot;
    }

    public ServiceDetails getServiceDetails() {
        return this.serviceDetails;
    }

    public void setServiceDetails(ServiceDetails serviceDetails) {
        this.serviceDetails = serviceDetails;
    }

    public List<ServiceAccountDetails> getAccountDetails() {
        return this.accountDetails;
    }

    public void setAccountDetails(List<ServiceAccountDetails> accountDetails) {
        this.accountDetails = accountDetails;
    }

    public List<ServiceSubledgerInfo> getSubledgerDetails() {
        return this.subledgerDetails;
    }

    public void setSubledgerDetails(List<ServiceSubledgerInfo> subledgerDetails) {
        this.subledgerDetails = subledgerDetails;
    }

    public void setServiceDetailsService(PersistenceService<ServiceDetails, Long> serviceDetailsService) {
        this.serviceDetailsService = serviceDetailsService;
    }

    public List<Long> getDepartmentList() {
        return this.departmentList;
    }

    public void setDepartmentList(List<Long> departmentList) {
        this.departmentList = departmentList;
    }

    public List<ServiceDetails> getServiceList() {
        return this.serviceList;
    }

    public void setServiceCategoryService(PersistenceService<ServiceCategory, Long> serviceCategoryService) {
        this.serviceCategoryService = serviceCategoryService;
    }

    public Long getServiceCategoryId() {
        return this.serviceCategoryId;
    }

    public void setServiceCategoryId(Long serviceCategoryId) {
        this.serviceCategoryId = serviceCategoryId;
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(List<String> headerFields) {
        this.headerFields = headerFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public void setMandatoryFields(List<String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    public SortedMap<String, String> getServiceTypeMap() {
        return this.serviceTypeMap;
    }

    public void setServiceTypeMap(SortedMap<String, String> serviceTypeMap) {
        this.serviceTypeMap = serviceTypeMap;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }
}

