/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.CollectionBankRemittanceReport;
import org.egov.collection.entity.CollectionRemittanceReportResult;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.Remittance;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.web.actions.receipts.AjaxBankRemittanceAction;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"index"}, location="remittanceVoucherReport-index.jsp"), @Result(name={"report"}, location="remittanceVoucherReport-report.jsp")})
@ParentPackage(value="egov")
public class RemittanceVoucherReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    static final String EGOV_BANKACCOUNT_ID = "EGOV_BANKACCOUNT_ID";
    private static final String EGOV_BRANCH_ID = "EGOV_BRANCH_ID";
    private static final String EGOV_CREATEDBY_ID = "EGOV_CREATEDBY_ID";
    private static final String EGOV_SERVICE_ID = "EGOV_SERVICE_ID";
    private static final String EGOV_VOUCHER_NUMBER = "EGOV_VOUCHER_NUMBER";
    private static final String EGOV_BANK_NAME = "EGOV_BANK_NAME";
    private static final String EGOV_BANKACCOUNT_NAME = "EGOV_BANKACCOUNT_NAME";
    private static final String EGOV_CREATED_BY_NAME = "EGOV_CREATED_BY_NAME";
    private static final String EGOV_SERVICE_NAME = "EGOV_SERVICE_NAME";
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private CollectionsUtil collectionsUtil;
    @Autowired
    private ReportService reportService;
    private Integer branchId;
    private static final String ACCOUNT_NUMBER_LIST = "accountNumberList";
    private static final String RECEIPTDETAILSLIST = "receiptdetailslist";
    private static final String RECIEPT_DETAILS_TEMPLATE = "collection_receiptdetails_main_report";
    private String reportId;
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    private String voucherNumber;
    private final Map<String, Object> critParams = new HashMap(0);
    private List<CollectionBankRemittanceReport> bankRemittanceList;
    private Long srvId;
    private Long bankAcctId;
    private Long createdId;
    private Integer bankBranchId;
    @Autowired
    private BankaccountHibernateDAO bankAccountHibernateDAO;
    @Autowired
    private BankBranchHibernateDAO bankbranchDAO;
    @Autowired
    private UserService userservice;
    private PersistenceService<ServiceDetails, Long> serviceDetailsService;

    public void prepare() {
        this.setReportFormat(ReportFormat.PDF);
        this.setDataSourceType(ReportDataSourceType.SQL);
    }

    public void populateBankAccountList() {
        AjaxBankRemittanceAction ajaxBankRemittanceAction = new AjaxBankRemittanceAction();
        ajaxBankRemittanceAction.setPersistenceService(this.getPersistenceService());
        ajaxBankRemittanceAction.bankBranchListOfService();
        this.addDropdownData("bankBranchList", ajaxBankRemittanceAction.getBankBranchArrayList());
        if (this.branchId != null) {
            ajaxBankRemittanceAction.setBranchId(this.branchId);
            ajaxBankRemittanceAction.accountListOfService();
            this.addDropdownData(ACCOUNT_NUMBER_LIST, ajaxBankRemittanceAction.getBankAccountArrayList());
        } else {
            this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.EMPTY_LIST);
        }
    }

    @Action(value="/reports/remittanceVoucherReport-criteria")
    public String criteria() {
        List usersList = this.persistenceService.findAllByNamedQuery("getAllRemittanceVoucherCreator", new Object[0]);
        User user = this.collectionsUtil.getLoggedInUser();
        this.employeeService.getEmployeeById(user.getId());
        this.populateBankAccountList();
        this.addDropdownData("collectionServiceList", Collections.EMPTY_LIST);
        this.addDropdownData("remittanceVoucherCreatorList", usersList);
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        this.critParams.put(EGOV_FROM_DATE, new Date());
        this.critParams.put(EGOV_TO_DATE, new Date());
        return "index";
    }

    @Action(value="/reports/remittanceVoucherReport-reportReceiptDetails")
    public String reportReceiptDetails() {
        Remittance remittanceObj = (Remittance)this.persistenceService.findByNamedQuery("getRemitanceByVoucherNumber", new Object[]{this.voucherNumber});
        this.critParams.put(EGOV_FROM_DATE, new Date());
        this.critParams.put(EGOV_TO_DATE, new Date());
        ArrayList<CollectionBankRemittanceReport> reportList = new ArrayList<CollectionBankRemittanceReport>(0);
        if (remittanceObj != null) {
            for (ReceiptHeader receiptHead : remittanceObj.getCollectionRemittance()) {
                Iterator itr = receiptHead.getReceiptInstrument().iterator();
                while (itr.hasNext()) {
                    CollectionBankRemittanceReport collBankRemitReport = new CollectionBankRemittanceReport();
                    InstrumentHeader instHead = (InstrumentHeader)itr.next();
                    collBankRemitReport.setPaymentMode(instHead.getInstrumentType().getType());
                    collBankRemitReport.setAmount(Double.valueOf(instHead.getInstrumentAmount().doubleValue()));
                    collBankRemitReport.setReceiptNumber(receiptHead.getReceiptnumber());
                    collBankRemitReport.setReceiptDate(receiptHead.getReceiptDate());
                    collBankRemitReport.setServiceType(receiptHead.getService().getName());
                    reportList.add(collBankRemitReport);
                }
            }
        }
        ServiceDetails service = (ServiceDetails)this.serviceDetailsService.findById((Serializable)this.srvId, false);
        this.setEgovVoucherNumber(this.voucherNumber);
        this.critParams.put(EGOV_SERVICE_NAME, service != null ? service.getName() : null);
        this.critParams.put(EGOV_BANK_NAME, this.bankBranchId != -1 ? this.bankbranchDAO.findById((Number)this.bankBranchId, false).getBank().getName() : null);
        this.critParams.put(EGOV_BANKACCOUNT_NAME, this.bankAcctId != -1L ? this.bankAccountHibernateDAO.findById((Number)this.bankAcctId, false).getBankbranch().getBank().getName() + "-" + this.bankAccountHibernateDAO.findById((Number)this.bankAcctId, false).getAccountnumber() : null);
        this.critParams.put(EGOV_CREATED_BY_NAME, this.createdId != -1L ? this.userservice.getUserById(this.createdId).getName() : null);
        CollectionRemittanceReportResult collReportResult = new CollectionRemittanceReportResult();
        collReportResult.setCollectionBankRemittanceReportList(reportList);
        ReportRequest reportInput = new ReportRequest(RECIEPT_DETAILS_TEMPLATE, (Object)collReportResult, this.critParams);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return "report";
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    @Action(value="/reports/remittanceVoucherReport-report")
    public String report() {
        ReportRequest reportInput = new ReportRequest(this.getReportTemplateName(), this.critParams, ReportDataSourceType.SQL);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return "report";
    }

    public void setFromDate(Date fromDate) {
        this.critParams.put(EGOV_FROM_DATE, fromDate);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public static String getReceiptdetailslist() {
        return RECEIPTDETAILSLIST;
    }

    public void setToDate(Date toDate) {
        this.critParams.put(EGOV_TO_DATE, toDate);
    }

    protected String getReportTemplateName() {
        return "collection_remittancevoucher_report";
    }

    public Integer getBankAccountId() {
        return (Integer)this.getReportParam(EGOV_BANKACCOUNT_ID);
    }

    public void setBankAccountId(Integer bankAccountId) {
        this.critParams.put(EGOV_BANKACCOUNT_ID, bankAccountId);
    }

    public Integer getCreatedById() {
        return (Integer)this.getReportParam(EGOV_CREATEDBY_ID);
    }

    public void setCreatedById(Integer createdById) {
        this.critParams.put(EGOV_CREATEDBY_ID, createdById);
    }

    public Long getServiceId() {
        return (Long)this.getReportParam(EGOV_SERVICE_ID);
    }

    public void setServiceId(Long serviceId) {
        this.critParams.put(EGOV_SERVICE_ID, serviceId);
    }

    public String getEgovVoucherNumber() {
        return (String)this.getReportParam(EGOV_VOUCHER_NUMBER);
    }

    public void setEgovVoucherNumber(String voucherNumber) {
        this.critParams.put(EGOV_VOUCHER_NUMBER, voucherNumber);
    }

    public Integer getBranchId() {
        return (Integer)this.getReportParam(EGOV_BRANCH_ID);
    }

    public void setBranchId(Integer branchId) {
        this.critParams.put(EGOV_BRANCH_ID, branchId);
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public String getReportId() {
        return this.reportId;
    }

    public List<CollectionBankRemittanceReport> getBankRemittanceList() {
        return this.bankRemittanceList;
    }

    public void setBankRemittanceList(List<CollectionBankRemittanceReport> bankRemittanceList) {
        this.bankRemittanceList = bankRemittanceList;
    }

    public Long getSrvId() {
        return this.srvId;
    }

    public void setSrvId(Long srvId) {
        this.srvId = srvId;
    }

    public Long getBankAcctId() {
        return this.bankAcctId;
    }

    public void setBankAcctId(Long bankAcctId) {
        this.bankAcctId = bankAcctId;
    }

    public Long getCreatedId() {
        return this.createdId;
    }

    public void setCreatedId(Long createdId) {
        this.createdId = createdId;
    }

    public Integer getBankBranchId() {
        return this.bankBranchId;
    }

    public void setBankBranchId(Integer bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public String getEgovBankName() {
        return (String)this.getReportParam(EGOV_BANK_NAME);
    }

    public void setEgovBankName(String branchName) {
        this.critParams.put(EGOV_BANK_NAME, branchName);
    }

    public String getEgovBankaccountName() {
        return (String)this.getReportParam(EGOV_BANKACCOUNT_NAME);
    }

    public void setEgovBankaccountName(String branchAccountName) {
        this.critParams.put(EGOV_BANKACCOUNT_NAME, branchAccountName);
    }

    public String getEgovCreatedByName() {
        return (String)this.getReportParam(EGOV_CREATED_BY_NAME);
    }

    public void setEgovCreatedByName(String createdByName) {
        this.critParams.put(EGOV_CREATED_BY_NAME, createdByName);
    }

    public String getEgovServiceName() {
        return (String)this.getReportParam(EGOV_SERVICE_NAME);
    }

    public void setEgovServiceName(String serviceName) {
        this.critParams.put(EGOV_SERVICE_NAME, serviceName);
    }

    public void setServiceDetailsService(PersistenceService<ServiceDetails, Long> serviceDetailsService) {
        this.serviceDetailsService = serviceDetailsService;
    }
}

