/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.web.struts.actions.ReportFormAction;

@Results(value={@Result(name={"index"}, location="bankRemittanceReport-index.jsp"), @Result(name={"report"}, location="bankRemittanceReport-report.jsp")})
public class BankRemittanceReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_DEPT_ID = "EGOV_DEPT_ID";
    private static final String BANK_REMITTANCE_REPORT_TEMPLATE = "bank_remittance";
    private CollectionsUtil collectionsUtil;

    public void prepare() {
        this.setReportFormat(ReportFormat.PDF);
        this.setDataSourceType(ReportDataSourceType.SQL);
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Integer getDeptId() {
        return (Integer)this.getReportParam(EGOV_DEPT_ID);
    }

    public void setDeptId(Integer deptId) {
        this.setReportParam(EGOV_DEPT_ID, (Object)deptId);
    }

    @Action(value="/reports/bankRemittanceReport-criteria")
    public String criteria() {
        this.addRelatedEntity("department", Department.class, "name");
        this.setupDropdownDataExcluding(new String[0]);
        Department dept = this.collectionsUtil.getDepartmentOfLoggedInUser();
        if (dept != null) {
            this.setReportParam(EGOV_DEPT_ID, (Object)dept.getId());
        }
        return "index";
    }

    @Action(value="/reports/bankRemittanceReport-report")
    public String report() {
        return super.report();
    }

    protected String getReportTemplateName() {
        return BANK_REMITTANCE_REPORT_TEMPLATE;
    }
}

