/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;

@ParentPackage(value="egov")
@Results(value={@Result(name={"success"}, location="searchChallan.jsp")})
public class SearchChallanAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private Long serviceId = -1L;
    private Long serviceCategoryId = -1L;
    private Date fromDate;
    private Date toDate;
    private Integer status = -1;
    private Long departmentId = -1L;
    private String challanNumber;
    private List<ReceiptHeader> results = new ArrayList(0);
    private String target = "new";
    private static final String sourcePage = "search";

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("departmentList", this.getPersistenceService().findAllByNamedQuery("getAllDepartment", new Object[0]));
        this.addDropdownData("serviceCategoryList", this.getPersistenceService().findAllByNamedQuery("ACTIVE_SERVICE_CATEGORY", new Object[0]));
        if (null != this.serviceCategoryId && this.serviceCategoryId != -1L) {
            this.addDropdownData("serviceList", this.getPersistenceService().findAllByNamedQuery("SERVICE_BY_CATEGORY_FOR_TYPE", new Object[]{this.serviceCategoryId, "C", Boolean.TRUE}));
        } else {
            this.addDropdownData("serviceList", Collections.EMPTY_LIST);
        }
        this.setFromDate(new Date());
        this.setToDate(new Date());
    }

    @Action(value="/receipts/searchChallan-reset")
    public String reset() {
        this.departmentId = -1L;
        this.results = null;
        this.serviceId = -1L;
        this.serviceCategoryId = -1L;
        this.challanNumber = "";
        this.fromDate = null;
        this.toDate = null;
        this.status = -1;
        return "success";
    }

    public List getChallanStatuses() {
        return this.persistenceService.findAllBy("select distinct s from ReceiptHeader receipt inner join receipt.challan.status s", new Object[0]);
    }

    @Action(value="/receipts/searchChallan-search")
    public String search() {
        StringBuilder queryString = new StringBuilder(" select distinct receipt from org.egov.collection.entity.ReceiptHeader receipt");
        StringBuilder criteria = new StringBuilder();
        StringBuilder joinString = new StringBuilder();
        StringBuilder whereString = new StringBuilder(" order by receipt.createdDate desc");
        ArrayList<Object> params = new ArrayList<Object>(0);
        if (StringUtils.isNotBlank((String)this.getChallanNumber())) {
            criteria.append(" upper(receipt.challan.challanNumber) like ? ");
            params.add("%" + this.getChallanNumber().toUpperCase() + "%");
        }
        if (this.getDepartmentId() != -1L) {
            criteria.append(this.getJoinOperand(criteria)).append(" receipt.receiptMisc.department.id = ? ");
            params.add(this.getDepartmentId());
        }
        if (this.getStatus() != -1) {
            criteria.append(this.getJoinOperand(criteria)).append(" receipt.challan.status.id = ? ");
            params.add(this.getStatus());
        }
        if (this.getFromDate() != null) {
            criteria.append(this.getJoinOperand(criteria)).append(" receipt.challan.challanDate >= ? ");
            params.add(this.fromDate);
        }
        if (this.getToDate() != null) {
            criteria.append(this.getJoinOperand(criteria)).append(" receipt.challan.challanDate < ? ");
            params.add(DateUtils.add((Date)this.toDate, (int)5, (int)1));
        }
        if (this.getServiceId() != -1L) {
            criteria.append(this.getJoinOperand(criteria)).append(" receipt.service.id = ? ");
            params.add(this.getServiceId());
        }
        if (this.getServiceCategoryId() != -1L) {
            criteria.append(this.getJoinOperand(criteria)).append(" receipt.service.serviceCategory.id = ? ");
            params.add(this.getServiceCategoryId());
        }
        criteria.append(this.getJoinOperand(criteria)).append(" receipt.receipttype = ? ");
        params.add(Character.valueOf('C'));
        queryString.append(StringUtils.isBlank((String)joinString.toString()) ? "" : joinString);
        queryString.append(StringUtils.isBlank((String)criteria.toString()) ? "" : " where ").append((CharSequence)criteria);
        queryString.append((CharSequence)whereString);
        this.results = this.getPersistenceService().findAllBy(queryString.toString(), params.toArray());
        if (this.results.size() > 500) {
            this.results.clear();
            throw new ValidationException(Arrays.asList(new ValidationError("searchchallan.changecriteria", "More than 500 results found.Please add more search criteria")));
        }
        this.target = "searchresult";
        return "success";
    }

    private String getJoinOperand(StringBuilder criteria) {
        return StringUtils.isBlank((String)criteria.toString()) ? "" : " and ";
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getChallanNumber() {
        return this.challanNumber;
    }

    public void setChallanNumber(String challanNumber) {
        this.challanNumber = challanNumber;
    }

    public String getTarget() {
        return this.target;
    }

    public List<ReceiptHeader> getResults() {
        return this.results;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getSourcePage() {
        return sourcePage;
    }

    public Long getServiceCategoryId() {
        return this.serviceCategoryId;
    }

    public void setServiceCategoryId(Long serviceCategoryId) {
        this.serviceCategoryId = serviceCategoryId;
    }
}

