/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.CollectionBankRemittanceReport;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.service.RemittanceServiceImpl;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.web.actions.receipts.AjaxBankRemittanceAction;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"new"}, location="bankRemittance-new.jsp"), @Result(name={"printBankChallan"}, type="redirectAction", location="remittanceStatementReport-printBankChallan.action", params={"namespace", "/reports", "totalCashAmount", "${totalCashAmount}", "totalChequeAmount", "${totalChequeAmount}", "bank", "${bank}", "bankAccount", "${bankAccount}", "remittanceDate", "${remittanceDate}"}), @Result(name={"index"}, location="bankRemittance-index.jsp")})
@ParentPackage(value="egov")
public class BankRemittanceAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BankRemittanceAction.class);
    private List<HashMap<String, Object>> paramList = null;
    private final ReceiptHeader receiptHeaderIntsance = new ReceiptHeader();
    private List<ReceiptHeader> voucherHeaderValues = new ArrayList(0);
    private String[] serviceNameArray;
    private String[] totalCashAmountArray;
    private String[] totalChequeAmountArray;
    private String[] totalCardAmountArray;
    private String[] receiptDateArray;
    private String[] receiptNumberArray;
    private String[] fundCodeArray;
    private String[] departmentCodeArray;
    private Integer accountNumberId;
    private CollectionsUtil collectionsUtil;
    private Integer branchId;
    private static final String ACCOUNT_NUMBER_LIST = "accountNumberList";
    private Boolean isListData = false;
    private Integer positionUser;
    private Integer designationId;
    private Date remittanceDate;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private BankaccountHibernateDAO bankaccountHibernateDAO;
    protected static final String PRINT_BANK_CHALLAN = "printBankChallan";
    private Double totalCashAmount;
    private Double totalChequeAmount;
    private List<CollectionBankRemittanceReport> bankRemittanceList;
    private String bank;
    private String bankAccount;
    private Boolean showCardAndOnlineColumn = false;
    private Boolean showRemittanceDate = false;
    private Long finYearId;
    private RemittanceServiceImpl remittanceService;
    private String voucherNumber;
    private SortedMap<String, String> paymentModesMap = new TreeMap();
    private String paymentMode;
    private Date fromDate;
    private Date toDate;
    private Integer pageSize;
    private String remittanceAmount;
    private static final String REMITTANCE_LIST = "REMITTANCE_LIST";
    private Boolean isBankCollectionRemitter;

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    @Action(value="/receipts/bankRemittance-newform")
    @SkipValidation
    public String newform() {
        this.populateRemittanceList();
        return "new";
    }

    private void populateRemittanceList() {
        AjaxBankRemittanceAction ajaxBankRemittanceAction = new AjaxBankRemittanceAction();
        ajaxBankRemittanceAction.setPersistenceService(this.getPersistenceService());
        ajaxBankRemittanceAction.setCollectionsUtil(this.collectionsUtil);
        ajaxBankRemittanceAction.bankBranchListOfService();
        this.addDropdownData("bankBranchList", ajaxBankRemittanceAction.getBankBranchArrayList());
        if (this.collectionsUtil.isBankCollectionRemitter(this.collectionsUtil.getLoggedInUser()).booleanValue()) {
            if (ajaxBankRemittanceAction.getBankBranchArrayList().isEmpty()) {
                throw new ValidationException(Arrays.asList(new ValidationError("The user is not mapped to any bank branch, please contact system administrator.", "bankremittance.error.bankcollectionoperator")));
            }
            this.branchId = ((Bankbranch)ajaxBankRemittanceAction.getBankBranchArrayList().get(0)).getId();
        }
        if (this.branchId != null) {
            ajaxBankRemittanceAction.setBranchId(this.branchId);
            ajaxBankRemittanceAction.accountListOfService();
            this.addDropdownData(ACCOUNT_NUMBER_LIST, ajaxBankRemittanceAction.getBankAccountArrayList());
        } else {
            this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.emptyList());
        }
        this.addDropdownData("financialYearList", this.financialYearDAO.getAllActivePostingAndNotClosedFinancialYears());
        TreeMap<String, String> paymentModes = new TreeMap<String, String>();
        paymentModes.put("cash", "cash");
        paymentModes.put("cheque/dd", "cheque/dd");
        this.paymentModesMap.putAll(paymentModes);
    }

    public String getJurisdictionBoundary() {
        User user = this.collectionsUtil.getLoggedInUser();
        if (!this.collectionsUtil.isBankCollectionRemitter(user).booleanValue()) {
            Employee employee = this.employeeService.getEmployeeById(user.getId());
            StringBuilder jurValuesId = new StringBuilder();
            for (Jurisdiction element : employee.getJurisdictions()) {
                if (jurValuesId.length() > 0) {
                    jurValuesId.append(',');
                }
                jurValuesId.append(element.getBoundary().getId());
                for (Boundary boundary : element.getBoundary().getChildren()) {
                    jurValuesId.append(',');
                    jurValuesId.append(boundary.getId());
                }
            }
            return jurValuesId.toString();
        }
        return "";
    }

    @Action(value="/receipts/bankRemittance-listData")
    @SkipValidation
    public String listData() {
        this.isListData = true;
        this.populateRemittanceList();
        if (this.fromDate != null && this.toDate != null && this.toDate.before(this.fromDate)) {
            this.addActionError(this.getText("bankremittance.before.fromdate"));
        }
        if (!this.hasErrors()) {
            String serviceFundQueryStr = "select distinct sd.code as servicecode,fd.code as fundcode from BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.BANKACCOUNT=ba.ID and asm.servicedetails=sd.ID and fd.ID=ba.FUNDID and ba.id=" + this.accountNumberId;
            SQLQuery serviceFundQuery = this.persistenceService.getSession().createSQLQuery(serviceFundQueryStr);
            List queryResults = serviceFundQuery.list();
            ArrayList<String> serviceCodeList = new ArrayList<String>(0);
            ArrayList<String> fundCodeList = new ArrayList<String>(0);
            for (int i = 0; i < queryResults.size(); ++i) {
                Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
                serviceCodeList.add(arrayObjectInitialIndex[0].toString());
                fundCodeList.add(arrayObjectInitialIndex[1].toString());
            }
            CFinancialYear financialYear = this.financialYearDAO.getFinancialYearById(this.finYearId);
            this.paramList = this.remittanceService.findAllRemittanceDetailsForServiceAndFund(this.getJurisdictionBoundary(), "'" + StringUtils.join(serviceCodeList, (String)"','") + "'", "'" + StringUtils.join(fundCodeList, (String)"','") + "'", this.fromDate == null ? financialYear.getStartingDate() : this.fromDate, this.toDate == null ? financialYear.getEndingDate() : this.toDate, this.paymentMode);
            this.pageSize = this.fromDate != null && this.toDate != null ? Integer.valueOf(this.paramList.size()) : CollectionConstants.DEFAULT_PAGE_SIZE;
        }
        return "new";
    }

    @Action(value="/receipts/bankRemittance-printBankChallan")
    @SkipValidation
    public String printBankChallan() {
        return PRINT_BANK_CHALLAN;
    }

    public String edit() {
        return "edit";
    }

    public String save() {
        return "success";
    }

    public void prepare() {
        String showRemitDate;
        super.prepare();
        String showColumn = this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_SHOWCOLUMNSCARDONLINE");
        if (!showColumn.isEmpty() && showColumn.equals("Y")) {
            this.showCardAndOnlineColumn = true;
        }
        if (!(showRemitDate = this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_SHOWREMITDATE")).isEmpty() && showRemitDate.equals("Y")) {
            this.showRemittanceDate = true;
        }
        this.isBankCollectionRemitter = this.collectionsUtil.isBankCollectionOperator(this.collectionsUtil.getLoggedInUser());
        this.addDropdownData("bankBranchList", Collections.emptyList());
        this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.emptyList());
    }

    @Action(value="/receipts/bankRemittance-create")
    @ValidationErrorPage(value="new")
    public String create() throws InstantiationException, IllegalAccessException {
        long startTimeMillis = System.currentTimeMillis();
        String serviceName = "";
        String fundCode = "";
        for (int i = 0; i < this.getServiceNameArray().length; ++i) {
            if (this.getServiceNameArray() == null || this.getServiceNameArray()[i].isEmpty()) continue;
            serviceName = this.getServiceNameArray()[i];
            fundCode = this.getFundCodeArray()[i];
            break;
        }
        String bankAccountStr = "select distinct asm.BANKACCOUNT from BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.BANKACCOUNT=ba.ID and asm.servicedetails=sd.ID and fd.ID=ba.FUNDID and sd.name= '" + serviceName + "'  and fd.code='" + fundCode + "'";
        SQLQuery bankAccountQry = this.persistenceService.getSession().createSQLQuery(bankAccountStr);
        if (bankAccountQry.list().size() > 1) {
            throw new ValidationException(Arrays.asList(new ValidationError("Mulitple Bank Accounts for the same Service and Fund is mapped. Please correct the data", "bankremittance.error.multiplebankaccounterror")));
        }
        Object queryResults = bankAccountQry.uniqueResult();
        BigInteger accountNumber = (BigInteger)queryResults;
        this.accountNumberId = accountNumber != null ? accountNumber.intValue() : this.accountNumberId.intValue();
        if (accountNumber == null || accountNumber.intValue() == -1 && accountNumber.intValue() != this.accountNumberId.intValue()) {
            throw new ValidationException(Arrays.asList(new ValidationError("Bank Account for the Service and Fund is not mapped", "bankremittance.error.bankaccounterror")));
        }
        this.voucherHeaderValues = this.remittanceService.createBankRemittance(this.getServiceNameArray(), this.getTotalCashAmountArray(), this.getTotalChequeAmountArray(), this.getTotalCardAmountArray(), this.getReceiptDateArray(), this.getFundCodeArray(), this.getDepartmentCodeArray(), this.accountNumberId, this.positionUser, this.getReceiptNumberArray(), this.remittanceDate);
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        LOGGER.info((Object)("$$$$$$ Time taken to persist the remittance list (ms) = " + elapsedTimeMillis));
        this.bankRemittanceList = this.remittanceService.prepareBankRemittanceReport(this.voucherHeaderValues);
        if (this.getSession().get(REMITTANCE_LIST) != null) {
            this.getSession().remove(REMITTANCE_LIST);
        }
        this.getSession().put(REMITTANCE_LIST, this.bankRemittanceList);
        Bankaccount bankAcc = this.bankaccountHibernateDAO.findById((Number)this.accountNumberId, false);
        this.bankAccount = bankAcc.getAccountnumber();
        this.bank = bankAcc.getBankbranch().getBank().getName();
        this.totalCashAmount = this.getSum(this.getTotalCashAmountArray());
        this.totalChequeAmount = this.getSum(this.getTotalChequeAmountArray());
        return "index";
    }

    private Double getSum(String[] array) {
        Double sum = 0.0;
        for (String num : array) {
            if (num.isEmpty()) continue;
            sum = sum + Double.valueOf(num);
        }
        return sum;
    }

    public void validate() {
        super.validate();
        this.populateRemittanceList();
        this.listData();
        SimpleDateFormat dateFomatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        if (this.receiptDateArray != null) {
            String[] filterReceiptDateArray = this.removeNullValue(this.receiptDateArray);
            String receiptEndDate = filterReceiptDateArray[filterReceiptDateArray.length - 1];
            try {
                if (!receiptEndDate.isEmpty() && this.remittanceDate != null && this.remittanceDate.before(dateFomatter.parse(receiptEndDate))) {
                    this.addActionError(this.getText("bankremittance.before.receiptdate"));
                }
            }
            catch (ParseException e) {
                LOGGER.debug((Object)("Exception in parsing date  " + receiptEndDate + " - " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception while parsing receiptEndDate date", (Throwable)e);
            }
        }
    }

    private String[] removeNullValue(String[] receiptDateArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : receiptDateArray) {
            if (s == null || s.length() <= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public Object getModel() {
        return this.receiptHeaderIntsance;
    }

    public List<HashMap<String, Object>> getParamList() {
        return this.paramList;
    }

    public void setParamList(List<HashMap<String, Object>> paramList) {
        this.paramList = paramList;
    }

    public String[] getServiceNameArray() {
        return this.serviceNameArray;
    }

    public void setServiceNameArray(String[] serviceNameArray) {
        this.serviceNameArray = serviceNameArray;
    }

    public String[] getTotalCashAmountArray() {
        return this.totalCashAmountArray;
    }

    public void setTotalCashAmountArray(String[] totalCashAmountArray) {
        this.totalCashAmountArray = totalCashAmountArray;
    }

    public String[] getTotalChequeAmountArray() {
        return this.totalChequeAmountArray;
    }

    public void setTotalChequeAmountArray(String[] totalChequeAmountArray) {
        this.totalChequeAmountArray = totalChequeAmountArray;
    }

    public String[] getReceiptDateArray() {
        return this.receiptDateArray;
    }

    public void setReceiptDateArray(String[] receiptDateArray) {
        this.receiptDateArray = receiptDateArray;
    }

    public List<ReceiptHeader> getVoucherHeaderValues() {
        return this.voucherHeaderValues;
    }

    public void setVoucherHeaderValues(List<ReceiptHeader> voucherHeaderValues) {
        this.voucherHeaderValues = voucherHeaderValues;
    }

    public String[] getFundCodeArray() {
        return this.fundCodeArray;
    }

    public void setFundCodeArray(String[] fundCodeArray) {
        this.fundCodeArray = fundCodeArray;
    }

    public String[] getDepartmentCodeArray() {
        return this.departmentCodeArray;
    }

    public void setDepartmentCodeArray(String[] departmentCodeArray) {
        this.departmentCodeArray = departmentCodeArray;
    }

    public String[] getTotalCardAmountArray() {
        return this.totalCardAmountArray;
    }

    public void setTotalCardAmountArray(String[] totalCardAmountArray) {
        this.totalCardAmountArray = totalCardAmountArray;
    }

    public Integer getPositionUser() {
        return this.positionUser;
    }

    public void setPositionUser(Integer positionUser) {
        this.positionUser = positionUser;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String[] getReceiptNumberArray() {
        return this.receiptNumberArray;
    }

    public void setReceiptNumberArray(String[] receiptNumberArray) {
        this.receiptNumberArray = receiptNumberArray;
    }

    public Integer getBranchId() {
        return this.branchId;
    }

    public void setBranchId(Integer branchId) {
        this.branchId = branchId;
    }

    public Integer getAccountNumberId() {
        return this.accountNumberId;
    }

    public void setAccountNumberId(Integer accountNumberId) {
        this.accountNumberId = accountNumberId;
    }

    public Boolean getIsListData() {
        return this.isListData;
    }

    public void setIsListData(Boolean isListData) {
        this.isListData = isListData;
    }

    public Double getTotalCashAmount() {
        return this.totalCashAmount;
    }

    public void setTotalCashAmount(Double totalCashAmount) {
        this.totalCashAmount = totalCashAmount;
    }

    public Double getTotalChequeAmount() {
        return this.totalChequeAmount;
    }

    public void setTotalChequeAmount(Double totalChequeAmount) {
        this.totalChequeAmount = totalChequeAmount;
    }

    public List<CollectionBankRemittanceReport> getBankRemittanceList() {
        return this.bankRemittanceList;
    }

    public void setBankRemittanceList(List<CollectionBankRemittanceReport> bankRemittanceList) {
        this.bankRemittanceList = bankRemittanceList;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Boolean getShowCardAndOnlineColumn() {
        return this.showCardAndOnlineColumn;
    }

    public void setShowCardAndOnlineColumn(Boolean showCardAndOnlineColumn) {
        this.showCardAndOnlineColumn = showCardAndOnlineColumn;
    }

    public Boolean getShowRemittanceDate() {
        return this.showRemittanceDate;
    }

    public void setShowRemittanceDate(Boolean showRemittanceDate) {
        this.showRemittanceDate = showRemittanceDate;
    }

    public Date getRemittanceDate() {
        return this.remittanceDate;
    }

    public void setRemittanceDate(Date remittanceDate) {
        this.remittanceDate = remittanceDate;
    }

    public Long getFinYearId() {
        return this.finYearId;
    }

    public void setFinYearId(Long finYearId) {
        this.finYearId = finYearId;
    }

    public void setRemittanceService(RemittanceServiceImpl remittanceService) {
        this.remittanceService = remittanceService;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public SortedMap<String, String> getPaymentModesMap() {
        return this.paymentModesMap;
    }

    public void setPaymentModesMap(SortedMap<String, String> paymentModesMap) {
        this.paymentModesMap = paymentModesMap;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getRemittanceAmount() {
        return this.remittanceAmount;
    }

    public void setRemittanceAmount(String remittanceAmount) {
        this.remittanceAmount = remittanceAmount;
    }

    public Boolean getIsBankCollectionRemitter() {
        return this.isBankCollectionRemitter;
    }

    public void setIsBankCollectionRemitter(Boolean isBankCollectionRemitter) {
        this.isBankCollectionRemitter = isBankCollectionRemitter;
    }
}

