/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptDetailInfo;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.service.ChallanService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bank;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.pims.commons.Position;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@ParentPackage(value="egov")
@Transactional(readOnly=true)
public class FileUploadAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(FileUploadAction.class);
    private File importFile;
    private String importContentType;
    private String importFileName;
    private String importfileCaption;
    private List<String[]> inputList = new ArrayList(0);
    private List<ReceiptDetailInfo> billCreditDetailslist = null;
    private List<ReceiptDetailInfo> subLedgerlist = null;
    SimpleDateFormat sdfInput = new SimpleDateFormat("dd-MMM-yyyy", Locale.getDefault());
    SimpleDateFormat sdfOutput = new SimpleDateFormat("ddMMyy", Locale.getDefault());
    private PersistenceService persistenceService;
    private CollectionsUtil collectionsUtil;
    private FinancialsUtil financialsUtil;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    private ReceiptHeaderService receiptHeaderService;
    private ChallanService challanService;
    private CollectionCommon collectionCommon;
    private BigDecimal cashOrCardInstrumenttotal;
    private BigDecimal chequeInstrumenttotal;
    @Autowired
    private ApplicationContext beanProvider;
    private final Map<Integer, String> errorRowMap = new TreeMap();
    private List<Long> errorReceiptList = new ArrayList(0);
    private Integer successNo = 0;
    private String source = "";
    private boolean testMode = false;

    public void setInputList(List<String[]> inputList) {
        this.inputList = inputList;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setReceiptWorkflowService(WorkflowService<ReceiptHeader> receiptWorkflowService) {
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setChallanService(ChallanService challanService) {
        this.challanService = challanService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public String execute() throws Exception {
        return this.list();
    }

    public String newform() {
        return "new";
    }

    public String list() {
        return "index";
    }

    public String edit() {
        return "edit";
    }

    private void removeNullListEntries() {
        ArrayList<String[]> tempInputList = new ArrayList<String[]>();
        for (String[] currentArray : this.inputList) {
            boolean isNull = true;
            for (int j = 0; j < currentArray.length - 1; ++j) {
                if (currentArray[j] == null || currentArray[j].equals("")) continue;
                isNull = false;
                break;
            }
            if (isNull) continue;
            tempInputList.add(currentArray);
        }
        this.inputList = tempInputList;
    }

    @Transactional
    public String save() {
        this.readColumn();
        this.setSource("upload");
        this.removeNullListEntries();
        for (int i = 0; i < this.inputList.size(); ++i) {
            String[] input = (String[])this.inputList.get(i);
            String challanNumber = input[0];
            input = this.formatValues(input);
            ArrayList<String[]> nextRecords = new ArrayList<String[]>();
            if (input[15].equalsIgnoreCase("cheque") || "dd".equalsIgnoreCase(input[15]) && input[9] != null && !"".equals(input[9])) {
                while (i + 1 < this.inputList.size() && this.inputList.get(i + 1) != null && challanNumber.equals(((String[])this.inputList.get(i + 1))[0]) && input[1].equals(((String[])this.inputList.get(i + 1))[1]) && (((String[])this.inputList.get(i + 1))[9] == null || "".equals(((String[])this.inputList.get(i + 1))[9]))) {
                    if (!"cheque".equalsIgnoreCase(((String[])this.inputList.get(i + 1))[15]) && !"dd".equalsIgnoreCase(((String[])this.inputList.get(i + 1))[15])) continue;
                    String[] rec = this.formatChequeDDValues((String[])this.inputList.get(i + 1));
                    nextRecords.add(rec);
                    ++i;
                }
            }
            if (!this.validateExcel(input, nextRecords)) continue;
            this.billCreditDetailslist = new ArrayList();
            this.subLedgerlist = new ArrayList();
            this.cashOrCardInstrumenttotal = BigDecimal.ZERO;
            this.chequeInstrumenttotal = BigDecimal.ZERO;
            ReceiptHeader receiptHeader = this.initialiseValuesForSaveNew(input);
            if (i + 1 < this.inputList.size() && this.inputList.get(i + 1) != null) {
                while (((String[])this.inputList.get(i + 1))[0] != null && !((String[])this.inputList.get(i + 1))[0].equals("") && challanNumber.equals(((String[])this.inputList.get(i + 1))[0]) && input[1].equals(((String[])this.inputList.get(i + 1))[1]) && input[6].equals(((String[])this.inputList.get(i + 1))[6]) && ((String[])this.inputList.get(i + 1))[8] != null && !((String[])this.inputList.get(i + 1))[8].equals("")) {
                    this.createCreditDetailslist((String[])this.inputList.get(i + 1));
                    try {
                        if (!"".equals(((String[])this.inputList.get(i + 1))[10])) {
                            if (((String[])this.inputList.get(i + 1))[11].endsWith(".0")) {
                                ((String[])this.inputList.get((int)(i + 1)))[11] = ((String[])this.inputList.get(i + 1))[11].substring(0, ((String[])this.inputList.get(i + 1))[11].indexOf(46));
                            }
                            this.createSubLedgerlist((String[])this.inputList.get(i + 1));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.debug((Object)e.getMessage());
                    }
                    if (++i < this.inputList.size() - 1) continue;
                }
            }
            try {
                if (this.errorRowMap.get(Integer.valueOf(input[21])) != null) continue;
                receiptHeader = this.saveChallan(receiptHeader, input[7]);
            }
            catch (Exception e) {
                if (e.getClass().equals(ConstraintViolationException.class) && e.getCause().toString().indexOf("UNIQUE_CHALLANNUMBER") != -1) {
                    this.errorRowMap.put(Integer.valueOf(input[21]), "Duplicate Challan Number - [" + input[0] + "]");
                    continue;
                }
                this.errorRowMap.put(Integer.valueOf(input[21]), "Error in challan creation.");
                continue;
            }
            try {
                this.createChallanReceipt(receiptHeader, input, nextRecords);
            }
            catch (Exception e) {
                this.errorRowMap.put(Integer.valueOf(input[21]), "Error in Challan Receipt creation.");
                LOGGER.debug((Object)e.getMessage());
                continue;
            }
            this.successNo = this.successNo + 1;
            this.setSuccessNo(this.successNo);
            LOGGER.debug((Object)("Challan details in Row " + input[21] + "uploaded and persisted successfully!"));
        }
        try {
            this.generateErrorReport();
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occrured while generating report : " + e.getMessage()));
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateErrorReport() throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(new File("ManualChallanUploadErrorReport.txt"));
            if (!this.errorRowMap.isEmpty()) {
                String[] errors = null;
                fos.write("Errors in Uploading Following Rows \n".getBytes());
                fos.write("********************************** \n\n".getBytes());
                for (Map.Entry pairs : this.errorRowMap.entrySet()) {
                    errors = new String[20];
                    for (String error2 : errors = pairs.getValue().toString().split(",")) {
                        fos.write(("  Row " + pairs.getKey().toString() + " : " + error2 + "\n").getBytes());
                    }
                    errors = null;
                }
            }
            LOGGER.debug((Object)"Written to file successfully ");
            fos.close();
        }
    }

    public String fileValidate() {
        this.readColumn();
        this.setSource("validate");
        this.removeNullListEntries();
        for (int i = 0; i < this.inputList.size(); ++i) {
            String[] input = (String[])this.inputList.get(i);
            String challanNumber = input[0];
            input = this.formatValues(input);
            ArrayList<String[]> nextRecords = new ArrayList<String[]>();
            if ("cheque".equalsIgnoreCase(input[15]) || "dd".equalsIgnoreCase(input[15]) && input[9] != null && !"".equals(input[9])) {
                while (i + 1 < this.inputList.size() && this.inputList.get(i + 1) != null && challanNumber.equals(((String[])this.inputList.get(i + 1))[0]) && input[1].equals(((String[])this.inputList.get(i + 1))[1]) && (((String[])this.inputList.get(i + 1))[9] == null || "".equals(((String[])this.inputList.get(i + 1))[9]))) {
                    if (!((String[])this.inputList.get(i + 1))[15].equalsIgnoreCase("cheque") && !"dd".equalsIgnoreCase(((String[])this.inputList.get(i + 1))[15])) continue;
                    String[] nextRec = this.formatChequeDDValues((String[])this.inputList.get(i + 1));
                    nextRecords.add(nextRec);
                    ++i;
                }
            }
            if (this.validateExcel(input, nextRecords)) {
                Integer n = this.successNo;
                Integer n2 = this.successNo = Integer.valueOf(this.successNo + 1);
                continue;
            }
            LOGGER.debug((Object)("Challan row no: " + i + " not persisted due to some incomplete data!!!!"));
        }
        try {
            this.generateErrorReport();
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occrured while generating report : " + e.getMessage()));
        }
        return "success";
    }

    private boolean validateExcel(String[] inputArray, List<String[]> nextRecords) {
        String result;
        CFunction function;
        Date date;
        boolean valid = true;
        String errorMsgs = "";
        if (inputArray[0] == null || "".equals(inputArray[0])) {
            errorMsgs = (errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Challan Number is null/Empty", null)).equals("") ? errorMsgs + "Challan Date is null/Empty" : errorMsgs + ", Challan Date is null/Empty";
            LOGGER.debug((Object)"Challan Number is null/Empty");
            valid = false;
        }
        if (inputArray[1] == null || "".equals(inputArray[1])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Challan Date is null/Empty", null);
            LOGGER.debug((Object)"Challan Date is null/Empty");
            valid = false;
        }
        try {
            date = this.sdfInput.parse(inputArray[1]);
            this.collectionsUtil.getFinancialYearforDate(date);
        }
        catch (ParseException e) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Invalid Challan Date", inputArray[1]);
            valid = false;
        }
        catch (Exception ex) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "No financial year found for challan date", inputArray[1]);
            valid = false;
        }
        if (inputArray[5] == null || "".equals(inputArray[5])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Fund is null/Empty", null);
            LOGGER.debug((Object)"Fund is null/Empty");
            valid = false;
        } else {
            Fund fund = (Fund)this.persistenceService.find("from Fund  where name=? ", new Object[]{inputArray[5]});
            if (fund == null) {
                errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Incorrect value for fund", inputArray[5]);
                LOGGER.debug((Object)("Incorrect value for fund" + inputArray[5] + "]"));
                valid = false;
            }
        }
        if (inputArray[6] == null || "".equals(inputArray[6])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Department is null/Empty", null);
            LOGGER.debug((Object)"Department is null/Empty");
            valid = false;
        } else {
            Department dept = (Department)this.persistenceService.find("from Department d where d.deptName=? ", new Object[]{inputArray[6]});
            if (dept == null) {
                errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Incorrect value for Department", inputArray[6]);
                LOGGER.debug((Object)("Incorrect value for Department[ " + inputArray[6] + "]"));
                valid = false;
            }
        }
        if (inputArray[7] != null && !"".equals(inputArray[7]) && (function = (CFunction)this.persistenceService.find("from CFunction  where code=? ", new Object[]{inputArray[7]})) == null) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Incorrect value for Function", inputArray[7]);
            LOGGER.debug((Object)("Incorrect value for Function " + inputArray[7]));
            valid = false;
        }
        if (inputArray[8] == null || "".equals(inputArray[8])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Account Code is null/Empty", null);
            LOGGER.debug((Object)"Account Code is null/Empty");
            valid = false;
        } else {
            CChartOfAccounts account = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts  where glcode=? and isActiveForPosting=true", new Object[]{inputArray[8]});
            if (account == null) {
                errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Incorrect value for Account Code ", inputArray[8]);
                LOGGER.debug((Object)"Incorrect value for Account Code ");
                valid = false;
            } else {
                CChartOfAccountDetail chartOfAccountDetail = (CChartOfAccountDetail)this.persistenceService.find(" from CChartOfAccountDetail where glCodeId=(select id from CChartOfAccounts where glcode=? and isActiveForPosting=true)", new Object[]{inputArray[8]});
                if (null != chartOfAccountDetail && (inputArray[10] == null || "".equals(inputArray[10]))) {
                    errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "No Subledger Data provided for account Code", inputArray[8]);
                    LOGGER.debug((Object)"No Subledger Data provided for account Code ");
                    valid = false;
                }
                if (!(null == chartOfAccountDetail || inputArray[9] == null || "".equals(inputArray[9]) || inputArray[12] == null || "".equals(inputArray[12]) || inputArray[9].equals(inputArray[12]))) {
                    errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Account head Amount [" + inputArray[9] + "] is not same as Subledger Amount [" + inputArray[12] + "] for account Code [" + inputArray[8] + "]", null);
                    LOGGER.debug((Object)("Account head Amount [" + inputArray[9] + "] is not same as Subledger Amount [" + inputArray[12] + "] for account Code " + inputArray[8]));
                    valid = false;
                }
            }
        }
        if (inputArray[9] == null || "".equals(inputArray[9])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Account head Amount is null/Empty", null);
            LOGGER.debug((Object)"Account head Amount is null/Empty");
            valid = false;
        }
        if (inputArray[10] != null && !"".equals(inputArray[10])) {
            try {
                Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype  where name=? ", new Object[]{inputArray[10]});
                String table = accountdetailtype.getFullQualifiedName();
                Class<?> service = Class.forName(table);
                service.getSimpleName();
            }
            catch (Exception e) {
                errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Subledger account type not found", inputArray[10]);
                LOGGER.debug((Object)("Subledger account type not found for [" + inputArray[10] + "]"));
                valid = false;
            }
        }
        if (inputArray[10] != null && !"".equals(inputArray[10]) && (inputArray[11] == null || "".equals(inputArray[11]) || inputArray[12] == null || "".equals(inputArray[12]))) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Subledger Data is incomplete for account Code", inputArray[8]);
            LOGGER.debug((Object)" Subledger Data is incomplete for account Code ");
            valid = false;
        }
        if (inputArray[13] == null || "".equals(inputArray[13])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Receipt number is null/Empty", null);
            LOGGER.debug((Object)"Receipt number is null/Empty");
            valid = false;
        }
        if (inputArray[14] == null || "".equals(inputArray[14])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Receipt date is null/Empty", null);
            LOGGER.debug((Object)"Receipt date is null/Empty");
            valid = false;
        }
        try {
            date = this.sdfInput.parse(inputArray[14]);
            this.collectionsUtil.getFinancialYearforDate(date);
        }
        catch (ParseException e) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Invalid Receipt Date Format", inputArray[14]);
            valid = false;
        }
        catch (Exception ex) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "No financial year found for receipt date", inputArray[14]);
            valid = false;
        }
        if (inputArray[15] == null || "".equals(inputArray[15])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Payment Mode is null/Empty", null);
            LOGGER.debug((Object)"Payment Mode is null/Empty");
            valid = false;
        }
        if (inputArray[15] != null && ("cheque".equalsIgnoreCase(inputArray[15]) || "dd".equalsIgnoreCase(inputArray[15].toLowerCase())) && !"".equals(result = this.validateChequeDD(inputArray))) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, result, null);
            valid = false;
        }
        BigDecimal sumOfPayts = BigDecimal.valueOf(0L);
        if (inputArray[16] == null || "".equals(inputArray[16])) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Payment Amount is null/Empty", null);
            LOGGER.debug((Object)"Payment Amount is null/Empty");
            valid = false;
        } else {
            sumOfPayts = new BigDecimal(inputArray[16]);
        }
        boolean multipleChequesValid = true;
        if (nextRecords != null && !nextRecords.isEmpty()) {
            for (String[] nextRecord : nextRecords) {
                String result2;
                if (nextRecord[16] != null && !"".equals(nextRecord[16])) {
                    sumOfPayts = sumOfPayts.add(new BigDecimal(nextRecord[16]));
                }
                if ("".equals(result2 = this.validateChequeDD(nextRecord))) continue;
                multipleChequesValid = false;
                this.errorRowMap.put(Integer.valueOf(nextRecord[21]), result2);
            }
            if (sumOfPayts.compareTo(new BigDecimal(inputArray[9])) != 0) {
                errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Sum of Cheque/DD amounts do not tally with the total amount", null);
                valid = false;
            }
        }
        if (!valid) {
            this.errorRowMap.put(Integer.valueOf(inputArray[21]), errorMsgs);
        }
        return valid && multipleChequesValid;
    }

    private String getErrorMsg(String errorMsgs, String msg, String value) {
        StringBuilder tempmsg = new StringBuilder();
        tempmsg.append(msg);
        if (value != null) {
            tempmsg.append("[ " + value + " ]");
        }
        if (errorMsgs.equals("")) {
            return tempmsg.toString();
        }
        return ", " + tempmsg.toString();
    }

    private String validateChequeDD(String[] inputArray) {
        String errorMsgs = "";
        if (inputArray[16] == null || inputArray[16].equals("")) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Cheque/DD Payment Amount is null/empty", null);
            LOGGER.debug((Object)"Cheque/DD Payment Amount is null/empty");
        }
        if (inputArray[17] == null || inputArray[17].equals("")) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Cheque/DD Number is null/empty", null);
            LOGGER.debug((Object)"Cheque/DD Number is null/empty");
        } else if (inputArray[17].length() != 6) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Invalid Cheque/DD Number", inputArray[17]);
            LOGGER.debug((Object)("Invalid Cheque/DD Number [" + inputArray[17] + "]"));
        }
        if (inputArray[18] == null || inputArray[18].equals("")) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Cheque/DD Date is null/empty", null);
            LOGGER.debug((Object)"Cheque/DD Date is null/empty");
        } else {
            try {
                this.sdfInput.parse(inputArray[18]);
            }
            catch (ParseException e) {
                errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Invalid Cheque/DD Date", inputArray[18]);
            }
            LOGGER.debug((Object)("Invalid Cheque/DD Date [" + inputArray[18] + "]"));
        }
        if (inputArray[19] == null || inputArray[19].equals("")) {
            errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Cheque/DD Bank Name is null/empty", null);
            LOGGER.debug((Object)"Cheque/DD Bank Name is null/empty");
        } else {
            Bank bank = (Bank)this.persistenceService.find("from Bank where name=?", new Object[]{inputArray[19]});
            if (bank == null) {
                errorMsgs = errorMsgs + this.getErrorMsg(errorMsgs, "Incorrect value for Bank Name", inputArray[19]);
                LOGGER.debug((Object)("Incorrect value for Bank Name[" + inputArray[19] + "]"));
            }
        }
        return errorMsgs;
    }

    private ReceiptHeader saveChallan(ReceiptHeader receipt, String functionName) {
        receipt.getReceiptDetails().clear();
        ReceiptHeader receiptHeader = this.populateAndPersistChallanReceipt(receipt, functionName);
        Position position = this.collectionsUtil.getPositionOfUser(this.collectionsUtil.getLoggedInUser());
        this.challanService.workflowtransition(receiptHeader.getChallan(), position, "CHALLAN_VALIDATE", "Challan Upload-Phase1");
        this.challanService.getSession().flush();
        return receiptHeader;
    }

    @Transactional
    private ReceiptHeader populateAndPersistChallanReceipt(ReceiptHeader receiptHeader, String functionName) {
        receiptHeader.setService((ServiceDetails)this.persistenceService.findByNamedQuery("getServiceByCode", new Object[]{"CL"}));
        receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "PENDING"));
        receiptHeader.setIsReconciled(Boolean.TRUE);
        receiptHeader.setIsModifiable(Boolean.FALSE);
        receiptHeader.setReceipttype('C');
        receiptHeader.setPaidBy("CHAIRPERSON");
        receiptHeader.getReceiptMisc().setReceiptHeader(receiptHeader);
        BigDecimal debitamount = BigDecimal.ZERO;
        int m = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (ReceiptDetailInfo rDetails : this.billCreditDetailslist) {
            CChartOfAccounts account = this.chartOfAccountsHibernateDAO.getCChartOfAccountsByGlCode(rDetails.getGlcodeDetail());
            CFunction function = (CFunction)this.persistenceService.find("from CFunction  where code=? ", new Object[]{functionName});
            ReceiptDetail receiptDetail = new ReceiptDetail(account, function, rDetails.getCreditAmountDetail(), rDetails.getDebitAmountDetail(), null, Long.valueOf(m), null, null, receiptHeader);
            receiptDetail.setCramount(rDetails.getCreditAmountDetail());
            totalAmt = totalAmt.add(receiptDetail.getCramount()).subtract(receiptDetail.getDramount());
            CFinancialYear financialYear = this.financialYearDAO.getFinancialYearById(rDetails.getFinancialYearId());
            receiptDetail.setFinancialYear(financialYear);
            if (rDetails.getCreditAmountDetail() == null) {
                receiptDetail.setCramount(BigDecimal.ZERO);
            } else {
                receiptDetail.setCramount(rDetails.getCreditAmountDetail());
            }
            if (rDetails.getDebitAmountDetail() == null) {
                receiptDetail.setDramount(BigDecimal.ZERO);
            } else {
                receiptDetail.setDramount(rDetails.getDebitAmountDetail());
            }
            receiptDetail = this.setAccountPayeeDetails(this.subLedgerlist, receiptDetail);
            receiptHeader.addReceiptDetail(receiptDetail);
            debitamount = debitamount.add(rDetails.getCreditAmountDetail());
            debitamount = debitamount.subtract(rDetails.getDebitAmountDetail());
            ++m;
        }
        receiptHeader.setTotalAmount(totalAmt);
        if (receiptHeader.getChallan().getCreatedBy() == null) {
            receiptHeader.getChallan().setCreatedBy(this.collectionsUtil.getLoggedInUser());
        }
        receiptHeader.getChallan().setStatus(this.collectionsUtil.getStatusForModuleAndCode("Challan", "CREATED"));
        if (receiptHeader.getChallan().getService() != null && receiptHeader.getChallan().getService().getId() != null) {
            receiptHeader.getChallan().setService((ServiceDetails)this.persistenceService.findByNamedQuery("SERVICE_BY_ID", new Object[]{receiptHeader.getChallan().getService().getId()}));
        }
        this.receiptHeaderService.getSession().flush();
        LOGGER.info((Object)"Persisted Challan and Created Receipt In Pending State For the Challan");
        return receiptHeader;
    }

    public ReceiptDetail setAccountPayeeDetails(List<ReceiptDetailInfo> subLedgerlist, ReceiptDetail receiptDetail) {
        for (ReceiptDetailInfo subvoucherDetails : subLedgerlist) {
            if (subvoucherDetails.getGlcode() == null || subvoucherDetails.getGlcode().getId() == 0L || !subvoucherDetails.getGlcode().getId().equals(receiptDetail.getAccounthead().getId())) continue;
            Accountdetailtype accdetailtype = (Accountdetailtype)this.persistenceService.findByNamedQuery("getAccountDetailtypeById", new Object[]{subvoucherDetails.getDetailType().getId()});
            Accountdetailkey accdetailkey = (Accountdetailkey)this.persistenceService.findByNamedQuery("getAccountDetailkeyByDetailKey", new Object[]{subvoucherDetails.getDetailKeyId(), subvoucherDetails.getDetailType().getId()});
            AccountPayeeDetail accPayeeDetail = new AccountPayeeDetail(accdetailtype, accdetailkey, subvoucherDetails.getAmount(), receiptDetail);
            receiptDetail.addAccountPayeeDetail(accPayeeDetail);
        }
        return receiptDetail;
    }

    @Transactional
    private void createChallanReceipt(ReceiptHeader receiptHeader, String[] input, List<String[]> nextRecords) {
        if (receiptHeader.getReceiptHeader() != null) {
            this.collectionCommon.cancelChallanReceiptOnCreation(receiptHeader);
        }
        boolean setInstrument = true;
        List receiptInstrList = new ArrayList();
        this.chequeInstrumenttotal = BigDecimal.valueOf(0L);
        receiptHeader.setIsReconciled(Boolean.FALSE);
        receiptHeader.setIsModifiable(Boolean.TRUE);
        receiptHeader.setCollectiontype(Character.valueOf('C'));
        receiptHeader.setLocation(this.collectionsUtil.getLocationOfUser(this.getSession()));
        receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "APPROVED"));
        receiptHeader.setCreatedBy(this.collectionsUtil.getLoggedInUser());
        receiptHeader.setCreatedDate(receiptHeader.getManualreceiptdate());
        if (setInstrument) {
            receiptInstrList = this.populateInstrumentDetails(input, nextRecords);
            setInstrument = false;
        }
        receiptHeader.setReceiptInstrument(new HashSet(receiptInstrList));
        BigDecimal debitAmount = BigDecimal.ZERO;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            debitAmount = debitAmount.add(receiptDetail.getCramount());
        }
        receiptHeader.addReceiptDetail(this.collectionCommon.addDebitAccountHeadDetails(debitAmount, receiptHeader, this.chequeInstrumenttotal, this.cashOrCardInstrumenttotal, input[15]));
        if (this.chequeInstrumenttotal != null && this.chequeInstrumenttotal.compareTo(BigDecimal.ZERO) != 0) {
            receiptHeader.setTotalAmount(this.chequeInstrumenttotal);
        }
        if (this.cashOrCardInstrumenttotal != null && this.cashOrCardInstrumenttotal.compareTo(BigDecimal.ZERO) != 0) {
            receiptHeader.setTotalAmount(this.cashOrCardInstrumenttotal);
        }
        this.receiptHeaderService.persist(receiptHeader);
        this.receiptHeaderService.startWorkflow(receiptHeader);
        LOGGER.info((Object)"Workflow started for newly created receipts");
        ArrayList<CVoucherHeader> voucherHeaderList = new ArrayList<CVoucherHeader>(0);
        Set receiptVouchers = receiptHeader.getReceiptVoucher();
        for (ReceiptVoucher receiptVoucher : receiptVouchers) {
            try {
                voucherHeaderList.add(receiptVoucher.getVoucherheader());
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error in getting voucher header for id [" + receiptVoucher.getVoucherheader() + "]"), (Throwable)e);
            }
        }
        if (voucherHeaderList != null && receiptInstrList != null) {
            this.receiptHeaderService.updateInstrument(receiptHeader);
        }
    }

    private List<InstrumentHeader> populateInstrumentDetails(String[] input, List<String[]> nextRecords) {
        ArrayList<InstrumentHeader> instrumentHeaderList = new ArrayList<InstrumentHeader>();
        if ("cash".equals(input[15])) {
            InstrumentHeader instrHeaderCash = new InstrumentHeader();
            instrHeaderCash.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("cash"));
            instrHeaderCash.setIsPayCheque("0");
            instrHeaderCash.setInstrumentAmount(new BigDecimal(input[16]));
            this.cashOrCardInstrumenttotal = this.cashOrCardInstrumenttotal.add(instrHeaderCash.getInstrumentAmount());
            instrumentHeaderList.add(instrHeaderCash);
        }
        if ("cheque".equalsIgnoreCase(input[15]) || "dd".equalsIgnoreCase(input[15])) {
            instrumentHeaderList.add(this.populateInstrumentHeaderForChequeDD(input));
            if (nextRecords != null && !nextRecords.isEmpty()) {
                for (String[] nextRecord : nextRecords) {
                    instrumentHeaderList.add(this.populateInstrumentHeaderForChequeDD(nextRecord));
                }
            }
        }
        return instrumentHeaderList;
    }

    private InstrumentHeader populateInstrumentHeaderForChequeDD(String[] input) {
        InstrumentHeader instrumentHeader = new InstrumentHeader();
        instrumentHeader.setInstrumentAmount(new BigDecimal(input[16]));
        if (input[15].equalsIgnoreCase("cheque")) {
            instrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("cheque"));
        } else if (input[15].equalsIgnoreCase("dd")) {
            instrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("dd"));
        }
        instrumentHeader.setInstrumentNumber(input[17]);
        if (input[19] != null) {
            Bank bank = (Bank)this.persistenceService.find("from Bank where name=?", new Object[]{input[19]});
            instrumentHeader.setBankId(bank);
        }
        if (input[20] != null) {
            instrumentHeader.setBankBranchName(input[20]);
        }
        Date dt = new Date();
        if (input[18] != null) {
            try {
                dt = this.sdfInput.parse(input[18]);
            }
            catch (ParseException e) {
                LOGGER.debug((Object)("Error occured while parsing instrument date " + e.getMessage()));
            }
            instrumentHeader.setInstrumentDate(dt);
        }
        this.chequeInstrumenttotal = this.chequeInstrumenttotal.add(new BigDecimal(input[16]));
        instrumentHeader.setIsPayCheque("0");
        return instrumentHeader;
    }

    public String create() {
        return "success";
    }

    protected void readColumn() {
        try {
            HSSFRow row;
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this.getImportFile()));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            int cols = 0;
            int tmp = 0;
            for (int i = 0; i < 15 || i < rows; ++i) {
                row = sheet.getRow(i);
                if (row == null || (tmp = sheet.getRow(i).getPhysicalNumberOfCells()) <= cols) continue;
                cols = tmp;
            }
            for (int r = 3; r < rows; ++r) {
                row = sheet.getRow(r);
                if (row == null) continue;
                String[] inputArray = new String[22];
                for (int c = 0; c < 21; ++c) {
                    int ct;
                    HSSFCell cell = row.getCell(c);
                    inputArray[c] = cell == null ? "" : ((ct = cell.getCellType()) == 2 ? Double.toString(cell.getNumericCellValue()) : cell.toString());
                }
                inputArray[21] = String.valueOf(r + 1);
                this.inputList.add(inputArray);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)e.getMessage());
        }
    }

    private String[] formatValues(String[] inputArray) {
        Department dept;
        if (inputArray[0] != null && !"".equals(inputArray[0]) && inputArray[0].endsWith(".0")) {
            inputArray[0] = inputArray[0].substring(0, inputArray[0].indexOf(46));
        }
        if (inputArray[6] != null && !"".equals(inputArray[6]) && (dept = (Department)this.persistenceService.find("from Department d where d.deptName=? ", new Object[]{inputArray[6]})) != null) {
            String departmentCode = dept.getCode();
            Date date = new Date();
            try {
                if (inputArray[1] != null && !inputArray[1].equals("")) {
                    date = this.sdfInput.parse(inputArray[1]);
                }
            }
            catch (ParseException e) {
                LOGGER.debug((Object)e.getMessage());
            }
            inputArray[0] = departmentCode.concat("/" + this.sdfOutput.format(date) + "/" + inputArray[0]);
        }
        if (inputArray[7] != null && !"".equals(inputArray[7]) && inputArray[7].endsWith(".0")) {
            inputArray[7] = inputArray[7].substring(0, inputArray[7].indexOf(46));
        }
        if (inputArray[8] != null && !"".equals(inputArray[8])) {
            if (inputArray[8].endsWith(".0")) {
                inputArray[8] = inputArray[8].substring(0, inputArray[8].indexOf(46));
            }
            BigDecimal bd = new BigDecimal(inputArray[8]);
            inputArray[8] = bd.toPlainString();
        }
        if (inputArray[15] != null && !"".equals(inputArray[15])) {
            inputArray[15] = inputArray[15].toLowerCase();
        }
        if (inputArray[11] != null && !"".equals(inputArray[11]) && inputArray[11].endsWith(".0")) {
            inputArray[11] = inputArray[11].substring(0, inputArray[11].indexOf(46));
        }
        if (inputArray[17] != null && !inputArray[17].equals("") && inputArray[17].endsWith(".0")) {
            inputArray[17] = inputArray[17].substring(0, inputArray[17].indexOf(46));
        }
        if ((inputArray[15] != null && inputArray[15].equalsIgnoreCase("cheque") || inputArray[15].equalsIgnoreCase("dd")) && inputArray[18] != null && inputArray[18].equals("")) {
            inputArray[18] = inputArray[14];
        }
        return inputArray;
    }

    private String[] formatChequeDDValues(String[] inputArray) {
        if (inputArray[17] != null && !inputArray[17].equals("") && inputArray[17].endsWith(".0")) {
            inputArray[17] = inputArray[17].substring(0, inputArray[17].indexOf(46));
        }
        if ((inputArray[15] != null && inputArray[15].equalsIgnoreCase("cheque") || inputArray[15].equalsIgnoreCase("dd")) && inputArray[18] != null && inputArray[18].equals("")) {
            inputArray[18] = inputArray[14];
        }
        return inputArray;
    }

    @Transactional
    private ReceiptHeader initialiseValuesForSaveNew(String[] inputArray) {
        ReceiptHeader header = this.createReceiptHeader(inputArray);
        Challan challan = this.createChallan(header, inputArray);
        header.setChallan(challan);
        this.createCreditDetailslist(inputArray);
        try {
            if ("".equals(inputArray[10])) {
                this.createEmptySubLedgerlist();
            } else {
                this.createSubLedgerlist(inputArray);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Exception in initialising values during sub ledger list creation : " + e.getMessage()));
        }
        return header;
    }

    public ReceiptHeader createReceiptHeader(String[] input) {
        ReceiptHeader receiptHeader = new ReceiptHeader();
        receiptHeader.setReferenceDesc(input[4]);
        receiptHeader.setReceiptMisc(this.createReceiptMisc(receiptHeader, input));
        receiptHeader.setManualreceiptnumber(input[13]);
        Date date = null;
        try {
            date = this.sdfInput.parse(input[14]);
        }
        catch (ParseException e) {
            LOGGER.debug((Object)("Exception in parsing date : " + input[14] + " - " + e.getMessage()));
        }
        receiptHeader.setManualreceiptdate(date);
        receiptHeader.setVoucherDate(date);
        return receiptHeader;
    }

    public ReceiptMisc createReceiptMisc(ReceiptHeader receiptHeader, String[] inputArray) {
        ReceiptMisc receiptMisc = new ReceiptMisc();
        Fund fund = (Fund)this.persistenceService.find("from Fund  where name=? ", new Object[]{inputArray[5]});
        Department dept = (Department)this.persistenceService.find("from Department d where d.deptName=? ", new Object[]{inputArray[6]});
        receiptMisc.setDepartment(dept);
        receiptMisc.setFund(fund);
        receiptMisc.setReceiptHeader(receiptHeader);
        return receiptMisc;
    }

    public Challan createChallan(ReceiptHeader header, String[] inputArray) {
        Challan challan = new Challan();
        Date date = null;
        try {
            date = this.sdfInput.parse(inputArray[1]);
        }
        catch (ParseException e) {
            LOGGER.debug((Object)("Exception in parsing challan date : " + inputArray[1] + " - " + e.getMessage()));
        }
        challan.setChallanDate(date);
        challan.setChallanNumber(inputArray[0]);
        challan.setReceiptHeader(header);
        challan.setLastModifiedBy(this.collectionsUtil.getLoggedInUser());
        challan.setLastModifiedDate(date);
        return challan;
    }

    public void createCreditDetailslist(String[] inputArray) {
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        CChartOfAccounts account = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts  where glcode=? and isActiveForPosting=true", new Object[]{inputArray[8]});
        if (account != null) {
            vd.setAccounthead(account.getName());
            vd.setCreditAmountDetail(new BigDecimal(inputArray[9]));
            vd.setDebitAmountDetail(BigDecimal.ZERO);
            vd.setAmount(BigDecimal.ZERO);
            vd.setGlcodeDetail(account.getGlcode());
            vd.setGlcodeIdDetail(account.getId());
            CFinancialYear financialYear1011 = (CFinancialYear)this.persistenceService.find("from CFinancialYear  where finYearRange=? ", new Object[]{"2010-11"});
            vd.setFinancialYearId(financialYear1011.getId());
            this.billCreditDetailslist.add(vd);
        }
    }

    public List<ReceiptDetailInfo> createEmptySubLedgerlist() {
        ArrayList<ReceiptDetailInfo> subLedgerlist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setCreditAmountDetail(BigDecimal.ZERO);
        vd.setDebitAmountDetail(BigDecimal.ZERO);
        vd.setAmount(BigDecimal.ZERO);
        vd.setDetailCode("");
        vd.setDetailKey("");
        subLedgerlist.add(vd);
        return subLedgerlist;
    }

    public List<ReceiptDetailInfo> createSubLedgerlist(String[] inputArray) throws Exception {
        Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype  where upper(name)=? ", new Object[]{inputArray[10].toUpperCase()});
        CChartOfAccounts account = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts  where glcode=? and isActiveForPosting=true", new Object[]{inputArray[8]});
        if (accountdetailtype != null && account != null) {
            String table = accountdetailtype.getFullQualifiedName();
            Class<?> service = Class.forName(table);
            String simpleName = service.getSimpleName();
            simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + "Service";
            EntityTypeService entityService = (EntityTypeService)this.beanProvider.getBean(simpleName);
            List entityList = entityService.filterActiveEntities(inputArray[11], -1, accountdetailtype.getId());
            EntityType entityType = null;
            if (entityList.size() == 1) {
                entityType = (EntityType)entityList.get(0);
            }
            ReceiptDetailInfo vd = new ReceiptDetailInfo();
            vd.setCreditAmountDetail(BigDecimal.ZERO);
            vd.setDebitAmountDetail(BigDecimal.ZERO);
            vd.setAmount(new BigDecimal(inputArray[12]));
            vd.setDetailCode(inputArray[11]);
            vd.setDetailKey(entityType.getName());
            vd.setDetailKeyId(entityType.getEntityId());
            vd.setDetailType(accountdetailtype);
            vd.setDetailTypeName(inputArray[10]);
            vd.setGlcode(account);
            vd.setSubledgerCode(inputArray[8]);
            this.subLedgerlist.add(vd);
        }
        return this.subLedgerlist;
    }

    @Transactional
    public String createVouchers() {
        this.errorReceiptList.clear();
        List approvedReceipts = this.persistenceService.findAllBy("from org.egov.collection.entity.ReceiptHeader where status.code=?", new Object[]{"APPROVED"});
        ArrayList<CVoucherHeader> voucherHeaderList = new ArrayList<CVoucherHeader>(0);
        Set receiptVouchers = new HashSet(0);
        for (ReceiptHeader receiptHeader : approvedReceipts) {
            block4: {
                voucherHeaderList.clear();
                receiptVouchers.clear();
                if (!receiptHeader.getReceiptVoucher().isEmpty()) continue;
                try {
                    this.receiptHeaderService.createVoucherForReceipt(receiptHeader);
                    receiptVouchers = receiptHeader.getReceiptVoucher();
                    for (ReceiptVoucher receiptVoucher : receiptVouchers) {
                        voucherHeaderList.add(receiptVoucher.getVoucherheader());
                    }
                    ArrayList receiptInstrList = new ArrayList();
                    receiptInstrList.addAll(receiptHeader.getReceiptInstrument());
                    if (voucherHeaderList == null || receiptInstrList.isEmpty()) break block4;
                    this.receiptHeaderService.updateInstrument(receiptHeader);
                }
                catch (Exception e) {
                    this.errorReceiptList.add(receiptHeader.getId());
                    continue;
                }
            }
            Integer n = this.successNo;
            Integer n2 = this.successNo = Integer.valueOf(this.successNo + 1);
        }
        Collections.sort(this.errorReceiptList);
        return "vouchercreationresult";
    }

    public List<Long> getErrorReceiptList() {
        return this.errorReceiptList;
    }

    public void setErrorReceiptList(List<Long> errorReceiptList) {
        this.errorReceiptList = errorReceiptList;
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    public String getImportContentType() {
        return this.importContentType;
    }

    public void setImportContentType(String importContentType) {
        this.importContentType = importContentType;
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public String getImportfileCaption() {
        return this.importfileCaption;
    }

    public void setImportfileCaption(String importfileCaption) {
        this.importfileCaption = importfileCaption;
    }

    public Object getModel() {
        return null;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public Map<Integer, String> getErrorRowMap() {
        return this.errorRowMap;
    }

    public Integer getSuccessNo() {
        return this.successNo;
    }

    public void setSuccessNo(Integer successNo) {
        this.successNo = successNo;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }
}

