/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.citizen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.OnlinePayment;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.models.ServiceDetails;

@ParentPackage(value="egov")
@Results(value={@Result(name="success", location="searchOnlineReceipt.jsp")})
public class SearchOnlineReceiptAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private Long serviceTypeId = -1L;
    private Long referenceId;
    private Date fromDate;
    private Date toDate;
    private Integer searchTransactionStatus = -1;
    private List<OnlinePayment> results = new ArrayList(0);
    private String target = "new";

    public Object getModel() {
        return null;
    }

    public SearchOnlineReceiptAction() {
        this.addRelatedEntity("serviceType", ServiceDetails.class, "name");
    }

    @Action(value="/citizen/searchOnlineReceipt-reset")
    public String reset() {
        this.results = null;
        this.serviceTypeId = -1L;
        this.fromDate = null;
        this.toDate = null;
        this.searchTransactionStatus = -1;
        this.referenceId = null;
        return "success";
    }

    public void prepare() {
        super.prepare();
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("serviceTypeList", this.persistenceService.findAllByNamedQuery("getServiceCategoryForType", new Object[]{"B", Boolean.TRUE}));
    }

    @Action(value="/citizen/searchOnlineReceipt")
    public String execute() {
        return "success";
    }

    public List getOnlineReceiptStatuses() {
        return this.persistenceService.findAllByNamedQuery("getAllStatusesForModule", new Object[]{OnlinePayment.class.getSimpleName()});
    }

    public List getOnlineReceiptTransitionStatuses() {
        ArrayList<String> statusCodes = new ArrayList<String>();
        statusCodes.add("ONLINE_STATUS_SUCCESS");
        statusCodes.add("TO_BE_REFUNDED");
        statusCodes.add("ONLINE_STATUS_REFUNDED");
        return this.persistenceService.findAllByNamedQuery("getStatusesForModuleAndCodes", new Object[]{OnlinePayment.class.getSimpleName(), statusCodes});
    }

    @Action(value="/citizen/searchOnlineReceipt-search")
    public String search() {
        StringBuilder queryString = new StringBuilder(" select distinct onlinePayment from org.egov.collection.entity.OnlinePayment onlinePayment");
        StringBuilder criteria = new StringBuilder();
        StringBuilder joinString = new StringBuilder();
        StringBuilder whereString = new StringBuilder();
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        if (this.getReferenceId() != null) {
            criteria.append("onlinePayment.receiptHeader.id = ? ");
            params.add(this.getReferenceId());
        }
        if (this.getSearchTransactionStatus() != -1) {
            criteria.append(this.getJoinOperand(criteria)).append(" onlinePayment.status.id = ? ");
            params.add(this.getSearchTransactionStatus());
        }
        if (this.getFromDate() != null) {
            criteria.append(this.getJoinOperand(criteria)).append(" onlinePayment.createdDate >= ? ");
            params.add(this.fromDate);
        }
        if (this.getToDate() != null) {
            criteria.append(this.getJoinOperand(criteria)).append(" onlinePayment.createdDate <= ? ");
            Calendar newTodate = Calendar.getInstance();
            newTodate.setTime(this.toDate);
            newTodate.add(5, 1);
            params.add(newTodate.getTime());
        }
        if (this.getServiceTypeId() != -1L) {
            ServiceDetails servDet = (ServiceDetails)this.persistenceService.findByNamedQuery("getServiceDetailsByCategory", new Object[]{this.getServiceTypeId(), Boolean.TRUE});
            criteria.append(this.getJoinOperand(criteria)).append(" onlinePayment.receiptHeader.service.id = ? ");
            params.add(servDet.getId());
        }
        queryString.append(StringUtils.isBlank((String)joinString.toString()) ? "" : joinString);
        queryString.append(StringUtils.isBlank((String)criteria.toString()) ? "" : " where ").append((CharSequence)criteria);
        queryString.append((CharSequence)whereString);
        this.results = this.getPersistenceService().findAllBy(queryString.toString(), params.toArray());
        this.target = "searchresult";
        return "success";
    }

    private String getJoinOperand(StringBuilder criteria) {
        return StringUtils.isBlank((String)criteria.toString()) ? "" : " and ";
    }

    public List<OnlinePayment> getResults() {
        return this.results;
    }

    public Integer getSearchTransactionStatus() {
        return this.searchTransactionStatus;
    }

    public void setSearchTransactionStatus(Integer searchTransactionStatus) {
        this.searchTransactionStatus = searchTransactionStatus;
    }

    public Long getServiceTypeId() {
        return this.serviceTypeId;
    }

    public void setServiceTypeId(Long serviceType) {
        this.serviceTypeId = serviceType;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getTarget() {
        return this.target;
    }
}

