/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.web.struts.actions.ReportFormAction;

@Results(value={@Result(name={"index"}, location="onlineTransactionReport-index.jsp"), @Result(name={"report"}, location="receiptRegisterReport-report.jsp")})
public class OnlineTransactionReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_DEPT_ID = "EGOV_DEPT_ID";
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_BILLING_SERVICE_ID = "EGOV_BILLING_SERVICE_ID";
    private static final String EGOV_ONLINETRANSACTION_STATUS_ID = "EGOV_ONLINETRANSACTION_STATUS_ID";
    private CollectionsUtil collectionsUtil;

    public void prepare() {
        super.prepare();
        this.setReportFormat(ReportConstants.FileFormat.PDF);
        this.setDataSourceType(ReportRequest.ReportDataSourceType.SQL);
    }

    @Action(value="/reports/onlineTransactionReport-criteria")
    public String criteria() {
        this.addRelatedEntity("department", Department.class, "name");
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("serviceList", this.collectionsUtil.getBillingServiceList());
        this.addDropdownData("onlineTransactionStatusList", this.getOnlineReceiptStatuses());
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        return "index";
    }

    @Action(value="/reports/onlineTransactionReport-report")
    public String report() {
        return super.report();
    }

    private List<EgwStatus> getOnlineReceiptStatuses() {
        return this.persistenceService.findAllByNamedQuery("getAllStatusesForModule", new Object[]{OnlinePayment.class.getSimpleName()});
    }

    protected String getReportTemplateName() {
        return "online_transaction";
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Integer getDepartmentId() {
        return (Integer)this.getReportParam(EGOV_DEPT_ID);
    }

    public void setDepartmentId(Integer deptId) {
        this.setReportParam(EGOV_DEPT_ID, (Object)deptId);
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    public void setFromDate(Date fromDate) {
        this.setReportParam(EGOV_FROM_DATE, (Object)fromDate);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public void setToDate(Date toDate) {
        this.setReportParam(EGOV_TO_DATE, (Object)toDate);
    }

    public Long getBillingServiceId() {
        return (Long)this.getReportParam(EGOV_BILLING_SERVICE_ID);
    }

    public void setBillingServiceId(Long challanServiceId) {
        this.setReportParam(EGOV_BILLING_SERVICE_ID, (Object)challanServiceId);
    }

    public Long getStatusId() {
        return (Long)this.getReportParam(EGOV_ONLINETRANSACTION_STATUS_ID);
    }

    public void setStatusId(Long statusId) {
        this.setReportParam(EGOV_ONLINETRANSACTION_STATUS_ID, (Object)statusId);
    }
}

