/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"success"}, location="collectionsWorkflow-success.jsp"), @Result(name={"index"}, location="collectionsWorkflow-index.jsp"), @Result(name={"error"}, location="collectionsWorkflow-error.jsp"), @Result(name={"submissionReportCash"}, type="redirectAction", location="cashCollectionReport-submissionReport.action", params={"namespace", "/reports", "receiptDate", "${receiptDate}"}), @Result(name={"submissionReportCheque"}, type="redirectAction", location="chequeCollectionReport-submissionReport.action", params={"namespace", "/reports", "receiptDate", "${receiptDate}"}), @Result(name={"cancel"}, type="redirectAction", location="receipt", params={"namespace", "/receipts", "method", "cancel"})})
public class CollectionsWorkflowAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private List<ReceiptHeader> receiptHeaders;
    private Long[] receiptIds;
    private final Map<String, BigDecimal> instrumentWiseAmounts = new HashMap(4);
    private BigDecimal totalAmount;
    private Long counterId = -1L;
    private String userName;
    private String serviceCode;
    private CollectionsUtil collectionsUtil;
    private ReceiptHeaderService receiptHeaderService;
    @Autowired
    private UserService userservice;
    private String remarks;
    private String wfAction;
    private String receiptDate;
    private String approverName;
    protected static final String SUBMISSION_REPORT_CASH = "submissionReportCash";
    protected static final String SUBMISSION_REPORT_CHEQUE = "submissionReportCheque";
    @Autowired
    private SecurityUtils securityUtils;
    private String inboxItemDetails;

    public void setWfAction(String wfAction) {
        this.wfAction = wfAction;
    }

    public String getInboxItemDetails() {
        return this.inboxItemDetails;
    }

    public void setInboxItemDetails(String inboxItemDetails) {
        String[] params = inboxItemDetails.split("-", -1);
        if (params.length <= 6) {
            this.setWfAction(params[0]);
            this.setServiceCode(params[1]);
            this.setUserName(params[2]);
            this.setCounterId(Long.valueOf(params[4]));
            this.setReceiptDate(params[3]);
        }
        this.inboxItemDetails = inboxItemDetails;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public Boolean getIsSubmitAction() {
        return this.wfAction.equals("Submit for Approval");
    }

    public Boolean getAllowPartialSelection() {
        if (this.getIsSubmitAction().booleanValue()) {
            return false;
        }
        return true;
    }

    public Boolean getIsApproveAction() {
        return this.wfAction.equals("Approve");
    }

    public Boolean getIsRejectAction() {
        return this.wfAction.equals("Reject");
    }

    public Object getModel() {
        return null;
    }

    public Long getCounterId() {
        return this.counterId;
    }

    public void setCounterId(Long counterId) {
        this.counterId = counterId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public List<ReceiptHeader> getReceiptHeaders() {
        return this.receiptHeaders;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    private BigDecimal getInstrumentTypeAmount(String instrumentType) {
        BigDecimal amount = (BigDecimal)this.instrumentWiseAmounts.get(instrumentType);
        return amount == null ? BigDecimal.valueOf(0L) : amount;
    }

    public BigDecimal getCashAmount() {
        return this.getInstrumentTypeAmount("cash");
    }

    public BigDecimal getChequeAmount() {
        return this.getInstrumentTypeAmount("cheque");
    }

    public BigDecimal getDdAmount() {
        return this.getInstrumentTypeAmount("dd");
    }

    public BigDecimal getCardAmount() {
        return this.getInstrumentTypeAmount("card");
    }

    public BigDecimal getBankAmount() {
        return this.getInstrumentTypeAmount("bankchallan");
    }

    public void setReceiptIds(Long[] receiptIds) {
        this.receiptIds = receiptIds;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    private String updateReceiptWorkflowStatus(String wfAction, String remarks) {
        for (Long receiptId : this.receiptIds) {
            ReceiptHeader receiptHeader = (ReceiptHeader)this.receiptHeaderService.findByNamedQuery("RECEIPT_BY_ID_AND_STATUSNOTCANCELLED", new Object[]{receiptId});
            if (receiptHeader == null) continue;
            this.receiptHeaderService.performWorkflow(wfAction, receiptHeader, remarks);
            this.approverName = this.collectionsUtil.getApproverName(receiptHeader.getState().getOwnerPosition());
        }
        this.getSession().put("EGOV_RECEIPT_IDS", this.receiptIds);
        return "success";
    }

    private String updateReceiptWorkflowStatusForAll(String wfAction, String remarks) {
        Position position = this.collectionsUtil.getPositionOfUser(this.securityUtils.getCurrentUser());
        this.receiptHeaders = this.receiptHeaderService.findAllByPositionAndInboxItemDetails(position.getId(), this.inboxItemDetails);
        Position operatorPosition = this.receiptHeaderService.getOperatorPosition((ReceiptHeader)this.receiptHeaders.get(0));
        Position approverPosition = this.receiptHeaderService.getApproverPosition((ReceiptHeader)this.receiptHeaders.get(0));
        this.receiptIds = new Long[this.receiptHeaders.size()];
        int i = 0;
        for (ReceiptHeader receiptHeader : this.receiptHeaders) {
            if (receiptHeader != null) {
                this.receiptIds[i] = receiptHeader.getId();
            }
            ++i;
        }
        this.receiptHeaderService.performWorkflowForAllReceipts(wfAction, this.receiptHeaders, remarks, operatorPosition, approverPosition);
        this.approverName = this.collectionsUtil.getApproverName(position);
        this.getSession().put("EGOV_RECEIPT_IDS", this.receiptIds);
        return "success";
    }

    private void fetchReceipts(String workflowAction) {
        Position position = this.collectionsUtil.getPositionOfUser(this.securityUtils.getCurrentUser());
        this.receiptHeaders = this.receiptHeaderService.findAllByPositionAndInboxItemDetails(position.getId(), this.inboxItemDetails);
        int receiptCount = this.receiptHeaders.size();
        this.receiptIds = new Long[receiptCount];
        for (int i = 0; i < receiptCount; ++i) {
            this.receiptIds[i] = ((ReceiptHeader)this.receiptHeaders.get(i)).getId();
        }
        this.wfAction = workflowAction;
        this.calculateAmounts();
    }

    @Action(value="/receipts/collectionsWorkflow-listWorkflow")
    public String listWorkflow() {
        if (this.wfAction != null && this.wfAction.equals("Approve")) {
            this.fetchReceipts("Approve");
        } else {
            this.fetchReceipts("Submit for Approval");
        }
        return "index";
    }

    @Action(value="/receipts/collectionsWorkflow-submissionReportCash")
    public String submissionReportCash() {
        return SUBMISSION_REPORT_CASH;
    }

    @Action(value="/receipts/collectionsWorkflow-submissionReportCheque")
    public String submissionReportCheque() {
        return SUBMISSION_REPORT_CHEQUE;
    }

    @ValidationErrorPage(value="index")
    @Action(value="/receipts/collectionsWorkflow-submitCollections")
    public String submitCollections() {
        this.wfAction = "Submit for Approval";
        return this.updateReceiptWorkflowStatus(this.wfAction, this.remarks);
    }

    @ValidationErrorPage(value="index")
    @Action(value="/receipts/collectionsWorkflow-submitAllCollections")
    public String submitAllCollections() {
        this.setInboxItemDetails(this.inboxItemDetails);
        return this.updateReceiptWorkflowStatusForAll(this.wfAction, this.remarks);
    }

    @Action(value="/receipts/collectionsWorkflow-approveCollections")
    public String approveCollections() {
        this.wfAction = "Approve";
        return this.updateReceiptWorkflowStatus(this.wfAction, this.remarks);
    }

    @Action(value="/receipts/collectionsWorkflow-approveAllCollections")
    public String approveAllCollections() {
        this.setInboxItemDetails(this.inboxItemDetails);
        return this.updateReceiptWorkflowStatusForAll(this.wfAction, this.remarks);
    }

    @Action(value="/receipts/collectionsWorkflow-rejectCollections")
    public String rejectCollections() {
        this.wfAction = "Reject";
        return this.updateReceiptWorkflowStatus(this.wfAction, this.remarks);
    }

    private void calculateAmounts() {
        this.totalAmount = BigDecimal.ZERO;
        for (ReceiptHeader receiptHeader : this.receiptHeaders) {
            for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
                String instrumentType = instrumentHeader.getInstrumentType().getType();
                this.totalAmount = this.totalAmount.add(instrumentHeader.getInstrumentAmount()).setScale(2, 4);
                BigDecimal instrumentAmount = (BigDecimal)this.instrumentWiseAmounts.get(instrumentType);
                instrumentAmount = instrumentAmount == null ? instrumentHeader.getInstrumentAmount() : instrumentAmount.add(instrumentHeader.getInstrumentAmount());
                this.instrumentWiseAmounts.put(instrumentType, instrumentAmount.setScale(2, 4));
            }
            receiptHeader.setInstrumentsAsString(receiptHeader.getInstrumentDetailAsString());
        }
    }

    public String getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }

    public String getApproverName() {
        return this.approverName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }
}

