/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.collection.entity.CollectionBankRemittanceReport;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.service.RemittanceServiceImpl;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.web.actions.receipts.AjaxBankRemittanceAction;
import org.egov.collection.web.actions.receipts.BankRemittanceAction;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"new"}, location="bankRemittance-new.jsp"), @Result(name={"printBankChallan"}, type="redirectAction", location="remittanceStatementReport-printBankChallan.action", params={"namespace", "/reports", "totalCashAmount", "${totalCashAmount}", "totalChequeAmount", "${totalChequeAmount}", "totalOnlineAmount", "${totalOnlineAmount}", "bank", "${bank}", "bankAccount", "${bankAccount}", "remittanceDate", "${remittanceDate}"}), @Result(name={"index"}, location="bankRemittance-index.jsp")})
@ParentPackage(value="egov")
public class BankRemittanceAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BankRemittanceAction.class);
    private List<HashMap<String, Object>> paramList = null;
    private final ReceiptHeader receiptHeaderIntsance = new ReceiptHeader();
    private List<ReceiptHeader> voucherHeaderValues = new ArrayList(0);
    private String[] serviceNameArray;
    private String[] totalCashAmountArray;
    private String[] totalChequeAmountArray;
    private String[] totalCardAmountArray;
    private String[] receiptDateArray;
    private String[] receiptNumberArray;
    private String[] totalOnlineAmountArray;
    private String[] fundCodeArray;
    private String[] departmentCodeArray;
    private Integer accountNumberId;
    private CollectionsUtil collectionsUtil;
    private Integer branchId;
    private static final String ACCOUNT_NUMBER_LIST = "accountNumberList";
    private Boolean isListData = false;
    private Integer positionUser;
    private Integer designationId;
    private Date remittanceDate;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private BankaccountHibernateDAO bankaccountHibernateDAO;
    protected static final String PRINT_BANK_CHALLAN = "printBankChallan";
    private Double totalCashAmount;
    private Double totalChequeAmount;
    private Double totalOnlineAmount;
    private List<CollectionBankRemittanceReport> bankRemittanceList;
    private String bank;
    private String bankAccount;
    private Boolean showCardAndOnlineColumn = false;
    private Boolean showRemittanceDate = false;
    private Long finYearId;
    private RemittanceServiceImpl remittanceService;
    private String voucherNumber;
    private TreeMap<String, String> paymentModesMap = new TreeMap();
    private String paymentMode;

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    @Action(value="/receipts/bankRemittance-newform")
    @SkipValidation
    public String newform() {
        this.populateRemittanceList();
        return "new";
    }

    private void populateRemittanceList() {
        AjaxBankRemittanceAction ajaxBankRemittanceAction = new AjaxBankRemittanceAction();
        ajaxBankRemittanceAction.setPersistenceService(this.getPersistenceService());
        ajaxBankRemittanceAction.bankBranchListOfService();
        this.addDropdownData("bankBranchList", ajaxBankRemittanceAction.getBankBranchArrayList());
        if (this.branchId != null) {
            ajaxBankRemittanceAction.setBranchId(this.branchId);
            ajaxBankRemittanceAction.accountListOfService();
            this.addDropdownData(ACCOUNT_NUMBER_LIST, ajaxBankRemittanceAction.getBankAccountArrayList());
        } else {
            this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.EMPTY_LIST);
        }
        this.addDropdownData("financialYearList", this.financialYearDAO.getAllPriorFinancialYears(new Date()));
        1 paymentModes = new /* Unavailable Anonymous Inner Class!! */;
        this.paymentModesMap.putAll(paymentModes);
    }

    public String getJurisdictionBoundary() {
        User user = this.collectionsUtil.getLoggedInUser();
        Employee employee = this.employeeService.getEmployeeById(user.getId());
        StringBuilder jurValuesId = new StringBuilder();
        for (Jurisdiction element : employee.getJurisdictions()) {
            if (jurValuesId.length() > 0) {
                jurValuesId.append(',');
            }
            jurValuesId.append(element.getBoundary().getId());
            for (Boundary boundary : element.getBoundary().getChildren()) {
                jurValuesId.append(',');
                jurValuesId.append(boundary.getId());
            }
        }
        return jurValuesId.toString();
    }

    @Action(value="/receipts/bankRemittance-listData")
    @SkipValidation
    public String listData() {
        this.isListData = true;
        this.populateRemittanceList();
        String serviceFundQueryStr = "select distinct sd.code as servicecode,fd.code as fundcode from BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.BANKACCOUNT=ba.ID and asm.servicedetails=sd.ID and fd.ID=ba.FUNDID and ba.id=" + this.accountNumberId;
        SQLQuery serviceFundQuery = this.persistenceService.getSession().createSQLQuery(serviceFundQueryStr);
        List queryResults = serviceFundQuery.list();
        ArrayList<String> serviceCodeList = new ArrayList<String>(0);
        ArrayList<String> fundCodeList = new ArrayList<String>(0);
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            serviceCodeList.add(arrayObjectInitialIndex[0].toString());
            fundCodeList.add(arrayObjectInitialIndex[1].toString());
        }
        CFinancialYear financialYear = this.financialYearDAO.getFinancialYearById(this.finYearId);
        this.paramList = this.remittanceService.findAllRemittanceDetailsForServiceAndFund(this.getJurisdictionBoundary(), "'" + StringUtils.join(serviceCodeList, (String)"','") + "'", "'" + StringUtils.join(fundCodeList, (String)"','") + "'", financialYear.getStartingDate(), financialYear.getEndingDate(), this.paymentMode);
        return "new";
    }

    @Action(value="/receipts/bankRemittance-printBankChallan")
    @SkipValidation
    public String printBankChallan() {
        return PRINT_BANK_CHALLAN;
    }

    public String edit() {
        return "edit";
    }

    public String save() {
        return "success";
    }

    public void prepare() {
        String showRemitDate;
        super.prepare();
        String showColumn = this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_SHOWCOLUMNSCARDONLINE");
        if (!showColumn.isEmpty() && showColumn.equals("Y")) {
            this.showCardAndOnlineColumn = true;
        }
        if (!(showRemitDate = this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_SHOWREMITDATE")).isEmpty() && showRemitDate.equals("Y")) {
            this.showRemittanceDate = true;
        }
        this.addDropdownData("bankBranchList", Collections.EMPTY_LIST);
        this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.EMPTY_LIST);
    }

    @Action(value="/receipts/bankRemittance-create")
    @ValidationErrorPage(value="new")
    public String create() throws InstantiationException, IllegalAccessException {
        long startTimeMillis = System.currentTimeMillis();
        BigInteger accountNumber = null;
        String serviceName = "";
        String fundCode = "";
        for (int i = 0; i < this.getServiceNameArray().length; ++i) {
            if (this.getServiceNameArray() == null || this.getServiceNameArray()[i].isEmpty()) continue;
            serviceName = this.getServiceNameArray()[i];
            fundCode = this.getFundCodeArray()[i];
            break;
        }
        String bankAccountStr = "select distinct asm.BANKACCOUNT from BANKACCOUNT ba,EGCL_BANKACCOUNTSERVICEMAPPING asm,EGCL_SERVICEDETAILS sd,FUND fd where asm.BANKACCOUNT=ba.ID and asm.servicedetails=sd.ID and fd.ID=ba.FUNDID and sd.name= '" + serviceName + "'  and fd.code='" + fundCode + "'";
        SQLQuery bankAccountQry = this.persistenceService.getSession().createSQLQuery(bankAccountStr);
        if (bankAccountQry.list().size() > 1) {
            throw new ValidationException(Arrays.asList(new ValidationError("Mulitple Bank Accounts for the same Service and Fund is mapped. Please correct the data", "bankremittance.error.multiplebankaccounterror")));
        }
        Object queryResults = bankAccountQry.uniqueResult();
        accountNumber = (BigInteger)queryResults;
        this.accountNumberId = accountNumber != null ? accountNumber.intValue() : this.accountNumberId.intValue();
        if (accountNumber == null || accountNumber.equals(-1) || accountNumber != null && accountNumber.intValue() != this.accountNumberId.intValue()) {
            throw new ValidationException(Arrays.asList(new ValidationError("Bank Account for the Service and Fund is not mapped", "bankremittance.error.bankaccounterror")));
        }
        this.voucherHeaderValues = this.remittanceService.createBankRemittance(this.getServiceNameArray(), this.getTotalCashAmountArray(), this.getTotalChequeAmountArray(), this.getTotalCardAmountArray(), this.getTotalOnlineAmountArray(), this.getReceiptDateArray(), this.getFundCodeArray(), this.getDepartmentCodeArray(), this.accountNumberId, this.positionUser, this.getReceiptNumberArray(), this.remittanceDate);
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        LOGGER.info((Object)("$$$$$$ Time taken to persist the remittance list (ms) = " + elapsedTimeMillis));
        this.bankRemittanceList = this.remittanceService.prepareBankRemittanceReport(this.voucherHeaderValues);
        if (this.getSession().get("REMITTANCE_LIST") != null) {
            this.getSession().remove("REMITTANCE_LIST");
        }
        this.getSession().put("REMITTANCE_LIST", this.bankRemittanceList);
        Bankaccount bankAcc = this.bankaccountHibernateDAO.findById((Number)this.accountNumberId, false);
        this.bankAccount = bankAcc.getAccountnumber();
        this.bank = bankAcc.getBankbranch().getBank().getName();
        this.totalCashAmount = this.getSum(this.getTotalCashAmountArray());
        this.totalChequeAmount = this.getSum(this.getTotalChequeAmountArray());
        this.totalOnlineAmount = this.getSum(this.getTotalOnlineAmountArray());
        return "index";
    }

    private Double getSum(String[] array) {
        Double sum = 0.0;
        for (String num : array) {
            if (num.isEmpty()) continue;
            sum = sum + Double.valueOf(num);
        }
        return sum;
    }

    public void validate() {
        String[] filterReceiptDateArray;
        String receiptEndDate;
        super.validate();
        this.populateRemittanceList();
        this.listData();
        SimpleDateFormat dateFomatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        if (this.receiptDateArray != null && !(receiptEndDate = (filterReceiptDateArray = this.removeNullValue(this.receiptDateArray))[filterReceiptDateArray.length - 1]).isEmpty()) {
            try {
                if (this.remittanceDate != null && this.remittanceDate.before(dateFomatter.parse(receiptEndDate))) {
                    this.addActionError(this.getText("bankremittance.before.receiptdate"));
                }
            }
            catch (ParseException e) {
                LOGGER.debug((Object)("Exception in parsing date  " + receiptEndDate + " - " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception while parsing receiptEndDate date", (Throwable)e);
            }
        }
    }

    private String[] removeNullValue(String[] receiptDateArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : receiptDateArray) {
            if (s == null || s.length() <= 0) continue;
            list.add(s);
        }
        receiptDateArray = list.toArray(new String[list.size()]);
        return receiptDateArray;
    }

    public Object getModel() {
        return this.receiptHeaderIntsance;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
    }

    public List<HashMap<String, Object>> getParamList() {
        return this.paramList;
    }

    public void setParamList(List<HashMap<String, Object>> paramList) {
        this.paramList = paramList;
    }

    public String[] getServiceNameArray() {
        return this.serviceNameArray;
    }

    public void setServiceNameArray(String[] serviceNameArray) {
        this.serviceNameArray = serviceNameArray;
    }

    public String[] getTotalCashAmountArray() {
        return this.totalCashAmountArray;
    }

    public void setTotalCashAmountArray(String[] totalCashAmountArray) {
        this.totalCashAmountArray = totalCashAmountArray;
    }

    public String[] getTotalChequeAmountArray() {
        return this.totalChequeAmountArray;
    }

    public void setTotalChequeAmountArray(String[] totalChequeAmountArray) {
        this.totalChequeAmountArray = totalChequeAmountArray;
    }

    public String[] getReceiptDateArray() {
        return this.receiptDateArray;
    }

    public void setReceiptDateArray(String[] receiptDateArray) {
        this.receiptDateArray = receiptDateArray;
    }

    public List<ReceiptHeader> getVoucherHeaderValues() {
        return this.voucherHeaderValues;
    }

    public void setVoucherHeaderValues(List<ReceiptHeader> voucherHeaderValues) {
        this.voucherHeaderValues = voucherHeaderValues;
    }

    public String[] getTotalOnlineAmountArray() {
        return this.totalOnlineAmountArray;
    }

    public void setTotalOnlineAmountArray(String[] totalOnlineAmountArray) {
        this.totalOnlineAmountArray = totalOnlineAmountArray;
    }

    public String[] getFundCodeArray() {
        return this.fundCodeArray;
    }

    public void setFundCodeArray(String[] fundCodeArray) {
        this.fundCodeArray = fundCodeArray;
    }

    public String[] getDepartmentCodeArray() {
        return this.departmentCodeArray;
    }

    public void setDepartmentCodeArray(String[] departmentCodeArray) {
        this.departmentCodeArray = departmentCodeArray;
    }

    public String[] getTotalCardAmountArray() {
        return this.totalCardAmountArray;
    }

    public void setTotalCardAmountArray(String[] totalCardAmountArray) {
        this.totalCardAmountArray = totalCardAmountArray;
    }

    public Integer getPositionUser() {
        return this.positionUser;
    }

    public void setPositionUser(Integer positionUser) {
        this.positionUser = positionUser;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String[] getReceiptNumberArray() {
        return this.receiptNumberArray;
    }

    public void setReceiptNumberArray(String[] receiptNumberArray) {
        this.receiptNumberArray = receiptNumberArray;
    }

    public Integer getBranchId() {
        return this.branchId;
    }

    public void setBranchId(Integer branchId) {
        this.branchId = branchId;
    }

    public Integer getAccountNumberId() {
        return this.accountNumberId;
    }

    public void setAccountNumberId(Integer accountNumberId) {
        this.accountNumberId = accountNumberId;
    }

    public Boolean getIsListData() {
        return this.isListData;
    }

    public void setIsListData(Boolean isListData) {
        this.isListData = isListData;
    }

    public Double getTotalCashAmount() {
        return this.totalCashAmount;
    }

    public void setTotalCashAmount(Double totalCashAmount) {
        this.totalCashAmount = totalCashAmount;
    }

    public Double getTotalChequeAmount() {
        return this.totalChequeAmount;
    }

    public void setTotalChequeAmount(Double totalChequeAmount) {
        this.totalChequeAmount = totalChequeAmount;
    }

    public Double getTotalOnlineAmount() {
        return this.totalOnlineAmount;
    }

    public void setTotalOnlineAmount(Double totalOnlineAmount) {
        this.totalOnlineAmount = totalOnlineAmount;
    }

    public List<CollectionBankRemittanceReport> getBankRemittanceList() {
        return this.bankRemittanceList;
    }

    public void setBankRemittanceList(List<CollectionBankRemittanceReport> bankRemittanceList) {
        this.bankRemittanceList = bankRemittanceList;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Boolean getShowCardAndOnlineColumn() {
        return this.showCardAndOnlineColumn;
    }

    public void setShowCardAndOnlineColumn(Boolean showCardAndOnlineColumn) {
        this.showCardAndOnlineColumn = showCardAndOnlineColumn;
    }

    public Boolean getShowRemittanceDate() {
        return this.showRemittanceDate;
    }

    public void setShowRemittanceDate(Boolean showRemittanceDate) {
        this.showRemittanceDate = showRemittanceDate;
    }

    public Date getRemittanceDate() {
        return this.remittanceDate;
    }

    public void setRemittanceDate(Date remittanceDate) {
        this.remittanceDate = remittanceDate;
    }

    public Long getFinYearId() {
        return this.finYearId;
    }

    public void setFinYearId(Long finYearId) {
        this.finYearId = finYearId;
    }

    public void setRemittanceService(RemittanceServiceImpl remittanceService) {
        this.remittanceService = remittanceService;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public TreeMap<String, String> getPaymentModesMap() {
        return this.paymentModesMap;
    }

    public void setPaymentModesMap(TreeMap<String, String> paymentModesMap) {
        this.paymentModesMap = paymentModesMap;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }
}

