/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"success"}, location="searchReceipt.jsp")})
public class SearchReceiptAction
extends SearchFormAction {
    private static final long serialVersionUID = 1L;
    private Integer serviceTypeId = -1;
    private Long userId = -1L;
    private String instrumentType;
    private String receiptNumber;
    private Date fromDate;
    private Date toDate;
    private Integer searchStatus = -1;
    private String target = "new";
    private String manualReceiptNumber;
    private List resultList;
    private String serviceClass = "-1";
    private TreeMap<String, String> serviceClassMap = new TreeMap();
    @Autowired
    private EisCommonService eisCommonService;

    public Object getModel() {
        return null;
    }

    public Integer getServiceTypeId() {
        return this.serviceTypeId;
    }

    public void setServiceTypeId(Integer serviceType) {
        this.serviceTypeId = serviceType;
    }

    public String getInstrumentType() {
        return this.instrumentType;
    }

    public void setInstrumentType(String instrumentType) {
        this.instrumentType = instrumentType;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    @Action(value="/receipts/searchReceipt-reset")
    public String reset() {
        this.setPage(1);
        this.serviceTypeId = -1;
        this.userId = -1L;
        this.receiptNumber = "";
        this.fromDate = null;
        this.toDate = null;
        this.instrumentType = "";
        this.searchStatus = -1;
        this.manualReceiptNumber = "";
        this.serviceClass = "-1";
        return "success";
    }

    public void prepare() {
        super.prepare();
        this.setupDropdownDataExcluding(new String[0]);
        this.addDropdownData("instrumentTypeList", this.getPersistenceService().findAllBy("from InstrumentType i where i.isActive = true order by type", new Object[0]));
        this.addDropdownData("userList", this.getPersistenceService().findAllByNamedQuery("CREATEDBYUSERS_OF_RECEIPTS", new Object[0]));
        this.serviceClassMap.putAll(CollectionConstants.SERVICE_TYPE_CLASSIFICATION);
        this.serviceClassMap.remove("P");
        this.addDropdownData("serviceTypeList", Collections.EMPTY_LIST);
    }

    @Action(value="/receipts/searchReceipt")
    public String execute() {
        return "success";
    }

    public List getReceiptStatuses() {
        return this.persistenceService.findAllBy("from EgwStatus s where moduletype=? and code != ? order by description", new Object[]{ReceiptHeader.class.getSimpleName(), "PENDING"});
    }

    @Action(value="/receipts/searchReceipt-search")
    public String search() {
        this.target = "searchresult";
        super.search();
        ArrayList receiptList = new ArrayList();
        receiptList.addAll(this.searchResult.getList());
        this.searchResult.getList().clear();
        if (this.getServiceClass() != "-1") {
            this.addDropdownData("serviceTypeList", this.getPersistenceService().findAllByNamedQuery("getServicesByType", new Object[]{this.getServiceClass()}));
        }
        Long posId = null;
        for (ReceiptHeader receiptHeader : receiptList) {
            if (receiptHeader.getState() != null && receiptHeader.getState().getOwnerPosition() != null) {
                posId = receiptHeader.getState().getOwnerPosition().getId();
                User user = null;
                user = this.eisCommonService.getUserForPosition(posId, receiptHeader.getCreatedDate());
                receiptHeader.setWorkflowUserName(user.getUsername());
            }
            this.searchResult.getList().add(receiptHeader);
        }
        this.resultList = this.searchResult.getList();
        return "success";
    }

    public String getTarget() {
        return this.target;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public SearchQuery prepareQuery(String sortField, String sortDir) {
        ArrayList<Object> params = new ArrayList<Object>(0);
        StringBuilder searchQueryString = new StringBuilder("select distinct receipt ");
        StringBuilder countQueryString = new StringBuilder("select count(distinct receipt) ");
        StringBuilder fromString = new StringBuilder(" from org.egov.collection.entity.ReceiptHeader receipt ");
        String orderByString = " group by receipt.receiptdate,receipt.id  order by receipt.receiptdate desc";
        StringBuilder criteriaString = new StringBuilder(" where receipt.status.code != ? ");
        params.add("PENDING");
        if (StringUtils.isNotBlank((String)this.getInstrumentType())) {
            fromString.append(" inner join receipt.receiptInstrument as instruments ");
            criteriaString.append(" and instruments.instrumentType.type = ? ");
            params.add(this.getInstrumentType());
        }
        if (StringUtils.isNotBlank((String)this.getReceiptNumber())) {
            criteriaString.append(" and upper(receiptNumber) like ? ");
            params.add("%" + this.getReceiptNumber().toUpperCase() + "%");
        }
        if (StringUtils.isNotBlank((String)this.getManualReceiptNumber())) {
            criteriaString.append(" and upper(receipt.manualreceiptnumber) like ? ");
            params.add("%" + this.getManualReceiptNumber().toUpperCase() + "%");
        }
        if (this.getSearchStatus() != -1) {
            criteriaString.append(" and receipt.status.id = ? ");
            params.add(this.getSearchStatus());
        }
        if (this.getFromDate() != null) {
            criteriaString.append(" and receipt.receiptdate >= ? ");
            params.add(this.fromDate);
        }
        if (this.getToDate() != null) {
            criteriaString.append(" and receipt.receiptdate < ? ");
            params.add(DateUtils.add((Date)this.toDate, (int)5, (int)1));
        }
        if (this.getServiceTypeId() != -1) {
            criteriaString.append(" and receipt.service.id = ? ");
            params.add(Long.valueOf(this.getServiceTypeId().intValue()));
        }
        if (this.getServiceClass() != "-1") {
            criteriaString.append(" and receipt.service.serviceType = ? ");
            params.add(this.getServiceClass());
        }
        if (this.getUserId() != -1L) {
            criteriaString.append(" and receipt.createdBy.id = ? ");
            params.add(this.userId);
        }
        String searchQuery = searchQueryString.append((CharSequence)fromString).append((CharSequence)criteriaString).append(" group by receipt.receiptdate,receipt.id  order by receipt.receiptdate desc").toString();
        String countQuery = countQueryString.append((CharSequence)fromString).append((CharSequence)criteriaString).toString();
        return new SearchQueryHQL(searchQuery, countQuery, params);
    }

    public Integer getSearchStatus() {
        return this.searchStatus;
    }

    public void setSearchStatus(Integer searchStatus) {
        this.searchStatus = searchStatus;
    }

    public SearchQuery prepareQuery() {
        return null;
    }

    public String getManualReceiptNumber() {
        return this.manualReceiptNumber;
    }

    public void setManualReceiptNumber(String manualReceiptNumber) {
        this.manualReceiptNumber = manualReceiptNumber;
    }

    public List getResultList() {
        return this.resultList;
    }

    public void setResultList(List resultList) {
        this.resultList = resultList;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public TreeMap<String, String> getServiceClassMap() {
        return this.serviceClassMap;
    }

    public void setServiceClassMap(TreeMap<String, String> serviceClassMap) {
        this.serviceClassMap = serviceClassMap;
    }
}

