/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.entity.CollectionBankRemittanceReport;
import org.egov.collection.entity.CollectionRemittanceReportResult;
import org.egov.collection.entity.Remittance;
import org.egov.collection.entity.RemittanceDetail;
import org.egov.collection.service.RemittanceServiceImpl;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.egov.model.masters.AccountCodePurpose;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"index"}, location="remittanceStatementReport-index.jsp"), @Result(name={"report"}, location="remittanceStatementReport-report.jsp")})
@ParentPackage(value="egov")
public class RemittanceStatementReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private CollectionsUtil collectionsUtil;
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_SERVICE_ID = "EGOV_SERVICE_ID";
    private static final String EGOV_FUND_ID = "EGOV_FUND_ID";
    private static final String EGOV_BANKBRANCH_ID = "EGOV_BANKBRANCH_ID";
    private static final String EGOV_BANKACCOUNT_ID = "EGOV_BANKACCOUNT_ID";
    private static final String EGOV_PAYMENT_MODE = "EGOV_PAYMENT_MODE";
    private static final String SELECTED_DEPT_ID = "SELECTED_DEPT_ID";
    private static final String EGOV_DEPT_ID = "EGOV_DEPT_ID";
    private static final String EGOV_CASH_AMOUNT = "EGOV_CASH_AMOUNT";
    private static final String EGOV_CHEQUE_AMOUNT = "EGOV_CHEQUE_AMOUNT";
    private static final String EGOV_BANK = "EGOV_BANK";
    private static final String EGOV_BANK_ACCOUNT = "EGOV_BANK_ACCOUNT";
    private static final String EGOV_REMITTANCE_VOUCHER = "EGOV_REMITTANCE_VOUCHER";
    private static final String EGOV_REMITTANCE_DATE = "EGOV_REMITTANCE_DATE";
    private static final String PRINT_BANK_CHALLAN_TEMPLATE = "collection_remittance_bankchallan_report";
    private final Map<String, Object> critParams = new HashMap(0);
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    private String reportId;
    private final Map<String, String> paymentModes = this.createPaymentModeList();
    private List<CollectionBankRemittanceReport> bankRemittanceList;
    private Double totalCashAmount;
    private Double totalChequeAmount;
    private String bank;
    private String bankAccount;
    private Date remittanceDate;
    private String voucherNumber;
    private RemittanceServiceImpl remittanceService;

    public void prepare() {
        this.setReportFormat(ReportConstants.FileFormat.PDF);
        this.setDataSourceType(ReportRequest.ReportDataSourceType.SQL);
    }

    @Action(value="/reports/remittanceStatementReport-criteria")
    public String criteria() {
        this.addDropdownData("collectionServiceList", this.persistenceService.findAllByNamedQuery("getCollectionServices", new Object[0]));
        this.addDropdownData("collectionFundList", this.persistenceService.findAllByNamedQuery("getAllFund", new Object[0]));
        this.critParams.put(EGOV_FROM_DATE, new Date());
        this.critParams.put(EGOV_TO_DATE, new Date());
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("bankAccountList", Collections.EMPTY_LIST);
        User user = this.collectionsUtil.getLoggedInUser();
        ArrayList<Boundary> boundaryList = new ArrayList<Boundary>();
        Employee employee = this.employeeService.getEmployeeById(user.getId());
        if (employee != null) {
            for (Jurisdiction element : employee.getJurisdictions()) {
                boundaryList.add(element.getBoundary());
            }
        }
        this.addDropdownData("boundaryList", boundaryList);
        return "index";
    }

    @Action(value="/reports/remittanceStatementReport-report")
    public String report() {
        User user = this.collectionsUtil.getLoggedInUser();
        this.critParams.put(SELECTED_DEPT_ID, this.getDeptId());
        Integer bounaryId = this.getDeptId();
        StringBuilder jurValuesId = new StringBuilder();
        jurValuesId.append(bounaryId);
        new ArrayList();
        Employee employee = this.employeeService.getEmployeeById(user.getId());
        if (employee != null) {
            for (Jurisdiction element : employee.getJurisdictions()) {
                if (jurValuesId.length() > 0) {
                    jurValuesId.append(',');
                }
                jurValuesId.append(element.getBoundary().getId());
                for (Boundary boundary : element.getBoundary().getChildren()) {
                    jurValuesId.append(',');
                    jurValuesId.append(boundary.getId());
                }
            }
        }
        if (null == jurValuesId.toString() || StringUtils.isEmpty((CharSequence)jurValuesId.toString()) || "-1".equals(jurValuesId.toString())) {
            this.critParams.put(EGOV_DEPT_ID, null);
        } else {
            this.critParams.put(EGOV_DEPT_ID, jurValuesId.toString());
        }
        ReportRequest reportInput = new ReportRequest(this.getReportTemplateName(), this.critParams, ReportRequest.ReportDataSourceType.SQL);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return "report";
    }

    @Action(value="/reports/remittanceStatementReport-printBankChallan")
    public String printBankChallan() {
        this.critParams.put(EGOV_CASH_AMOUNT, this.totalCashAmount);
        this.critParams.put(EGOV_CHEQUE_AMOUNT, this.totalChequeAmount);
        this.critParams.put(EGOV_BANK, this.bank);
        this.critParams.put(EGOV_BANK_ACCOUNT, this.bankAccount);
        this.critParams.put(EGOV_REMITTANCE_DATE, this.remittanceDate == null ? new Date() : this.remittanceDate);
        CollectionRemittanceReportResult collReportResult = new CollectionRemittanceReportResult();
        this.bankRemittanceList = (List)this.getSession().get("REMITTANCE_LIST");
        this.critParams.put(EGOV_REMITTANCE_VOUCHER, this.bankRemittanceList.isEmpty() ? "" : ((CollectionBankRemittanceReport)this.bankRemittanceList.get(0)).getVoucherNumber());
        collReportResult.setCollectionBankRemittanceReportList(this.bankRemittanceList);
        ReportRequest reportInput = new ReportRequest(PRINT_BANK_CHALLAN_TEMPLATE, (Object)collReportResult, this.critParams);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return "report";
    }

    @Action(value="/reports/remittanceStatementReport-reportPrintBankChallan")
    public String reportPrintBankChallan() {
        Remittance remittanceObj = (Remittance)this.persistenceService.findByNamedQuery("getRemitanceByVoucherNumber", new Object[]{this.voucherNumber});
        ArrayList remittanceList = new ArrayList(remittanceObj.getCollectionRemittance());
        double totalCashAmt = 0.0;
        double totalChequeAmt = 0.0;
        this.bankRemittanceList = this.remittanceService.prepareBankRemittanceReport(remittanceList);
        for (RemittanceDetail rd : remittanceObj.getRemittanceDetails()) {
            if (rd.getChartOfAccount().getPurposeId() == this.getAccountCodePurpose("Cash In Hand").getId()) {
                totalCashAmt = rd.getCreditAmount().doubleValue();
            }
            if (!rd.getChartOfAccount().getPurposeId().equals(this.getAccountCodePurpose("Cheque In Hand").getId())) continue;
            totalChequeAmt = rd.getCreditAmount().doubleValue();
        }
        this.critParams.put(EGOV_CASH_AMOUNT, totalCashAmt);
        this.critParams.put(EGOV_CHEQUE_AMOUNT, totalChequeAmt);
        this.critParams.put(EGOV_REMITTANCE_VOUCHER, remittanceObj == null ? "" : remittanceObj.getReferenceNumber());
        this.critParams.put(EGOV_REMITTANCE_DATE, remittanceObj == null ? new Date() : remittanceObj.getReferenceDate());
        this.critParams.put(EGOV_BANK, remittanceObj.getBankAccount() != null ? remittanceObj.getBankAccount().getBankbranch().getBank().getName() : "");
        this.critParams.put(EGOV_BANK_ACCOUNT, remittanceObj.getBankAccount() != null ? remittanceObj.getBankAccount().getAccountnumber() : "");
        CollectionRemittanceReportResult collReportResult = new CollectionRemittanceReportResult();
        collReportResult.setCollectionBankRemittanceReportList(this.bankRemittanceList);
        ReportRequest reportInput = new ReportRequest(PRINT_BANK_CHALLAN_TEMPLATE, (Object)collReportResult, this.critParams);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return "report";
    }

    public AccountCodePurpose getAccountCodePurpose(String purposeName) {
        AccountCodePurpose acctCodePurposeObj = (AccountCodePurpose)this.getPersistenceService().find(" from AccountCodePurpose where name = ? ", new Object[]{purposeName});
        return acctCodePurposeObj;
    }

    protected String getReportTemplateName() {
        return "collection_remittanc_statement_report";
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    public void setFromDate(Date fromDate) {
        this.critParams.put(EGOV_FROM_DATE, fromDate);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public void setToDate(Date toDate) {
        this.critParams.put(EGOV_TO_DATE, toDate);
    }

    public Long getServiceId() {
        return (Long)this.getReportParam(EGOV_SERVICE_ID);
    }

    public void setServiceId(Long serviceId) {
        this.critParams.put(EGOV_SERVICE_ID, serviceId);
    }

    public Integer getFundId() {
        return (Integer)this.getReportParam(EGOV_FUND_ID);
    }

    public void setFundId(Integer fundId) {
        this.critParams.put(EGOV_FUND_ID, fundId);
    }

    public Integer getBranchId() {
        return (Integer)this.getReportParam(EGOV_BANKBRANCH_ID);
    }

    public void setBranchId(Integer branchId) {
        this.critParams.put(EGOV_BANKBRANCH_ID, branchId);
    }

    public Integer getBankaccountId() {
        return (Integer)this.getReportParam(EGOV_BANKACCOUNT_ID);
    }

    public void setBankaccountId(Integer bankAccountId) {
        this.critParams.put(EGOV_BANKACCOUNT_ID, bankAccountId);
    }

    public String getPaymentMode() {
        String modeOfPayment = (String)this.getReportParam(EGOV_PAYMENT_MODE);
        return null == modeOfPayment ? "-1" : modeOfPayment;
    }

    public void setPaymentMode(String paymentMode) {
        if (null != paymentMode && !"-1".equals(paymentMode)) {
            this.critParams.put(EGOV_PAYMENT_MODE, paymentMode);
        } else {
            this.critParams.put(EGOV_PAYMENT_MODE, null);
        }
    }

    public Integer getDeptId() {
        return (Integer)this.getReportParam(EGOV_DEPT_ID);
    }

    public void setDeptId(Integer deptId) {
        this.critParams.put(EGOV_DEPT_ID, deptId);
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Map<String, String> getPaymentModes() {
        return this.paymentModes;
    }

    private Map<String, String> createPaymentModeList() {
        HashMap<String, String> paymentModesMap = new HashMap<String, String>();
        paymentModesMap.put("cash", "cash");
        paymentModesMap.put("cheque/dd", "cheque/dd");
        paymentModesMap.put("online", "online");
        paymentModesMap.put("card", "card");
        return paymentModesMap;
    }

    public String getReportId() {
        return this.reportId;
    }

    public Double getTotalCashAmount() {
        return this.totalCashAmount;
    }

    public void setTotalCashAmount(Double totalCashAmount) {
        this.totalCashAmount = totalCashAmount;
    }

    public Double getTotalChequeAmount() {
        return this.totalChequeAmount;
    }

    public void setTotalChequeAmount(Double totalChequeAmount) {
        this.totalChequeAmount = totalChequeAmount;
    }

    public List<CollectionBankRemittanceReport> getBankRemittanceList() {
        return this.bankRemittanceList;
    }

    public void setBankRemittanceList(List<CollectionBankRemittanceReport> bankRemittanceList) {
        this.bankRemittanceList = bankRemittanceList;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Date getRemittanceDate() {
        return this.remittanceDate;
    }

    public void setRemittanceDate(Date remittanceDate) {
        this.remittanceDate = remittanceDate;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public void setRemittanceService(RemittanceServiceImpl remittanceService) {
        this.remittanceService = remittanceService;
    }
}

