/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.EgwStatus;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.web.struts.actions.ReportFormAction;

@ParentPackage(value="egov")
@Results(value={@Result(name={"index"}, location="receiptRegisterReport-index.jsp"), @Result(name={"report"}, location="receiptRegisterReport-report.jsp")})
public class ReceiptRegisterReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_DEPT_ID = "EGOV_DEPT_ID";
    private static final String EGOV_PAYMENT_MODE = "EGOV_PAYMENT_MODE";
    private static final String EGOV_STATUS_ID = "EGOV_STATUS_ID";
    private static final String EGOV_SOURCE = "EGOV_SOURCE";
    private static final String EGOV_SERVICE_ID = "EGOV_SERVICE_ID";
    private static final String EGOV_CLASSIFICATION = "EGOV_CLASSIFICATION";
    private final Map<String, String> paymentModes = this.createPaymentModeList();
    private final Map<String, String> sources = this.createSourceList();
    private CollectionsUtil collectionsUtil;
    private TreeMap<String, String> serviceTypeMap = new TreeMap();

    private Map<String, String> createPaymentModeList() {
        HashMap<String, String> paymentModesMap = new HashMap<String, String>(0);
        paymentModesMap.put("cash", "cash");
        paymentModesMap.put("cheque/dd", "cheque/dd");
        paymentModesMap.put("bankchallan", "bankchallan");
        paymentModesMap.put("online", "online");
        return paymentModesMap;
    }

    private Map<String, String> createSourceList() {
        HashMap<String, String> sourcesMap = new HashMap<String, String>(0);
        sourcesMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        sourcesMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        sourcesMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        sourcesMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return sourcesMap;
    }

    public void prepare() {
        this.setReportFormat(ReportConstants.FileFormat.PDF);
        this.setDataSourceType(ReportRequest.ReportDataSourceType.SQL);
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    public void setFromDate(Date fromDate) {
        this.setReportParam(EGOV_FROM_DATE, (Object)fromDate);
    }

    public String getSource() {
        return (String)this.getReportParam(EGOV_SOURCE);
    }

    public void setSource(String source) {
        this.setReportParam(EGOV_SOURCE, (Object)source);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public void setToDate(Date toDate) {
        this.setReportParam(EGOV_TO_DATE, (Object)toDate);
    }

    public Integer getDeptId() {
        return (Integer)this.getReportParam(EGOV_DEPT_ID);
    }

    public void setDeptId(Integer deptId) {
        this.setReportParam(EGOV_DEPT_ID, (Object)deptId);
    }

    public String getPaymentMode() {
        return (String)this.getReportParam(EGOV_PAYMENT_MODE);
    }

    public void setPaymentMode(String paymentMode) {
        this.setReportParam(EGOV_PAYMENT_MODE, (Object)paymentMode);
    }

    public Integer getStatusId() {
        return (Integer)this.getReportParam(EGOV_STATUS_ID);
    }

    public void setStatusId(Integer statusId) {
        this.setReportParam(EGOV_STATUS_ID, (Object)statusId);
    }

    public Map<String, String> getPaymentModes() {
        return this.paymentModes;
    }

    @Action(value="/reports/receiptRegisterReport-criteria")
    public String criteria() {
        this.addRelatedEntity("department", Department.class, "name");
        this.addRelatedEntity("status", EgwStatus.class, "description");
        this.addDropdownData("servicetypeList", this.getPersistenceService().findAllByNamedQuery("getCollectionServices", new Object[0]));
        this.setupDropdownDataExcluding(new String[0]);
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        this.serviceTypeMap.putAll(CollectionConstants.SERVICE_TYPE_CLASSIFICATION);
        this.serviceTypeMap.remove("P");
        return "index";
    }

    @Action(value="/reports/receiptRegisterReport-report")
    public String report() {
        return super.report();
    }

    protected String getReportTemplateName() {
        return "collection_receipt_register";
    }

    public List getReceiptStatuses() {
        return this.collectionsUtil.getAllReceiptHeaderStatus();
    }

    public Map<String, String> getSources() {
        return this.sources;
    }

    public Long getServiceId() {
        return (Long)this.getReportParam(EGOV_SERVICE_ID);
    }

    public void setServiceId(Long serviceId) {
        this.setReportParam(EGOV_SERVICE_ID, (Object)serviceId);
    }

    public String getClassificationType() {
        return (String)this.getReportParam(EGOV_CLASSIFICATION);
    }

    public void setClassificationType(String classification) {
        this.setReportParam(EGOV_CLASSIFICATION, (Object)classification);
    }

    public TreeMap<String, String> getServiceTypeMap() {
        return this.serviceTypeMap;
    }

    public void setServiceTypeMap(TreeMap<String, String> serviceTypeMap) {
        this.serviceTypeMap = serviceTypeMap;
    }
}

