/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.entity.BankAccountServiceMap;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="serviceTypeToBankAccountMapping-new.jsp"), @Result(name="success", location="serviceTypeToBankAccountMapping-success.jsp"), @Result(name="index", location="serviceTypeToBankAccountMapping-index.jsp")})
public class ServiceTypeToBankAccountMappingAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private PersistenceService<BankAccountServiceMap, Long> bankAccountMappingService;
    private BankAccountServiceMap bankAccountServiceMap = new BankAccountServiceMap();
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    private BankBranchHibernateDAO bankBrankHibernateDAO;
    @Autowired
    private BankaccountHibernateDAO bankAccountHibernateDAO;
    List<BankAccountServiceMap> bankAccountServices = new ArrayList();
    Integer bankId;
    Integer branchId;
    Long serviceCategory;
    Long serviceAccountId;
    String sourcePage;
    private String target;

    public ServiceTypeToBankAccountMappingAction() {
        this.addRelatedEntity("serviceDetails", ServiceDetails.class);
        this.addRelatedEntity("bankAccountId", Bankaccount.class);
    }

    @Action(value="/service/serviceTypeToBankAccountMapping-newform")
    public String newform() {
        if (this.getServiceAccountId() != null) {
            this.populateListsForView();
            this.setupDropdownDataExcluding(new String[0]);
            this.bankAccountServiceMap = (BankAccountServiceMap)this.bankAccountMappingService.findById((Serializable)this.getServiceAccountId(), false);
            this.addDropdownData("bankBranchList", this.bankBrankHibernateDAO.getAllBankBranchsByBank(this.bankAccountServiceMap.getBankAccountId().getBankbranch().getBank().getId()));
            this.addDropdownData("bankAccountIdList", this.bankAccountHibernateDAO.getBankAccountByBankBranchForReceiptsPayments(this.bankAccountServiceMap.getBankAccountId().getBankbranch().getId()));
            this.setServiceCategory(this.bankAccountServiceMap.getServiceDetails().getServiceCategory().getId());
            this.setBankId(this.bankAccountServiceMap.getBankAccountId().getBankbranch().getBank().getId());
            this.setBranchId(this.bankAccountServiceMap.getBankAccountId().getBankbranch().getId());
        } else {
            this.populateLists();
        }
        return "new";
    }

    private void populateLists() {
        this.addDropdownData("serviceCategoryList", this.persistenceService.findAllByNamedQuery("ACTIVE_SERVICE_CATEGORY", new Object[0]));
        this.addDropdownData("serviceDetailsList", Collections.EMPTY_LIST);
        this.addDropdownData("bankNameList", this.bankHibernateDAO.getAllBankHavingBranchAndAccounts());
        this.addDropdownData("bankBranchList", Collections.EMPTY_LIST);
        this.addDropdownData("bankAccountIdList", Collections.EMPTY_LIST);
    }

    private void populateListsForView() {
        this.addDropdownData("serviceCategoryList", this.persistenceService.findAllByNamedQuery("ACTIVE_SERVICE_CATEGORY", new Object[0]));
        this.addDropdownData("serviceDetailsList", Collections.EMPTY_LIST);
        this.addDropdownData("bankNameList", this.getBankMappedToService());
        this.addDropdownData("bankBranchList", Collections.EMPTY_LIST);
        this.addDropdownData("bankAccountIdList", Collections.EMPTY_LIST);
    }

    private List<Bank> getBankMappedToService() {
        ArrayList<Bank> bankList = new ArrayList();
        String serviceBankQueryString = "select distinct asm.bankAccountId.bankbranch.bank from BankAccountServiceMap asm)";
        Query bankListQuery = this.persistenceService.getSession().createQuery("select distinct asm.bankAccountId.bankbranch.bank from BankAccountServiceMap asm)");
        bankList = bankListQuery.list();
        return bankList;
    }

    @Action(value="/service/serviceTypeToBankAccountMapping-list")
    public String list() {
        this.populateListsForView();
        return "index";
    }

    @Action(value="/service/serviceTypeToBankAccountMapping-search")
    public String search() {
        this.populateListsForView();
        StringBuilder searchkQueryString = new StringBuilder();
        searchkQueryString.append("select distinct asm from BankAccountServiceMap asm where 1=1");
        if (this.bankId != null && this.bankId != -1) {
            searchkQueryString.append(" and asm.bankAccountId.bankbranch.bank.id=:bankId");
        }
        if (this.branchId != null && this.branchId != -1) {
            searchkQueryString.append(" and asm.bankAccountId.bankbranch.id=:branchId");
        }
        if (this.bankAccountServiceMap.getBankAccountId() != null && this.bankAccountServiceMap.getBankAccountId().getId() != -1L) {
            searchkQueryString.append(" and asm.bankAccountId.id=:accountId");
        }
        if (this.serviceCategory != null && this.serviceCategory != -1L) {
            searchkQueryString.append(" and asm.serviceDetails.serviceCategory.id=:serviceCatId");
        }
        if (this.bankAccountServiceMap.getServiceDetails() != null && this.bankAccountServiceMap.getServiceDetails().getId() != -1L) {
            searchkQueryString.append(" and asm.serviceDetails.id=:serviceId");
        }
        Query searchBankAccountListQuery = this.persistenceService.getSession().createQuery(searchkQueryString.toString());
        if (this.bankId != null && this.bankId != -1) {
            searchBankAccountListQuery.setParameter("bankId", (Object)this.bankId);
        }
        if (this.branchId != null && this.branchId != -1) {
            searchBankAccountListQuery.setParameter("branchId", (Object)this.branchId);
        }
        if (this.bankAccountServiceMap.getBankAccountId() != null && this.bankAccountServiceMap.getBankAccountId().getId() != -1L) {
            searchBankAccountListQuery.setParameter("accountId", (Object)this.bankAccountServiceMap.getBankAccountId().getId());
        }
        if (this.serviceCategory != null && this.serviceCategory != -1L) {
            searchBankAccountListQuery.setParameter("serviceCatId", (Object)this.serviceCategory);
        }
        if (this.bankAccountServiceMap.getServiceDetails() != null && this.bankAccountServiceMap.getServiceDetails().getId() != -1L) {
            searchBankAccountListQuery.setParameter("serviceId", (Object)this.bankAccountServiceMap.getServiceDetails().getId());
        }
        this.bankAccountServices = searchBankAccountListQuery.list();
        this.target = "searchresult";
        return "index";
    }

    @Action(value="/service/serviceTypeToBankAccountMapping-create")
    public String create() {
        if (this.bankAccountServiceMap.getId() != null) {
            BankAccountServiceMap bankAccountServiceMapObj = (BankAccountServiceMap)this.bankAccountMappingService.findById((Serializable)this.bankAccountServiceMap.getId(), false);
            bankAccountServiceMapObj.setBankAccountId(this.bankAccountServiceMap.getBankAccountId());
            bankAccountServiceMapObj.setServiceDetails(this.bankAccountServiceMap.getServiceDetails());
            this.bankAccountMappingService.persist((Object)bankAccountServiceMapObj);
        } else {
            this.bankAccountMappingService.persist((Object)this.bankAccountServiceMap);
        }
        if (this.sourcePage != null && this.sourcePage.equals("modify")) {
            this.addActionMessage(this.getText("service.master.successmessage.modify", new String[]{this.bankAccountServiceMap.getServiceDetails().getName()}));
        } else {
            this.addActionMessage(this.getText("service.master.successmessage.create", new String[]{this.bankAccountServiceMap.getServiceDetails().getName(), this.bankAccountServiceMap.getBankAccountId().getBankbranch().getBank().getName(), this.bankAccountServiceMap.getBankAccountId().getAccountnumber()}));
        }
        return "success";
    }

    public Object getModel() {
        return this.bankAccountServiceMap;
    }

    public List<BankAccountServiceMap> getBankAccountServices() {
        return this.bankAccountServices;
    }

    public void setBankAccountServices(List<BankAccountServiceMap> bankAccountServices) {
        this.bankAccountServices = bankAccountServices;
    }

    public PersistenceService<BankAccountServiceMap, Long> getBankAccountMappingService() {
        return this.bankAccountMappingService;
    }

    public void setBankAccountMappingService(PersistenceService<BankAccountServiceMap, Long> bankAccountMappingService) {
        this.bankAccountMappingService = bankAccountMappingService;
    }

    public Integer getBankId() {
        return this.bankId;
    }

    public void setBankId(Integer bankId) {
        this.bankId = bankId;
    }

    public Integer getBranchId() {
        return this.branchId;
    }

    public void setBranchId(Integer branchId) {
        this.branchId = branchId;
    }

    public Long getServiceCategory() {
        return this.serviceCategory;
    }

    public void setServiceCategory(Long serviceCategory) {
        this.serviceCategory = serviceCategory;
    }

    public Long getServiceAccountId() {
        return this.serviceAccountId;
    }

    public void setServiceAccountId(Long serviceAccountId) {
        this.serviceAccountId = serviceAccountId;
    }

    public String getSourcePage() {
        return this.sourcePage;
    }

    public void setSourcePage(String sourcePage) {
        this.sourcePage = sourcePage;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

