/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.reports;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.collection.service.CollectionReportService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.web.actions.receipts.AjaxBankRemittanceAction;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name="index", location="remittanceVoucherReport-index.jsp"), @Result(name="report", location="remittanceVoucherReport-report.jsp")})
@ParentPackage(value="egov")
public class RemittanceVoucherReportAction
extends ReportFormAction {
    private static final long serialVersionUID = 1L;
    private static final String EGOV_VOUCHER_TYPE = "EGOV_VOUCHER_TYPE";
    private static final String EGOV_FROM_DATE = "EGOV_FROM_DATE";
    private static final String EGOV_TO_DATE = "EGOV_TO_DATE";
    private static final String EGOV_BANKACCOUNT_ID = "EGOV_BANKACCOUNT_ID";
    private static final String EGOV_BRANCH_ID = "EGOV_BRANCH_ID";
    private static final String EGOV_CREATEDBY_ID = "EGOV_CREATEDBY_ID";
    private static final String EGOV_SERVICE_ID = "EGOV_SERVICE_ID";
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private CollectionsUtil collectionsUtil;
    @Autowired
    private CollectionReportService reportService;
    private Integer branchId;
    private static final String ACCOUNT_NUMBER_LIST = "accountNumberList";

    public void prepare() {
        this.setReportFormat(ReportConstants.FileFormat.PDF);
        this.setDataSourceType(ReportRequest.ReportDataSourceType.SQL);
    }

    public void populateBankAccountList() {
        AjaxBankRemittanceAction ajaxBankRemittanceAction = new AjaxBankRemittanceAction();
        ajaxBankRemittanceAction.setPersistenceService(this.getPersistenceService());
        ajaxBankRemittanceAction.bankBranchListOfService();
        this.addDropdownData("bankBranchList", ajaxBankRemittanceAction.getBankBranchArrayList());
        if (this.branchId != null) {
            ajaxBankRemittanceAction.setBranchId(this.branchId);
            ajaxBankRemittanceAction.accountListOfService();
            this.addDropdownData(ACCOUNT_NUMBER_LIST, ajaxBankRemittanceAction.getBankAccountArrayList());
        } else {
            this.addDropdownData(ACCOUNT_NUMBER_LIST, Collections.EMPTY_LIST);
        }
    }

    @Action(value="/reports/remittanceVoucherReport-criteria")
    public String criteria() {
        List usersList = this.persistenceService.findAllByNamedQuery("getAllRemittanceVoucherCreator", new Object[0]);
        User user = this.collectionsUtil.getLoggedInUser();
        Employee employee = this.employeeService.getEmployeeById(user.getId());
        this.populateBankAccountList();
        this.addDropdownData("collectionServiceList", Collections.EMPTY_LIST);
        this.addDropdownData("remittanceVoucherCreatorList", usersList);
        this.setReportParam(EGOV_FROM_DATE, (Object)new Date());
        this.setReportParam(EGOV_TO_DATE, (Object)new Date());
        return "index";
    }

    public Date getFromDate() {
        return (Date)this.getReportParam(EGOV_FROM_DATE);
    }

    @Action(value="/reports/remittanceVoucherReport-report")
    public String report() {
        return super.report();
    }

    public void setFromDate(Date fromDate) {
        this.setReportParam(EGOV_FROM_DATE, (Object)fromDate);
    }

    public Date getToDate() {
        return (Date)this.getReportParam(EGOV_TO_DATE);
    }

    public void setToDate(Date toDate) {
        this.setReportParam(EGOV_TO_DATE, (Object)toDate);
    }

    protected String getReportTemplateName() {
        return "collection_remittancevoucher_report";
    }

    public Integer getBankAccountId() {
        return (Integer)this.getReportParam(EGOV_BANKACCOUNT_ID);
    }

    public void setBankAccountId(Integer bankAccountId) {
        this.setReportParam(EGOV_BANKACCOUNT_ID, (Object)bankAccountId);
    }

    public Integer getCreatedById() {
        return (Integer)this.getReportParam(EGOV_CREATEDBY_ID);
    }

    public void setCreatedById(Integer createdById) {
        this.setReportParam(EGOV_CREATEDBY_ID, (Object)createdById);
    }

    public Long getServiceId() {
        return (Long)this.getReportParam(EGOV_SERVICE_ID);
    }

    public void setServiceId(Long serviceId) {
        this.setReportParam(EGOV_SERVICE_ID, (Object)serviceId);
    }

    public Integer getBranchId() {
        return (Integer)this.getReportParam(EGOV_BRANCH_ID);
    }

    public void setBranchId(Integer branchId) {
        this.setReportParam(EGOV_BRANCH_ID, (Object)branchId);
    }
}

