/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.collection.entity.ReceiptDetailInfo;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.collection.web.actions.receipts.ReceiptAction;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.model.instrument.InstrumentHeader;
import org.springframework.transaction.annotation.Transactional;

@ParentPackage(value="egov")
@Transactional(readOnly=true)
public class MiscellaneousFileUploadAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MiscellaneousFileUploadAction.class);
    private File importFile;
    private String importContentType;
    private String importFileName;
    private String importfileCaption;
    private List<String[]> inputList = new ArrayList();
    private List<ReceiptDetailInfo> billCreditDetailslist;
    private List<ReceiptDetailInfo> billRebateDetailslist;
    private List<ReceiptDetailInfo> subLedgerlist;
    SimpleDateFormat sdfInput = new SimpleDateFormat("dd.MM.yy", Locale.getDefault());
    private ReceiptAction receiptAction;
    private CollectionCommon collectionCommon;
    private FinancialsUtil financialsUtil;
    private CollectionsUtil collectionsUtil;
    private ReceiptHeaderService receiptHeaderService;
    private final Map<Integer, String> errorRowMap = new TreeMap();
    private Integer successNo = 0;
    private final List<String> errorMsgsList = new ArrayList(0);

    public Map<Integer, String> getErrorRowMap() {
        return this.errorRowMap;
    }

    private void injectObjectsIntoAction() {
        this.receiptAction = new ReceiptAction();
        this.receiptAction.setSession(this.getSession());
        this.receiptAction.setPersistenceService(this.getPersistenceService());
        this.receiptAction.setCollectionCommon(this.collectionCommon);
        this.receiptAction.setCollectionsUtil(this.collectionsUtil);
        this.receiptAction.setFinancialsUtil(this.financialsUtil);
        this.receiptAction.setReceiptHeaderService(this.receiptHeaderService);
        this.receiptAction.setReceiptBulkUpload(Boolean.TRUE);
    }

    private void initialiseObjectsInAction(String[] input) {
        this.receiptAction.setBillSource("misc");
        this.receiptAction.setPayeename(input[3]);
        this.receiptAction.setPaidBy(input[3]);
        this.billCreditDetailslist = new ArrayList();
        this.billRebateDetailslist = new ArrayList();
        this.subLedgerlist = new ArrayList();
        this.receiptAction.setReceiptMisc(this.createReceiptMisc(input));
        Department dept = (Department)this.persistenceService.find("from Department d where d.deptName=? ", new Object[]{input[1]});
        this.receiptAction.setDeptId(dept.getId().toString());
        Date dt = new Date();
        try {
            dt = this.sdfInput.parse(input[0]);
            this.receiptAction.setManualReceiptDate(dt);
            this.receiptAction.setVoucherDate(dt);
        }
        catch (ParseException e) {
            LOGGER.debug((Object)("Error occured while parsing receipt date [ " + input[0] + " ] : " + e.getMessage()));
        }
        if (input[9].equals("cash")) {
            this.receiptAction.setCashOrCardInstrumenttotal(BigDecimal.ZERO);
            InstrumentHeader instrHeaderCash = new InstrumentHeader();
            instrHeaderCash.setInstrumentAmount(new BigDecimal(input[8]));
            this.receiptAction.setInstrHeaderCash(instrHeaderCash);
            this.receiptAction.setInstrumentTypeCashOrCard("cash");
        }
        if (input[9].equals("bankchallan")) {
            this.receiptAction.setCashOrCardInstrumenttotal(BigDecimal.ZERO);
            InstrumentHeader instrHeaderBank = new InstrumentHeader();
            instrHeaderBank.setInstrumentAmount(new BigDecimal(input[8]));
            instrHeaderBank.setTransactionDate(this.receiptAction.getManualReceiptDate());
            instrHeaderBank.setTransactionNumber(dept.getCode() + new SimpleDateFormat("ddMMyy", Locale.getDefault()).format(dt) + "UPL");
            Bankaccount account = (Bankaccount)this.persistenceService.find("from Bankaccount where accountnumber=?", new Object[]{input[4]});
            this.receiptAction.setBankAccountId(account.getId());
            this.receiptAction.setInstrHeaderBank(instrHeaderBank);
            this.receiptAction.setInstrumentTypeCashOrCard("bankchallan");
        }
        this.createCreditDetailslist(input);
        this.createEmptyRebatelist();
        this.createEmptySubLedgerlist();
        this.receiptAction.setBillCreditDetailslist(this.billCreditDetailslist);
        this.receiptAction.setSubLedgerlist(this.subLedgerlist);
        this.receiptAction.setBillRebateDetailslist(this.billRebateDetailslist);
    }

    public String fileValidate() {
        this.readColumn();
        this.removeNullListEntries();
        for (int i = 0; i < this.inputList.size(); ++i) {
            String[] input = (String[])this.inputList.get(i);
            if (this.validateExcel(input = this.formatValues(input))) {
                Integer n = this.successNo;
                Integer n2 = this.successNo = Integer.valueOf(this.successNo + 1);
                continue;
            }
            LOGGER.debug((Object)("Misc row no: " + i + " not persisted due to some incomplete data!!!!"));
        }
        this.generateErrorReport();
        return "success";
    }

    private void generateErrorReport() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File("ManualMiscUploadErrorReport.txt"));
            String[] errors = new String[20];
            if (!this.errorRowMap.isEmpty()) {
                fos.write("Errors in Uploading Following Rows \n".getBytes());
                fos.write("********************************** \n\n".getBytes());
                for (Map.Entry pairs : this.errorRowMap.entrySet()) {
                    for (String error2 : errors = pairs.getValue().toString().split(",")) {
                        fos.write(("  Row " + pairs.getKey().toString() + " : " + error2 + "\n").getBytes());
                    }
                }
            }
            LOGGER.debug((Object)"Written to file successfully ");
            fos.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("Error occrured while generating report : " + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occrured while generating report : " + e.getMessage()));
        }
    }

    public String save() {
        this.readColumn();
        this.removeNullListEntries();
        this.injectObjectsIntoAction();
        for (int i = 0; i < this.inputList.size(); ++i) {
            String[] input = (String[])this.inputList.get(i);
            if (!this.validateExcel(input = this.formatValues(input))) continue;
            this.initialiseObjectsInAction(input);
            try {
                this.receiptAction.save();
            }
            catch (Exception ex) {
                String errMsg = "Error in Receipt Creation : " + ex.getMessage();
                LOGGER.error((Object)errMsg, (Throwable)ex);
                this.errorRowMap.put(Integer.valueOf(input[11]), errMsg);
                continue;
            }
            Integer n = this.successNo;
            Integer n2 = this.successNo = Integer.valueOf(this.successNo + 1);
            LOGGER.info((Object)(" Persisted " + (i + 1) + " records "));
            LOGGER.debug((Object)(" Persisted " + (i + 1) + " records "));
        }
        return "success";
    }

    public void createCreditDetailslist(String[] inputArray) {
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        CChartOfAccounts account = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts  where glcode=? ", new Object[]{inputArray[10]});
        vd.setAccounthead(account.getName());
        vd.setCreditAmountDetail(new BigDecimal(inputArray[8]));
        vd.setDebitAmountDetail(BigDecimal.ZERO);
        vd.setAmount(BigDecimal.ZERO);
        vd.setGlcodeDetail(account.getGlcode());
        vd.setGlcodeIdDetail(account.getId());
        CFinancialYear financialYear1011 = (CFinancialYear)this.persistenceService.find("from CFinancialYear  where finYearRange=? ", new Object[]{"2010-11"});
        vd.setFinancialYearId(financialYear1011.getId());
        this.billCreditDetailslist.add(vd);
    }

    public void createEmptySubLedgerlist() {
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setCreditAmountDetail(BigDecimal.ZERO);
        vd.setDebitAmountDetail(BigDecimal.ZERO);
        vd.setAmount(BigDecimal.ZERO);
        vd.setDetailCode("");
        vd.setDetailKey("");
        this.subLedgerlist.add(vd);
    }

    public void createEmptyRebatelist() {
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setAccounthead("");
        vd.setCreditAmountDetail(BigDecimal.ZERO);
        vd.setDebitAmountDetail(BigDecimal.ZERO);
        vd.setAmount(BigDecimal.ZERO);
        vd.setGlcodeDetail("");
        this.billRebateDetailslist.add(vd);
    }

    public ReceiptMisc createReceiptMisc(String[] inputArray) {
        ReceiptMisc receiptMisc = new ReceiptMisc();
        Fund fund = (Fund)this.persistenceService.find("from Fund  where name=? ", new Object[]{inputArray[2]});
        receiptMisc.setFund(fund);
        return receiptMisc;
    }

    private String[] formatValues(String[] inputArray) {
        if (inputArray[4].endsWith(".0")) {
            inputArray[4] = inputArray[4].substring(0, inputArray[4].indexOf(46));
        }
        if (inputArray[10].endsWith(".0")) {
            inputArray[10] = inputArray[10].substring(0, inputArray[10].indexOf(46));
        }
        BigDecimal bd = new BigDecimal(inputArray[10]);
        inputArray[10] = bd.toPlainString();
        return inputArray;
    }

    private boolean validateExcel(String[] inputArray) {
        boolean valid = true;
        String errorMsgs = "";
        if (inputArray[0] == null || inputArray[0].equals("")) {
            errorMsgs = errorMsgs + "Receipt Date is null/Empty";
            LOGGER.debug((Object)"Receipt Date is null/Empty");
            valid = false;
        }
        try {
            Date date = this.sdfInput.parse(inputArray[0]);
            this.collectionsUtil.getFinancialYearforDate(date);
        }
        catch (ParseException e) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Invalid Receipt Date[ " + inputArray[0] + " ]" : errorMsgs + ", Invalid Receipt Date[ " + inputArray[0] + " ]";
            valid = false;
        }
        catch (Exception ex) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "No financial year found for receipt date [" + inputArray[0] + "]" : errorMsgs + ", No financial year found for receipt date [" + inputArray[0] + "]";
            valid = false;
        }
        if (inputArray[1] == null || inputArray[1].equals("")) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Department is null/Empty" : errorMsgs + ", Department is null/Empty";
            LOGGER.debug((Object)"Department is null/Empty");
            valid = false;
        } else {
            Department dept = (Department)this.persistenceService.find("from Department d where d.deptName=? ", new Object[]{inputArray[1]});
            if (dept == null) {
                errorMsgs = errorMsgs.equals("") ? errorMsgs + "Incorrect value for Department [" + inputArray[1] + "]" : errorMsgs + ", Incorrect value for Department []";
                LOGGER.debug((Object)("Incorrect value for Department " + inputArray[1] + "]"));
                valid = false;
            }
        }
        if (inputArray[2] == null || inputArray[2].equals("")) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Fund is null/Empty" : errorMsgs + ", Fund is null/Empty";
            LOGGER.debug((Object)"Fund is null/Empty");
            valid = false;
        } else {
            Fund fund = (Fund)this.persistenceService.find("from Fund  where name=? ", new Object[]{inputArray[2]});
            if (fund == null) {
                errorMsgs = errorMsgs.equals("") ? errorMsgs + "Incorrect value for fund [" + inputArray[2] + "]" : errorMsgs + ", Incorrect value for fund " + inputArray[2] + "]";
                LOGGER.debug((Object)("Incorrect value for fund" + inputArray[2] + "]"));
                valid = false;
            }
        }
        if (inputArray[3] == null || inputArray[3].equals("")) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Payee Name is null/Empty" : errorMsgs + ", Payee Name is null/Empty";
            LOGGER.debug((Object)"Payee Name is null/Empty");
            valid = false;
        }
        if (inputArray[6] == null || inputArray[6].equals("") || inputArray[6].equals("0.0")) {
            this.errorMsgsList.add("Account head Amount is null/Empty/Zero");
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Account head Amount is null/Empty/Zero" : errorMsgs + ", Account head Amount is null/Empty/Zero";
            LOGGER.debug((Object)"Account head Amount is null/Empty/Zero");
            valid = false;
        }
        if (inputArray[8] == null || inputArray[8].equals("") || inputArray[8].equals("0.0")) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Payment Amount is null/Empty" : errorMsgs + ", Payment Amount is null/Empty";
            LOGGER.debug((Object)"Payment Amount is null/Empty");
            valid = false;
        }
        if (inputArray[9] == null || inputArray[9].equals("")) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Mode of payment is null/Empty" : errorMsgs + ", Mode of payment is null/Empty";
            LOGGER.debug((Object)"Mode of payment is null/Empty");
            valid = false;
        }
        if (inputArray[9].equals("bankchallan") && inputArray[3].equals("")) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Bank Name is null/Empty" : errorMsgs + ", Bank Name is null/Empty";
            LOGGER.debug((Object)"Bank Name is null/Empty");
            valid = false;
        }
        if (inputArray[9].equals("bankchallan")) {
            if (inputArray[4].equals("")) {
                errorMsgs = errorMsgs.equals("") ? errorMsgs + "Bank Account Code is null/Empty" : errorMsgs + ", Bank Account Code is null/Empty";
                LOGGER.debug((Object)"Bank Account Code is null/Empty");
                valid = false;
            } else {
                Bankaccount bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where accountnumber=?", new Object[]{inputArray[4]});
                if (bankAccount == null) {
                    errorMsgs = errorMsgs.equals("") ? errorMsgs + "Incorrect value for Bank Account Code [" + inputArray[4] + "]" : errorMsgs + ", Incorrect value for Bank Account Code [" + inputArray[4] + "]";
                    LOGGER.debug((Object)("Incorrect value for Bank Account Code [" + inputArray[4] + "]"));
                    valid = false;
                }
            }
        }
        if (inputArray[10] == null || inputArray[10].equals("")) {
            errorMsgs = errorMsgs.equals("") ? errorMsgs + "Department Receivable Code is null/Empty" : errorMsgs + ", Department Receivable Code is null/Empty";
            LOGGER.debug((Object)"Department Receivable Code is null/Empty");
            valid = false;
        } else {
            CChartOfAccounts account = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts  where glcode=? ", new Object[]{inputArray[10]});
            if (account == null) {
                errorMsgs = errorMsgs.equals("") ? errorMsgs + "Incorrect value for Account Code [" + inputArray[10] + "]" : errorMsgs + ", Incorrect value for Account Code [" + inputArray[10] + "]";
                LOGGER.debug((Object)("Incorrect value for Account Code [" + inputArray[10] + "]"));
                valid = false;
            }
        }
        if (!valid) {
            this.errorRowMap.put(Integer.valueOf(inputArray[11]), errorMsgs);
        }
        return valid;
    }

    private void removeNullListEntries() {
        ArrayList<String[]> tempInputList = new ArrayList<String[]>();
        for (String[] currentArray : this.inputList) {
            boolean isNull = true;
            for (int j = 0; j < currentArray.length - 1; ++j) {
                if (currentArray[j] == null || currentArray[j].equals("")) continue;
                isNull = false;
                break;
            }
            if (isNull) continue;
            tempInputList.add(currentArray);
        }
        this.inputList = tempInputList;
    }

    public String execute() throws Exception {
        return this.list();
    }

    public String newform() {
        return "new";
    }

    public String list() {
        return "index";
    }

    public String edit() {
        return "edit";
    }

    public String create() {
        return "success";
    }

    private void readColumn() {
        try {
            HSSFRow row;
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(this.getImportFile()));
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(1);
            int rows = sheet.getPhysicalNumberOfRows();
            int cols = 0;
            int tmp = 0;
            for (int i = 0; i < 15 || i < rows; ++i) {
                row = sheet.getRow(i);
                if (row == null || (tmp = sheet.getRow(i).getPhysicalNumberOfCells()) <= cols) continue;
                cols = tmp;
            }
            for (int r = 1; r < rows; ++r) {
                row = sheet.getRow(r);
                if (row == null) continue;
                String[] inputArray = new String[12];
                for (int c = 0; c < 11; ++c) {
                    int ct;
                    HSSFCell cell = row.getCell(c);
                    LOGGER.info((Object)(" Cell : " + c + " Value : " + cell));
                    inputArray[c] = cell == null ? "" : ((ct = cell.getCellType()) == 2 ? Double.toString(cell.getNumericCellValue()) : cell.toString());
                }
                inputArray[11] = String.valueOf(r + 1);
                this.inputList.add(inputArray);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Exception in reading columns : " + e.getMessage()));
        }
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    public String getImportContentType() {
        return this.importContentType;
    }

    public void setImportContentType(String importContentType) {
        this.importContentType = importContentType;
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public String getImportfileCaption() {
        return this.importfileCaption;
    }

    public void setImportfileCaption(String importfileCaption) {
        this.importfileCaption = importfileCaption;
    }

    public Object getModel() {
        return null;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public List<ReceiptDetailInfo> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<ReceiptDetailInfo> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public List<ReceiptDetailInfo> getBillCreditDetailslist() {
        return this.billCreditDetailslist;
    }

    public void setBillCreditDetailslist(List<ReceiptDetailInfo> billCreditDetailslist) {
        this.billCreditDetailslist = billCreditDetailslist;
    }

    public List<ReceiptDetailInfo> getBillRebateDetailslist() {
        return this.billRebateDetailslist;
    }

    public void setBillRebateDetailslist(List<ReceiptDetailInfo> billRebateDetailslist) {
        this.billRebateDetailslist = billRebateDetailslist;
    }

    public Integer getSuccessNo() {
        return this.successNo;
    }

    public void setSuccessNo(Integer successNo) {
        this.successNo = successNo;
    }
}

