/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.web.actions.receipts;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.DishonoredChequeBean;
import org.egov.collection.entity.DishonoredChequeForm;
import org.egov.collection.integration.services.DishonorChequeActionHelper;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.commons.dao.BankBranchHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQuerySQL;
import org.egov.model.instrument.InstrumentType;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name="search", location="dishonoredCheque-search.jsp"), @Result(name="success", location="dishonoredCheque-success.jsp"), @Result(name="process", location="dishonoredCheque-process.jsp"), @Result(name="accountList", location="dishonoredCheque-accountList.jsp")})
@ParentPackage(value="egov")
public class DishonoredChequeAction
extends SearchFormAction {
    private static final long serialVersionUID = 2871716607884152080L;
    private static final Logger LOGGER = Logger.getLogger(DishonoredChequeAction.class);
    private static final String PAYMENT = "Payment";
    private static final String RECEIPT = "Receipt";
    private static final String JOURNAL_VOUCHER = "Journal Voucher";
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    public static final String SEARCH = "search";
    private List bankBranchList;
    @Autowired
    private BankBranchHibernateDAO bankBranchHibernateDAO;
    @Autowired
    private BankaccountHibernateDAO bankaccountHibernateDAO;
    private String bankBranchId;
    private List accountNumberList;
    private Map instrumentModesMap;
    private String chequeNumber;
    private Date chequeDate;
    private String instHeaderIds;
    private String voucherHeaderIds;
    private String receiptGLDetails;
    private String remittanceGLDetails;
    private Date transactionDate;
    private String dishonorReason;
    private String remarks;
    private String instrumentMode;
    private String referenceNo;
    private Long accountNumber;
    private EgovPaginatedList paginatedList;
    private List<DishonoredChequeForm> generalLedger = new ArrayList();
    private List<DishonoredChequeForm> subLedgerDetails = new ArrayList();
    private List<DishonoredChequeForm> remittanceGeneralLedger = new ArrayList();
    protected List<DishonoredChequeBean> dishonoredChequeDisplayList = new ArrayList(0);
    @Autowired
    private ReceiptHeaderService receiptHeaderService;
    @Autowired
    private DishonorChequeActionHelper dishonorChequeActionHelper;
    private BigDecimal reversalAmount;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("bankBranchList", this.bankBranchHibernateDAO.getAllBankBranchs());
        this.addDropdownData("accountNumberList", Collections.EMPTY_LIST);
        this.addDropdownData("dishonorReasonsList", this.persistenceService.getSession().createSQLQuery("select * from egf_instrument_dishonor_reason").list());
        this.instrumentModesMap = CollectionConstants.INSTRUMENT_MODES_MAP;
    }

    @Action(value="/receipts/dishonoredCheque-getAccountNumbers")
    public String getAccountNumbers() {
        try {
            Long branchId = null;
            if (!this.bankBranchId.equals("-1") && this.bankBranchId != null && this.bankBranchId != "") {
                String[] id = this.bankBranchId.split("-");
                branchId = Long.parseLong(id[1]);
            }
            this.accountNumberList = this.bankaccountHibernateDAO.getBankAccountByBankBranch(Integer.valueOf(branchId.intValue()));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception Encountered!!!" + ex.getMessage()), (Throwable)ex);
        }
        return "accountList";
    }

    @SkipValidation
    @Action(value="/receipts/dishonoredCheque-search")
    public String search() {
        return SEARCH;
    }

    @Action(value="/receipts/dishonoredCheque-list")
    public String list() throws Exception {
        this.setPageSize(30);
        super.search();
        this.prepareResults();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"DishonoredChequeAction | list | End");
        }
        return SEARCH;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        Long bankId = null;
        if (!this.bankBranchId.equals("-1") && this.bankBranchId != null && this.bankBranchId != "") {
            String[] id = this.bankBranchId.split("-");
            bankId = Long.parseLong(id[0]);
        }
        InstrumentType instType = (InstrumentType)this.getPersistenceService().find("from InstrumentType where type=?", new Object[]{this.instrumentMode});
        String searchQuery = this.receiptHeaderService.getReceiptHeaderforDishonor(instType.getId(), this.accountNumber, bankId, this.chequeNumber, this.chequeDate.toString());
        String srchQry = "select vh.id as voucherHeaderId,vh.vouchernumber as voucherNumber, rpt.id as receiptheaderid,ih.id as instrumentheaderid,rpt.receiptnumber as receiptnumber,rpt.receiptdate as receiptdate,ih.instrumentnumber as instrumentnumber,ih.instrumentdate as instrumentdate,ih.instrumentamount as instrumentamount,b.name as bankname,ba.accountnumber as accountnumber,ih.payto as payto,status.description as description " + searchQuery + " ORDER BY rpt.receiptnumber, rpt.receiptdate ";
        String countQry = "select count(distinct rpt) " + searchQuery + "";
        return new SearchQuerySQL(srchQry, countQry, null);
    }

    @ValidationErrorPage(value="process")
    @Action(value="/receipts/dishonoredCheque-create")
    public String create() throws Exception {
        try {
            DishonoredChequeForm chequeForm = new DishonoredChequeForm();
            chequeForm.setTransactionDate(this.transactionDate);
            chequeForm.setDishonorReason(this.dishonorReason);
            chequeForm.setReferenceNo(this.referenceNo);
            chequeForm.setRemarks(this.remarks);
            chequeForm.setInstHeaderIds(this.instHeaderIds);
            chequeForm.setVoucherHeaderIds(this.voucherHeaderIds);
            chequeForm.setReceiptGLDetails(this.receiptGLDetails);
            chequeForm.setRemittanceGLDetails(this.remittanceGLDetails);
            this.dishonorChequeActionHelper.createDishonorCheque(chequeForm);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return "success";
    }

    private void prepareResults() {
        LOGGER.debug((Object)"Entering into prepareResults");
        this.paginatedList = (EgovPaginatedList)this.searchResult;
        List list = this.paginatedList.getList();
        for (Object[] object : list) {
            DishonoredChequeBean chequeBean = new DishonoredChequeBean();
            chequeBean.setVoucherHeaderId(this.getLongValue(object[0]));
            chequeBean.setVoucherNumber(this.getStringValue(object[1]));
            chequeBean.setReceiptHeaderid(this.getLongValue(object[2]));
            chequeBean.setInstrumentHeaderid(this.getLongValue(object[3]));
            chequeBean.setReceiptNumber(this.getStringValue(object[4]));
            chequeBean.setReceiptDate(this.getDateValue(object[5]));
            chequeBean.setInstrumentNumber(this.getStringValue(object[6]));
            chequeBean.setInstrumentDate(this.getDateValue(object[7]));
            chequeBean.setInstrumentAmount(this.getBigDecimalValue(object[8]));
            chequeBean.setBankName(this.getStringValue(object[9]));
            chequeBean.setAccountNumber(this.getStringValue(object[10]));
            chequeBean.setPayTo(this.getStringValue(object[11]));
            chequeBean.setDescription(this.getStringValue(object[12]));
            this.dishonoredChequeDisplayList.add(chequeBean);
        }
        this.paginatedList.setList(this.dishonoredChequeDisplayList);
        LOGGER.debug((Object)"Exiting from prepareResults");
    }

    @Action(value="/receipts/dishonoredCheque-process")
    public String process() throws Exception {
        this.getReversalGlCodes();
        return "process";
    }

    public void getReversalGlCodes() {
        DishonoredChequeForm detail;
        List glCodes = new ArrayList();
        List glCodescredit = new ArrayList();
        ArrayList slDetailsCredit = new ArrayList();
        ArrayList slDetailsDebit = new ArrayList();
        List remittanceDetailsCredit = new ArrayList();
        List instrumentDetails = new ArrayList();
        this.reversalAmount = (BigDecimal)this.persistenceService.find("select sum(instrumentAmount) from InstrumentHeader where id in (" + this.instHeaderIds + ")");
        glCodescredit = this.persistenceService.findAllBy("select gl.voucherHeaderId.id ,gl.glcodeId.id, gl.glcode,gl.glcodeId.name, sum(gl.creditAmount),sum(gl.debitAmount),gl.functionId from CGeneralLedger gl where gl.voucherHeaderId in(" + this.voucherHeaderIds + ") and gl.debitAmount<>0 and gl.creditAmount=0 and gl.glcode not in (select glcode from CChartOfAccounts where purposeId in (select id from AccountCodePurpose where name='Cheque In Hand')) group by gl.voucherHeaderId.id ,gl.glcodeId.id,gl.glcode,gl.glcodeId.name,gl.functionId order by gl.glcode", new Object[0]);
        glCodes = this.persistenceService.findAllBy("select gl.voucherHeaderId.id ,gl.glcodeId.id,gl.glcode,gl.glcodeId.name,sum(gl.creditAmount),sum(gl.debitAmount),gl.functionId  from CGeneralLedger gl where gl.voucherHeaderId in(" + this.voucherHeaderIds + ") and gl.creditAmount<>0 and gl.debitAmount=0 group by gl.voucherHeaderId.id ,gl.glcodeId.id, gl.glcode,gl.glcodeId.name,gl.functionId order by gl.glcode", new Object[0]);
        glCodes.addAll(glCodescredit);
        String reversalGlCodesStr = "";
        for (Object[] gl : glCodes) {
            detail = new DishonoredChequeForm();
            detail.setVoucherHeaderId(this.getStringValue(gl[0]));
            detail.setGlcodeId(this.getStringValue(gl[1]));
            detail.setGlcode(this.getStringValue(gl[2]));
            detail.setDescription(this.getStringValue(gl[3]));
            detail.setDebitAmount(this.getStringValue(gl[4]));
            detail.setCreditAmount(this.getStringValue(gl[5]));
            detail.setFunctionId(this.getStringValue(gl[6]));
            this.generalLedger.add(detail);
            if (reversalGlCodesStr.equalsIgnoreCase("")) {
                reversalGlCodesStr = "'" + this.getStringValue(gl[2]) + "'";
                continue;
            }
            reversalGlCodesStr = reversalGlCodesStr + "," + "'" + this.getStringValue(gl[2]) + "'";
        }
        remittanceDetailsCredit = this.persistenceService.findAllBy("select gl.voucherHeaderId.id ,gl.glcodeId.id, gl.glcode,gl.glcodeId.name, sum(gl.creditAmount),sum(gl.debitAmount),gl.functionId from CGeneralLedger gl ,InstrumentOtherDetails iod where gl.voucherHeaderId.id = iod.payinslipId.id and iod.instrumentHeaderId.id   in (" + this.instHeaderIds + ") and gl.debitAmount<>0 and gl.creditAmount=0  group by gl.voucherHeaderId.id ,gl.glcodeId.id,gl.glcode,gl.glcodeId.name,gl.functionId order by gl.glcode", new Object[0]);
        for (Object[] gl : remittanceDetailsCredit) {
            detail = new DishonoredChequeForm();
            detail.setVoucherHeaderId(this.getStringValue(gl[0]));
            detail.setGlcodeId(this.getStringValue(gl[1]));
            detail.setGlcode(this.getStringValue(gl[2]));
            detail.setDescription(this.getStringValue(gl[3]));
            detail.setDebitAmount(this.getStringValue(gl[4]));
            detail.setCreditAmount(this.getStringValue(gl[5]));
            detail.setFunctionId(this.getStringValue(gl[6]));
            this.remittanceGeneralLedger.add(detail);
        }
        instrumentDetails = this.persistenceService.getSession().createSQLQuery("select vh.id as voucherHeaderId,vh.vouchernumber as voucherNumber, rpt.id as receiptheaderid,ih.id as instrumentheaderid,rpt.receiptnumber as receiptnumber,rpt.receiptdate as receiptdate,ih.instrumentnumber as instrumentnumber,ih.instrumentdate as instrumentdate,ih.instrumentamount as instrumentamount,b.name as bankname,ba.accountnumber as accountnumber,ih.payto as payto,status.description as description from voucherheader vh,egf_instrumentvoucher iv,egcl_collectionheader rpt,egcl_collectioninstrument ci,egf_instrumentheader ih,egw_status status,bank b,bankbranch bb,bankaccount ba where  iv.voucherheaderid=vh.id and iv.instrumentheaderid = ih.id  and rpt.id = ci.collectionheader AND ci.instrumentheader = ih.id AND status.id = ih.id_status AND b.id = bb.bankid AND bb.id = ba.branchid AND ba.id = ih.bankaccountid and ih.id in  (" + this.instHeaderIds + ")").list();
        this.dishonoredChequeDisplayList = new ArrayList(0);
        for (Object[] object : instrumentDetails) {
            DishonoredChequeBean chequeBean = new DishonoredChequeBean();
            chequeBean.setVoucherHeaderId(this.getLongValue(object[0]));
            chequeBean.setVoucherNumber(this.getStringValue(object[1]));
            chequeBean.setReceiptHeaderid(this.getLongValue(object[2]));
            chequeBean.setInstrumentHeaderid(this.getLongValue(object[3]));
            chequeBean.setReceiptNumber(this.getStringValue(object[4]));
            chequeBean.setReceiptDate(this.getDateValue(object[5]));
            chequeBean.setInstrumentNumber(this.getStringValue(object[6]));
            chequeBean.setInstrumentDate(this.getDateValue(object[7]));
            chequeBean.setInstrumentAmount(this.getBigDecimalValue(object[8]));
            chequeBean.setBankName(this.getStringValue(object[9]));
            chequeBean.setAccountNumber(this.getStringValue(object[10]));
            chequeBean.setPayTo(this.getStringValue(object[11]));
            chequeBean.setDescription(this.getStringValue(object[12]));
            this.dishonoredChequeDisplayList.add(chequeBean);
        }
    }

    protected String getStringValue(Object object) {
        return object != null ? object.toString() : "";
    }

    protected String getDateValue(Object object) {
        return object != null ? this.formatter.format((Date)object) : "";
    }

    protected Long getLongValue(Object object) {
        return object != null ? Long.valueOf(object.toString()) : null;
    }

    private BigDecimal getBigDecimalValue(Object object) {
        return object != null ? new BigDecimal(object.toString()).setScale(2) : BigDecimal.ZERO.setScale(2);
    }

    public List getBankBranchList() {
        return this.bankBranchList;
    }

    public void setBankBranchList(List bankBranchList) {
        this.bankBranchList = bankBranchList;
    }

    public Map getInstrumentModesMap() {
        return this.instrumentModesMap;
    }

    public void setInstrumentModesMap(Map instrumentModesList) {
        this.instrumentModesMap = instrumentModesList;
    }

    public String getBankBranchId() {
        return this.bankBranchId;
    }

    public void setBankBranchId(String bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public List getAccountNumberList() {
        return this.accountNumberList;
    }

    public void setAccountNumberList(List accountNumberList) {
        this.accountNumberList = accountNumberList;
    }

    public String getChequeNumber() {
        return this.chequeNumber;
    }

    public void setChequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
    }

    public Date getChequeDate() {
        return this.chequeDate;
    }

    public void setChequeDate(Date chequeDate) {
        this.chequeDate = chequeDate;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public String getInstrumentMode() {
        return this.instrumentMode;
    }

    public void setInstrumentMode(String instrumentMode) {
        this.instrumentMode = instrumentMode;
    }

    public String getInstHeaderIds() {
        return this.instHeaderIds;
    }

    public void setInstHeaderIds(String instHeaderIds) {
        this.instHeaderIds = instHeaderIds;
    }

    public String getVoucherHeaderIds() {
        return this.voucherHeaderIds;
    }

    public void setVoucherHeaderIds(String voucherHeaderIds) {
        this.voucherHeaderIds = voucherHeaderIds;
    }

    public List<DishonoredChequeForm> getGeneralLedger() {
        return this.generalLedger;
    }

    public void setGeneralLedger(List<DishonoredChequeForm> generalLedger) {
        this.generalLedger = generalLedger;
    }

    public List<DishonoredChequeForm> getSubLedgerDetails() {
        return this.subLedgerDetails;
    }

    public void setSubLedgerDetails(List<DishonoredChequeForm> subLedgerDetails) {
        this.subLedgerDetails = subLedgerDetails;
    }

    public BigDecimal getReversalAmount() {
        return this.reversalAmount;
    }

    public void setReversalAmount(BigDecimal reversalAmount) {
        this.reversalAmount = reversalAmount;
    }

    public List<DishonoredChequeForm> getRemittanceGeneralLedger() {
        return this.remittanceGeneralLedger;
    }

    public void setRemittanceGeneralLedger(List<DishonoredChequeForm> remittanceGeneralLedger) {
        this.remittanceGeneralLedger = remittanceGeneralLedger;
    }

    public String getReceiptGLDetails() {
        return this.receiptGLDetails;
    }

    public void setReceiptGLDetails(String receiptGLDetails) {
        this.receiptGLDetails = receiptGLDetails;
    }

    public String getRemittanceGLDetails() {
        return this.remittanceGLDetails;
    }

    public void setRemittanceGLDetails(String remittanceGLDetails) {
        this.remittanceGLDetails = remittanceGLDetails;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getDishonorReason() {
        return this.dishonorReason;
    }

    public void setDishonorReason(String dishonorReason) {
        this.dishonorReason = dishonorReason;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getReferenceNo() {
        return this.referenceNo;
    }

    public void setReferenceNo(String referenceNo) {
        this.referenceNo = referenceNo;
    }

    public Long getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(Long accountNumber) {
        this.accountNumber = accountNumber;
    }

    public List<DishonoredChequeBean> getDishonoredChequeDisplayList() {
        return this.dishonoredChequeDisplayList;
    }

    public void setDishonoredChequeDisplayList(List<DishonoredChequeBean> dishonoredChequeDisplayList) {
        this.dishonoredChequeDisplayList = dishonoredChequeDisplayList;
    }
}

