/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.egov.collection.entity.BranchUserMap;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.Remittance;
import org.egov.collection.entity.RemittanceDetail;
import org.egov.collection.entity.RemittanceInstrument;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.service.RemittanceService;
import org.egov.collection.utils.CollectionsNumberGenerator;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class RemittanceServiceImpl
extends RemittanceService {
    private static final long serialVersionUID = 5581301494846870670L;
    private static final Logger LOGGER = Logger.getLogger(ReceiptHeaderService.class);
    private CollectionsUtil collectionsUtil;
    private FinancialsUtil financialsUtil;
    private ReceiptHeaderService receiptHeaderService;
    private PersistenceService persistenceService;
    private CollectionsNumberGenerator collectionsNumberGenerator;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private FunctionHibernateDAO functionHibernateDAO;
    @Autowired
    private ChartOfAccountsDAO chartOfAccountsDAO;
    private PersistenceService<Remittance, Long> remittancePersistService;
    @Autowired
    @Qualifier(value="branchUserMapService")
    private PersistenceService<BranchUserMap, Long> branchUserMapService;

    @Override
    @Transactional
    public List<ReceiptHeader> createBankRemittance(String[] serviceNameArr, String[] totalCashAmount, String[] totalAmount, String[] totalCardAmount, String[] receiptDateArray, String[] fundCodeArray, String[] departmentCodeArray, Integer accountNumberId, Integer positionUser, String[] receiptNumberArray, Date remittanceDate) {
        ArrayList<ReceiptHeader> bankRemittanceList = new ArrayList<ReceiptHeader>(0);
        ArrayList<ReceiptHeader> bankRemitList = new ArrayList<ReceiptHeader>();
        SimpleDateFormat dateFomatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        this.financialsUtil.prepareForUpdateInstrumentDepositSQL();
        String instrumentGlCodeQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE=";
        String receiptInstrumentQueryString = "select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments join receipt.receiptMisc as receiptMisc where ";
        String serviceNameCondition = "receipt.service.name=? ";
        String receiptDateCondition = "and date(receipt.receiptdate)=? ";
        String instrumentStatusCondition = "and instruments.statusId.id=? ";
        String instrumentTypeCondition = "and instruments.instrumentType.type = ? ";
        String receiptFundCondition = "and receiptMisc.fund.code = ? ";
        String receiptDepartmentCondition = "and receiptMisc.department.code = ? ";
        String receiptSourceCondition = "and receipt.source = ? ";
        String depositedBranchCondition = "";
        if (this.collectionsUtil.isBankCollectionRemitter(this.collectionsUtil.getLoggedInUser()).booleanValue()) {
            BranchUserMap branchUserMap = (BranchUserMap)((Object)this.branchUserMapService.findByNamedQuery("QUERY_ACTIVE_BRANCHUSER_BY_USER", new Object[]{this.collectionsUtil.getLoggedInUser().getId()}));
            depositedBranchCondition = "and receiptMisc.depositedBranch.id=" + branchUserMap.getBankbranch().getId();
        } else {
            depositedBranchCondition = "and receiptMisc.depositedBranch is null";
        }
        String cashInHandQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cash'";
        String chequeInHandQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cheque'";
        String cardPaymentQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='card'";
        SQLQuery cashInHand = this.persistenceService.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cash'");
        SQLQuery chequeInHand = this.persistenceService.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cheque'");
        SQLQuery cardPaymentAccount = this.persistenceService.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='card'");
        String cashInHandGLCode = null;
        String chequeInHandGlcode = null;
        String createVoucher = this.collectionsUtil.getAppConfigValue("Collection", "CREATEVOUCHER_FOR_REMITTANCE");
        String functionCode = this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_FUNCTIONCODE");
        EgwStatus instrmentStatusNew = this.collectionsUtil.getStatusForModuleAndCode("Instrument", "New");
        EgwStatus receiptStatusRemitted = this.collectionsUtil.getReceiptStatusForCode("REMITTED");
        if (!cashInHand.list().isEmpty()) {
            cashInHandGLCode = cashInHand.list().get(0).toString();
        }
        if (!chequeInHand.list().isEmpty()) {
            chequeInHandGlcode = chequeInHand.list().get(0).toString();
        }
        if (!cardPaymentAccount.list().isEmpty()) {
            cardPaymentAccount.list().get(0).toString();
        }
        this.collectionsUtil.getVoucherType();
        Boolean showRemitDate = false;
        BigDecimal totalCashAmt = BigDecimal.ZERO;
        BigDecimal totalChequeAmount = BigDecimal.ZERO;
        BigDecimal totalCashVoucherAmt = BigDecimal.ZERO;
        BigDecimal totalChequeVoucherAmt = BigDecimal.ZERO;
        String fundCode = "";
        Date voucherDate = null;
        if (this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_SHOWREMITDATE").equals("Y")) {
            showRemitDate = true;
        }
        EgwStatus instrumentStatusDeposited = this.collectionsUtil.getStatusForModuleAndCode("Instrument", "Deposited");
        Bankaccount depositedBankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{accountNumberId.longValue()});
        String serviceGlCode = depositedBankAccount.getChartofaccounts().getGlcode();
        for (int i = 0; i < serviceNameArr.length; ++i) {
            String serviceName = serviceNameArr[i].trim();
            if (showRemitDate.booleanValue() && remittanceDate != null) {
                voucherDate = remittanceDate;
            } else {
                try {
                    this.collectionsUtil.getRemittanceVoucherDate(dateFomatter.parse(receiptDateArray[i]));
                }
                catch (ParseException e) {
                    LOGGER.error((Object)"Error Parsing Date", (Throwable)e);
                }
            }
            if (serviceName != null && serviceName.length() > 0) {
                Object[] arguments;
                this.persistenceService.findByNamedQuery("getServicesByName", new Object[]{serviceName});
                ServiceDetails serviceDetails = (ServiceDetails)this.persistenceService.findByNamedQuery("getServicesByName", new Object[]{serviceName});
                if (totalCashAmount[i].trim() != null && totalCashAmount[i].trim().length() > 0 && cashInHandGLCode != null) {
                    StringBuilder cashQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments join receipt.receiptMisc as receiptMisc where ");
                    cashQueryBuilder.append("receipt.service.name=? ");
                    cashQueryBuilder.append("and date(receipt.receiptdate)=? ");
                    cashQueryBuilder.append("and instruments.statusId.id=? ");
                    cashQueryBuilder.append("and instruments.instrumentType.type = ? ");
                    cashQueryBuilder.append("and receiptMisc.fund.code = ? ");
                    cashQueryBuilder.append("and receiptMisc.department.code = ? ");
                    cashQueryBuilder.append("and receipt.status.id=(select id from org.egov.commons.EgwStatus where moduletype=? and code=?) ");
                    cashQueryBuilder.append("and receipt.source = ? ");
                    cashQueryBuilder.append(depositedBranchCondition);
                    arguments = new Object[9];
                    arguments[0] = serviceName;
                    try {
                        arguments[1] = dateFomatter.parse(receiptDateArray[i]);
                    }
                    catch (ParseException exp) {
                        LOGGER.debug((Object)("Exception in parsing date  " + receiptDateArray[i] + " - " + exp.getMessage()));
                        throw new ApplicationRuntimeException("Exception while parsing date", (Throwable)exp);
                    }
                    arguments[2] = instrmentStatusNew.getId();
                    arguments[3] = "cash";
                    arguments[4] = fundCodeArray[i];
                    arguments[5] = departmentCodeArray[i];
                    arguments[6] = "ReceiptHeader";
                    arguments[7] = "APPROVED";
                    arguments[8] = Source.SYSTEM.toString();
                    fundCode = fundCodeArray[i];
                    List instrumentHeaderListCash = this.persistenceService.findAllBy(cashQueryBuilder.toString(), arguments);
                    totalCashAmt = totalCashAmt.add(new BigDecimal(totalCashAmount[i]));
                    if ("Y".equalsIgnoreCase(createVoucher) && serviceDetails.getVoucherCreation().booleanValue()) {
                        totalCashVoucherAmt = totalCashVoucherAmt.add(new BigDecimal(totalCashAmount[i]));
                    } else {
                        this.financialsUtil.updateInstrumentHeader(instrumentHeaderListCash, instrumentStatusDeposited, depositedBankAccount);
                    }
                    bankRemittanceList.addAll(this.getRemittanceList(serviceDetails, instrumentHeaderListCash));
                }
                if (totalAmount[i].trim() != null && totalAmount[i].trim().length() > 0 && chequeInHandGlcode != null) {
                    StringBuilder chequeQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments join receipt.receiptMisc as receiptMisc where ");
                    chequeQueryBuilder.append("receipt.service.name=? ");
                    chequeQueryBuilder.append("and date(receipt.receiptdate)=? ");
                    chequeQueryBuilder.append("and instruments.statusId.id=? ");
                    chequeQueryBuilder.append("and instruments.instrumentType.type in ( ?, ?)");
                    chequeQueryBuilder.append("and receipt.status.id=(select id from org.egov.commons.EgwStatus where moduletype=? and code=?) ");
                    chequeQueryBuilder.append("and receiptMisc.fund.code = ? ");
                    chequeQueryBuilder.append("and receiptMisc.department.code = ? ");
                    chequeQueryBuilder.append("and receipt.source = ? ");
                    chequeQueryBuilder.append(depositedBranchCondition);
                    arguments = new Object[10];
                    arguments[0] = serviceName;
                    try {
                        arguments[1] = dateFomatter.parse(receiptDateArray[i]);
                    }
                    catch (ParseException exp) {
                        LOGGER.debug((Object)("Exception in parsing date  " + receiptDateArray[i] + " - " + exp.getMessage()));
                        throw new ApplicationRuntimeException("Exception while parsing date", (Throwable)exp);
                    }
                    arguments[2] = instrmentStatusNew.getId();
                    arguments[3] = "cheque";
                    arguments[4] = "dd";
                    arguments[5] = "ReceiptHeader";
                    arguments[6] = "APPROVED";
                    arguments[7] = fundCodeArray[i];
                    arguments[8] = departmentCodeArray[i];
                    arguments[9] = Source.SYSTEM.toString();
                    fundCode = fundCodeArray[i];
                    List instrumentHeaderListCheque = this.persistenceService.findAllBy(chequeQueryBuilder.toString(), arguments);
                    totalChequeAmount = totalChequeAmount.add(new BigDecimal(totalAmount[i]));
                    if ("Y".equalsIgnoreCase(createVoucher) && serviceDetails.getVoucherCreation().booleanValue()) {
                        totalChequeVoucherAmt = totalChequeVoucherAmt.add(new BigDecimal(totalAmount[i]));
                    } else {
                        this.financialsUtil.updateInstrumentHeader(instrumentHeaderListCheque, instrumentStatusDeposited, depositedBankAccount);
                    }
                    bankRemittanceList.addAll(this.getRemittanceList(serviceDetails, instrumentHeaderListCheque));
                }
            }
            for (ReceiptHeader receiptHeader : bankRemittanceList) {
                if (bankRemitList.contains((Object)receiptHeader)) continue;
                bankRemitList.add(receiptHeader);
            }
        }
        Remittance remittance = this.populateAndPersistRemittance(totalCashAmt, totalChequeAmount, fundCode, cashInHandGLCode, chequeInHandGlcode, serviceGlCode, functionCode, bankRemitList, createVoucher, voucherDate, depositedBankAccount, totalCashVoucherAmt, totalChequeVoucherAmt);
        for (ReceiptHeader receiptHeader : bankRemitList) {
            receiptHeader.setStatus(receiptStatusRemitted);
            receiptHeader.setRemittanceReferenceNumber(remittance.getReferenceNumber());
            this.receiptHeaderService.update((Object)receiptHeader);
        }
        return bankRemitList;
    }

    @Transactional
    public CVoucherHeader createVoucherForRemittance(String cashInHandGLCode, String chequeInHandGLcode, String serviceGLCode, String functionCode, BigDecimal totalCashVoucherAmt, BigDecimal totalChequeVoucherAmt, Date voucherDate, String fundCode) {
        HashMap<String, Object> accountcodedetailsHashMap;
        ArrayList<HashMap<String, Object>> accountCodeList = new ArrayList<HashMap<String, Object>>(0);
        if (totalCashVoucherAmt.compareTo(BigDecimal.ZERO) > 0 && !cashInHandGLCode.isEmpty()) {
            accountcodedetailsHashMap = this.prepareAccountCodeDetails(cashInHandGLCode, functionCode, totalCashVoucherAmt, BigDecimal.ZERO);
            accountCodeList.add(accountcodedetailsHashMap);
        }
        if (totalChequeVoucherAmt.compareTo(BigDecimal.ZERO) > 0 && !chequeInHandGLcode.isEmpty()) {
            accountcodedetailsHashMap = this.prepareAccountCodeDetails(chequeInHandGLcode, functionCode, totalChequeVoucherAmt, BigDecimal.ZERO);
            accountCodeList.add(accountcodedetailsHashMap);
        }
        BigDecimal totalDebitAmount = totalChequeVoucherAmt.add(totalCashVoucherAmt);
        if (!serviceGLCode.isEmpty()) {
            accountcodedetailsHashMap = this.prepareAccountCodeDetails(serviceGLCode, functionCode, BigDecimal.ZERO, totalDebitAmount);
            accountCodeList.add(accountcodedetailsHashMap);
        }
        CVoucherHeader voucherHeader = this.financialsUtil.createRemittanceVoucher(this.prepareHeaderDetails(fundCode, voucherDate), accountCodeList, new ArrayList<HashMap<String, Object>>(0));
        return voucherHeader;
    }

    public List<ReceiptHeader> getRemittanceList(ServiceDetails serviceDetails, List<InstrumentHeader> instrumentHeaderList) {
        ArrayList<Long> instHeaderList = new ArrayList<Long>();
        for (InstrumentHeader instHead : instrumentHeaderList) {
            instHeaderList.add(instHead.getId());
        }
        ArrayList<ReceiptHeader> bankRemittanceList = new ArrayList<ReceiptHeader>();
        List receiptHeaders = this.persistenceService.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{serviceDetails.getCode(), instHeaderList});
        bankRemittanceList.addAll(receiptHeaders);
        return bankRemittanceList;
    }

    @Transactional
    public Remittance populateAndPersistRemittance(BigDecimal totalCashAmount, BigDecimal totalChequeAmount, String fundCode, String cashInHandGLCode, String chequeInHandGLcode, String serviceGLCode, String functionCode, List<ReceiptHeader> receiptHeadList, String createVoucher, Date voucherDate, Bankaccount depositedBankAccount, BigDecimal totalCashVoucherAmt, BigDecimal totalChequeVoucherAmt) {
        CFinancialYear financialYear = this.collectionsUtil.getFinancialYearforDate(new Date());
        BigDecimal totalAmount = BigDecimal.ZERO;
        Remittance remittance = new Remittance();
        ArrayList<RemittanceDetail> remittanceDetailsList = new ArrayList<RemittanceDetail>();
        remittance.setReferenceDate(new Date());
        EgwStatus receiptStatusApproved = this.collectionsUtil.getStatusForModuleAndCode("Remittance", "APPROVED");
        remittance.setStatus(receiptStatusApproved);
        remittance.setReferenceNumber(this.collectionsNumberGenerator.generateRemittanceNumber(financialYear));
        remittance.setFund(this.fundHibernateDAO.fundByCode(fundCode));
        remittance.setFunction(this.functionHibernateDAO.getFunctionByCode(functionCode));
        remittance.setCollectionRemittance(new HashSet<ReceiptHeader>(receiptHeadList));
        remittance.setBankAccount(depositedBankAccount);
        if (totalCashAmount != null && totalCashAmount.compareTo(BigDecimal.ZERO) > 0 && cashInHandGLCode != null) {
            remittanceDetailsList.addAll(this.getRemittanceDetailsList(totalCashAmount, BigDecimal.ZERO, cashInHandGLCode, remittance));
            totalAmount = totalAmount.add(totalCashAmount);
        }
        if (totalChequeAmount != null && totalChequeAmount.compareTo(BigDecimal.ZERO) > 0 && chequeInHandGLcode != null) {
            remittanceDetailsList.addAll(this.getRemittanceDetailsList(totalChequeAmount, BigDecimal.ZERO, chequeInHandGLcode, remittance));
            totalAmount = totalAmount.add(totalChequeAmount);
        }
        remittanceDetailsList.addAll(this.getRemittanceDetailsList(BigDecimal.ZERO, totalAmount, serviceGLCode, remittance));
        remittance.setRemittanceDetails(new HashSet<RemittanceDetail>(remittanceDetailsList));
        this.remittancePersistService.persist((Object)remittance);
        if ("Y".equalsIgnoreCase(createVoucher) && (totalCashVoucherAmt.compareTo(BigDecimal.ZERO) > 0 || totalChequeVoucherAmt.compareTo(BigDecimal.ZERO) > 0)) {
            CVoucherHeader voucherHeader = this.createVoucherForRemittance(cashInHandGLCode, chequeInHandGLcode, serviceGLCode, functionCode, totalCashVoucherAmt, totalChequeVoucherAmt, voucherDate, fundCode);
            remittance.setVoucherHeader(voucherHeader);
            for (ReceiptHeader receiptHeader : receiptHeadList) {
                for (InstrumentHeader instHead : receiptHeader.getReceiptInstrument()) {
                    this.persistRemittanceInstrument(remittance, instHead);
                }
            }
            this.remittancePersistService.persist((Object)remittance);
        }
        return remittance;
    }

    @Transactional
    public void persistRemittanceInstrument(Remittance remittance, InstrumentHeader instrumentHeader) {
        RemittanceInstrument remittanceInstrument = new RemittanceInstrument();
        remittanceInstrument.setRemittance(remittance);
        remittanceInstrument.setInstrumentHeader(instrumentHeader);
        remittanceInstrument.setReconciled(Boolean.FALSE);
        this.persistenceService.persist((Object)remittanceInstrument);
    }

    public HashMap<String, Object> prepareAccountCodeDetails(String glCode, String functionCode, BigDecimal creditAmount, BigDecimal debitAmount) {
        HashMap<String, Object> accountcodedetailsHashMap = new HashMap<String, Object>(0);
        accountcodedetailsHashMap.put("glcode", glCode);
        accountcodedetailsHashMap.put("functioncode", functionCode);
        accountcodedetailsHashMap.put("creditamount", creditAmount);
        accountcodedetailsHashMap.put("debitamount", debitAmount);
        return accountcodedetailsHashMap;
    }

    public HashMap<String, Object> prepareHeaderDetails(String fundCode, Date voucherDate) {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>(0);
        if (this.collectionsUtil.getVoucherType().booleanValue()) {
            headerdetails.put("vouchername", "Other receipts");
            headerdetails.put("vouchertype", "Receipt");
        } else {
            headerdetails.put("vouchername", "Pay in slip");
            headerdetails.put("vouchertype", "Contra");
        }
        headerdetails.put("description", "Collection Module");
        headerdetails.put("voucherdate", voucherDate);
        headerdetails.put("fundcode", fundCode);
        headerdetails.put("departmentcode", "ACC");
        headerdetails.put("moduleid", "10");
        headerdetails.put("moduleid", "10");
        return headerdetails;
    }

    public List<RemittanceDetail> getRemittanceDetailsList(BigDecimal creditAmount, BigDecimal debitAmount, String glCode, Remittance remittance) {
        ArrayList<RemittanceDetail> remittanceDetailsList = new ArrayList<RemittanceDetail>();
        RemittanceDetail remittanceDetail = new RemittanceDetail();
        remittanceDetail.setCreditAmount(creditAmount);
        remittanceDetail.setDebitAmount(debitAmount);
        remittanceDetail.setRemittance(remittance);
        remittanceDetail.setChartOfAccount(this.chartOfAccountsDAO.getCChartOfAccountsByGlCode(glCode));
        remittanceDetailsList.add(remittanceDetail);
        return remittanceDetailsList;
    }

    @Override
    public List<HashMap<String, Object>> findAllRemittanceDetailsForServiceAndFund(String boundaryIdList, String serviceCodes, String fundCodes, Date startDate, Date endDate, String paymentMode) {
        ArrayList<HashMap<String, Object>> paramList = new ArrayList<HashMap<String, Object>>();
        String queryBuilder = "SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,date(ch.RECEIPTDATE) AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt";
        String whereClauseBeforInstumentType = " where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and ";
        String whereClauseForServiceAndFund = " sd.code in (" + serviceCodes + ") and fnd.code in (" + fundCodes + ") and ";
        String whereClause = " AND ih.ID_STATUS=(select id from egw_status where moduletype='Instrument' and description='New') and ih.ISPAYCHEQUE='0' and ch.STATUS=(select id from egw_status where moduletype='ReceiptHeader' and code='APPROVED')  AND ch.source='" + Source.SYSTEM + "' ";
        if (startDate != null && endDate != null) {
            whereClause = whereClause + " AND date(ch.receiptdate) between '" + startDate + "' and '" + endDate + "' ";
        }
        String groupByClause = " group by date(ch.RECEIPTDATE),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code";
        String orderBy = " order by RECEIPTDATE";
        StringBuilder queryStringForCashChequeDDCard = new StringBuilder("SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,date(ch.RECEIPTDATE) AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and " + whereClauseForServiceAndFund + "it.TYPE in ");
        if (paymentMode.equals("cash")) {
            queryStringForCashChequeDDCard.append("('cash')");
        } else if (paymentMode.equals("cheque/dd")) {
            queryStringForCashChequeDDCard.append("('cheque','dd') ");
        } else {
            queryStringForCashChequeDDCard.append("('cash','cheque','dd') ");
        }
        if (this.collectionsUtil.isBankCollectionRemitter(this.collectionsUtil.getLoggedInUser()).booleanValue()) {
            BranchUserMap branchUserMap = (BranchUserMap)((Object)this.branchUserMapService.findByNamedQuery("QUERY_ACTIVE_BRANCHUSER_BY_USER", new Object[]{this.collectionsUtil.getLoggedInUser().getId()}));
            queryStringForCashChequeDDCard.append(whereClause + " AND cm.depositedbranch=" + branchUserMap.getBankbranch().getId());
        } else {
            queryStringForCashChequeDDCard.append(whereClause + " AND cm.depositedbranch is null AND ch.CREATEDBY in (select distinct ujl.employee from egeis_jurisdiction ujl where ujl.boundary in (" + boundaryIdList + "))");
        }
        queryStringForCashChequeDDCard.append(" group by date(ch.RECEIPTDATE),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code");
        SQLQuery query = this.receiptHeaderService.getSession().createSQLQuery(queryStringForCashChequeDDCard.toString() + " order by RECEIPTDATE");
        List queryResults = query.list();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            HashMap objHashMap = new HashMap(0);
            if (i == 0) {
                objHashMap.put("RECEIPTDATE", arrayObjectInitialIndex[1]);
                objHashMap.put("SERVICENAME", arrayObjectInitialIndex[2]);
                objHashMap.put("FUNDNAME", arrayObjectInitialIndex[4]);
                objHashMap.put("DEPARTMENTNAME", arrayObjectInitialIndex[5]);
                objHashMap.put("FUNDCODE", arrayObjectInitialIndex[6]);
                objHashMap.put("DEPARTMENTCODE", arrayObjectInitialIndex[7]);
                if (arrayObjectInitialIndex[3].equals("cash")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                }
                if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", arrayObjectInitialIndex[0]);
                }
            } else {
                int checknew = this.receiptHeaderService.checkIfMapObjectExist(paramList, arrayObjectInitialIndex);
                if (checknew == -1) {
                    objHashMap.put("RECEIPTDATE", arrayObjectInitialIndex[1]);
                    objHashMap.put("SERVICENAME", arrayObjectInitialIndex[2]);
                    objHashMap.put("FUNDNAME", arrayObjectInitialIndex[4]);
                    objHashMap.put("DEPARTMENTNAME", arrayObjectInitialIndex[5]);
                    objHashMap.put("FUNDCODE", arrayObjectInitialIndex[6]);
                    objHashMap.put("DEPARTMENTCODE", arrayObjectInitialIndex[7]);
                    if (arrayObjectInitialIndex[3].equals("cash")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    }
                    if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    }
                } else {
                    objHashMap = (HashMap)paramList.get(checknew);
                    paramList.remove(checknew);
                    if (arrayObjectInitialIndex[3].equals("cash")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                    }
                    if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                        BigDecimal existingAmount = BigDecimal.ZERO;
                        if (!objHashMap.get("SERVICETOTALCHEQUEAMOUNT").equals("")) {
                            existingAmount = new BigDecimal(objHashMap.get("SERVICETOTALCHEQUEAMOUNT").toString());
                        }
                        existingAmount = existingAmount.add(new BigDecimal(arrayObjectInitialIndex[0].toString()));
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", existingAmount);
                    }
                }
            }
            if (objHashMap.get("RECEIPTDATE") == null || objHashMap.get("SERVICENAME") == null) continue;
            paramList.add(objHashMap);
        }
        return paramList;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public CollectionsNumberGenerator getCollectionsNumberGenerator() {
        return this.collectionsNumberGenerator;
    }

    public void setCollectionsNumberGenerator(CollectionsNumberGenerator collectionsNumberGenerator) {
        this.collectionsNumberGenerator = collectionsNumberGenerator;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setRemittancePersistService(PersistenceService<Remittance, Long> remittancePersistService) {
        this.remittancePersistService = remittancePersistService;
    }
}

