/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.services.DebitAccountHeadDetailsService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.entity.Source;
import org.egov.infstr.models.ServiceDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CollectionService {
    private CollectionsUtil collectionsUtil;
    private ReceiptHeaderService receiptHeaderService;
    private CollectionCommon collectionCommon;
    @Autowired
    private ApplicationContext beanProvider;

    public PaymentRequest populateAndPersistReceipts(ServiceDetails paymentService, ReceiptHeader receiptHeader, List<ReceiptDetail> receiptDetailList, BigDecimal paymentAmount, Character collectionType) {
        if (receiptHeader.getStatus() == null) {
            receiptHeader.setReceiptdate(new Date());
            receiptHeader.setReceipttype('B');
            receiptHeader.setIsModifiable(Boolean.FALSE);
            receiptHeader.setIsReconciled(Boolean.TRUE);
            receiptHeader.setCollectiontype(collectionType);
            receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "PENDING"));
            receiptHeader.setSource(Source.SYSTEM.toString());
            BigDecimal debitAmount = BigDecimal.ZERO;
            for (ReceiptDetail creditChangeReceiptDetail : receiptDetailList) {
                debitAmount = debitAmount.add(creditChangeReceiptDetail.getCramount());
                debitAmount = debitAmount.subtract(creditChangeReceiptDetail.getDramount());
                for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
                    if (!creditChangeReceiptDetail.getReceiptHeader().getReferencenumber().equals(receiptDetail.getReceiptHeader().getReferencenumber()) || !receiptDetail.getOrdernumber().equals(creditChangeReceiptDetail.getOrdernumber())) continue;
                    receiptDetail.setCramount(creditChangeReceiptDetail.getCramount());
                }
            }
            receiptHeader.setTotalAmount(paymentAmount);
            OnlinePayment onlinePayment = new OnlinePayment();
            onlinePayment.setStatus(this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_PENDING"));
            onlinePayment.setReceiptHeader(receiptHeader);
            onlinePayment.setService(paymentService);
            receiptHeader.setOnlinePayment(onlinePayment);
            DebitAccountHeadDetailsService debitAccountHeadService = (DebitAccountHeadDetailsService)this.beanProvider.getBean(this.collectionsUtil.getBeanNameForDebitAccountHead());
            receiptHeader.addReceiptDetail(debitAccountHeadService.addDebitAccountHeadDetails(debitAmount, receiptHeader, BigDecimal.ZERO, paymentAmount, "online"));
        }
        this.receiptHeaderService.persistReceiptObject(receiptHeader);
        return this.collectionCommon.createPaymentRequest(paymentService, receiptHeader);
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }
}

